/*
 * Decompiled with CFR 0.152.
 */
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorConvertOp;
import java.awt.image.ColorModel;
import java.awt.image.ConvolveOp;
import java.awt.image.Kernel;
import java.awt.image.LookupOp;
import java.awt.image.PixelGrabber;
import java.awt.image.RenderedImage;
import java.awt.image.RescaleOp;
import java.awt.image.ShortLookupTable;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;

public class ImageOps {
    public static int[] pixels;
    public static ColorModel cm;
    static /* synthetic */ Class class$ImageOps;

    public static Image loadWorkableImage(String ImageName) {
        URL url = (class$ImageOps == null ? (class$ImageOps = ImageOps.class$("ImageOps")) : class$ImageOps).getResource(ImageName);
        Image theImage = Toolkit.getDefaultToolkit().getImage(url);
        while (theImage.getWidth(null) < 0) {
        }
        return theImage;
    }

    public static Image flipImageVertically(Image image) {
        BufferedImage bi = ImageOps.toBufferedImage(image);
        Image img = Toolkit.getDefaultToolkit().getImage("");
        AffineTransform tx = AffineTransform.getScaleInstance(1.0, -1.0);
        tx.translate(0.0, -image.getHeight(null));
        AffineTransformOp op = new AffineTransformOp(tx, 1);
        bi = op.filter(bi, null);
        Graphics2D g = bi.createGraphics();
        g.drawImage(img, 0, 0, null);
        img = ImageOps.toImage(bi);
        g.dispose();
        return img;
    }

    public static void saveImageToPng(Image img, String name) {
        BufferedImage bufferedimage = ImageOps.toBufferedImage(img);
        Graphics2D g2 = bufferedimage.createGraphics();
        g2.drawImage(img, 0, 0, null);
        img = ImageOps.toImage(bufferedimage);
        g2.dispose();
        if (!name.endsWith(".png") || !name.endsWith(".PNG")) {
            name = name + ".png";
        }
        try {
            File file = new File(name);
            ImageIO.write((RenderedImage)bufferedimage, "png", file);
        }
        catch (IOException e) {
            // empty catch block
        }
    }

    public static void saveImageToPng(Image image1, Image image2, String name, int WIDTH, int HEIGHT) {
        BufferedImage bufferedimage = new BufferedImage(image1.getWidth(null), image1.getHeight(null), 2);
        Graphics2D g2 = bufferedimage.createGraphics();
        g2.drawImage(image1, null, null);
        AlphaComposite c = AlphaComposite.getInstance(3, 0.99f);
        g2.setComposite(c);
        g2.drawImage(image2, null, null);
        if (!name.endsWith(".png") || !name.endsWith(".PNG")) {
            name = name + ".png";
        }
        try {
            File file = new File(name);
            ImageIO.write((RenderedImage)bufferedimage, "png", file);
        }
        catch (IOException e) {
            // empty catch block
        }
        g2.dispose();
    }

    public static Image combineImages(Image image1, Image image2, int WIDTH, int HEIGHT) {
        BufferedImage bufferedimage = new BufferedImage(image1.getWidth(null), image1.getHeight(null), 2);
        Graphics2D g2 = bufferedimage.createGraphics();
        g2.drawImage(image1, null, null);
        AlphaComposite c = AlphaComposite.getInstance(3, 0.99f);
        g2.setComposite(c);
        if (image2 == null) {
            BufferedImage bufimage = new BufferedImage(image1.getWidth(null), image1.getHeight(null), 2);
            image2 = ImageOps.toImage(bufimage);
            g2.drawImage(image2, null, null);
        } else {
            g2.drawImage(image2, null, null);
        }
        Image img = ImageOps.toImage(bufferedimage);
        g2.dispose();
        return img;
    }

    public static void grabImagePixels(Image pic, int width, int height) {
        pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(pic, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        cm = pg.getColorModel();
    }

    public static int[] getImagePixels(Image pic, int width, int height) {
        pixels = new int[width * height];
        PixelGrabber pg = new PixelGrabber(pic, 0, 0, width, height, pixels, 0, width);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return pixels;
    }

    public static Color getPointRGB(int YY, int XX, int width) {
        int index = XX + YY * width;
        int c = pixels[index];
        int r = (c & 0xFF0000) >> 16;
        int g = (c & 0xFF00) >> 8;
        int b = c & 0xFF;
        int a = cm.getAlpha(c);
        Color pointColor = new Color(r, g, b, a);
        return pointColor;
    }

    public static Image toImage(BufferedImage bufferedImage) {
        return Toolkit.getDefaultToolkit().createImage(bufferedImage.getSource());
    }

    public static BufferedImage toBufferedImage(Image image) {
        if (image instanceof BufferedImage) {
            return (BufferedImage)image;
        }
        image = new ImageIcon(image).getImage();
        boolean hasAlpha = ImageOps.hasAlpha(image);
        BufferedImage bimage = null;
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        try {
            int transparency = 1;
            if (hasAlpha) {
                transparency = 2;
            }
            GraphicsDevice gs = ge.getDefaultScreenDevice();
            GraphicsConfiguration gc = gs.getDefaultConfiguration();
            bimage = gc.createCompatibleImage(image.getWidth(null), image.getHeight(null), transparency);
        }
        catch (HeadlessException e) {
            // empty catch block
        }
        if (bimage == null) {
            int type = 1;
            if (hasAlpha) {
                type = 2;
            }
            bimage = new BufferedImage(image.getWidth(null), image.getHeight(null), type);
        }
        Graphics2D g = bimage.createGraphics();
        g.drawImage(image, 0, 0, null);
        g.dispose();
        return bimage;
    }

    public static boolean hasAlpha(Image image) {
        if (image instanceof BufferedImage) {
            BufferedImage bimage = (BufferedImage)image;
            return bimage.getColorModel().hasAlpha();
        }
        PixelGrabber pg = new PixelGrabber(image, 0, 0, 1, 1, false);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        ColorModel cm = pg.getColorModel();
        return cm.hasAlpha();
    }

    public static Image changeBrightness(Image image) {
        BufferedImage bimage = ImageOps.toBufferedImage(image);
        BufferedImage bimage2 = ImageOps.toBufferedImage(image);
        float scaleFactor = 1.0f;
        RescaleOp op = new RescaleOp(scaleFactor, 0.0f, null);
        bimage = op.filter(bimage, bimage2);
        return ImageOps.toImage(bimage2);
    }

    public static Image invertImage(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, null, null);
        short[] invert = new short[256];
        for (int i = 0; i < 256; ++i) {
            invert[i] = (short)(255 - i);
        }
        LookupOp invertOp = new LookupOp(new ShortLookupTable(0, invert), null);
        BufferedImage destination = invertOp.filter(bi, null);
        return ImageOps.toImage(destination);
    }

    public static Image blueInvertImage(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, null, null);
        short[] straight = new short[256];
        short[] invert = new short[256];
        for (int i = 0; i < 256; ++i) {
            invert[i] = (short)(255 - i);
            straight[i] = (short)i;
        }
        short[][] blueInvert = new short[][]{straight, straight, invert};
        LookupOp blueOp = new LookupOp(new ShortLookupTable(0, blueInvert), null);
        BufferedImage destination = blueOp.filter(bi, null);
        return ImageOps.toImage(destination);
    }

    public static BufferedImage convertToGrayscale(BufferedImage source) {
        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        return op.filter(source, null);
    }

    public static Image blurImage(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, null, null);
        float ninth = 0.11111111f;
        float[] blurKernel = new float[]{ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth, ninth};
        ConvolveOp blurOp = new ConvolveOp(new Kernel(3, 3, blurKernel));
        BufferedImage destination = blurOp.filter(bi, null);
        return ImageOps.toImage(destination);
    }

    public static Image sharpenImage(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, null, null);
        float[] sharpKernel = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 5.0f, -1.0f, 0.0f, -1.0f, 0.0f};
        ConvolveOp sharpenOp = new ConvolveOp(new Kernel(3, 3, sharpKernel), 1, null);
        BufferedImage destination = sharpenOp.filter(bi, null);
        return ImageOps.toImage(destination);
    }

    public static Image findEdges(Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, null, null);
        float[] edgeKernel = new float[]{0.0f, -1.0f, 0.0f, -1.0f, 4.0f, -1.0f, 0.0f, -1.0f, 0.0f};
        ConvolveOp edgeOp = new ConvolveOp(new Kernel(3, 3, edgeKernel));
        BufferedImage destination = edgeOp.filter(bi, null);
        return ImageOps.toImage(destination);
    }

    public static Image findThreshold(String type, Image image) {
        BufferedImage bi = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        Graphics2D g2 = bi.createGraphics();
        g2.drawImage(image, null, null);
        BufferedImageOp thresholdOp = null;
        if (type.equals("Threshold 192")) {
            thresholdOp = ImageOps.createThresholdOp(192, 0, 255);
        }
        if (type.equals("Threshold 128")) {
            thresholdOp = ImageOps.createThresholdOp(128, 0, 255);
        }
        if (type.equals("Threshold 64")) {
            thresholdOp = ImageOps.createThresholdOp(64, 0, 255);
        }
        BufferedImage destination = thresholdOp.filter(bi, null);
        return ImageOps.toImage(destination);
    }

    private static BufferedImageOp createThresholdOp(int threshold, int minimum, int maximum) {
        short[] thresholdArray = new short[256];
        for (int i = 0; i < 256; ++i) {
            thresholdArray[i] = i < threshold ? (short)minimum : (short)maximum;
        }
        return new LookupOp(new ShortLookupTable(0, thresholdArray), null);
    }

    public static void saveJpegImage(Image image, String path) {
        RenderedImage rendImage = ImageOps.createJpegImage(image);
        try {
            File file = new File(path);
            ImageIO.write(rendImage, "jpg", file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static RenderedImage createJpegImage(Image image) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        BufferedImage bufferedImage = new BufferedImage(width, height, 1);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, null, null);
        g2.dispose();
        return bufferedImage;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

