/*
 * Decompiled with CFR 0.152.
 */
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class AstroFunctions {
    public static double lunarheight(double L1, double L2, double LE, double BE, double CS, double BS, double LO, double BO, double MQ) {
        double RetVal = 0.0;
        double DR = Math.toRadians(1.0);
        double LS = 90.0 - CS;
        if (LS < 0.0) {
            LS = 450.0 - CS;
        }
        BE *= DR;
        LE *= DR;
        BS *= DR;
        LS *= DR;
        CS *= DR;
        double RM = 1080.0;
        double EM = 239000.0;
        double SM = 9.3E7;
        LO *= DR;
        double I1 = Math.sin(BE) * Math.sin(BO *= DR);
        double I2 = Math.sin(BE) * Math.sin(BS);
        double I3 = Math.sin(BS) * Math.sin(BO);
        double I4 = Math.cos(BE) * Math.cos(BO);
        double I5 = Math.cos(BE) * Math.cos(BS);
        double I6 = Math.cos(BS) * Math.cos(BO);
        double EI = I1 + I4 * Math.cos(LO - LE);
        double ER = I2 + I5 * Math.cos(LE - LS);
        double SI = I3 + I6 * Math.cos(LO - LS);
        double RX = L1 / Math.sin(2.0 * Math.atan(L1 / L2));
        double MR = MQ / RX;
        double I7 = RM * RM;
        double I8 = EM * EM;
        double I9 = SM * SM;
        double XE = Math.sqrt(I7 + I8 - 2.0 * RM * EM * EI);
        double ES = Math.sqrt(I8 + I9 - 2.0 * EM * SM * ER);
        double XS = Math.sqrt(I7 + I9 - 2.0 * RM * SM * SI);
        double S = (XE + ES + XS) / 2.0;
        double SH = I3 + I6 * Math.sin(CS + LO);
        double Phi = Math.atan(-SH / Math.sqrt(-SH * SH + 1.0)) + 2.0 * Math.atan(1.0);
        double H = MR / EI * RM / Math.tan(Phi);
        RetVal = Math.floor(H *= 5280.0);
        return RetVal;
    }

    public static double day2000(double y, double m, double d, double h) {
        double b;
        double greg = y * 10000.0 + m * 100.0 + d;
        if (m == 1.0 || m == 2.0) {
            y -= 1.0;
            m += 12.0;
        }
        if (greg > 1.5821004E7) {
            double a = Math.floor(y / 100.0);
            b = 2.0 - a + Math.floor(a / 4.0);
        } else {
            b = 0.0;
        }
        double c = Math.floor(365.25 * y);
        double d1 = Math.floor(30.6001 * (m + 1.0));
        return b + c + d1 - 730550.5 + d + h / 24.0;
    }

    public static double isleap(double y) {
        double a = 0.0;
        if (y % 4.0 == 0.0) {
            a = 1.0;
        }
        if (y % 100.0 == 0.0) {
            a = 0.0;
        }
        if (y % 400.0 == 0.0) {
            a = 1.0;
        }
        return a;
    }

    public static double goodmonthday(double y, double m, double d) {
        double leap = AstroFunctions.isleap(y);
        double a = 1.0;
        if (d == 0.0) {
            a = 0.0;
        }
        if (m == 2.0 && leap == 1.0 && d > 29.0) {
            a = 0.0;
        }
        if (m == 2.0 && d > 28.0 && leap == 0.0) {
            a = 0.0;
        }
        if ((m == 4.0 || m == 6.0 || m == 9.0 || m == 11.0) && d > 30.0) {
            a = 0.0;
        }
        if (d > 31.0) {
            a = 0.0;
        }
        return a;
    }

    public static String Format(double num, String pattern) {
        DecimalFormat DF = new DecimalFormat(pattern);
        return DF.format(num);
    }

    public static double dsin(double x) {
        return Math.sin(Math.PI / 180 * x);
    }

    public static double dcos(double x) {
        return Math.cos(Math.PI / 180 * x);
    }

    public static double dtan(double x) {
        return Math.tan(Math.PI / 180 * x);
    }

    public static double dasin(double x) {
        return 57.29577951308232 * Math.asin(x);
    }

    public static double dacos(double x) {
        return 57.29577951308232 * Math.acos(x);
    }

    public static double datan(double x) {
        return 57.29577951308232 * Math.atan(x);
    }

    public static double datan2(double y, double x) {
        if (x == 0.0 && y == 0.0) {
            return 0.0;
        }
        double a = AstroFunctions.datan(y / x);
        if (x < 0.0) {
            a += 180.0;
        }
        if (y < 0.0 && x > 0.0) {
            a += 360.0;
        }
        return a;
    }

    public static double ipart(double x) {
        double a = x > 0.0 ? Math.floor(x) : Math.ceil(x);
        return a;
    }

    public static double range(double x) {
        double b = x / 360.0;
        double a = 360.0 * (b - AstroFunctions.ipart(b));
        if (a < 0.0) {
            a += 360.0;
        }
        return a;
    }

    public static double round(double num, int dp) {
        return (double)Math.round(num * Math.pow(10.0, dp)) / Math.pow(10.0, dp);
    }

    public static double In360(double num) {
        if (num < 0.0) {
            while (num < 0.0) {
                num += 360.0;
            }
        }
        if (num > 360.0) {
            while (num > 360.0) {
                num -= 360.0;
            }
        }
        return num;
    }

    public static double In24(double num) {
        if (num < 0.0) {
            while (num < 0.0) {
                num += 24.0;
            }
        }
        if (num > 24.0) {
            while (num > 24.0) {
                num -= 24.0;
            }
        }
        return num;
    }

    public static double[] EclipticToEquatorial(double eLon, double eLat) {
        double ra;
        double[] RetVal = new double[2];
        double e = 23.441884;
        double sinD = AstroFunctions.dsin(eLat) * AstroFunctions.dcos(23.441884) + AstroFunctions.dcos(eLat) * AstroFunctions.dsin(23.441884) * AstroFunctions.dsin(eLon);
        double dec = AstroFunctions.dasin(sinD);
        double y = AstroFunctions.dsin(eLon) * AstroFunctions.dcos(23.441884) - AstroFunctions.dtan(eLat) * AstroFunctions.dsin(23.441884);
        double x = AstroFunctions.dcos(eLon);
        double yx = y / x;
        RetVal[0] = ra = AstroFunctions.datan2(y, x) / 15.0;
        RetVal[1] = dec;
        return RetVal;
    }

    public static Point2D.Double getHorizontalCoords(double ra, double dec, double lst, double lat) {
        double ha = lst - ra;
        double sinalt = AstroFunctions.dsin(dec) * AstroFunctions.dsin(lat) + AstroFunctions.dcos(dec) * AstroFunctions.dcos(lat) * AstroFunctions.dcos(ha);
        double altitude = AstroFunctions.dasin(sinalt);
        double az = AstroFunctions.dcos(ha) * AstroFunctions.dsin(lat) - AstroFunctions.dtan(dec) * AstroFunctions.dcos(lat);
        double azimuth = AstroFunctions.datan2(AstroFunctions.dsin(ha), az);
        if ((azimuth += 180.0) >= 360.0) {
            azimuth -= 360.0;
        }
        return new Point2D.Double(azimuth, altitude);
    }

    public static String strTimeFormat(double x) {
        double tmp = x - Math.floor(x);
        double m = Math.floor(tmp * 60.0);
        double s = (tmp * 60.0 - m) * 60.0;
        int hr = (int)Math.floor(x);
        int min = (int)m;
        DecimalFormat nf = new DecimalFormat("00");
        String RetTime = nf.format(hr) + ":" + nf.format(min) + ":" + nf.format(s);
        return RetTime;
    }

    public static String strRa(double x) {
        double tmp = x - Math.floor(x);
        double m = Math.floor(tmp * 60.0);
        double s = (tmp * 60.0 - m) * 60.0;
        int hr = (int)Math.floor(x);
        int min = (int)m;
        DecimalFormat df = new DecimalFormat("00.000");
        DecimalFormat nf = new DecimalFormat("00");
        String RetRA = nf.format(hr) + "h " + nf.format(min) + "m " + df.format(s) + "s";
        return RetRA;
    }

    public static String strDec(double x) {
        int secstr = 34;
        int degstr = 176;
        int minus = 1;
        if (x < 0.0) {
            x = Math.abs(x);
            minus = -1;
        } else {
            minus = 1;
        }
        double tmp = x - Math.floor(x);
        double m = Math.floor(tmp * 60.0);
        double s = (tmp * 60.0 - m) * 60.0;
        int hr = (int)Math.floor(x);
        int min = (int)m;
        DecimalFormat df = new DecimalFormat("00.000");
        DecimalFormat nf = new DecimalFormat("00");
        if (minus < 0) {
            String RetDEC = "-" + nf.format(hr) + '\u00b0' + " " + nf.format(min) + "' " + df.format(s) + '\"';
            return RetDEC;
        }
        String RetDEC = "+" + nf.format(hr) + '\u00b0' + " " + nf.format(min) + "' " + df.format(s) + '\"';
        return RetDEC;
    }

    public static String strDec(double x, boolean useplus) {
        int secstr = 34;
        int degstr = 176;
        String RetDEC = "";
        int minus = 1;
        if (x < 0.0) {
            x = Math.abs(x);
            minus = -1;
        } else {
            minus = 1;
        }
        double tmp = x - Math.floor(x);
        double m = Math.floor(tmp * 60.0);
        double s = (tmp * 60.0 - m) * 60.0;
        int hr = (int)Math.floor(x);
        int min = (int)m;
        DecimalFormat df = new DecimalFormat("00.000");
        DecimalFormat nf = new DecimalFormat("00");
        DecimalFormat af = new DecimalFormat("000");
        RetDEC = minus < 0 ? "-" + nf.format(hr) + '\u00b0' + " " + nf.format(min) + "' " + df.format(s) + '\"' : (useplus ? "+" + af.format(hr) + '\u00b0' + " " + nf.format(min) + "' " + df.format(s) + '\"' : "" + af.format(hr) + '\u00b0' + " " + nf.format(min) + "' " + df.format(s) + '\"');
        return RetDEC;
    }

    public static String strLst(double x) {
        double tmp = x - Math.floor(x);
        double m = Math.floor(tmp * 60.0);
        double s = (tmp * 60.0 - m) * 60.0;
        int hr = (int)Math.floor(x);
        int min = (int)m;
        DecimalFormat nf = new DecimalFormat("00");
        String RetRA = nf.format(hr) + ":" + nf.format(min) + ":" + nf.format(s);
        return RetRA;
    }

    public static double julianday(double month, double day, double year, double hour, double min, double sec) {
        double b = 0.0;
        double a = 0.0;
        double gregNum = 1.5821015E7;
        double dateNum = year * 10000.0 + month * 100.0 + day + hour / 100.0 + min / 10000.0 + sec / 1000000.0;
        double x = (sec / 60.0 + min) / 60.0;
        double y = (x + hour) / 24.0;
        day += y;
        if (month == 1.0 || month == 2.0) {
            year -= 1.0;
            month += 12.0;
        }
        if (dateNum >= gregNum) {
            a = Math.floor(year / 100.0);
            b = 2.0 - a + Math.floor(a / 4.0);
        } else {
            b = 0.0;
        }
        double c = year < 0.0 ? Math.floor(365.25 * year - 0.75) : Math.floor(365.25 * year);
        double dd = Math.floor(30.6001 * (month + 1.0));
        double d = b + c + dd + day + 1720994.5;
        return d;
    }

    public static String[] getTransitTimes(double xMonth, double xDay, double xYear, double LON, double ZONE) {
        double DIFF;
        xDay = xDay + ZONE / 24.0 + 0.0;
        if (xMonth < 3.0) {
            xYear -= 1.0;
            xMonth += 12.0;
        }
        double A = Math.floor(xYear / 100.0);
        double B = 2.0 - A + Math.floor(A / 4.0);
        double JD = Math.floor(365.25 * xYear) + Math.floor(30.6001 * (xMonth + 1.0));
        JD = JD + xDay + 1720994.5 + B;
        double DAYS = JD - 2451545.0;
        double CEN = DAYS / 36525.0;
        double RTD = 57.29578;
        double PP = 11.8567785;
        double PI = 1.3053 - 0.001152777777777778 * CEN;
        double PE = 0.04839266 - 1.288E-4 * CEN;
        double PA = 5.20336301 + 6.0737E-4 * CEN;
        double PO = 100.55615 + 0.3381027777777778 * CEN;
        double PW = 14.75385 + 0.23331388888888888 * CEN;
        double PL = 34.40438 + 0.083086762 * DAYS;
        double MEAN = PL - PW;
        double Z = MEAN / 360.0;
        double True1 = (MEAN -= 360.0 * Math.floor(Z)) + 114.5915590261571 * PE * Math.sin(MEAN / RTD);
        Z = True1 / 360.0;
        double L = (True1 -= 360.0 * Math.floor(Z)) + PW;
        double R = PA * (1.0 - PE * PE) / (1.0 + PE * Math.cos(True1 / RTD));
        double SINPSI = Math.sin((L - PO) / RTD) * Math.sin(PI / RTD);
        double PSI = Math.atan(SINPSI / Math.sqrt(1.0 - SINPSI * SINPSI));
        double NUM = Math.sin((L - PO) / RTD) * Math.cos(PI / RTD);
        double DEN = Math.cos((L - PO) / RTD);
        double LP = Math.atan(NUM / DEN) * RTD + PO;
        if (DEN < 0.0) {
            LP += 180.0;
        }
        double RP = R * Math.cos(PSI);
        double EE = 0.01671022 - 3.804E-5 * CEN;
        double EA = 1.00000011 - 5.0E-8 * CEN;
        double EW = 102.94719 + 0.33285555555555557 * CEN;
        double EL = 100.46435 + 0.9856091 * DAYS;
        double OBL = 23.43928;
        double MEANE = EL - EW;
        Z = MEANE / 360.0;
        double TRUEE = (MEANE -= 360.0 * Math.floor(Z)) + 114.5915590261571 * EE * Math.sin(MEANE / RTD);
        Z = TRUEE / 360.0;
        double LE = (TRUEE -= 360.0 * Math.floor(Z)) + EW;
        double RE = EA * (1.0 - EE * EE) / (1.0 + EE * Math.cos(TRUEE / RTD));
        double LAMB = RE * Math.sin((LP - LE) / RTD);
        LAMB = Math.atan(LAMB / (RP - RE * Math.cos((LP - LE) / RTD))) * RTD + LP;
        double BETA = RP * Math.tan(PSI) * Math.sin((LAMB - LP) / RTD);
        BETA = Math.atan(BETA / (RE * Math.sin((LP - LE) / RTD))) * RTD;
        NUM = Math.sin(LAMB / RTD) * Math.cos(OBL / RTD) - Math.tan(BETA / RTD) * Math.sin(OBL / RTD);
        DEN = Math.cos(LAMB / RTD);
        double RA = Math.atan(NUM / DEN) * RTD;
        if (NUM * DEN < 0.0) {
            RA += 180.0;
        }
        if (NUM < 0.0) {
            RA += 180.0;
        }
        double SINDEC = Math.sin(BETA / RTD) * Math.cos(OBL / RTD);
        double DEC = Math.atan((SINDEC += Math.cos(BETA / RTD) * Math.sin(OBL / RTD) * Math.sin(LAMB / RTD)) / Math.sqrt(1.0 - SINDEC * SINDEC)) * RTD;
        double DSQRD = RE * RE + R * R - 2.0 * RE * R * Math.cos((L - LE) / RTD);
        double DIST = Math.sqrt(DSQRD);
        double A0 = 268.05 - 0.008999999 * CEN;
        double D0 = 64.49 + 0.003 * CEN;
        double W0 = 43.3 + 870.27 * DAYS;
        Z = W0 / 360.0;
        double W1 = (W0 -= 360.0 * Math.floor(Z)) - 5.026244385 * DIST;
        double SINB = -Math.sin(D0 / RTD) * Math.sin(DEC / RTD);
        double COSB = Math.sqrt(1.0 - (SINB -= Math.cos(D0 / RTD) * Math.cos(DEC / RTD) * Math.cos((A0 - RA) / RTD)) * SINB);
        double SINK = Math.sin(D0 / RTD) * Math.cos(DEC / RTD) * Math.cos((A0 - RA) / RTD);
        SINK = (SINK - Math.cos(D0 / RTD) * Math.sin(DEC / RTD)) / COSB;
        double COSK = Math.cos(DEC / RTD) * Math.sin((A0 - RA) / RTD) / COSB;
        double K = Math.atan(SINK / COSK) * RTD;
        double MER = W1 - K;
        if (COSK < 0.0) {
            MER += 180.0;
        }
        if (MER > 360.0) {
            MER -= 360.0;
        }
        if ((DIFF = LON - MER) < 0.0) {
            DIFF += 360.0;
        }
        DecimalFormat df = new DecimalFormat("00");
        DecimalFormat yf = new DecimalFormat("0000");
        int index = 0;
        String[] grsTimes = new String[5];
        while (DIFF < 870.27) {
            double TRAN = DIFF / 870.27 * 24.0;
            double H = Math.floor(TRAN);
            double M = Math.floor(60.0 * (TRAN - H));
            double S = Math.floor(60.0 * (60.0 * (TRAN - H) - M));
            grsTimes[index] = df.format(H) + ":" + df.format(M) + ":" + df.format(S);
            ++index;
            DIFF += 360.0;
        }
        return grsTimes;
    }

    public static double ConvertToDec(double H, double M, double S) {
        int sign = 1;
        if (H < 0.0) {
            sign = -1;
            H = -H;
        } else {
            sign = 1;
        }
        double retDec = S / 3600.0;
        retDec += M / 60.0;
        retDec += H;
        return retDec *= (double)sign;
    }

    public static double FindLST(double Lon) {
        GregorianCalendar utccal = new GregorianCalendar(TimeZone.getTimeZone("GMT+00:00"));
        double jMonth = utccal.get(2) + 1;
        double jDay = utccal.get(5);
        double jYear = utccal.get(1);
        double JD = AstroFunctions.julianday(jMonth, jDay, jYear, 0.0, 0.0, 0.0);
        double T = (JD - 2451545.0) / 36525.0;
        double TSquare = T * T;
        double ST = 6.697374558 + 2400.051336 * T + 2.5862E-5 * TSquare;
        ST = AstroFunctions.In24(ST);
        double tHour = utccal.get(11);
        double tMin = utccal.get(12);
        double tSec = utccal.get(13);
        double GST = AstroFunctions.ConvertToDec(tHour, tMin, tSec) * 1.00273790935 + ST;
        double LST = (GST = AstroFunctions.In24(GST)) + Lon / 15.0;
        if (LST > 24.0) {
            LST -= 24.0;
        }
        if (LST < 0.0) {
            LST += 24.0;
        }
        return LST;
    }

    public static double FindLST(double Lon, double jMonth, double jDay, double jYear, double tHour, double tMin, double tSec) {
        double JD = AstroFunctions.julianday(jMonth, jDay, jYear, 0.0, 0.0, 0.0);
        double T = (JD - 2451545.0) / 36525.0;
        double TSquare = T * T;
        double ST = 6.697374558 + 2400.051336 * T + 2.5862E-5 * TSquare;
        ST = AstroFunctions.In24(ST);
        double GST = AstroFunctions.ConvertToDec(tHour, tMin, tSec) * 1.00273790935 + ST;
        double LST = (GST = AstroFunctions.In24(GST)) + Lon / 15.0;
        if (LST > 24.0) {
            LST -= 24.0;
        }
        if (LST < 0.0) {
            LST += 24.0;
        }
        return LST;
    }

    public static double[] buildLocalCalendar() {
        double tYear;
        double[] dtOut = new double[6];
        TimeZone tz = TimeZone.getDefault();
        GregorianCalendar mycal = new GregorianCalendar(tz);
        DecimalFormat DayF = new DecimalFormat("00");
        DecimalFormat YearF = new DecimalFormat("0000");
        double tHour = mycal.get(11);
        double tMin = mycal.get(12);
        double tSec = mycal.get(13);
        double tMonth = mycal.get(2) + 1;
        double tDay = mycal.get(5);
        dtOut[0] = tYear = (double)mycal.get(1);
        dtOut[1] = tMonth;
        dtOut[2] = tDay;
        dtOut[3] = tHour;
        dtOut[4] = tMin;
        dtOut[5] = tSec;
        return dtOut;
    }

    public static double[] buildWebCalendar(String strZone) {
        double tYear;
        double[] dtOut = new double[6];
        TimeZone tz = TimeZone.getTimeZone(strZone);
        GregorianCalendar mycal = new GregorianCalendar(tz);
        DecimalFormat DayF = new DecimalFormat("00");
        DecimalFormat YearF = new DecimalFormat("0000");
        double tHour = mycal.get(11);
        double tMin = mycal.get(12);
        double tSec = mycal.get(13);
        double tMonth = mycal.get(2) + 1;
        double tDay = mycal.get(5);
        dtOut[0] = tYear = (double)mycal.get(1);
        dtOut[1] = tMonth;
        dtOut[2] = tDay;
        dtOut[3] = tHour;
        dtOut[4] = tMin;
        dtOut[5] = tSec;
        return dtOut;
    }

    public static String getStringTimeZone(double z) {
        DecimalFormat ZoneF = new DecimalFormat("00");
        String zoneBuilder = "";
        if (z < 0.0) {
            double tz = Math.abs(z);
            String strZ = ZoneF.format(tz);
            zoneBuilder = "GMT-" + strZ + ":00";
        } else {
            double tz = Math.abs(z);
            String strZ = ZoneF.format(tz);
            zoneBuilder = "GMT+" + strZ + ":00";
        }
        return zoneBuilder;
    }

    public static int dayOfYear() {
        GregorianCalendar mycal = new GregorianCalendar(TimeZone.getTimeZone("GMT+00:00"));
        int dayofyear = mycal.get(6);
        return dayofyear;
    }

    public static double[] currentUTC() {
        double[] dtOut = new double[6];
        GregorianCalendar mycal = new GregorianCalendar(TimeZone.getTimeZone("GMT+00:00"));
        DecimalFormat DayF = new DecimalFormat("00");
        DecimalFormat YearF = new DecimalFormat("0000");
        int tHour = mycal.get(11);
        int tMin = mycal.get(12);
        int tSec = mycal.get(13);
        int tMonth = mycal.get(2) + 1;
        int tDay = mycal.get(5);
        int tYear = mycal.get(1);
        dtOut[0] = tYear;
        dtOut[1] = tMonth;
        dtOut[2] = tDay;
        dtOut[3] = tHour;
        dtOut[4] = tMin;
        dtOut[5] = tSec;
        return dtOut;
    }

    public static double[] currentUTC(Calendar mycal) {
        double[] dtOut = new double[6];
        int tHour = mycal.get(11);
        int tMin = mycal.get(12);
        int tSec = mycal.get(13);
        int tMonth = mycal.get(2) + 1;
        int tDay = mycal.get(5);
        int tYear = mycal.get(1);
        dtOut[0] = tYear;
        dtOut[1] = tMonth;
        dtOut[2] = tDay;
        dtOut[3] = tHour;
        dtOut[4] = tMin;
        dtOut[5] = tSec;
        return dtOut;
    }

    public static int[] currentIntUtc() {
        int tYear;
        int[] dtOut = new int[6];
        GregorianCalendar mycal = new GregorianCalendar(TimeZone.getTimeZone("GMT+00:00"));
        int tHour = mycal.get(11);
        int tMin = mycal.get(12);
        int tSec = mycal.get(13);
        int tMonth = mycal.get(2) + 1;
        int tDay = mycal.get(5);
        dtOut[0] = tYear = mycal.get(1);
        dtOut[1] = tMonth;
        dtOut[2] = tDay;
        dtOut[3] = tHour;
        dtOut[4] = tMin;
        dtOut[5] = tSec;
        return dtOut;
    }

    public static double currentUtcNum() {
        GregorianCalendar mycal = new GregorianCalendar(TimeZone.getTimeZone("GMT+00:00"));
        DecimalFormat DayF = new DecimalFormat("00");
        DecimalFormat YearF = new DecimalFormat("0000");
        int tHour = mycal.get(11);
        int tMin = mycal.get(12);
        int tSec = mycal.get(13);
        int tMonth = mycal.get(2) + 1;
        int tDay = mycal.get(5);
        int tYear = mycal.get(1);
        String tm = YearF.format(tYear) + DayF.format(tMonth) + DayF.format(tDay) + DayF.format(tHour) + DayF.format(tMin);
        double dateRet = Double.parseDouble(tm) / 10000.0;
        return dateRet;
    }

    public static double currentUtcNum(Calendar mycal) {
        DecimalFormat DayF = new DecimalFormat("00");
        DecimalFormat YearF = new DecimalFormat("0000");
        int tHour = mycal.get(11);
        int tMin = mycal.get(12);
        int tSec = mycal.get(13);
        int tMonth = mycal.get(2) + 1;
        int tDay = mycal.get(5);
        int tYear = mycal.get(1);
        String tm = YearF.format(tYear) + DayF.format(tMonth) + DayF.format(tDay) + DayF.format(tHour) + DayF.format(tMin);
        double dateRet = Double.parseDouble(tm) / 10000.0;
        return dateRet;
    }

    public static Calendar setUTC() {
        GregorianCalendar mycal = new GregorianCalendar(TimeZone.getTimeZone("GMT+00:00"));
        return mycal;
    }

    public static Calendar setUTC(int month, int day, int year, int hour, int minute, int second) {
        GregorianCalendar mycal = new GregorianCalendar(TimeZone.getTimeZone("GMT+00:00"));
        mycal.set(11, hour);
        mycal.set(12, minute);
        mycal.set(13, second);
        mycal.set(2, month);
        mycal.set(5, day);
        mycal.set(1, year);
        return mycal;
    }

    public static double[] moonPosition(double DateNum) {
        double[] retMoon = new double[2];
        double g = DateNum;
        double y = Math.floor(g / 10000.0);
        double m = Math.floor((g - y * 10000.0) / 100.0);
        double d = Math.floor(g - y * 10000.0 - m * 100.0);
        double bit = (g - Math.floor(g)) * 100.0;
        double h = Math.floor(bit);
        double min = Math.floor(bit * 100.0 - h * 100.0 + 0.5);
        double days = AstroFunctions.day2000(y, m, d, h + min / 60.0);
        double t = days / 36525.0;
        double L1 = AstroFunctions.range(280.466 + 36000.8 * t);
        double M1 = AstroFunctions.range(357.529 + 35999.0 * t - 1.536E-4 * t * t + t * t * t / 2.449E7);
        double C1 = (1.915 - 0.004817 * t - 1.4E-5 * t * t) * AstroFunctions.dsin(M1);
        C1 += (0.01999 - 1.01E-4 * t) * AstroFunctions.dsin(2.0 * M1);
        double V1 = M1 + (C1 += 2.9E-4 * AstroFunctions.dsin(3.0 * M1));
        double Ec1 = 0.01671 - 4.204E-5 * t - 1.236E-7 * t * t;
        double R1 = 0.99972 / (1.0 + Ec1 * AstroFunctions.dcos(V1));
        double Th1 = L1 + C1;
        double Om1 = AstroFunctions.range(125.04 - 1934.1 * t);
        double Lam1 = Th1 - 0.00569 - 0.00478 * AstroFunctions.dsin(Om1);
        double Obl = (84381.448 - 46.815 * t) / 3600.0;
        double Ra1 = AstroFunctions.datan2(AstroFunctions.dsin(Th1) * AstroFunctions.dcos(Obl) - AstroFunctions.dtan(0.0) * AstroFunctions.dsin(Obl), AstroFunctions.dcos(Th1));
        Ra1 /= 15.0;
        double Dec1 = AstroFunctions.dasin(AstroFunctions.dsin(0.0) * AstroFunctions.dcos(Obl) + AstroFunctions.dcos(0.0) * AstroFunctions.dsin(Obl) * AstroFunctions.dsin(Th1));
        double F = AstroFunctions.range(93.2721 + 483202.0 * t - 0.003403 * t * t - t * t * t / 3526000.0);
        double L2 = AstroFunctions.range(218.316 + 481268.0 * t);
        double Om2 = AstroFunctions.range(125.045 - 1934.14 * t + 0.002071 * t * t + t * t * t / 450000.0);
        double M2 = AstroFunctions.range(134.963 + 477199.0 * t + 0.008997 * t * t + t * t * t / 69700.0);
        double D = AstroFunctions.range(297.85 + 445267.0 * t - 0.00163 * t * t + t * t * t / 545900.0);
        double D2 = 2.0 * D;
        double R2 = 1.0 + (-20954.0 * AstroFunctions.dcos(M2) - 3699.0 * AstroFunctions.dcos(D2 - M2) - 2956.0 * AstroFunctions.dcos(D2)) / 385000.0;
        double R3 = R2 / R1 / 379.168831168831;
        double Bm = 5.128 * AstroFunctions.dsin(F) + 0.2806 * AstroFunctions.dsin(M2 + F);
        Bm = Bm + 0.2777 * AstroFunctions.dsin(M2 - F) + 0.1732 * AstroFunctions.dsin(D2 - F);
        double Lm = 6.289 * AstroFunctions.dsin(M2) + 1.274 * AstroFunctions.dsin(D2 - M2) + 0.6583 * AstroFunctions.dsin(D2);
        Lm = Lm + 0.2136 * AstroFunctions.dsin(2.0 * M2) - 0.1851 * AstroFunctions.dsin(M1) - 0.1143 * AstroFunctions.dsin(2.0 * F);
        Lm += 0.0588 * AstroFunctions.dsin(D2 - 2.0 * M2);
        Lm = Lm + 0.0572 * AstroFunctions.dsin(D2 - M1 - M2) + 0.0533 * AstroFunctions.dsin(D2 + M2);
        double Ra2 = AstroFunctions.datan2(AstroFunctions.dsin(Lm += L2) * AstroFunctions.dcos(Obl) - AstroFunctions.dtan(Bm) * AstroFunctions.dsin(Obl), AstroFunctions.dcos(Lm));
        double Dec2 = AstroFunctions.dasin(AstroFunctions.dsin(Bm) * AstroFunctions.dcos(Obl) + AstroFunctions.dcos(Bm) * AstroFunctions.dsin(Obl) * AstroFunctions.dsin(Lm));
        double HLm = AstroFunctions.range(Lam1 + 180.0 + 57.29577951308232 * R3 * AstroFunctions.dcos(Bm) * AstroFunctions.dsin(Lam1 - Lm));
        double HBm = R3 * Bm;
        retMoon[0] = Ra2 /= 15.0;
        retMoon[1] = Dec2;
        return retMoon;
    }

    public static double SysIILongitude(double dMonth, double dDay, double dYear, double dHour, double dMin, double dSec) {
        double DIFF;
        double zMonth = dMonth;
        double zDay = dDay;
        double zYear = dYear;
        double LON = 84.0;
        double ZONE = 0.0;
        zDay = zDay + ZONE / 24.0 + 0.0;
        if (zMonth < 3.0) {
            zYear -= 1.0;
            zMonth += 12.0;
        }
        double A = Math.floor(zYear / 100.0);
        double B = 2.0 - A + Math.floor(A / 4.0);
        double JD = Math.floor(365.25 * zYear) + Math.floor(30.6001 * (zMonth + 1.0));
        JD = JD + zDay + 1720994.5 + B;
        double DAYS = JD - 2451545.0;
        double CEN = DAYS / 36525.0;
        double RTD = 57.29578;
        double PP = 11.8567785;
        double Pye = 1.3053 - 0.001152777777777778 * CEN;
        double PE = 0.04839266 - 1.288E-4 * CEN;
        double PA = 5.20336301 + 6.0737E-4 * CEN;
        double PO = 100.55615 + 0.3381027777777778 * CEN;
        double PW = 14.75385 + 0.23331388888888888 * CEN;
        double PL = 34.40438 + 0.083086762 * DAYS;
        double MEAN = PL - PW;
        double Z = MEAN / 360.0;
        double True1 = (MEAN -= 360.0 * Math.floor(Z)) + 114.5915590261571 * PE * Math.sin(MEAN / RTD);
        Z = True1 / 360.0;
        double L = (True1 -= 360.0 * Math.floor(Z)) + PW;
        double R = PA * (1.0 - PE * PE) / (1.0 + PE * Math.cos(True1 / RTD));
        double SinPsi = Math.sin((L - PO) / RTD) * Math.sin(Pye / RTD);
        double Psi = Math.atan(SinPsi / Math.sqrt(1.0 - SinPsi * SinPsi));
        double NUM = Math.sin((L - PO) / RTD) * Math.cos(Pye / RTD);
        double DEN = Math.cos((L - PO) / RTD);
        double LP = Math.atan(NUM / DEN) * RTD + PO;
        if (DEN < 0.0) {
            LP += 180.0;
        }
        double RP = R * Math.cos(Psi);
        double EE = 0.01671022 - 3.804E-5 * CEN;
        double EA = 1.00000011 - 5.0E-8 * CEN;
        double EW = 102.94719 + 0.33285555555555557 * CEN;
        double EL = 100.46435 + 0.9856091 * DAYS;
        double OBL = 23.43928;
        double MEANE = EL - EW;
        Z = MEANE / 360.0;
        double TRUEE = (MEANE -= 360.0 * Math.floor(Z)) + 114.5915590261571 * EE * Math.sin(MEANE / RTD);
        Z = TRUEE / 360.0;
        double LE = (TRUEE -= 360.0 * Math.floor(Z)) + EW;
        double RE = EA * (1.0 - EE * EE) / (1.0 + EE * Math.cos(TRUEE / RTD));
        double LAMB = RE * Math.sin((LP - LE) / RTD);
        LAMB = Math.atan(LAMB / (RP - RE * Math.cos((LP - LE) / RTD))) * RTD + LP;
        double BETA = RP * Math.tan(Psi) * Math.sin((LAMB - LP) / RTD);
        BETA = Math.atan(BETA / (RE * Math.sin((LP - LE) / RTD))) * RTD;
        NUM = Math.sin(LAMB / RTD) * Math.cos(OBL / RTD) - Math.tan(BETA / RTD) * Math.sin(OBL / RTD);
        DEN = Math.cos(LAMB / RTD);
        double RA = Math.atan(NUM / DEN) * RTD;
        if (NUM * DEN < 0.0) {
            RA += 180.0;
        }
        if (NUM < 0.0) {
            RA += 180.0;
        }
        double SINDEC = Math.sin(BETA / RTD) * Math.cos(OBL / RTD);
        double DEC = Math.atan((SINDEC += Math.cos(BETA / RTD) * Math.sin(OBL / RTD) * Math.sin(LAMB / RTD)) / Math.sqrt(1.0 - SINDEC * SINDEC)) * RTD;
        double DSQRD = RE * RE + R * R - 2.0 * RE * R * Math.cos((L - LE) / RTD);
        double DIST = Math.sqrt(DSQRD);
        double A0 = 268.05 - 0.008999999 * CEN;
        double D0 = 64.49 + 0.003 * CEN;
        double W0 = 43.3 + 870.27 * DAYS;
        Z = W0 / 360.0;
        double W1 = (W0 -= 360.0 * Math.floor(Z)) - 5.026244385 * DIST;
        double SINB = -Math.sin(D0 / RTD) * Math.sin(DEC / RTD);
        double COSB = Math.sqrt(1.0 - (SINB -= Math.cos(D0 / RTD) * Math.cos(DEC / RTD) * Math.cos((A0 - RA) / RTD)) * SINB);
        double SINK = Math.sin(D0 / RTD) * Math.cos(DEC / RTD) * Math.cos((A0 - RA) / RTD);
        SINK = (SINK - Math.cos(D0 / RTD) * Math.sin(DEC / RTD)) / COSB;
        double COSK = Math.cos(DEC / RTD) * Math.sin((A0 - RA) / RTD) / COSB;
        double K = Math.atan(SINK / COSK) * RTD;
        double MER = W1 - K;
        if (COSK < 0.0) {
            MER += 180.0;
        }
        if (MER > 360.0) {
            MER -= 360.0;
        }
        if ((DIFF = LON - MER) < 0.0) {
            DIFF += 360.0;
        }
        double LonHour = dHour;
        double LonMin = dMin;
        double LonSec = dSec;
        double SysIITime = (LonSec / 60.0 + LonMin) / 60.0 + LonHour;
        double S2MER = MER + SysIITime / 24.0 * 870.27;
        while (S2MER > 360.0) {
            if (!(S2MER > 360.0)) continue;
            S2MER -= 360.0;
        }
        return S2MER;
    }
}

