/*
 * Decompiled with CFR 0.152.
 */
package appPackage;

import appPackage.Globals;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;

public class ProxyDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private JButton btnOk;
    private JSpinner spinnerPort;
    private JTextField txtPassword;
    private JTextField txtUserName;
    private JLabel jLabel3;
    private JLabel jLabel2;
    private JCheckBox checkProxyHasUser;
    private JLabel jLabel1;
    private JTextField txtProxyAddress;
    private JLabel jLabel4;
    private JCheckBox checkProxyEnabled;
    private JButton btnCancel;
    private static final String BTN_OK = "OK";
    private static final String BTN_CANCEL = "Cancel";
    private static final String BTN_ENABLE_PROXY = "Enable Proxy";
    private static final String BTN_PROXY_WITH_USER = "Proxy with User/Password";

    public ProxyDialog(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.getContentPane().setLayout(null);
            this.btnOk = new JButton();
            this.getContentPane().add(this.btnOk);
            this.btnOk.setText(BTN_OK);
            this.btnOk.setBounds(180, 200, 56, 21);
            this.btnOk.addActionListener(this);
            this.btnCancel = new JButton();
            this.getContentPane().add(this.btnCancel);
            this.btnCancel.setText(BTN_CANCEL);
            this.btnCancel.setBounds(252, 200, 77, 21);
            this.btnCancel.addActionListener(this);
            this.checkProxyEnabled = new JCheckBox();
            this.getContentPane().add(this.checkProxyEnabled);
            this.checkProxyEnabled.setText(BTN_ENABLE_PROXY);
            this.checkProxyEnabled.setBounds(12, 12, 152, 18);
            this.checkProxyEnabled.addActionListener(this);
            this.jLabel4 = new JLabel();
            this.getContentPane().add(this.jLabel4);
            this.jLabel4.setText("Proxy Address:");
            this.jLabel4.setBounds(12, 47, 100, 14);
            this.txtProxyAddress = new JTextField();
            this.getContentPane().add(this.txtProxyAddress);
            this.txtProxyAddress.setBounds(112, 44, 222, 21);
            this.txtProxyAddress.setEnabled(false);
            this.jLabel1 = new JLabel();
            this.getContentPane().add(this.jLabel1);
            this.jLabel1.setText("Proxy Port:");
            this.jLabel1.setBounds(12, 73, 81, 14);
            SpinnerNumberModel spinnerPortModel = new SpinnerNumberModel(8080, 1, 30000, 1);
            this.spinnerPort = new JSpinner();
            this.getContentPane().add(this.spinnerPort);
            this.spinnerPort.setModel(spinnerPortModel);
            this.spinnerPort.setBounds(112, 70, 80, 21);
            this.spinnerPort.setEditor(new JSpinner.NumberEditor(this.spinnerPort, "00"));
            this.spinnerPort.setEnabled(false);
            this.checkProxyHasUser = new JCheckBox();
            this.getContentPane().add(this.checkProxyHasUser);
            this.checkProxyHasUser.setText(BTN_PROXY_WITH_USER);
            this.checkProxyHasUser.setBounds(12, 113, 239, 18);
            this.checkProxyHasUser.addActionListener(this);
            this.checkProxyHasUser.setEnabled(false);
            this.jLabel2 = new JLabel();
            this.getContentPane().add(this.jLabel2);
            this.jLabel2.setText("Proxy Username:");
            this.jLabel2.setBounds(12, 140, 100, 14);
            this.jLabel3 = new JLabel();
            this.getContentPane().add(this.jLabel3);
            this.jLabel3.setText("Proxy Password:");
            this.jLabel3.setBounds(12, 167, 100, 14);
            this.txtUserName = new JTextField();
            this.getContentPane().add(this.txtUserName);
            this.txtUserName.setBounds(118, 137, 222, 21);
            this.txtUserName.setEnabled(false);
            this.txtPassword = new JPasswordField();
            this.getContentPane().add(this.txtPassword);
            this.txtPassword.setBounds(118, 164, 222, 21);
            this.txtPassword.setEnabled(false);
            this.setSize(360, 280);
            this.setTitle("Proxy preferences");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setValues() {
        if (Globals.proxyEnabled) {
            this.checkProxyEnabled.setSelected(true);
            this.txtProxyAddress.setEnabled(true);
            this.spinnerPort.setEnabled(true);
            this.checkProxyHasUser.setEnabled(true);
        } else {
            this.checkProxyEnabled.setSelected(false);
            this.txtProxyAddress.setEnabled(false);
            this.spinnerPort.setEnabled(false);
            this.checkProxyHasUser.setEnabled(false);
        }
        this.txtProxyAddress.setText(Globals.proxyAddress);
        this.spinnerPort.setValue(Integer.parseInt(Globals.proxyPort));
        if (Globals.proxyHasUser) {
            this.checkProxyHasUser.setSelected(true);
            this.txtUserName.setEnabled(true);
            this.txtPassword.setEnabled(true);
        } else {
            this.checkProxyHasUser.setSelected(false);
            this.txtUserName.setEnabled(false);
            this.txtPassword.setEnabled(false);
        }
        this.txtUserName.setText(Globals.proxyUsername);
        this.txtPassword.setText(Globals.proxyPassword);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand().equals(BTN_ENABLE_PROXY)) {
            if (this.checkProxyEnabled.isSelected()) {
                this.txtProxyAddress.setEnabled(true);
                this.spinnerPort.setEnabled(true);
            } else {
                this.txtProxyAddress.setEnabled(false);
                this.spinnerPort.setEnabled(false);
            }
        } else if (e.getActionCommand().equals(BTN_PROXY_WITH_USER)) {
            if (this.checkProxyHasUser.isSelected()) {
                this.txtUserName.setEnabled(true);
                this.txtPassword.setEnabled(true);
            } else {
                this.txtUserName.setEnabled(false);
                this.txtPassword.setEnabled(false);
            }
        } else if (e.getActionCommand().equals(BTN_OK)) {
            boolean proxy = this.checkProxyEnabled.isSelected();
            String addr = this.txtProxyAddress.getText();
            String port = this.spinnerPort.getValue().toString();
            boolean hasUser = this.checkProxyHasUser.isSelected();
            String user = this.txtUserName.getText();
            String pass = this.txtPassword.getText();
            Globals.savePreferences(proxy, addr, port, hasUser, user, pass);
            this.setVisible(false);
        } else if (e.getActionCommand().equals(BTN_CANCEL)) {
            this.setVisible(false);
        }
    }
}

