#
# NAME:
#
#   	truetype_font_install installs all the TrueType fonts
#
# SYNOPSIS:	
#
#	truetype_font_install NeXT_root_directory major_version minor_version 
#				Windows_root_directory
#
#
# DESCRIPTION:
#
#	truetype_font_install is a Bourne shell script used to 
#	convert all the .ttf font files in the window root directory 
#	and places the resultant .font files in the next root directory
#
#  EXAMPLES:
#
#	>truetype_font_install $(NEXT_ROOT) 4 0 $(WINDIR)
#
NEXTFONTDIR=""
BUILDAFMDIR=""

# Check argumens 
case $# in
	1 )
		;;
	* )
		echo "runbuild : usage";
		echo "      runbuild.sh NeXT_root_directory";;
esac

# Check Next root directory
if test ! -d $1
then
	echo "runbuild : invalid NeXT root directory" $1
	exit 1
fi


NEXTFONTDIR=$1"/Library/Fonts";
BUILDAFMDIR=$1"/Library/Executables";

if test ! -d $NEXTFONTDIR
then
	echo "runbuild : invalid NeXt font directory" $NEXTFONTDIR
	exit 1
fi

echo "runbuild : running buildafmdir"

$BUILDAFMDIR/buildafmdir.exe  $NEXTFONTDIR

