#
# NAME:
#
#   	mntrinst.sh installs Monitor and MonitorProxy as services
#
# SYNOPSIS:	
#
#	mntrinst.sh NeXT_root_directory major_version minor_version 
#				Windows_root_directory
#
#
# DESCRIPTION:
#
#	mntrinst.sh is a Bourne shell script used to 
#	install the Monitor and MonitorProxy services into the registry.
#
#  EXAMPLES:
#
#	>mntrinst.sh $(NEXT_ROOT) 4 0 $(WINDIR)
#

# Check arguments 
if test $# -lt 1
then
	echo "mntrinst.sh : usage";
	echo "      mntrinst.sh NeXT_root_directory";
	exit 1
fi
echo "Number of parameters okay"

#PATH=$1/Library/WebObjects/Applications/Monitor.woa\;$PATH
#export PATH
#echo $PATH

MONITOR_DAEMON=$1/Library/WebObjects/Applications/Monitor.woa/MonitorDaemon.exe

#sleep 2
# Check Next root directory
if test ! -d $1
then
	echo "mntrinst : invalid NeXT root directory" $1
	exit 1
fi
echo "Next Root okay"

# Makesure that the executables exist before installing
if test ! -f $MONITOR_DAEMON
then
	echo "mntrinst : Can't find MonitorDaemon.exe" $1
	exit 1
fi
echo "Monitor Daemon okay"

$MONITOR_DAEMON -InstallMonitor
$MONITOR_DAEMON -InstallMonitorProxy
