#!/bin/sh
#
# docroot
#
# docroot document_root next_root
#
#
next_root=$2
document_root=$1
cat=$next_root/Developer/Executables/Utilities/cat.exe
cp=$next_root/Developer/Executables/Utilities/cp.exe
echo=$next_root/Developer/Executables/Utilities/echo.exe
mv=$next_root/Developer/Executables/Utilities/mv.exe
rm=$next_root/Developer/Executables/Utilities/rm.exe
sed=$next_root/Developer/Executables/Utilities/sed.exe
tar=$next_root/Developer/Executables/Utilities/tar.exe
#mkdirs=$next_root/Developer/Executables/Utilities/mkdirs.exe

PATH=$next_root/Library/Executables\;$next_root/Developer/Executables/Utilities\;$PATH
export PATH
echo $PATH
sleep 2

#
# Remove any old WODocumentRoot that might be lying around
#    from a previous installation.
# Copy all things in docroot_src into document_root.
#
# docroot_src: /Library/WebObjects/WODocumentRoot/WebObjects
# old_stuff: $document_root/WebObjects
#
docroot_src=$next_root/Library/WebObjects/WODocumentRoot/WebObjects
old_stuff=$document_root/WebObjects

$echo Removing old document root installation.
$rm -rf $old_stuff/Examples
$rm -rf $old_stuff/icons
$rm -rf $old_stuff/info
$rm -rf $old_stuff/Java/next
$rm -rf $old_stuff/Frameworks/WOExtensions.framework
$rm -rf $old_stuff/Frameworks/DodgeDemo.framework
$rm -rf $old_stuff/Frameworks/DirectToWeb.framework
$rm -rf $old_stuff/Frameworks/ReusableComponents.framework
$rm -rf $old_stuff/Frameworks/SharedComponentsDemo.framework
$rm -rf $old_stuff/Monitor.woa

$echo Moving WODocumentRoot contents into document root.
$cp -r $docroot_src $document_root
$rm -rf $next_root/Library/WebObjects/WODocumentRoot

#
# Create platform-independent document root indicator
#
# config_root: /Library/WebObjects/Configuration
# cgibin_name: last path component in cgi_bin
#
$echo Creating WebServerConfig.plist...
config_root=$next_root/Library/WebObjects/Configuration
stripped_cgibin=`$cat $next_root/Scratch.txt | $sed -e 's/\/$//'`
cgibin_name=`$echo $stripped_cgibin | $sed -e 's/^.*\///'`
config_file=$config_root/WebServerConfig.plist
#$mkdirs $config_root
$echo "{"                                                                    > $config_file
$echo "   //** This configuration file is used by WOF"                      >> $config_file
$echo "   //** to compute startup parameters."                              >> $config_file
$echo "   DocumentRoot = \"$document_root\";"                               >> $config_file
$echo "   WOAdaptorURL = \"http://localhost/$cgibin_name/WebObjects.exe\";" >> $config_file
$echo "}"                                                                   >> $config_file
$rm -f $next_root/Scratch.txt
$echo Done.
