#!/bin/sh
# 
#  Name
#    DOCINSTAL.SH
#
#  Description
#    1. Moves doc from installation directory ($next_root) to server's doc root.
#    2. Invokes curls.sh to customize marked URLs in the doc and examples
#
#  Editing history
#    11/11/96 Created by Matt Morse
#    11/14/96 modified after testing installer package--MM
#
#
##############################################################################################################
#  Step 1:  move doc and examples into server's doc root.
##############################################################################################################

document_root=$1
next_root=$2

cp=$next_root/Developer/Executables/Utilities/cp
rm=$next_root/Developer/Executables/Utilities/rm
mv=$next_root/Developer/Executables/Utilities/mv
mkdirs=$next_root/Developer/Executables/Utilities/mkdirs

instal=$next_root/Documentation/Developer/WebObjects/Installer
doc_src=$next_root/Documentation/Developer/WebObjects
doc_dest=$document_root/WebObjects/Documentation

echo "Moving WebObjects documentation from $doc_src to $doc_dest"
$mkdirs $doc_dest
$cp -p $doc_src/WOHomePage.html $doc_dest/WOHomePage.html
$cp -rp $doc_src/WOPages $doc_dest
$rm -rf $doc_src/WOHomePage.html
$rm -rf $doc_src/WOPages

##############################################################################################################
#  Step 2:  a) get cgi-bin and hostname;  b) invoke curls.sh on doc.
##############################################################################################################
cgi_binPath=`$instal/registry HKEY_LOCAL_MACHINE SOFTWARE/NeXT/WebObjects/Configuration CGI_BIN`
hostname=`$instal/registry HKEY_LOCAL_MACHINE SYSTEM/CurrentControlSet/Control/ComputerName/ComputerName ComputerName`

# get rid of trailing slash in cgi-bin path
lastChar=`expr "$cgi_binPath" : '.*\(.\)'`
if [ "$lastChar" = "/" ]
then
    temp=`expr "$cgi_binPath" : '\(.*\).'`
    cgi_binPath=$temp
fi

# now, chop off last path component
cgi_bin=`expr "$cgi_binPath" : '.*\/\(.*\)'`

# invoke curls.sh on $doc_dest
$instal/curls.sh -h $hostname -c $cgi_bin -F $doc_dest
