/*!
 * jQuery Cookie Plugin v1.3.1
 * https://github.com/carhartl/jquery-cookie
 *
 * Copyright 2013 Klaus Hartl
 * Released under the MIT license
 */
(function (factory) {
	if (typeof define === 'function' && define.amd) {
		// AMD. Register as anonymous module.
		define(['jquery'], factory);
	} else {
		// Browser globals.
		factory(jQuery);
	}
}(function ($) {

	var pluses = /\+/g;

	function raw(s) {
		return s;
	}

	function decoded(s) {
		return decodeURIComponent(s.replace(pluses, ' '));
	}

	function converted(s) {
		if (s.indexOf('"') === 0) {
			// This is a quoted cookie as according to RFC2068, unescape
			s = s.slice(1, -1).replace(/\\"/g, '"').replace(/\\\\/g, '\\');
		}
		try {
			return config.json ? JSON.parse(s) : s;
		} catch(er) {}
	}

	var config = $.cookie = function (key, value, options) {

		// write
		if (value !== undefined) {
			options = $.extend({}, config.defaults, options);

			if (typeof options.expires === 'number') {
				var days = options.expires, t = options.expires = new Date();
				t.setDate(t.getDate() + days);
			}

			value = config.json ? JSON.stringify(value) : String(value);

			return (document.cookie = [
				config.raw ? key : encodeURIComponent(key),
				'=',
				config.raw ? value : encodeURIComponent(value),
				options.expires ? '; expires=' + options.expires.toUTCString() : '', // use expires attribute, max-age is not supported by IE
				options.path    ? '; path=' + options.path : '',
				options.domain  ? '; domain=' + options.domain : '',
				options.secure  ? '; secure' : ''
			].join(''));
		}

		// read
		var decode = config.raw ? raw : decoded;
		var cookies = document.cookie.split('; ');
		var result = key ? undefined : {};
		for (var i = 0, l = cookies.length; i < l; i++) {
			var parts = cookies[i].split('=');
			var name = decode(parts.shift());
			var cookie = decode(parts.join('='));

			if (key && key === name) {
				result = converted(cookie);
				break;
			}

			if (!key) {
				result[name] = converted(cookie);
			}
		}

		return result;
	};

	config.defaults = {};

	$.removeCookie = function (key, options) {
		if ($.cookie(key) !== undefined) {
			$.cookie(key, '', $.extend(options, { expires: -1 }));
			return true;
		}
		return false;
	};

}));


//shuffle plugin
(function(d){d.fn.shuffle=function(c){c=[];return this.each(function(){c.push(d(this).clone(true))}).each(function(a,b){d(b).replaceWith(c[a=Math.floor(Math.random()*c.length)]);c.splice(a,1)})};d.shuffle=function(a){return d(a).shuffle()}})(jQuery);

//Showing - Firing function when OBJ appears in Window viewport $(obj).showing(function(){...},50); 
// * where '50' is percentage of object area visible in viewport / by dofton, 2013
(function( $ ){
	  $.fn.showing = function(func,position) {
	  return this.each(function(i){
	  		var $position = position?position:'20';
	  		var $this = $(this);
	  		var objtop = $this.offset().top;
	  		var test = function(){
		  		return ((objtop+($this.outerHeight()/Math.round(100/$position)))<($(document).scrollTop()+$(window).height())?true:false);
	  		}
	  		var handler = function(){
			  	if (test.call()){event.call()}
	  		}
	  		var event = function(){
			  		func.call($this);
					$(document).unbind('scroll',handler);
					$(window).unbind('resize',handler);
	  		}
	  		if (test.call()){event.call()}else{$(document).bind('scroll',handler); $(window).bind('resize',handler)};
	  });
	  };
	})( jQuery );


//Count-up - jQuery plugin $(obj).countup(destination,speed,function); / by dofton, 2013
(function( $ ){
	  $.fn.countup = function(destin,time,func) {
	  return this.each(function(i){
	  	var $this = $(this);
        var cnt = 1;
        var prnt = '';
        destin = (isNaN(destin))?(destin=($($this).text())):(destin);
        var counter = setInterval(function() {
            if (cnt < destin) {
                	prnt = function(){
            		var val = '';
            		var zeros = (destin.toString().length)-((Math.round(cnt)).toString().length);
            		for (var i=0;i<zeros;i++){ val=val.toString()+'0';}
            		return ('<span style="color:#ddd">'+val+'</span>'+((Math.round(cnt)).toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,")));
					};
                $this.html(prnt);
                cnt=cnt*1.1;
            }
            else {
                clearInterval(counter);
            	$this.html(destin.toString().replace(/(\d)(?=(\d\d\d)+(?!\d))/g, "$1,"));
            	try {
	                func.call($this);
				} catch(err){
					return true;
				        }
            }
            }, time);
	  });
	  };
	})( jQuery );

//addTip - tool $(obj).addTip('Some tip goes here'); / by dofton, 2013
(function( $ ){
	  $.fn.addTip = function(content,position) {
	  return this.each(function(i){
	  	var pos = position?position:'auto';
	  	var $this = $(this);
	  	var tipblock, timeout;
	  	$this.hover(function(){
	  		timeout = setTimeout(function(){
		  	tipblock = $(('<div style="position:absolute;top:'+$this.offset().top+'px;left:'+$this.offset().left+'px;background-color:#000;color:#fff;padding:13px;display:none;z-index:30;width:200px;text-align:center; font-size:14px;opacity:.9;box-shadow:0 1px 5px #000">'+content+'<span style="position:absolute;background-size:30px 15px;background-image:url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAeCAYAAABwmH1PAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJdJREFUeNrkz8kNwCAUA1H6P9FxtlOkbAT+YpuRpoBXSil1e5nk3XpUZ8LOgL5gldGPWEX0J1YJ3YxVQP/GMqO7sYzoYSwT2gzLgDbHIqPdsIhodywSOgyLgA7HZqLTsBnodGwkGgYbgYbDeqJhsR5oeKwlmgZrgabDjqBpsT1oeuwftAy2BS2HfUPLYu/Q8tgzOgW7CjAAv8+EiPUbeaAAAAAASUVORK5CYII=);width:30px;height:15px;bottom:-15px;left:100px"></span></div>'));
		  	$('body').append(tipblock);
		  	tipblock.css('left',((parseInt(tipblock.css('left'))+($this.outerWidth()/2)-(tipblock.outerWidth()/2))+'px'));
		  	switch(pos)
			{
			case 'bottom':{
//			  $() //not implimented
			  break;
			  }
			case 'top':{
//			  $() //not implimented
			  break;
			  }
			default:{
				var direction = 'top';
			  	tipblock.css('top',(($this.offset().top-tipblock.outerHeight()-32)+'px'));
			  	if (parseInt(tipblock.css('top'))<$(document).scrollTop()) {
			  		direction = 'bottom';
				  	tipblock.css('top',(($this.offset().top+$this.outerHeight()+32)+'px'));
				  	$('span',tipblock).css({'background-image':'url(data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADwAAAAeCAYAAABwmH1PAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAJVJREFUeNrkz8kJwDAUA9H0D645IWByyeblL5I8MAW8bcup1JfohO71shJWHv2ElUV/YeXQLVgZdA+WHj2CpUXPYOnQFlgatCUWHu2BhUV7YuHQEVgYdCQ2HZ2BTUNnYsPRCNgwNBLWHY2IdUMjY83RDFgzNBN2Gs2IHUYzY7vRCthmtBL2F62IfUUrY2/oFbAX+hBgALWpg9Q83xvVAAAAAElFTkSuQmCC)','bottom':'auto','top':'-15px'});
			  	}
			  	$(tipblock).fadeIn('slow').animate({ top: (direction=='top'?"+=16px":"-=16px") },{ duration: 300, queue: false });
			  	
			  }
			}
			}, 200);
	  	},function(){
	  		clearTimeout(timeout);
		  	$(tipblock).fadeOut('fast',function(){$(this).remove()});
	  	});
	  	});
	  };
	})( jQuery );

//addWebkitClass - jQuery plugin adds class name for animation classes and removes them after animation ends $(obj).addWebkitClass('classname')  ; 
// by dofton, 2013
(function( $ ){
	  $.fn.addWebkitClass = function(cssclass,func) {
	  var animEndProp = (/WebKit/.test(navigator.userAgent))?'webkitAnimationEnd':'animationend';
	  return this.each(function(i){
	  	var $this = $(this);
	  	var removeClass = function(){
	  		$this.removeClass(cssclass).unbind(animEndProp,removeClass);
	  		try {
	                func.call($this);
				} catch(err){
					return true;
				}
	  		}
	  	$this.addClass(cssclass).bind(animEndProp,removeClass);
	  });
	  };
	})( jQuery );


// randomize any array by Gabriele Romanato
(function($) {
  $.randomize = function(arr) {
    for(var j, x, i = arr.length; i; j = parseInt(Math.random() * i), x = arr[--i], arr[i] = arr[j], arr[j] = x);
    return arr;
  };
})(jQuery);


//SWITCHER plugin - creates switcher from divs (css required)
(function( $ ){
	$.fn.bindSwitcher = function(arr,func) {
	return this.each(function(i){

	var o = this;
	var a = arr;
	var f = func;
	var swtch = {
		obj: '',
		currClass: 'sbutcurr',
		func: '',
		buildSwitcher: function(switcherobj,values,func){
			var ths = this;
			ths.obj = $(switcherobj);
			ths.func = func;
			ths.obj.addClass('switchers');
			$.each(values,function(){
				ths.obj.append(ths.clk(ths.createObj(this)));
			})
		},
		createObj: function(arr){
			return $('<div class="sbut'+(arr.isDefault?(' '+this.currClass):'')+'" val="'+arr.value+'">'+arr.name+'</div>');
		},
		setCurrent: function(obj){
			this.obj.children().removeClass(this.currClass);
			return $(obj).addClass(this.currClass).attr('val');
		},
		callFunc: function(obj){
			this.func(this.setCurrent(obj));
		},
		clk: function(obj){
			var ths = this;
			var o = obj;
			obj.bind('click',function(){ths.callFunc(o)});
			return obj;
		}
	}
	swtch.buildSwitcher(this,a,f);
	});
	};

})(jQuery);

(function($){

  $.extend({
    playSound: function(){
      return $("<embed src='"+arguments[0]+"' hidden='true' autostart='true' loop='false' class='playSound'>").appendTo('body');
    }
  });

})(jQuery);