//
//  DMProblemReporter.h
//  DevMate
//
//  Copyright 2013 MacPaw Inc. All rights reserved.
//

#import <Cocoa/Cocoa.h>

@protocol DevMateProblemReporterDelegate;

@class DMHostApplication;
@class DMProblemWindowController;
@class DMFeedbackWindowController;
@class PLCrashReporter;
@class DMReportsLibrary;

@interface DMProblemReporter : NSObject
{
    @private
        id<DevMateProblemReporterDelegate> delegate;
        
        NSString *userEmail;
        NSArray *logURLs;
        NSURL *SparkleFeedURL;
        
        DMProblemWindowController *problemWindowController;
        DMFeedbackWindowController *feedbackWindowController;

        DMHostApplication *hostApplication;
        PLCrashReporter *plReporter;
        DMReportsLibrary *library;
}

+ (DMProblemReporter *)sharedReporter;

- (void)enableCrashReporting;
- (void)enableUncaughtExceptionReporting;

//! Show problem reporter with crashes that user hasn't seen yet. This can happen when crash reporter failed to show reporter in time for some reason.
//! You should call this method on application launch.
- (void)reportUnhandledCrashes;

- (IBAction)showFeedbackDialog:(id)aSender;

@property (assign) id<DevMateProblemReporterDelegate> delegate;

//! User email to use inside the problem reporter. Contains the last entered email by user.
@property (retain, nonatomic) NSString *userEmail;

//! Array of NSURL instances. Set it in case you have custom log files. By default log is obtained from ASL (default NSLog behaviour).
@property (retain, nonatomic) NSArray *logURLs;

//! Sparkle Feed URL to check if problem occured with the latest version of application.
@property (retain, nonatomic) NSURL *SparkleFeedURL;

//! Determine if application started with '-testCrashes' argument. Use this to test crash reporter.
@property (nonatomic, readonly, getter = isInTestMode) BOOL inTestMode;

@end

@protocol DevMateProblemReporterDelegate <NSObject>

@required
- (void)reporterWillRestartApplication:(DMProblemReporter *)reporter;

@end