//
//  openfile.m
//  general use
//
//  Created by Flea on Thu May 23 2002.
//  Copyright (c) 2002 . All rights reserved.
//

#include "openfile.h"



int openFile( char * r )

{
    NSOpenPanel *oPanel = [NSOpenPanel openPanel];
    int i, count, result;
    char cstrName[1024];
    NSArray *filesToOpen;
    NSArray *fileTypes = nil;
    
    [oPanel setAllowsMultipleSelection:NO];
    [oPanel setTitle:@"Open Rom..."];
    result = [oPanel runModalForDirectory:nil file:nil types:fileTypes];
    if (result == NSOKButton) 
    {
        filesToOpen = [oPanel filenames];
        count = [filesToOpen count];
        for (i=0; i<count; i++) 
        {
            NSString *aFile = [filesToOpen objectAtIndex:i];
            [aFile getCString: cstrName];
            strcpy(r , cstrName);
        
        }
        return 1;
    }
    return 0;
}

void noBiosError (void)
{
NSRunInformationalAlertPanel(@"Error!",@"BIOS File Not Found.  Please put gbasys.bin in the VisualBoyAdvance folder.",@"OK",NULL,NULL);
}

/*bool stopPoll = false;


#define GETHATCODE(event) ((event.jhat.which+1)<<12)|(event.jhat.hat<<2)|\
  (event.jhat.value & SDL_HAT_UP ? 0 : event.jhat.value & SDL_HAT_DOWN ? 1 : event.jhat.value & SDL_HAT_RIGHT ? 2 : event.jhat.value & SDL_HAT_LEFT ? 3 : 0)

#define GETBUTTONCODE(event) ((event.jbutton.which+1)<<12)|(event.jbutton.button+0x80)

#define GETAXISCODE(event) ((event.jaxis.which+1)<<12)|(event.jaxis.axis<<1)|(event.jaxis.value > 16384 ? 1 : event.jaxis.value < -16384 ? 0 : 0)

void poll( int key )
{
  SDL_Event event;
  
  while(SDL_PollEvent(&event)) {
    switch(event.type) {
    case SDL_JOYHATMOTION:
      printf("JOY HAT code: %04x\n", GETHATCODE(event));
      gKeyValue[key] = GETHATCODE(event);
      stopPoll = true;
      break;
    case SDL_JOYBUTTONDOWN:
      printf("JOY BUTTON code: %04x\n", GETBUTTONCODE(event));
      gKeyValue[key] = GETBUTTONCODE(event);
      stopPoll = true;
      break;
    case SDL_JOYAXISMOTION:
      printf("JOY AXIS code: %04x\n", GETAXISCODE(event));
      gKeyValue[key] = GETAXISCODE(event);
      stopPoll = true;
      break;
    case SDL_KEYDOWN:
      printf("KEY code: %04x\n", event.key.keysym.sym);
      gKeyValue[key] = event.key.keysym.sym;
      stopPoll = true;
      break;
    case SDL_KEYUP:
      break;
    }
  }
}

int configKey( int key )
{
if (SDL_WasInit(SDL_INIT_TIMER|SDL_INIT_VIDEO) == 0)
{
  
  if(SDL_Init(SDL_INIT_TIMER|SDL_INIT_VIDEO)) {
    printf("Failed to init SDL: %d\n", SDL_GetError());
    exit(-1);
  }

  if(SDL_InitSubSystem(SDL_INIT_JOYSTICK)) {
    printf("Failed to init joystick: %d\n", SDL_GetError());
  }
}

  SDL_Surface *surface = SDL_SetVideoMode(1,1, 16,
                                          SDL_ANYFORMAT);
  int numJoy = SDL_NumJoysticks();
  
  for(int i = 0; i < numJoy; i++) {
    SDL_JoystickOpen(i);
  }
  SDL_JoystickEventState(SDL_ENABLE);

  while(!stopPoll) {
    poll( key );
    SDL_Delay(100);
  }
  //SDL_Quit();
  return gKeyValue[key];
}

*/
