/*   SDLMain.m - main entry point for our Cocoa-ized SDL app
       Initial Version: Darrell Walisser <dwaliss1@purdue.edu>
       Non-NIB-Code & other changes: Max Horn <max@quendi.de>

    Feel free to customize this file to suit your needs
*/

#import "SDL.h"
#import "SDLMain.h"
#import "openfile.h"
#import <sys/param.h> /* for MAXPATHLEN */
#import <unistd.h>

/* Use this flag to determine whether we use SDLMain.nib or not */
#define		SDL_USE_NIB_FILE	1


static int    gArgc;
static char  **gArgv;
static BOOL   gFinderLaunch;
extern int done;
extern int emulating;
extern void sdlEmuReset( void );
extern void sdlEmuPause( void );

#if SDL_USE_NIB_FILE
/* A helper category for NSString */
@interface NSString (ReplaceSubString)
- (NSString *)stringByReplacingRange:(NSRange)aRange with:(NSString *)aString;
@end
#else
/* An internal Apple class used to setup Apple menus */
@interface NSAppleMenuController:NSObject {}
- (void)controlMenu:(NSMenu *)aMenu;
@end
#endif

@interface SDLApplication : NSApplication
@end

@implementation SDLApplication
/* Invoked from the Quit menu item */
- (void)terminate:(id)sender
{
    /* Post a SDL_QUIT event */
    SDL_Event event;
    event.type = SDL_QUIT;
    SDL_PushEvent(&event);
}
@end


/* The main class of the application, the application's delegate */
@implementation SDLMain


- (void) quit:(id)sender
{
if (emulating == true)
{
done = true;
emulating = false;
}
else
{
exit(0);
}
}

- (void) openPrefs:(id)sender
{
[self loadConfig];
[prefsWindow makeKeyAndOrderFront:self];
}

- (void) closePrefsNull:(id)sender
{
[prefsWindow orderOut:self];
}

- (void)closePrefs:(id)sender
{
        
        NSMutableString * path = [[NSMutableString alloc] initWithString:[[NSBundle mainBundle] bundlePath]];
        [path deleteCharactersInRange:NSMakeRange( [path length] - 20, 20 )];
        [path appendString:@"VisualBoyAdvance.cfg"];
        NSMutableString * outFile = [[NSMutableString alloc] initWithFormat:@"#VisualBoyAdvance Prefs\n"];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Left 0114\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Right 0113\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Up 0111\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Down 0112\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_A 007a\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_B 0078\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_L 0061\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_R 0073\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Start 000d\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Select 0008\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Speed 0020\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Capture 003d\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Motion_Left 0104\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Motion_Right 0106\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Motion_Up 0108\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Motion_Down 0102\n"]];
        [outFile appendString:[NSString stringWithFormat:@"frameSkip %i\n", [gbaFrameSkip indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"gbFrameSkip %i\n", [gbFrameSkip indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"video %i\n", [videoSize indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"fullScreen %i\n", [videoFullscreen indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"useBios 1\n"]];
        [outFile appendString:[NSString stringWithFormat:@"biosFile gbasys.bin\n"]];
        [outFile appendString:[NSString stringWithFormat:@"filter %i\n", [videoFilter indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"borderOn %i\n", [videoBorder indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"disableStatus 1\n"]];
        [outFile appendString:[NSString stringWithFormat:@"emulatorType 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"colorOption %i\n", [videoWashedColors indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"captureFormat 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"soundOn %i\n", [soundOn indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"soundQuality %i\n", ([soundQuality indexOfSelectedItem] + 1)]];
        [outFile appendString:[NSString stringWithFormat:@"soundLowPass %i\n", [soundLowPass indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"soundEcho %i\n", [soundEcho indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"soundReverse %i\n", [soundReverseStereo indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"removeIntros %i\n", [removeIntros indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"flashSize %i\n", [flashSize indexOfSelectedItem]]];
        [outFile appendString:[NSString stringWithFormat:@"saveDir Save States\n"]];
        [outFile appendString:[NSString stringWithFormat:@"captureDir Screenshots\n"]];
        [outFile appendString:[NSString stringWithFormat:@"batteryDir Battery Saves\n"]];
        [outFile writeToFile:path atomically:YES];
        printf( "Writing the .cfg file (%s)\n", [path cString] );
        
        [prefsWindow orderOut:self];
}

-(void) loadConfig
{
    NSMutableString * path = [[NSMutableString alloc] initWithString:[[NSBundle mainBundle] bundlePath]];
    [path deleteCharactersInRange:NSMakeRange( [path length] - 20, 20 )];
    [path appendString:@"VisualBoyAdvance.cfg"];
    
    if( ![[NSFileManager defaultManager] fileExistsAtPath:path] ) {
    NSMutableString * outFile = [[NSMutableString alloc] initWithFormat:@"#VisualBoyAdvance Prefs\n"];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Left 0114\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Right 0113\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Up 0111\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Down 0112\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_A 007a\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_B 0078\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_L 0061\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_R 0073\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Start 000d\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Select 0008\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Speed 0020\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Joy0_Capture 003d\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Motion_Left 0104\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Motion_Right 0106\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Motion_Up 0108\n"]];
        [outFile appendString:[NSString stringWithFormat:@"Motion_Down 0102\n"]];
        [outFile appendString:[NSString stringWithFormat:@"frameSkip 2\n"]];
        [outFile appendString:[NSString stringWithFormat:@"gbFrameSkip 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"video 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"fullScreen 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"useBios 1\n"]];
        [outFile appendString:[NSString stringWithFormat:@"biosFile gbasys.bin\n"]];
        [outFile appendString:[NSString stringWithFormat:@"filter 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"borderOn 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"disableStatus 1\n"]];
        [outFile appendString:[NSString stringWithFormat:@"emulatorType 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"colorOption 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"captureFormat 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"soundOn 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"soundQuality 1\n"]];
        [outFile appendString:[NSString stringWithFormat:@"soundLowPass 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"soundEcho 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"soundReverse 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"removeIntros 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"flashSize 0\n"]];
        [outFile appendString:[NSString stringWithFormat:@"saveDir Save States\n"]];
        [outFile appendString:[NSString stringWithFormat:@"captureDir Screenshots\n"]];
        [outFile appendString:[NSString stringWithFormat:@"batteryDir Battery Saves\n"]];
        [outFile writeToFile:path atomically:YES];
        printf( "Writing the default .cfg file (%s)\n", [path cString] );
        }
        else
        {
        int add;
        NSString * configFile, * buffer;
        NSRange scan;
        
        configFile = [NSString stringWithContentsOfFile:path];
        
        scan = [configFile rangeOfString:@"video "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [videoSize selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [videoSize selectItemAtIndex:1];
        if( [buffer isEqualTo:@"2"] )
            [videoSize selectItemAtIndex:2];
        if( [buffer isEqualTo:@"3"] )
            [videoSize selectItemAtIndex:3];
            
        scan = [configFile rangeOfString:@"fullScreen "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [videoFullscreen selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [videoFullscreen selectItemAtIndex:1];
            
        scan = [configFile rangeOfString:@"filter "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [videoFilter selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [videoFilter selectItemAtIndex:1];
        if( [buffer isEqualTo:@"2"] )
            [videoFilter selectItemAtIndex:2];
        if( [buffer isEqualTo:@"3"] )
            [videoFilter selectItemAtIndex:3];
        if( [buffer isEqualTo:@"4"] )
            [videoFilter selectItemAtIndex:4];
        if( [buffer isEqualTo:@"5"] )
            [videoFilter selectItemAtIndex:5];
        if( [buffer isEqualTo:@"6"] )
            [videoFilter selectItemAtIndex:6];
        if( [buffer isEqualTo:@"7"] )
            [videoFilter selectItemAtIndex:7];
            
        scan = [configFile rangeOfString:@"borderOn "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [videoBorder selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [videoBorder selectItemAtIndex:1];
            
        scan = [configFile rangeOfString:@"colorOption "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [videoWashedColors selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [videoWashedColors selectItemAtIndex:1];
            
        scan = [configFile rangeOfString:@"soundOn "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [soundOn selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [soundOn selectItemAtIndex:1];
            
        scan = [configFile rangeOfString:@"soundQuality "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"1"] )
            [soundQuality selectItemAtIndex:0];
        if( [buffer isEqualTo:@"2"] )
            [soundQuality selectItemAtIndex:1];
        if( [buffer isEqualTo:@"3"] )
            [soundQuality selectItemAtIndex:2];
            
        scan = [configFile rangeOfString:@"soundEcho "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [soundEcho selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [soundEcho selectItemAtIndex:1];
            
        scan = [configFile rangeOfString:@"soundLowPass "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [soundLowPass selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [soundLowPass selectItemAtIndex:1];
            
        scan = [configFile rangeOfString:@"soundReverse "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [soundReverseStereo selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [soundReverseStereo selectItemAtIndex:1];
            
        scan = [configFile rangeOfString:@"removeIntros "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [removeIntros selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [removeIntros selectItemAtIndex:1];
            
        scan = [configFile rangeOfString:@"flashSize "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [flashSize selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [flashSize selectItemAtIndex:1];
            
        scan = [configFile rangeOfString:@"frameSkip "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [gbaFrameSkip selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [gbaFrameSkip selectItemAtIndex:1];
        if( [buffer isEqualTo:@"2"] )
            [gbaFrameSkip selectItemAtIndex:2];
        if( [buffer isEqualTo:@"3"] )
            [gbaFrameSkip selectItemAtIndex:3];
        if( [buffer isEqualTo:@"4"] )
            [gbaFrameSkip selectItemAtIndex:4];
        if( [buffer isEqualTo:@"5"] )
            [gbaFrameSkip selectItemAtIndex:5];
            
        scan = [configFile rangeOfString:@"gbFrameSkip "];
        add = scan.location + scan.length;
        buffer = [NSString stringWithString:[configFile substringWithRange:NSMakeRange( add, 1 )]];
        if( [buffer isEqualTo:@"0"] )
            [gbFrameSkip selectItemAtIndex:0];
        if( [buffer isEqualTo:@"1"] )
            [gbFrameSkip selectItemAtIndex:1];
        if( [buffer isEqualTo:@"2"] )
            [gbFrameSkip selectItemAtIndex:2];
        if( [buffer isEqualTo:@"3"] )
            [gbFrameSkip selectItemAtIndex:3];
        if( [buffer isEqualTo:@"4"] )
            [gbFrameSkip selectItemAtIndex:4];
        if( [buffer isEqualTo:@"5"] )
            [gbFrameSkip selectItemAtIndex:5];
            
        printf("Loading config...\n");
        }
}


- (void) closeRom:(id)sender
{
emulating = false;
//SDL_Quit();
//NSApplicationMain(gArgc, **gArgv);
}

- (void) openRomFromMenu:(id)sender
{
//emulating = false;
//SDL_Quit();
main (gArgc, **gArgv);

}

-(void) resetEmulation:(id)sender
{
    sdlEmuReset();
}

-(void) pauseEmulation:(id)sender
{
    sdlEmuPause();
}

/* Set the working directory to the .app's parent directory */
- (void) setupWorkingDirectory:(BOOL)shouldChdir
{
    char parentdir[MAXPATHLEN];
    char *c;
    
    strncpy ( parentdir, gArgv[0], sizeof(parentdir) );
    c = (char*) parentdir;

    while (*c != '\0')     /* go to end */
        c++;
    
    while (*c != '/')      /* back up to parent */
        c--;
    
    *c++ = '\0';             /* cut off last part (binary name) */
  
    if (shouldChdir)
    {
      assert ( chdir (parentdir) == 0 );   /* chdir to the binary app's parent */
      assert ( chdir ("../../../") == 0 ); /* chdir to the .app's parent */
    }
}

#if SDL_USE_NIB_FILE
#else

void setupAppleMenu(void)
{
    /* warning: this code is very odd */
    NSAppleMenuController *appleMenuController;
    NSMenu *appleMenu;
    NSMenuItem *appleMenuItem;

    appleMenuController = [[NSAppleMenuController alloc] init];
    appleMenu = [[NSMenu alloc] initWithTitle:@""];
    appleMenuItem = [[NSMenuItem alloc] initWithTitle:@"" action:nil keyEquivalent:@""];
    
    [appleMenuItem setSubmenu:appleMenu];

    /* yes, we do need to add it and then remove it --
       if you don't add it, it doesn't get displayed
       if you don't remove it, you have an extra, titleless item in the menubar
       when you remove it, it appears to stick around
       very, very odd */
    [[NSApp mainMenu] addItem:appleMenuItem];
    [appleMenuController controlMenu:appleMenu];
    [[NSApp mainMenu] removeItem:appleMenuItem];
    [appleMenu release];
    [appleMenuItem release];
}

/* Create a window menu */
void setupWindowMenu(void)
{
    NSMenu		*windowMenu;
    NSMenuItem	*windowMenuItem;
    NSMenuItem	*menuItem;


    windowMenu = [[NSMenu alloc] initWithTitle:@"Window"];
    
    /* "Minimize" item */
    menuItem = [[NSMenuItem alloc] initWithTitle:@"Minimize" action:@selector(performMiniaturize:) keyEquivalent:@"m"];
    [windowMenu addItem:menuItem];
    [menuItem release];
    
    /* Put menu into the menubar */
    windowMenuItem = [[NSMenuItem alloc] initWithTitle:@"Window" action:nil keyEquivalent:@""];
    [windowMenuItem setSubmenu:windowMenu];
    [[NSApp mainMenu] addItem:windowMenuItem];
    
    /* Tell the application object that this is now the window menu */
    [NSApp setWindowsMenu:windowMenu];

    /* Finally give up our references to the objects */
    [windowMenu release];
    [windowMenuItem release];
}

/* Replacement for NSApplicationMain */
void CustomApplicationMain (argc, argv)
{
    NSAutoreleasePool	*pool = [[NSAutoreleasePool alloc] init];
    SDLMain				*sdlMain;

    /* Ensure the application object is initialised */
    [SDLApplication sharedApplication];
    
    /* Set up the menubar */
    [NSApp setMainMenu:[[NSMenu alloc] init]];
    setupAppleMenu();
    setupWindowMenu();
    
    /* Create SDLMain and make it the app delegate */
    sdlMain = [[SDLMain alloc] init];
    [NSApp setDelegate:sdlMain];
    
    /* Start the main event loop */
    [NSApp run];
    
    [sdlMain release];
    [pool release];
}

#endif

/* Called when the internal event loop has just started running */
- (void) applicationDidFinishLaunching: (NSNotification *) note
{
    int status;

    /* Set the working directory to the .app's parent directory */
    [self setupWorkingDirectory:gFinderLaunch];
    
    /* Create the threads, mutexs, and conditional variable */
    //pthread_mutex_init(myMutex);
    //pthread_cond_init(
    

    /* Hand off to main application code */
    status = SDL_main (gArgc, gArgv);

    /* We're done, thank you for playing */
    exit(status);
}
@end


@implementation NSString (ReplaceSubString)

- (NSString *)stringByReplacingRange:(NSRange)aRange with:(NSString *)aString
{
    unsigned int bufferSize;
    unsigned int selfLen = [self length];
    unsigned int aStringLen = [aString length];
    unichar *buffer;
    NSRange localRange;
    NSString *result;

    bufferSize = selfLen + aStringLen - aRange.length;
    buffer = NSAllocateMemoryPages(bufferSize*sizeof(unichar));
    
    /* Get first part into buffer */
    localRange.location = 0;
    localRange.length = aRange.location;
    [self getCharacters:buffer range:localRange];
    
    /* Get middle part into buffer */
    localRange.location = 0;
    localRange.length = aStringLen;
    [aString getCharacters:(buffer+aRange.location) range:localRange];
     
    /* Get last part into buffer */
    localRange.location = aRange.location + aRange.length;
    localRange.length = selfLen - localRange.location;
    [self getCharacters:(buffer+aRange.location+aStringLen) range:localRange];
    
    /* Build output string */
    result = [NSString stringWithCharacters:buffer length:bufferSize];
    
    NSDeallocateMemoryPages(buffer, bufferSize);
    
    return result;
}

@end



#ifdef main
#  undef main
#endif


/* Main entry point to executable - should *not* be SDL_main! */
int main (int argc, char **argv)
{

    /* Copy the arguments into a global variable */
    int i;
    
    /* This is passed if we are launched by double-clicking */
    if ( argc >= 2 && strncmp (argv[1], "-psn", 4) == 0 ) {
        gArgc = 1;
	gFinderLaunch = YES;
    } else {
        gArgc = argc;
	gFinderLaunch = NO;
    }
    gArgv = (char**) malloc (sizeof(*gArgv) * (gArgc+1));
    assert (gArgv != NULL);
    for (i = 0; i < gArgc; i++)
        gArgv[i] = argv[i];
    gArgv[i] = NULL;

#if SDL_USE_NIB_FILE
    [SDLApplication poseAsClass:[NSApplication class]];
    NSApplicationMain (argc, argv);
#else
    CustomApplicationMain (argc, argv);
#endif
    return 0;
}
