/*
 *  Turbo264.h
 *  TurboFramework
 *
 *  Created by Uli Kusterer on 05.05.08.
 *  Copyright 2008 Elgato Systems GmbH. All rights reserved.
 *
 */

/* Umbrella header for the Elgato Turbo.264 framework. */

// -----------------------------------------------------------------------------
//	Headers:
// -----------------------------------------------------------------------------

#include "Turbo264Constants.h"


// -----------------------------------------------------------------------------
//	Cocoa/QTKit API:
// -----------------------------------------------------------------------------

#if __OBJC__
#import "ESTurbo264.h"
#endif


// -----------------------------------------------------------------------------
//	Carbon/QuickTime API:
// -----------------------------------------------------------------------------

typedef void (*ESTurbo264DeviceCountChangedCallback)();

// The following function is for users of the procedural QuickTime APIs:
//	Caller is responsible of disposing of outExportSettings.
// Returns invalidComponentID error constant when Turbo component is not installed.

extern OSStatus		ESCreateTurboExportSettingsAtomForPreset( CFDictionaryRef presetDict, Handle* outExportSettings );

// This returns an array of dictionaries describing the available presets, pass
//	one of those to the call above to get the appropriate settings dictionary.
extern CFArrayRef	ESCopyExportPresets();	// equivalent to [[ESTurbo264 sharedTurbo264] exportPresets].


// Returns true if the Turbo component and a device are available:
extern bool			ESTurbo264Available();


// Register a callback that tells you when a Turbo device is added/removed:
//	Call ESTurbo264Available() to find out whether the device was plugged in or removed.
//	Set to NULL to remove the callback again.
extern void			ESSetTurbo264DeviceCountChangedCallback( ESTurbo264DeviceCountChangedCallback callbk );