//
//  ESTurbo264.h
//  UKTurboExport
//
//  Created by Uli Kusterer on 09.02.08.
//  Copyright 2008 M. Uli Kusterer. All rights reserved.
//

/*
	This is a class that implements a singleton object through which you can
	talk to Elgato's Turbo.264 device from a Cocoa app. It lets you detect the
	presence of the device and QuickTime component, sends out notifications
	when the device is plugged in or unplugged, and lets you list the presets
	available.
*/

// -----------------------------------------------------------------------------
//	Headers:
// -----------------------------------------------------------------------------

#import <Cocoa/Cocoa.h>


// -----------------------------------------------------------------------------
//	Forwards:
// -----------------------------------------------------------------------------

struct ESTurbo264IVars;


// -----------------------------------------------------------------------------
//	Class:
// -----------------------------------------------------------------------------

@interface ESTurbo264 : NSObject
{
	struct ESTurbo264IVars*	_ivars;	// Avoids fragile base class issues in case someone subclasses this.
}

+(id)				sharedTurbo264;

-(BOOL)				isAvailable;	// Is the Turbo Component installed and a device plugged in right now?

-(NSArray*)			exportPresets;	// NSArray of NSDictionaries with the list of supported presets (built-in only right now). Empty array if no component installed.
-(NSDictionary*)	exportPresetForID: (NSString*)presetIdentifier;			// presetIdentifier is a ESTurbo264PresetIdentifierKey value.

-(NSData*)			exportSettingsFromPreset: (NSDictionary*)preset;		// Takes exportPreset, gives QTMovieExportSettings NSData block.

-(NSDictionary*)	writeToFileAttributesForPreset: (NSDictionary*)preset;	// Returns an attributes dictionary with QTMovieExportSettings and all other keys set up correctly for QTMovie -writeToFile:.

@end


// -----------------------------------------------------------------------------
//	Constants:
// -----------------------------------------------------------------------------

// exportPresets dictionary fields:
extern NSString*	ESTurbo264PresetIdentifierKey;		// NSString with unique identifier of preset. Use this if you want to save the current preset to persistent storage.
extern NSString*	ESTurbo264PresetDisplayNameKey;		// NSString with localized name of preset.
extern NSString*	ESTurbo264PresetInternalIDKey;		// NSNumber containing a long with the actual type to hand to the exporter.

// Notifications sent by ESTurbo264: (call [ESTurbo264 sharedTurbo264] at startup or you won't get these)
//	Sent to the default NSNotificationCenter. Pass nil as the object.
extern NSString*	ESTurbo264DeviceCountChangedNotification;



