/*
 * Decompiled with CFR 0.152.
 */
package com.webworks.help3;

import com.webworks.help3.ColorUtils;
import com.webworks.help3.GeneralUtils;
import com.webworks.help3.ListItem;
import com.webworks.help3.OS;
import com.webworks.help3.PropertyChangeSupport;
import com.webworks.help3.VetoableChangeSupport;
import java.awt.AWTEventMulticaster;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class ImageListBox
extends Panel
implements ItemSelectable,
AdjustmentListener,
MouseMotionListener,
MouseListener,
KeyListener {
    public static final int EVT_IMAGE_SELECT = 16388;
    public static final int BORDER_REGULAR = 0;
    public static final int BORDER_NONE = 1;
    public static final int IMAGE_WIDTH = 19;
    protected int nTopRow = 0;
    protected int lWidth = 0;
    protected int cellHt = 0;
    protected int yAdj = 0;
    protected int borderWidth = 4;
    protected int halfBorderWidth = 2;
    ActionListener actionListener = null;
    ItemListener itemListener = null;
    protected final int LINE_SLOP = 6;
    protected String ilbLabel;
    protected Scrollbar VBar = null;
    protected Scrollbar HBar = null;
    protected Vector items;
    protected Font font;
    protected transient FontMetrics fm = null;
    protected transient boolean bAllDirty = true;
    protected boolean bMultipleSelections = false;
    protected boolean bBlockPaint = false;
    protected boolean bVBarVisible = false;
    protected boolean bHBarVisible = false;
    protected transient boolean bInternalBlockPaint = false;
    protected int rowsToShow = -1;
    protected int colsToShow = 10;
    protected transient int visibleRows = -1;
    protected transient int visibleCols = -1;
    protected int visibleIndex = -1;
    protected transient int fontHeight;
    protected transient int fontDescent;
    protected transient int lastDownModifiers = -1;
    protected transient int lastSelected = -1;
    protected transient int lastIndex = -1;
    protected transient int lastTempIndex = -1;
    protected transient int countSelected = 0;
    protected int borderType = 0;
    protected int longestLineValue = 0;
    protected transient int barSize = 0;
    protected int xCoord = 0;
    protected transient long prevSelectTime = -1L;
    protected transient long prevSelectRow = -1L;
    protected boolean bComboMode = false;
    protected boolean bCellBorders = false;
    protected boolean bAllowShowVBar = true;
    protected boolean bAllowShowHBar = true;
    protected Color borderLighterColor = null;
    protected Color borderDarkerColor = null;
    protected Color borderLightColor = null;
    protected Color borderDarkColor = null;
    protected Color cachedBackground = null;
    protected Color textHighlight = OS.isMacintosh() ? new Color(0, 0, 128) : SystemColor.textHighlight;
    protected Color textHighlightText = OS.isMacintosh() ? Color.white : SystemColor.textHighlightText;
    protected Color enabledColor = OS.isMacintosh() ? Color.black : SystemColor.textText;
    protected Color disabledColor = OS.isMacintosh() ? Color.gray : SystemColor.textInactiveText;
    protected int fastDownCount = 0;
    protected boolean bMouseDrawHandled = false;
    private VetoableChangeSupport vetos = new VetoableChangeSupport(this);
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public ImageListBox() {
        this("", -1, false);
    }

    public ImageListBox(String string) {
        this(string, -1, false);
    }

    public ImageListBox(String string, boolean bl) {
        this(string, -1, bl);
    }

    public ImageListBox(String string, int n, boolean bl) {
        this.items = new Vector();
        this.ilbLabel = string;
        this.rowsToShow = n;
        this.bMultipleSelections = bl;
        this.setLayout(null);
        this.VBar = new Scrollbar();
        this.VBar.setBackground(SystemColor.control);
        this.VBar.hide();
        this.add(this.VBar);
        this.HBar = new Scrollbar(0);
        this.HBar.setBackground(SystemColor.control);
        this.HBar.hide();
        this.add(this.HBar);
        this.cachedBackground = this.getBackground();
    }

    public ImageListBox(Component component, String string, int n, boolean bl) {
        this(string, n, bl);
    }

    public ImageListBox(Component component, String string) {
        this(string);
    }

    public void setComboMode(boolean bl) throws PropertyVetoException {
        if (this.bComboMode != bl) {
            Boolean bl2 = new Boolean(this.bComboMode);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("ComboMode", bl2, bl3);
            this.bComboMode = bl;
            this.yAdj = 3;
            this.invalidate();
            this.changes.firePropertyChange("ComboMode", bl2, bl3);
        }
    }

    public boolean isComboMode() {
        return this.bComboMode;
    }

    public boolean getComboMode() {
        return this.isComboMode();
    }

    public void setRowsToShow(int n) throws PropertyVetoException {
        if (this.rowsToShow != n) {
            Integer n2 = new Integer(this.rowsToShow);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("RowsToShow", n2, n3);
            this.rowsToShow = n;
            this.invalidate();
            this.changes.firePropertyChange("RowsToShow", n2, n3);
        }
    }

    public int getRowsToShow() {
        return this.rowsToShow;
    }

    public void setShowVerticalScroll(boolean bl) throws PropertyVetoException {
        if (this.bAllowShowVBar != bl) {
            Boolean bl2 = new Boolean(this.bAllowShowVBar);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("ShowVerticalScroll", bl2, bl3);
            this.bAllowShowVBar = bl;
            this.invalidate();
            this.changes.firePropertyChange("ShowVerticalScroll", bl2, bl3);
        }
    }

    public boolean isShowVerticalScroll() {
        return this.bAllowShowVBar;
    }

    public boolean getShowVerticalScroll() {
        return this.isShowVerticalScroll();
    }

    public void setShowHorizontalScroll(boolean bl) throws PropertyVetoException {
        if (this.bAllowShowHBar != bl) {
            Boolean bl2 = new Boolean(this.bAllowShowHBar);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("ShowHorizontalScroll", bl2, bl3);
            this.bAllowShowHBar = bl;
            this.invalidate();
            this.changes.firePropertyChange("ShowHorizontalScroll", bl2, bl3);
        }
    }

    public boolean isShowHorizontalScroll() {
        return this.bAllowShowHBar;
    }

    public boolean getShowHorizontalScroll() {
        return this.isShowHorizontalScroll();
    }

    public void setBorderType(int n) throws PropertyVetoException {
        if (this.borderType != n) {
            Integer n2 = new Integer(this.borderType);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("BorderType", n2, n3);
            this.borderType = n;
            if (n == 0) {
                this.borderWidth = 4;
                this.halfBorderWidth = 2;
            } else {
                this.borderWidth = 0;
                this.halfBorderWidth = 0;
            }
            this.invalidate();
            this.changes.firePropertyChange("BorderType", n2, n3);
        }
    }

    public int getBorderType() {
        return this.borderType;
    }

    public void setCellBorder(int n, boolean bl) throws PropertyVetoException {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            if (listItem.bCellBorder != bl) {
                Boolean bl2 = new Boolean(listItem.bCellBorder);
                Boolean bl3 = new Boolean(bl);
                this.vetos.fireVetoableChange("CellBorder", bl2, bl3);
                listItem.bCellBorder = bl;
                listItem.bDirty = true;
                this.invalidate();
                this.changes.firePropertyChange("CellBorder", bl2, bl3);
            }
        }
    }

    public void setCellBorders(boolean bl) throws PropertyVetoException {
        if (this.bCellBorders != bl) {
            Boolean bl2 = new Boolean(this.bCellBorders);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("CellBorders", bl2, bl3);
            this.bCellBorders = bl;
            int n = this.items.size();
            ListItem listItem = null;
            int n2 = 0;
            while (n2 < n) {
                listItem = (ListItem)this.items.elementAt(n2);
                listItem.bCellBorder = bl;
                ++n2;
            }
            this.bAllDirty = true;
            this.invalidate();
            this.changes.firePropertyChange("CellBorders", bl2, bl3);
        }
    }

    public boolean isCellBorders() {
        return this.bCellBorders;
    }

    public boolean getCellBorders() {
        return this.isCellBorders();
    }

    public void setEnabledTextColor(int n, Color color) throws PropertyVetoException {
        ListItem listItem;
        if (this.validIndex(n) && !GeneralUtils.objectsEqual(listItem = (ListItem)this.items.elementAt(n), color)) {
            Color color2 = listItem.color;
            this.vetos.fireVetoableChange("EnabledTextColor", color2, color);
            listItem.color = color;
            this.changes.firePropertyChange("EnabledTextColor", color2, color);
        }
    }

    public Color getEnabledTextColor(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.color;
        }
        return null;
    }

    public synchronized void setMultiColumnMode(boolean bl) throws PropertyVetoException {
        if (this.isCellBorders() != bl) {
            this.setComboMode(false);
            this.setBorderType(1);
            this.setCellBorders(bl);
            this.yAdj = 2;
        }
    }

    public void setListItems(String[] stringArray) throws PropertyVetoException {
        String[] stringArray2 = this.getListItems();
        this.vetos.fireVetoableChange("ListItems", stringArray2, stringArray);
        this.clear();
        int n = 0;
        while (n < stringArray.length) {
            this.addItem(stringArray[n]);
            ++n;
        }
        this.changes.firePropertyChange("ListItems", stringArray2, stringArray);
    }

    public String[] getListItems() {
        int n = this.countItems();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            stringArray[n2] = this.getItem(n2);
            ++n2;
        }
        return stringArray;
    }

    public void setEdited(int n, boolean bl) throws PropertyVetoException {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            if (listItem.bEdited != bl) {
                Boolean bl2 = new Boolean(listItem.bEdited);
                Boolean bl3 = new Boolean(bl);
                this.vetos.fireVetoableChange("Edited", bl2, bl3);
                listItem.bEdited = bl;
                this.changes.firePropertyChange("Edited", bl2, bl3);
            }
        }
    }

    public boolean isEdited(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.bEdited;
        }
        return false;
    }

    public boolean getEdited(int n) {
        return this.isEdited(n);
    }

    public void setMultipleSelections(boolean bl) throws PropertyVetoException {
        if (this.bMultipleSelections != bl) {
            Boolean bl2 = new Boolean(this.bMultipleSelections);
            Boolean bl3 = new Boolean(bl);
            this.vetos.fireVetoableChange("MultipleSelections", bl2, bl3);
            if (!bl) {
                this.deselectAll();
            }
            this.bMultipleSelections = bl;
            this.changes.firePropertyChange("MultipleSelections", bl2, bl3);
        }
    }

    public boolean isMultipleSelections() {
        return this.bMultipleSelections;
    }

    public void setEnabled(int n, boolean bl) throws PropertyVetoException {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            if (listItem.bEnabled != bl) {
                Boolean bl2 = new Boolean(listItem.bEnabled);
                Boolean bl3 = new Boolean(bl);
                this.vetos.fireVetoableChange("Enabled", bl2, bl3);
                listItem.bEnabled = bl;
                if (!bl) {
                    this.deselect(n);
                }
                listItem.bDirty = true;
                if (!this.bInternalBlockPaint) {
                    this.repaint();
                }
                this.changes.firePropertyChange("Enabled", bl2, bl3);
            }
        }
    }

    public boolean isEnabled(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.bEnabled;
        }
        return false;
    }

    public void setText(int n, String string) throws PropertyVetoException {
        ListItem listItem;
        if (this.validIndex(n) && !GeneralUtils.objectsEqual(listItem = (ListItem)this.items.elementAt(n), string)) {
            String string2 = listItem.sText;
            this.vetos.fireVetoableChange("Text", string2, string);
            listItem.sText = string;
            listItem.bDirty = true;
            listItem.updateWidth(this.fm);
            this.updateWidth(listItem);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.changes.firePropertyChange("Text", string2, string);
        }
    }

    public String getText(int n) {
        if (this.validIndex(n)) {
            return ((ListItem)this.items.elementAt((int)n)).sText;
        }
        return null;
    }

    public boolean contains(String string) {
        int n = this.countItems();
        String string2 = null;
        int n2 = 0;
        while (n2 < n) {
            string2 = ((ListItem)this.items.elementAt((int)n2)).sText;
            if (string2.equals(string)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public String getItem(int n) {
        return this.getText(n);
    }

    public void setImageURL(int n, URL uRL) throws MalformedURLException, PropertyVetoException {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            URL uRL2 = listItem.url;
            Image image = this.getToolkit().getImage(uRL);
            if (image != null) {
                this.setImage(n, image);
            }
            listItem.url = uRL;
            this.changes.firePropertyChange("ImageURL", uRL2, uRL);
        }
    }

    public URL getImageURL(int n) {
        if (this.validIndex(n)) {
            return ((ListItem)this.items.elementAt((int)n)).url;
        }
        return null;
    }

    public void setImage(int n, Image image) throws PropertyVetoException {
        ListItem listItem;
        if (this.validIndex(n) && !GeneralUtils.objectsEqual(listItem = (ListItem)this.items.elementAt(n), image)) {
            Image image2 = listItem.image;
            this.vetos.fireVetoableChange("Image", image2, image);
            listItem.image = image;
            listItem.bDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.changes.firePropertyChange("Image", image2, image);
        }
    }

    public Image getImage(int n) {
        if (this.validIndex(n)) {
            return ((ListItem)this.items.elementAt((int)n)).image;
        }
        return null;
    }

    public synchronized void setSelectedItem(String string, boolean bl) throws PropertyVetoException {
        int n = this.items.size();
        int n2 = 0;
        while (n2 < n) {
            ListItem listItem = (ListItem)this.items.elementAt(n2);
            if (GeneralUtils.objectsEqual(listItem.sText, string)) {
                String[] stringArray = this.getSelectedItems();
                Vector<String> vector = new Vector<String>(stringArray.length);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    vector.insertElementAt(stringArray[n3], n3);
                    ++n3;
                }
                if (bl) {
                    vector.addElement(listItem.sText);
                } else {
                    vector.removeElement(listItem.sText);
                }
                Object[] objectArray = new String[vector.size()];
                vector.copyInto(objectArray);
                this.vetos.fireVetoableChange("SelectedItems", stringArray, objectArray);
                this.setSelectedIndex(n2, bl);
                if (!this.bInternalBlockPaint) {
                    this.repaint();
                }
                this.changes.firePropertyChange("SelectedItems", stringArray, this.getSelectedItems());
                return;
            }
            ++n2;
        }
    }

    public synchronized String getSelectedItem() {
        return this.lastSelected < 0 ? null : this.getItem(this.lastSelected);
    }

    public synchronized void setSelectedIndex(int n, boolean bl) throws PropertyVetoException {
        ListItem listItem = null;
        if (this.bMultipleSelections) {
            listItem = (ListItem)this.items.elementAt(n);
            int[] nArray = this.getSelectedIndexes();
            Vector<Integer> vector = new Vector<Integer>(nArray.length);
            int n2 = 0;
            while (n2 < nArray.length) {
                vector.insertElementAt(new Integer(nArray[n2]), n2);
                ++n2;
            }
            if (bl) {
                vector.addElement(new Integer(n));
            } else {
                vector.removeElement(new Integer(n));
            }
            int[] nArray2 = new int[vector.size()];
            int n3 = 0;
            while (n3 < vector.size()) {
                nArray2[n3] = (Integer)vector.elementAt(n3);
                ++n3;
            }
            this.vetos.fireVetoableChange("SelectedIndex", nArray, nArray2);
            if (bl) {
                try {
                    this.deselectAll();
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            listItem.bSelected = bl;
            listItem.bDirty = true;
            if (bl) {
                ++this.countSelected;
            }
            this.changes.firePropertyChange("SelectedIndex", nArray, this.getSelectedIndexes());
        } else {
            int n4 = this.items.size();
            if (n < n4 && n > -1) {
                int[] nArray = this.getSelectedIndexes();
                int[] nArray3 = new int[]{};
                if (bl) {
                    nArray3 = new int[]{n};
                }
                this.vetos.fireVetoableChange("SelectedIndexes", nArray, nArray3);
                listItem = (ListItem)this.items.elementAt(n);
                boolean bl2 = listItem.bSelected;
                if (bl) {
                    int n5 = 0;
                    while (n5 < n4) {
                        listItem = (ListItem)this.items.elementAt(n5);
                        if (listItem.bSelected) {
                            listItem.bSelected = false;
                            listItem.bDirty = true;
                        }
                        ++n5;
                    }
                    listItem = (ListItem)this.items.elementAt(n);
                    listItem.bSelected = true;
                    if (bl2) {
                        listItem.bDirty = false;
                    }
                    this.countSelected = 1;
                } else {
                    listItem.bSelected = false;
                    if (bl2) {
                        listItem.bDirty = true;
                        --this.countSelected;
                    }
                }
                this.changes.firePropertyChange("SelectedIndexes", nArray, this.getSelectedIndexes());
            }
        }
        this.lastSelected = n;
        this.setVisibleIndex(n);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized int getSelectedIndex() {
        return this.lastSelected;
    }

    public synchronized int[] getSelectedIndexes() {
        int[] nArray = new int[this.countSelected];
        if (this.countSelected == 1) {
            nArray[0] = this.lastSelected;
        } else if (this.countSelected > 1) {
            int n = 0;
            int n2 = this.items.size();
            int n3 = 0;
            while (n3 < n2) {
                ListItem listItem = (ListItem)this.items.elementAt(n3);
                if (listItem.bSelected) {
                    nArray[n++] = n3;
                    if (n == this.countSelected) break;
                }
                ++n3;
            }
        }
        return nArray;
    }

    public synchronized String[] getSelectedItems() {
        String[] stringArray = new String[Math.max(1, this.countSelected)];
        if (!this.bMultipleSelections) {
            if (this.lastSelected != -1) {
                ListItem listItem = (ListItem)this.items.elementAt(this.lastSelected);
                stringArray[0] = listItem.sText;
            }
        } else if (this.countSelected > 0) {
            int n = 0;
            int n2 = this.items.size();
            int n3 = 0;
            while (n3 < n2) {
                ListItem listItem = (ListItem)this.items.elementAt(n3);
                if (listItem.bSelected) {
                    stringArray[n] = listItem.sText;
                    if (++n == this.countSelected) break;
                }
                ++n3;
            }
        }
        return stringArray;
    }

    public Object[] getSelectedObjects() {
        return this.getSelectedItems();
    }

    public synchronized boolean isSelected(int n) {
        if (this.validIndex(n)) {
            ListItem listItem = (ListItem)this.items.elementAt(n);
            return listItem.bSelected;
        }
        return false;
    }

    public synchronized void setLabel(String string) throws PropertyVetoException {
        if (!GeneralUtils.objectsEqual(this.ilbLabel, string)) {
            String string2 = this.ilbLabel;
            this.vetos.fireVetoableChange("Label", string2, string);
            this.ilbLabel = string;
            this.changes.firePropertyChange("Label", string2, string);
        }
    }

    public synchronized String getLabel() {
        return new String(this.ilbLabel);
    }

    public synchronized void setVisibleIndex(int n) throws PropertyVetoException {
        if (this.visibleIndex != n) {
            Integer n2 = new Integer(this.visibleIndex);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("VisibleIndex", n2, n3);
            this.visibleIndex = n;
            if (this.nTopRow > n) {
                this.scrollVertical(n, true);
            } else if (n >= this.nTopRow + this.visibleRows) {
                this.scrollVertical(n - (this.visibleRows + 1), true);
            }
            this.changes.firePropertyChange("VisibleIndex", n2, n3);
        }
    }

    public int getVisibleIndex() {
        return this.visibleIndex;
    }

    public void setTopRow(int n) throws PropertyVetoException {
        int n2 = this.items.size();
        if (n2 < this.visibleRows) {
            n = 0;
        } else if (n > n2 - this.visibleRows) {
            n = n2 - this.visibleRows;
        }
        if (this.nTopRow != n) {
            Integer n3 = new Integer(this.nTopRow);
            Integer n4 = new Integer(n);
            this.vetos.fireVetoableChange("TopRow", n3, n4);
            this.nTopRow = n;
            this.bAllDirty = true;
            this.invalidate();
            this.changes.firePropertyChange("TopRow", n3, n4);
        }
    }

    public synchronized int getTopRow() {
        return this.nTopRow;
    }

    public synchronized void setColumns(int n) throws PropertyVetoException {
        if (this.colsToShow != n) {
            Integer n2 = new Integer(this.colsToShow);
            Integer n3 = new Integer(n);
            this.vetos.fireVetoableChange("Columns", n2, n3);
            this.colsToShow = n;
            this.invalidate();
            this.changes.firePropertyChange("Columns", n2, n3);
        }
    }

    public synchronized int getColumns() {
        return this.colsToShow;
    }

    public int getRows() {
        return this.visibleRows;
    }

    public synchronized void setFont(Font font) {
        super.setFont(font);
        font = this.getFont();
        if (font != null) {
            this.fm = this.getFontMetrics(font);
            this.updateWidths(this.fm);
            this.xCoord = 0;
            this.bAllDirty = true;
            this.invalidate();
        }
    }

    public synchronized void setDirty(boolean bl) throws PropertyVetoException {
        Boolean bl2 = new Boolean(this.bAllDirty);
        Boolean bl3 = new Boolean(bl);
        this.vetos.fireVetoableChange("Dirty", bl2, bl3);
        this.bAllDirty = bl;
        this.changes.firePropertyChange("Dirty", bl2, bl3);
    }

    public synchronized boolean isDirty() {
        return this.bAllDirty;
    }

    public synchronized void setDirty() throws PropertyVetoException {
        this.setDirty(true);
    }

    public boolean isAllSelected() {
        return this.countSelected == this.items.size();
    }

    public boolean allSelected() {
        return this.isAllSelected();
    }

    public synchronized void addItem(String string) throws PropertyVetoException {
        this.addItem(new ListItem(null, string, true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(String string, boolean bl) throws PropertyVetoException {
        this.addItem(new ListItem(null, string, bl, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String string) throws PropertyVetoException {
        this.addItem(new ListItem(image, string, true, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String string, boolean bl) throws PropertyVetoException {
        this.addItem(new ListItem(image, string, bl, this.fm, this.bCellBorders));
    }

    public synchronized void addItem(Image image, String string, boolean bl, Color color) throws PropertyVetoException {
        ListItem listItem = new ListItem(image, string, bl, this.fm, this.bCellBorders);
        listItem.color = color;
        this.addItem(listItem);
    }

    public synchronized void insertItem(int n, Image image, String string, boolean bl) {
        ListItem listItem = null;
        if (this.validIndex(n)) {
            listItem = new ListItem(image, string, bl, this.fm, this.bCellBorders);
            this.items.insertElementAt(listItem, n);
            this.bAllDirty = true;
            if (this.lastSelected >= n) {
                ++this.lastSelected;
            }
        } else {
            listItem = new ListItem(image, string, bl, this.fm, this.bCellBorders);
            this.items.addElement(listItem);
        }
        this.updateWidth(listItem);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void insertItems(int n, Vector vector, Image image, boolean bl) throws PropertyVetoException {
        int n2 = vector.size();
        int n3 = 0;
        int n4 = n;
        if (this.validIndex(n)) {
            n3 = 0;
            while (n3 < n2) {
                this.items.insertElementAt(new ListItem(image, (String)vector.elementAt(n3), bl, this.fm, this.bCellBorders), n++);
                ++n3;
            }
        } else {
            n3 = 0;
            while (n3 < n2) {
                this.items.addElement(new ListItem(image, (String)vector.elementAt(n3), bl, this.fm, this.bCellBorders));
                ++n3;
            }
        }
        this.deselectAll();
        this.bAllDirty = true;
        this.updateWidths(this.fm);
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    public int countItems() {
        return this.items.size();
    }

    public void changeImage(int n, Image image) throws PropertyVetoException {
        this.setImage(n, image);
    }

    public void changeText(int n, String string) throws PropertyVetoException {
        this.setText(n, string);
    }

    public boolean allowsMultipleSelections() {
        return this.isMultipleSelections();
    }

    public void enable(int n, boolean bl) throws PropertyVetoException {
        this.setEnabled(n, bl);
    }

    public void enable(int n) throws PropertyVetoException {
        this.setEnabled(n, true);
    }

    public void disable(int n) throws PropertyVetoException {
        this.setEnabled(n, false);
    }

    public synchronized void clear() {
        this.items = new Vector();
        this.nTopRow = 0;
        this.visibleIndex = -1;
        this.lastDownModifiers = -1;
        this.lastSelected = -1;
        this.lastIndex = -1;
        this.lastTempIndex = -1;
        this.countSelected = 0;
        this.prevSelectTime = -1L;
        this.prevSelectRow = -1L;
        this.VBar.setValues(1, 1, 0, 2);
        this.VBar.hide();
        this.bVBarVisible = false;
        this.HBar.setValues(1, 1, 0, 2);
        this.HBar.hide();
        this.bHBarVisible = false;
        this.bAllDirty = true;
        this.bInternalBlockPaint = false;
        this.bBlockPaint = false;
        this.longestLineValue = 0;
        this.xCoord = 0;
        this.repaint();
    }

    public synchronized void delItem(int n) throws PropertyVetoException {
        if (this.validIndex(n)) {
            String[] stringArray = this.getListItems();
            String[] stringArray2 = new String[stringArray.length - 1];
            Vector<String> vector = new Vector<String>(stringArray.length);
            int n2 = 0;
            while (n2 < stringArray.length) {
                vector.insertElementAt(new String(stringArray[n2]), n2);
                ++n2;
            }
            vector.removeElementAt(n);
            int n3 = 0;
            while (n3 < vector.size()) {
                stringArray2[n3] = new String((String)vector.elementAt(n3));
                ++n3;
            }
            this.vetos.fireVetoableChange("ListItems", stringArray, stringArray2);
            this.setSelectedIndex(n, false);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.items.removeElementAt(n);
            this.bAllDirty = true;
            this.scrollVertical(this.nTopRow, true);
            this.updateWidths(null);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.changes.firePropertyChange("ListItems", stringArray, this.getListItems());
        }
    }

    public synchronized void delItems(int n, int n2) throws PropertyVetoException {
        int n3 = this.items.size();
        if (n3 > 0) {
            if (n2 >= n3) {
                n2 = n3 - 1;
            }
            if (n < 0) {
                n = 0;
            }
            if (n <= n2) {
                String[] stringArray = this.getListItems();
                String[] stringArray2 = new String[stringArray.length - (n2 - n) - 1];
                Vector<Object> vector = new Vector<Object>(stringArray2.length);
                int n4 = 0;
                while (n4 < n) {
                    vector.insertElementAt(new Integer(stringArray[n4]), n4);
                    ++n4;
                }
                int n5 = n2 + 1;
                while (n5 < stringArray.length) {
                    vector.insertElementAt(new String(stringArray[n5]), n + (n5 - (n2 + 1)));
                    ++n5;
                }
                int n6 = 0;
                while (n6 < vector.size()) {
                    stringArray2[n6] = new String((String)vector.elementAt(n6));
                    ++n6;
                }
                this.vetos.fireVetoableChange("ListItems", stringArray, stringArray2);
                this.bInternalBlockPaint = true;
                int n7 = n2;
                while (n7 >= n) {
                    this.setSelectedIndex(n7, false);
                    this.items.removeElementAt(n7);
                    --n7;
                }
                this.bInternalBlockPaint = false;
                this.bAllDirty = true;
                this.scrollVertical(this.nTopRow, true);
                this.updateWidths(null);
                this.repaint();
                this.changes.firePropertyChange("ListItems", stringArray, this.getListItems());
            }
        }
    }

    public synchronized void delSelectedItems() throws PropertyVetoException {
        int n = this.items.size();
        this.bInternalBlockPaint = true;
        int n2 = 0;
        while (n2 < n) {
            ListItem listItem = (ListItem)this.items.elementAt(n2);
            if (listItem.bSelected) {
                this.delItem(n2);
                --n;
                continue;
            }
            ++n2;
        }
        this.bAllDirty = true;
        this.scrollVertical(this.nTopRow, true);
        this.updateWidths(null);
        this.bInternalBlockPaint = false;
        this.repaint();
    }

    public synchronized void select(int n) throws PropertyVetoException {
        this.setSelectedIndex(n, true);
    }

    public synchronized void select(String string) throws PropertyVetoException {
        this.setSelectedItem(string, true);
    }

    public synchronized void selectMultiple(int n, boolean bl, boolean bl2) throws PropertyVetoException {
        if (!this.bMultipleSelections) {
            bl = false;
            bl2 = false;
        }
        if (bl) {
            this.shiftSelect(n, bl2);
        } else if (bl2) {
            this.ctrlSelect(n);
        } else {
            this.setSelectedIndex(n, true);
        }
    }

    public synchronized void selectAll() {
        if (!this.bMultipleSelections) {
            return;
        }
        int n = this.items.size();
        int n2 = 0;
        while (n2 < n) {
            ListItem listItem = (ListItem)this.items.elementAt(n2);
            if (listItem.bEnabled) {
                listItem.bSelected = true;
            }
            ++n2;
        }
        this.countSelected = n;
        this.lastSelected = n - 1;
        this.repaint();
    }

    public synchronized void deselect(int n) throws PropertyVetoException {
        if (this.validIndex(n)) {
            this.setSelectedIndex(n, false);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void deselectAll() throws PropertyVetoException {
        int[] nArray = this.getSelectedIndexes();
        int[] nArray2 = new int[]{};
        this.vetos.fireVetoableChange("SelectedIndexes", nArray, nArray2);
        if (!this.bMultipleSelections) {
            if (this.lastSelected != -1) {
                ListItem listItem = (ListItem)this.items.elementAt(this.lastSelected);
                listItem.bSelected = false;
                listItem.bDirty = true;
            }
        } else {
            int n = this.items.size();
            int n2 = 0;
            while (n2 < n) {
                ListItem listItem = (ListItem)this.items.elementAt(n2);
                if (listItem.bSelected) {
                    listItem.bSelected = false;
                    listItem.bDirty = true;
                }
                ++n2;
            }
        }
        this.lastSelected = -1;
        this.countSelected = 0;
        this.repaint();
        this.changes.firePropertyChange("SelectedIndexes", nArray, this.getSelectedIndexes());
    }

    public synchronized void makeVisible(int n) throws PropertyVetoException {
        this.setVisibleIndex(n);
    }

    public int getCellHeight() {
        return this.cellHt;
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public Dimension getPreferredSize(int n) {
        Dimension dimension = this.getMinimumSize(n);
        Dimension dimension2 = this.size();
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }

    public Dimension getPreferredSize() {
        if (this.rowsToShow > 0) {
            return this.getPreferredSize(this.rowsToShow);
        }
        return this.getPreferredSize(this.items.size());
    }

    public Dimension getMinimumSize(int n) {
        this.font = this.getFont();
        if (this.font != null) {
            this.fm = this.getFontMetrics(this.font);
            if (this.fm != null) {
                this.fontHeight = this.fm.getHeight();
                this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
                return new Dimension(this.fm.stringWidth("WN") * this.colsToShow / 2 + 6, n * this.cellHt + this.borderWidth);
            }
        }
        return new Dimension(this.borderWidth + 6, this.borderWidth);
    }

    public Dimension getMinimumSize() {
        if (this.rowsToShow > 0) {
            return this.getMinimumSize(this.rowsToShow);
        }
        return this.getMinimumSize(this.items.size());
    }

    public Dimension preferredSize(int n) {
        return this.getPreferredSize(n);
    }

    public Dimension preferredSize() {
        return this.getPreferredSize();
    }

    public Dimension minimumSize(int n) {
        return this.getMinimumSize(n);
    }

    public Dimension minimumSize() {
        return this.getMinimumSize();
    }

    public synchronized void addNotify() {
        super.addNotify();
        this.barSize = this.VBar.getPreferredSize().width;
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.VBar.addAdjustmentListener(this);
        this.HBar.addAdjustmentListener(this);
        this.font = this.getFont();
        this.fm = this.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.updateWidths(this.fm);
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public synchronized void removeNotify() {
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.removeKeyListener(this);
        this.VBar.removeAdjustmentListener(this);
        this.HBar.removeAdjustmentListener(this);
        super.removeNotify();
    }

    public synchronized void blockPaint(boolean bl) {
        this.bBlockPaint = bl;
        if (!this.bBlockPaint) {
            this.repaint();
        }
    }

    public synchronized void scrollVertical(int n, boolean bl) {
        int n2 = this.nTopRow;
        if (this.visibleRows == 0) {
            n2 = 0;
        } else {
            if (bl) {
                n2 = n;
            } else {
                switch (n) {
                    case 3: {
                        n2 -= this.visibleRows;
                        break;
                    }
                    case 4: {
                        n2 += this.visibleRows;
                        break;
                    }
                    case 2: {
                        --n2;
                        break;
                    }
                    case 1: {
                        ++n2;
                        break;
                    }
                }
            }
            if (n2 < 0) {
                n2 = 0;
            } else if (n2 > this.items.size() - this.visibleRows && (n2 = this.items.size() - this.visibleRows) < 0) {
                n2 = 0;
            }
        }
        if (this.nTopRow != n2) {
            this.nTopRow = n2;
            this.VBar.setValue(n2);
            this.bAllDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void scrollHorizontal(int n, boolean bl) {
        int n2 = this.xCoord;
        if (bl) {
            n2 = -n;
        } else {
            switch (n) {
                case 3: {
                    n2 += this.lWidth;
                    break;
                }
                case 4: {
                    n2 -= this.lWidth;
                    break;
                }
                case 2: {
                    ++n2;
                    break;
                }
                case 1: {
                    --n2;
                    break;
                }
            }
        }
        if (n2 > 0) {
            n2 = 0;
        } else if (-n2 > this.HBar.getMaximum() - this.lWidth) {
            n2 = -(this.HBar.getMaximum() - this.lWidth);
        }
        if (this.xCoord != n2) {
            this.xCoord = n2;
            this.HBar.setValue(-n2);
            this.bAllDirty = true;
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
        }
    }

    public synchronized void update(Graphics graphics) {
        if (!this.bBlockPaint && !this.bInternalBlockPaint) {
            this.paint(graphics);
        }
    }

    public synchronized void paint(Graphics graphics) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        boolean bl2 = false;
        Color color = this.getBackground();
        if (!GeneralUtils.objectsEqual(color, this.cachedBackground)) {
            this.cachedBackground = color;
            this.calculateBorderColors(color);
        }
        Rectangle rectangle = this.bounds();
        this.font = graphics.getFont();
        this.fm = graphics.getFontMetrics(this.font);
        this.fontHeight = this.fm.getHeight();
        this.fontDescent = this.fm.getDescent();
        int n6 = this.items.size();
        this.cellHt = this.bCellBorders ? this.fontHeight + 5 : this.fontHeight + 1;
        if (n6 == 0) {
            this.nTopRow = 0;
            this.visibleRows = 0;
            bl2 = false;
            bl = false;
            this.xCoord = 0;
        } else {
            if (this.bAllowShowHBar && this.longestLineValue > rectangle.width - this.borderWidth) {
                bl2 = true;
                n2 = this.barSize;
            } else {
                bl2 = false;
                n2 = 0;
            }
            int n7 = (rectangle.height - n2 - this.borderWidth) / this.cellHt;
            if (this.bAllowShowVBar && n6 > n7) {
                bl = true;
                n = this.barSize;
                if (!bl2 && this.bAllowShowHBar && this.longestLineValue > rectangle.width - this.borderWidth - n) {
                    bl2 = true;
                    n2 = this.barSize;
                    n7 = (rectangle.height - n2 - this.borderWidth) / this.cellHt;
                }
            } else {
                bl = false;
                n = 0;
            }
            if (this.visibleRows != n7) {
                this.visibleRows = n7;
                this.bAllDirty = true;
            }
            if (bl) {
                this.VBar.reshape(rectangle.width - this.barSize - this.halfBorderWidth, this.halfBorderWidth, this.barSize, rectangle.height - this.borderWidth - n2);
                this.VBar.setValues(this.nTopRow, this.visibleRows, 0, n6);
                this.VBar.setPageIncrement(this.visibleRows);
                this.lWidth = rectangle.width - n - this.borderWidth;
                if (!this.bVBarVisible) {
                    this.bVBarVisible = true;
                    this.VBar.show();
                }
            } else {
                this.lWidth = rectangle.width - this.borderWidth;
                if (this.bVBarVisible) {
                    this.bVBarVisible = false;
                    this.VBar.hide();
                }
            }
            if (bl2) {
                this.HBar.reshape(this.halfBorderWidth, rectangle.height - this.barSize - this.halfBorderWidth, rectangle.width - this.borderWidth - n, this.barSize);
                this.HBar.setValues(-this.xCoord, this.lWidth, 0, this.longestLineValue);
                this.HBar.setPageIncrement(this.lWidth);
                if (!this.bHBarVisible) {
                    this.bHBarVisible = true;
                    this.HBar.show();
                }
            } else if (this.bHBarVisible) {
                this.bHBarVisible = false;
                this.HBar.hide();
            }
        }
        if (n6 == 0 || this.bAllDirty) {
            graphics.clearRect(this.halfBorderWidth, this.halfBorderWidth, rectangle.width - this.borderWidth - 1, rectangle.height - this.borderWidth - 1);
        }
        if (this.borderType == 0) {
            graphics.setColor(this.borderDarkerColor);
            graphics.drawLine(0, 0, rectangle.width - 1, 0);
            graphics.drawLine(0, 0, 0, rectangle.height - 1);
            graphics.setColor(this.borderDarkColor);
            graphics.drawLine(1, 1, rectangle.width - 2, 1);
            graphics.drawLine(1, 1, 1, rectangle.height - 2);
            graphics.setColor(this.borderLightColor);
            graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
            graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
            graphics.setColor(this.borderLighterColor);
            graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
            graphics.drawLine(rectangle.width - 1, 0, rectangle.width - 1, rectangle.height - 1);
        } else {
            graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
        }
        graphics.clipRect(this.halfBorderWidth, this.halfBorderWidth, this.lWidth, rectangle.height - this.borderWidth);
        if (this.nTopRow >= n6) {
            this.nTopRow -= this.visibleRows + 1;
        }
        int n8 = this.nTopRow;
        int n9 = Math.min(this.nTopRow + this.visibleRows, n6);
        int n10 = 0;
        while (n8 < n9 && this.items.size() > 0) {
            n4 = n10 * this.cellHt + this.halfBorderWidth;
            n5 = (n10 + 1) * this.cellHt + this.halfBorderWidth;
            ListItem listItem = (ListItem)this.items.elementAt(n8);
            if (listItem.bDirty || this.bAllDirty) {
                listItem.bDirty = false;
                graphics.clearRect(this.halfBorderWidth, n4, this.lWidth, this.cellHt);
            }
            int n11 = listItem.image != null ? this.halfBorderWidth + 19 + 2 : this.halfBorderWidth;
            n3 = listItem.bCellBorder ? 2 : 0;
            if (listItem.bSelected) {
                graphics.setColor(this.textHighlight);
                graphics.fillRect(this.xCoord + n11 + n3, n4, this.lWidth - this.xCoord, this.cellHt);
                graphics.setColor(this.textHighlightText);
            } else if (listItem.bEnabled) {
                if (listItem.color == null) {
                    graphics.setColor(this.enabledColor);
                } else {
                    graphics.setColor(listItem.color);
                }
            } else {
                graphics.setColor(this.disabledColor);
            }
            graphics.drawString(listItem.sText, this.xCoord + n11 + n3 + 2, n5 - this.fontDescent);
            if (listItem.image != null) {
                graphics.drawImage(listItem.image, this.xCoord + this.halfBorderWidth + n3 + 2, n4 + 2, 19, this.cellHt - 3, this);
            }
            if (listItem.bCellBorder) {
                graphics.setColor(listItem.cellBorderColor);
                graphics.drawRect(this.halfBorderWidth, n4, this.lWidth, this.cellHt);
            }
            ++n8;
            ++n10;
        }
        this.extraPaint(graphics, rectangle);
        this.bAllDirty = false;
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, rectangle.width - 1, rectangle.height - 1);
    }

    public void extraPaint(Graphics graphics, Rectangle rectangle) {
    }

    public synchronized void show() {
        this.bAllDirty = true;
        super.show();
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        this.bAllDirty = true;
        super.reshape(n, n2, n3, n4);
    }

    public synchronized void addItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.add(this.itemListener, itemListener);
    }

    public synchronized void removeItemListener(ItemListener itemListener) {
        this.itemListener = AWTEventMulticaster.remove(this.itemListener, itemListener);
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.add(this.actionListener, actionListener);
    }

    public synchronized void removeActionListener(ActionListener actionListener) {
        this.actionListener = AWTEventMulticaster.remove(this.actionListener, actionListener);
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.changes.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        this.vetos.removeVetoableChangeListener(vetoableChangeListener);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        this.requestFocus();
        ++this.fastDownCount;
        this.bMouseDrawHandled = false;
        if (n > -1 && n < this.lWidth) {
            n3 = this.mouseCalcIndex(n2);
            if (n3 == -1) {
                return;
            }
            if (this.bMultipleSelections) {
                if (mouseEvent.isShiftDown() && mouseEvent.isControlDown()) {
                    this.bMouseDrawHandled = true;
                    try {
                        this.shiftSelect(n3, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (mouseEvent.isShiftDown()) {
                    this.bMouseDrawHandled = true;
                    try {
                        this.shiftSelect(n3, false);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                } else if (mouseEvent.isControlDown()) {
                    this.bMouseDrawHandled = true;
                    this.ctrlSelect(n3);
                } else {
                    try {
                        this.setSelectedIndex(n3, true);
                    }
                    catch (PropertyVetoException propertyVetoException) {}
                }
            } else {
                this.lastTempIndex = n3;
                try {
                    this.setSelectedIndex(n3, true);
                }
                catch (PropertyVetoException propertyVetoException) {}
            }
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        boolean bl;
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        --this.fastDownCount;
        if (this.bMouseDrawHandled) {
            this.notifyHelper(-1, n2, -1, false);
            return;
        }
        n3 = this.mouseCalcIndex(n2);
        if (n3 == -1 || n < 0 || n >= this.lWidth) {
            this.fastDownCount = 0;
            n3 = this.lastTempIndex;
            if (n3 == -1) {
                return;
            }
        }
        if (this.bComboMode) {
            this.fastDownCount = 0;
            bl = false;
        } else if (this.fastDownCount > 0) {
            this.fastDownCount = 0;
            bl = true;
            this.prevSelectTime = -1L;
            this.prevSelectRow = -1L;
        } else {
            long l = System.currentTimeMillis();
            if (this.prevSelectTime != -1L && this.prevSelectRow == (long)n3 && this.prevSelectTime + 250L > l) {
                bl = true;
                this.prevSelectTime = -1L;
                this.prevSelectRow = -1L;
            } else {
                bl = false;
                this.prevSelectTime = l;
                this.prevSelectRow = n3;
            }
        }
        if (this.lastSelected != n3) {
            try {
                this.setSelectedIndex(n3, true);
            }
            catch (PropertyVetoException propertyVetoException) {}
            this.repaint();
        }
        if (this.bMultipleSelections) {
            this.notifyHelper(n, n2, this.lastSelected, bl);
            this.lastIndex = this.lastSelected;
        } else {
            this.notifyHelper(n, n2, n3, bl);
            this.lastIndex = n3;
        }
        this.lastTempIndex = -1;
        this.lastDownModifiers = -1;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (!this.bMultipleSelections && this.bComboMode) {
            this.lastIndex = -1;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (!this.bMultipleSelections) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            int n3 = -1;
            if (n > -1 && n < this.lWidth && this.bComboMode) {
                n3 = this.mouseCalcIndex(n2);
                if (n3 == -1 || n3 == this.lastIndex) {
                    return;
                }
                this.lastIndex = n3;
                try {
                    this.setSelectedIndex(n3, true);
                }
                catch (PropertyVetoException propertyVetoException) {}
                this.repaint();
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        int n = mouseEvent.getX();
        int n2 = mouseEvent.getY();
        int n3 = -1;
        if (n > -1 && n < this.lWidth) {
            if (this.bComboMode) {
                n3 = this.mouseCalcIndex(n2);
                if (n3 == -1 || n3 == this.lastIndex) {
                    return;
                }
                this.lastIndex = n3;
                try {
                    this.setSelectedIndex(n3, true);
                }
                catch (PropertyVetoException propertyVetoException) {}
                this.repaint();
            } else {
                n3 = this.mouseCalcIndex(n2);
                if (n3 != -1 && n3 != this.lastIndex) {
                    if (this.bMultipleSelections) {
                        if (mouseEvent.getModifiers() != 0) {
                            return;
                        }
                        this.bInternalBlockPaint = true;
                        try {
                            this.setVisibleIndex(n3);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                        this.bInternalBlockPaint = false;
                        try {
                            this.shiftSelect(n3, false);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    } else {
                        try {
                            this.setSelectedIndex(n3, true);
                        }
                        catch (PropertyVetoException propertyVetoException) {}
                    }
                    this.lastIndex = n3;
                }
            }
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.isControlDown() || keyEvent.isMetaDown() || keyEvent.isAltDown()) {
            return;
        }
        int n = -1;
        switch (keyEvent.getKeyCode()) {
            case 36: {
                n = this.keyCalcIndex(0, true);
                break;
            }
            case 35: {
                n = this.keyCalcIndex(this.items.size() - 1, true);
                break;
            }
            case 33: {
                n = this.keyCalcIndex(-this.visibleRows, false);
                break;
            }
            case 34: {
                n = this.keyCalcIndex(this.visibleRows, false);
                break;
            }
            case 38: {
                n = this.keyCalcIndex(-1, false);
                break;
            }
            case 40: {
                n = this.keyCalcIndex(1, false);
                break;
            }
        }
        if (n == -1) {
            return;
        }
        if (this.bMultipleSelections && keyEvent.isShiftDown()) {
            try {
                this.setVisibleIndex(n);
            }
            catch (PropertyVetoException propertyVetoException) {}
            try {
                this.shiftSelect(n, false);
            }
            catch (PropertyVetoException propertyVetoException) {}
            return;
        }
        try {
            this.setSelectedIndex(n, true);
        }
        catch (PropertyVetoException propertyVetoException) {}
        this.repaint();
        this.notifyHelper(-1, -1, n, false);
        this.prevSelectTime = -1L;
        this.prevSelectRow = -1L;
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (adjustmentEvent.getSource() == this.VBar) {
            if (adjustmentEvent.getAdjustmentType() == 5) {
                this.scrollVertical(adjustmentEvent.getValue(), true);
            } else {
                this.scrollVertical(adjustmentEvent.getAdjustmentType(), false);
            }
        } else if (adjustmentEvent.getSource() == this.HBar) {
            if (adjustmentEvent.getAdjustmentType() == 5) {
                this.scrollHorizontal(adjustmentEvent.getValue(), true);
            } else {
                this.scrollHorizontal(adjustmentEvent.getAdjustmentType(), false);
            }
        }
    }

    protected void sourceItemEvent() {
        if (this.itemListener != null) {
            this.itemListener.itemStateChanged(new ItemEvent(this, 701, this, 1));
        }
    }

    protected void sourceActionEvent(String string) {
        if (this.actionListener != null) {
            this.actionListener.actionPerformed(new ActionEvent(this, 1001, string));
        }
    }

    protected boolean validIndex(int n) {
        return n >= 0 && n < this.items.size();
    }

    protected boolean isVisibleIndex(int n) {
        return n >= this.nTopRow && n < this.nTopRow + this.visibleRows;
    }

    protected String paramString() {
        return String.valueOf(super.paramString()) + ", selected=" + this.getSelectedItem();
    }

    protected void shiftSelect(int n, boolean bl) throws PropertyVetoException {
        int n2 = 0;
        int n3 = 0;
        if (this.lastSelected == -1) {
            this.setSelectedIndex(n, true);
        } else if (this.lastSelected == n) {
            if (!bl) {
                this.bInternalBlockPaint = true;
                this.setSelectedIndex(n, true);
                this.bInternalBlockPaint = false;
            }
        } else if (this.lastSelected < n) {
            if (!this.isEnabled(n)) {
                return;
            }
            if (bl) {
                n2 = this.lastSelected + 1;
                n3 = Math.min(this.items.size(), n + 1);
            } else {
                n2 = 0;
                n3 = this.items.size();
            }
            while (n2 < n3) {
                ListItem listItem = (ListItem)this.items.elementAt(n2);
                if (n2 < this.lastSelected || n2 > n) {
                    if (listItem.bSelected) {
                        listItem.bDirty = true;
                        listItem.bSelected = false;
                        --this.countSelected;
                    }
                } else if (!listItem.bSelected) {
                    listItem.bDirty = true;
                    listItem.bSelected = true;
                    ++this.countSelected;
                }
                ++n2;
            }
        } else if (this.lastSelected > n) {
            if (!this.isEnabled(n)) {
                return;
            }
            if (bl) {
                n2 = n;
                n3 = Math.min(this.items.size(), this.lastSelected);
            } else {
                n2 = 0;
                n3 = this.items.size();
            }
            n2 = 0;
            while (n2 < n3) {
                ListItem listItem = (ListItem)this.items.elementAt(n2);
                if (n2 < n || n2 > this.lastSelected) {
                    if (listItem.bSelected) {
                        listItem.bDirty = true;
                        listItem.bSelected = false;
                        --this.countSelected;
                    }
                } else if (!listItem.bSelected) {
                    listItem.bDirty = true;
                    listItem.bSelected = true;
                    ++this.countSelected;
                }
                ++n2;
            }
        }
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    protected void ctrlSelect(int n) {
        ListItem listItem = (ListItem)this.items.elementAt(n);
        if (!listItem.bEnabled) {
            return;
        }
        if (listItem.bSelected) {
            listItem.bSelected = false;
            --this.countSelected;
            this.lastSelected = -1;
        } else {
            listItem.bSelected = true;
            ++this.countSelected;
            this.lastSelected = n;
        }
        listItem.bDirty = true;
        if (!this.bInternalBlockPaint) {
            this.repaint();
        }
    }

    protected int mouseCalcIndex(int n) {
        int n2 = n < this.yAdj ? this.nTopRow - 1 : (n - this.yAdj) / this.cellHt + this.nTopRow;
        if (n2 >= this.items.size()) {
            n2 = -1;
        } else if (n2 < 0) {
            n2 = 0;
        }
        return n2;
    }

    protected void addItem(ListItem listItem) throws PropertyVetoException {
        if (listItem != null) {
            String[] stringArray = this.getListItems();
            String[] stringArray2 = new String[stringArray.length + 1];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = new String(stringArray[n]);
                ++n;
            }
            stringArray2[stringArray.length] = new String(listItem.sText);
            this.vetos.fireVetoableChange("ListItems", stringArray, stringArray2);
            if (this.nTopRow < 0) {
                this.nTopRow = 0;
            }
            this.items.addElement(listItem);
            this.updateWidth(listItem);
            if (!this.bInternalBlockPaint) {
                this.repaint();
            }
            this.changes.firePropertyChange("ListItems", stringArray, this.getListItems());
        }
    }

    private void updateWidth(ListItem listItem) {
        int n = listItem.lineWidth + 6;
        if (listItem.image != null) {
            n += 19;
        }
        if (n > this.longestLineValue) {
            this.longestLineValue = n;
        }
    }

    private void updateWidths(FontMetrics fontMetrics) {
        this.longestLineValue = 0;
        int n = this.items.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            ListItem listItem = (ListItem)this.items.elementAt(n3);
            listItem.updateWidth(fontMetrics);
            n2 = listItem.lineWidth + 6;
            if (listItem.image != null) {
                n2 += 19;
            }
            if (n2 > this.longestLineValue) {
                this.longestLineValue = n2;
            }
            ++n3;
        }
    }

    protected void notifyHelper(int n, int n2, int n3, boolean bl) {
        if (bl) {
            this.sourceActionEvent("DoubleClicked");
        } else {
            if (n >= 0 && n - this.xCoord < 19) {
                ListItem listItem = (ListItem)this.items.elementAt(n3);
                if (listItem.image != null) {
                    this.sourceActionEvent("ImageSelected");
                }
            }
            this.sourceItemEvent();
        }
    }

    protected void calculateBorderColors(Color color) {
        this.borderLighterColor = ColorUtils.calculateHilightColor(color);
        this.borderDarkerColor = ColorUtils.calculateShadowColor(color);
        this.borderLightColor = ColorUtils.darken(this.borderLighterColor, 0.2);
        this.borderDarkColor = ColorUtils.darken(this.borderDarkerColor, 0.2);
    }

    protected int keyCalcIndex(int n, boolean bl) {
        this.lastIndex = bl ? n : (this.lastIndex += n);
        if (this.lastIndex >= this.items.size()) {
            this.lastIndex = this.items.size() - 1;
        } else if (this.lastIndex < 0) {
            this.lastIndex = 0;
        }
        return this.lastIndex;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ListItem listItem = null;
        int n = 0;
        while (n < this.items.size()) {
            listItem = (ListItem)this.items.elementAt(n);
            if (listItem.url != null) {
                listItem.image = this.getToolkit().getImage(listItem.url);
                MediaTracker mediaTracker = new MediaTracker(this);
                mediaTracker.addImage(listItem.image, 0);
                try {
                    mediaTracker.waitForAll();
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException("ErrorLoadingImageForURL" + listItem.url);
                }
            }
            ++n;
        }
    }
}

