/*
 * Decompiled with CFR 0.152.
 */
package com.objectspace.jgl;

import com.objectspace.jgl.Algos;
import com.objectspace.jgl.BinaryPredicate;
import com.objectspace.jgl.Container;
import com.objectspace.jgl.ForwardIterator;
import com.objectspace.jgl.InputIterator;
import com.objectspace.jgl.Map;
import com.objectspace.jgl.OrderedMapIterator;
import com.objectspace.jgl.Pair;
import com.objectspace.jgl.Range;
import com.objectspace.jgl.Tree;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Enumeration;

public class OrderedMap
extends Map {
    Tree myTree;
    int version = 30100;
    static final long serialVersionUID = -8187379858339202062L;

    public OrderedMap() {
        this.myTree = new Tree(true, false, this);
    }

    public OrderedMap(boolean bl) {
        this.myTree = new Tree(true, bl, this);
    }

    public OrderedMap(BinaryPredicate binaryPredicate) {
        this.myTree = new Tree(true, false, binaryPredicate, this);
    }

    public OrderedMap(BinaryPredicate binaryPredicate, boolean bl) {
        this.myTree = new Tree(true, bl, binaryPredicate, this);
    }

    public OrderedMap(OrderedMap orderedMap) {
        OrderedMap orderedMap2 = orderedMap;
        synchronized (orderedMap2) {
            this.myTree = new Tree(orderedMap.myTree, this);
        }
    }

    public boolean allowsDuplicates() {
        return this.myTree.myInsertAlways;
    }

    public synchronized Object clone() {
        return new OrderedMap(this);
    }

    public synchronized void copy(OrderedMap orderedMap) {
        OrderedMap orderedMap2 = orderedMap;
        synchronized (orderedMap2) {
            this.myTree.copy(orderedMap.myTree);
        }
    }

    public synchronized String toString() {
        return Algos.Printing.toString((Container)this, (String)"OrderedMap");
    }

    public synchronized Enumeration elements() {
        return this.myTree.beginMap(3);
    }

    public ForwardIterator start() {
        return this.begin();
    }

    public ForwardIterator finish() {
        return this.end();
    }

    public synchronized OrderedMapIterator begin() {
        return this.myTree.beginMap(1);
    }

    public synchronized OrderedMapIterator end() {
        return this.myTree.endMap(1);
    }

    public boolean isEmpty() {
        return this.myTree.size == 0;
    }

    public int size() {
        return this.myTree.size;
    }

    public int maxSize() {
        return this.myTree.maxSize();
    }

    public boolean equals(Object object) {
        return object instanceof OrderedMap && this.equals((OrderedMap)object);
    }

    public synchronized boolean equals(OrderedMap orderedMap) {
        OrderedMap orderedMap2 = orderedMap;
        synchronized (orderedMap2) {
            boolean bl = Algos.Comparing.equal((Container)this, (Container)orderedMap);
            Object var4_4 = null;
            return bl;
        }
    }

    public synchronized int hashCode() {
        OrderedMapIterator orderedMapIterator = this.myTree.beginMap(2);
        return Algos.Hashing.orderedHash((ForwardIterator)orderedMapIterator, (int)this.myTree.size);
    }

    public synchronized void swap(OrderedMap orderedMap) {
        OrderedMap orderedMap2 = orderedMap;
        synchronized (orderedMap2) {
            Tree tree = this.myTree;
            this.myTree = orderedMap.myTree;
            orderedMap.myTree = tree;
        }
    }

    public synchronized void clear() {
        this.myTree.clear();
    }

    public synchronized Object remove(Object object) {
        return this.myTree.remove((Object)object).first;
    }

    public synchronized int remove(Object object, int n) {
        Pair pair = this.myTree.remove(object, n);
        return ((Number)pair.second).intValue();
    }

    public synchronized Object remove(Enumeration enumeration) {
        if (!(enumeration instanceof OrderedMapIterator)) {
            throw new IllegalArgumentException("Enumeration not an OrderedMapIterator");
        }
        if (((OrderedMapIterator)enumeration).myOrderedMap != this) {
            throw new IllegalArgumentException("Enumeration not for this OrderedMap");
        }
        Tree.TreeNode treeNode = this.myTree.remove(((OrderedMapIterator)enumeration).myNode);
        return treeNode == null ? null : treeNode.object;
    }

    public synchronized int remove(Enumeration enumeration, Enumeration enumeration2) {
        if (!(enumeration instanceof OrderedMapIterator) || !(enumeration2 instanceof OrderedMapIterator)) {
            throw new IllegalArgumentException("Enumeration not an OrderedMapIterator");
        }
        if (((OrderedMapIterator)enumeration).myOrderedMap != this || ((OrderedMapIterator)enumeration2).myOrderedMap != this) {
            throw new IllegalArgumentException("Enumeration not for this OrderedMap");
        }
        Pair pair = this.myTree.remove(((OrderedMapIterator)enumeration).myNode, ((OrderedMapIterator)enumeration2).myNode);
        return ((Number)pair.second).intValue();
    }

    public synchronized OrderedMapIterator find(Object object) {
        return new OrderedMapIterator(this.myTree, this.myTree.find(object), this, 1);
    }

    public synchronized int count(Object object) {
        return this.myTree.count(object);
    }

    public synchronized int countValues(Object object) {
        return Algos.Counting.count((InputIterator)this.myTree.beginMap(3), (InputIterator)this.myTree.endMap(3), (Object)object);
    }

    public synchronized OrderedMapIterator lowerBound(Object object) {
        return new OrderedMapIterator(this.myTree, this.myTree.lowerBound(object), this, 1);
    }

    public synchronized OrderedMapIterator upperBound(Object object) {
        return new OrderedMapIterator(this.myTree, this.myTree.upperBound(object), this, 1);
    }

    public synchronized Range equalRange(Object object) {
        Pair pair = this.myTree.equalRange(object);
        return new Range((ForwardIterator)new OrderedMapIterator(this.myTree, (Tree.TreeNode)pair.first, this, 1), (ForwardIterator)new OrderedMapIterator(this.myTree, (Tree.TreeNode)pair.second, this, 1));
    }

    public BinaryPredicate getComparator() {
        return this.myTree.myComparator;
    }

    public synchronized Object get(Object object) {
        return this.myTree.get(object);
    }

    public synchronized Object put(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        Tree.InsertResult insertResult = this.myTree.put(new Pair(object, object2));
        if (insertResult.ok) {
            return null;
        }
        Pair pair = (Pair)insertResult.node.object;
        Object object3 = pair.second;
        pair.second = object2;
        return object3;
    }

    public Object add(Object object) {
        if (object == null) {
            throw new NullPointerException();
        }
        if (!(object instanceof Pair)) {
            throw new IllegalArgumentException("object is not Pair");
        }
        if (((Pair)object).first == null || ((Pair)object).second == null) {
            throw new NullPointerException();
        }
        Pair pair = (Pair)object;
        return this.add(pair.first, pair.second);
    }

    public synchronized Object add(Object object, Object object2) {
        if (object == null || object2 == null) {
            throw new NullPointerException();
        }
        Tree.InsertResult insertResult = this.myTree.insert(new Pair(object, object2));
        return insertResult.ok ? null : ((Pair)insertResult.node.object).second;
    }

    public synchronized Enumeration keys() {
        return this.myTree.beginMap(2);
    }

    public synchronized Enumeration keys(Object object) {
        return this.myTree.keys(object).elements();
    }

    public synchronized Enumeration values(Object object) {
        return this.myTree.values(object).elements();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.version == 0) {
            boolean bl = objectInputStream.readBoolean();
            BinaryPredicate binaryPredicate = (BinaryPredicate)objectInputStream.readObject();
            this.myTree = new Tree(true, bl, binaryPredicate, this);
            int n = objectInputStream.readInt();
            while (n-- > 0) {
                this.add(objectInputStream.readObject());
            }
        }
    }
}

