// TimeScroller
// Copyright(C) Terry Brett, TimeScroller.com

var gTS_Version=1.6;
var gTS_SlideDays=3;
var gTS_24Hr=false;
var gTS_ShowDay=true;
var gTS_NextUpdateCheck=0;
var gTS_UpdateCheckFreqDays=7; // days
var gTS_Loz=false;
var gTS_Rotate="Right";	// Do not translate
var gTS_Small=false;
var gTS_SecondTimer=null;
var gTS_ResetTimer=null;
var gTS_FlashTimer=null;
var gTS_List=[];
var gTS_SelectedBackRow=null;
var gTS_EditingRoxIdx=-1;
var gTS_ContinentIdx=-1;
var gTS_CityIdx=-1;
var gTS_OffsetShowingMins=0;	// Offset (from now) in minutes currently showing
var gTS_Width=300;
var gTS_ShowingBack=false;
var gTS_ShowingMinute=-1;	// Current minute showing 00..59 - so we only update non-home cities every minute
var gTS_Slider=null;
var gTS_Colour=[];
var gTS_ColourNames=[];
var gTS_Segs=[];
var gTS_Day=["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];	// Keys - do not translate
var gTS_RespondToSlide=true;
var gTS_Request=null;
var gTS_UpdateURL=null;
var gTS_kRoundQuarterHour=15;
var gTS_kRoundHour=60;

if (window.widget)
{
	widget.onremove=_onRemove;
	widget.onhide=_onHide;
	widget.onshow=_onShow;
}

function CityTime()
{
	this.date=new Date();
}
	
CityTime.prototype.calcCityTime=function(inZone,inOffset)
{
	var m=0;
	if ( TimeScrollerPlugin ) m=TimeScrollerPlugin.getTimeWithOffset(inZone, inOffset);
	this.date.setTime(Math.floor(m) * 1000);
}

CityTime.prototype.getTimeStr=function(inRounded)
{
	if ( this.date.getTime() == 0 ) return "?";

	var hh;
	if ( gTS_24Hr )
	{
		hh=this.date.getUTCHours();
		hh=(hh < 10 ? "0" + hh : hh);
	}
	else
	{
		hh=((11+this.date.getUTCHours()) % 12)+1;
	}
	
	var mm=this.date.getUTCMinutes();
	if ( inRounded ) mm=Math.floor(mm/15)*15;
	mm=":" + ((mm < 10) ? "0":"") + mm;
	
	return hh + mm;
}

CityTime.prototype.getAmStr=function()
{
	if ( gTS_24Hr )
		return "";
	else
		return this.date.getUTCHours() > 11 ? "PM" : "AM";
}

CityTime.prototype.getDayMins=function()
{
	// From 0..1
	return (this.date.getUTCHours() * 60 + this.date.getUTCMinutes()) / 1440;
}
	
CityTime.prototype.getFullTimeStr=function()
{
	return this.getTimeStr(true) + this.getAmStr() + ", " + this.getDayString(true);
}

CityTime.prototype.getDayString=function(inLong)
{
	var s = gTS_Day[ this.date.getUTCDay() ];
	if ( inLong )
		return getLocalizedString(s);
	else
		return getLocalizedString(s.substr(0,3));
}
	
function showTimes()
{
	if ( gTS_List.length == 0 ) return;

	var minsOffset=0;
	var isNow=( gTS_OffsetShowingMins == 0 );
	
	if ( isNow )
	{
		var thisMin=new Date().getUTCMinutes();
		if ( thisMin == gTS_ShowingMinute )
            return;
		gTS_ShowingMinute=thisMin;
	}

	// Calculate times.
	var cityTime=new CityTime();
	cityTime.calcCityTime( gTS_List[0].tz, 0 );
	var nowDay=cityTime.date.getUTCDay();
	for( var i in gTS_List ) 
	{
		if ( gTS_List[i].cityTime == null ) gTS_List[i].cityTime=new CityTime();
		gTS_List[i].cityTime.calcCityTime( gTS_List[i].tz, gTS_OffsetShowingMins );
	}
	
//	debug( justShowHomeSeconds ? "TS: Seconds" : "TS: Full" );
	
	// Update UI
	for( var i in gTS_List ) 
	{
		cityTime=gTS_List[i].cityTime;
		var showDay = ( gTS_ShowDay || cityTime.date.getUTCDay() != nowDay );
		var timeStr = cityTime.getTimeStr(!isNow);

		if ( gTS_Small )
		{
			if (showDay) timeStr = "<small>"+cityTime.getDayString(false)+"</small> " + timeStr;
			if (!gTS_24Hr) timeStr = timeStr+" <small>"+cityTime.getAmStr()+"</small>";
		
			document.getElementById("time"+i).innerHTML=timeStr;
		}
		else
		{
			document.getElementById("time"+i).innerText=timeStr;			
			document.getElementById("ampm"+i).innerText=cityTime.getAmStr();
		
			if ( showDay )
				document.getElementById("day"+i).innerText=cityTime.getDayString(gTS_24Hr);
			else
				document.getElementById("day"+i).innerText="";
		}
				
		paintGimbal( document.getElementById("gim"+i), cityTime.getDayMins() );
	}
}

function _load()
{
	setupParts();
	
	gTS_ColourNames=["Red","Green","Amber","Yellow","Blue","Black","Gray","White"];	// Keys - do not translate
	
	gTS_Colour["Red"]	= { rgb:"rgb(200,0,0)" };
	gTS_Colour["Green"]= { rgb:"rgb(0,125,0)" };
	gTS_Colour["Amber"]= { rgb:"rgb(200,125,0)"};
	gTS_Colour["Yellow"]={ rgb:"rgb(200,200,0)"};
	gTS_Colour["Blue"]	= { rgb:"rgb(0,0,200)"};
	gTS_Colour["Black"]= { rgb:"rgb(30,30,30)" };
	gTS_Colour["Gray"]	= { rgb:"rgb(100,100,100)" };
	gTS_Colour["White"]= { rgb:"rgb(190,190,190)" };
	
	var defZone="";
	if ( TimeScrollerPlugin ) defZone=TimeScrollerPlugin.getDefaultZone();
	
	var fallbackContinentIdx=0;
	var fallbackCityIdx=0;
	for( var c in continents )
	{
		var cities=continents[c].cities;
		for( var i in cities )
		{
			if ( cities[i].tz == defZone )
			{
				gTS_ContinentIdx=c;
				gTS_CityIdx=i;
				break;
			}
			else if ( cities[i].tz == "America/New_York" )
			{
				fallbackContinentIdx=c;
				fallbackCityIdx=i;
			}
		}
	}
	
	if ( gTS_ContinentIdx == -1 )
	{
		gTS_ContinentIdx=fallbackContinentIdx;
		gTS_CityIdx=fallbackCityIdx;
	}

	var idx=0;
	for( var colour in gTS_Colour )
		gTS_Colour[colour].i=idx++;
	
	document.onmousewheel=_doMouseWheel;

	loadPrefs();	
	frontRowsPopulate();
	showTimes();
	_showCities();
	
	document.getElementById("remove").object.setEnabled( false );
	document.getElementById("up").object.setEnabled( false );
	document.getElementById("down").object.setEnabled( false );
	
	document.getElementById("add").object.textElement.style.minWidth="50px";
	document.getElementById("remove").object.textElement.style.minWidth="50px";
	document.getElementById("rename").object.textElement.style.minWidth="50px";
	document.getElementById("up").object.textElement.style.minWidth="50px";
	document.getElementById("down").object.textElement.style.minWidth="50px";
	document.getElementById("done").object.textElement.style.minWidth="50px";
	
	document.getElementById("vers").innerText=gTS_Version;
}

function _onRemove()
{
	if (window.widget)
	{
		widget.setPreferenceForKey( null, createInstancePreferenceKey("Hr24") );
		widget.setPreferenceForKey( null, createInstancePreferenceKey("ShowDay") );
		widget.setPreferenceForKey( null, createInstancePreferenceKey("LozStyle") );
		widget.setPreferenceForKey( null, createInstancePreferenceKey("Cities") );
		widget.setPreferenceForKey( null, createInstancePreferenceKey("Segs") );
		widget.setPreferenceForKey( null, createInstancePreferenceKey("Duration"));
	}
}

function _updateMoreInfo(e)
{
	if ( gTS_UpdateURL==null || gTS_UpdateURL.length == 0 ) gTS_UpdateURL="http://www.timescroller.com?default";
	widget.openURL( gTS_UpdateURL );
	document.getElementById('updateBox').style.display="none";
}

function _updateLater(e)
{
	document.getElementById('updateBox').style.display="none";
}

function checkForUpdate()
{
///*
	gTS_Request=new XMLHttpRequest();
		
	gTS_Request.open('GET', 'http://www.timescroller.com/vers.xml?v=' + gTS_Version, true);
	gTS_Request.setRequestHeader("Cache-Control", "no-cache");
	gTS_Request.onload=function(e)
	{
		if (gTS_Request.readyState == 4) 
		{
			var response=gTS_Request.responseXML.documentElement;
			var versions=response.getElementsByTagName("VERSION");
			if ( versions.length > 0 )
			{
				var latestVers=versions[0].getElementsByTagName("ID")[0].firstChild.data;
				if ( latestVers > gTS_Version )
				{
					gTS_UpdateURL=versions[0].getElementsByTagName("LINK")[0].firstChild.data;
//*/
					var box = document.getElementById('updateBox');
					
					box.style.left = ((gTS_Width-200)/2) + "px";
					box.style.display="block";
///*
				}
			}
		}
	}
	gTS_Request.send(null);
//*/
}

function getPreference(inKey)
{
	var res=widget.preferenceForKey(createInstancePreferenceKey(inKey));
	if (res==null)
		res=widget.preferenceForKey("DEFAULT-"+inKey);
	return res;
}

function setPreference(inVal,inKey)
{
	var global = (inKey=="NextUpdateCheck");
	if (! global) widget.setPreferenceForKey( inVal, createInstancePreferenceKey(inKey));
	widget.setPreferenceForKey( inVal, "DEFAULT-"+inKey);
}

function clearSecTimer()
{
	if ( gTS_SecondTimer != null )
	{
		clearInterval(gTS_SecondTimer);
		gTS_SecondTimer=null;
	}
}

function ensureSecTimer()
{
	if ( gTS_SecondTimer == null )
	{
		gTS_SecondTimer=setInterval("showTimes();", 1000);
	}
}

function _onHide()
{
	// Create timer to reset clock to "now" in 10 minutes.
	if ( gTS_Slider && ! gTS_ShowingBack ) gTS_ResetTimer=setInterval("resetSlider();",10*60*1000);
	clearSecTimer();
}

function _onShow()
{
	if ( ! gTS_ShowingBack )
	{
		gTS_ShowingMinute=-1;
		showTimes();
		ensureSecTimer();

		gTS_NextUpdateCheck = getPreference( "NextUpdateCheck" );
//		gTS_NextUpdateCheck = null;

		var now = new Date().getTime();
		if ( gTS_NextUpdateCheck == null || now > gTS_NextUpdateCheck )
		{
			gTS_NextUpdateCheck = now + gTS_UpdateCheckFreqDays*24*60*60*1000;
			setPreference( gTS_NextUpdateCheck, "NextUpdateCheck" );
			checkForUpdate();
		}
	}
	
	if (gTS_ResetTimer!=null)
	{
		clearInterval(gTS_ResetTimer);
		gTS_ResetTimer=null;
	}
}

function resetSlider()
{
	if (gTS_ResetTimer!=null)
	{
		clearInterval(gTS_ResetTimer);
		gTS_ResetTimer=null;
	}
	if ( gTS_Slider )
	{
		gTS_Slider.setValue(0);
	}
}

function _showFront(event)
{
	ensureCityEditEnded();

	// your widget needs to show the front
	var front=document.getElementById("front");
	var back=document.getElementById("back");
	
	if (window.widget)
		widget.prepareForTransition("ToFront");

	front.style.display="block";
	back.style.display="none";
	
	gTS_FlipShown=false;

	// See comment below.
	front.style.opacity = 0.99;

	if ( gTS_List.length < 2 )	defaultCities();
	sortSegs();
	
	if (window.widget)
		setTimeout("widget.performTransition();", 0);
		
	// Window resizes performed during performTransition() seem to sometimes
	// leave parts of the window missing. This method is performed 1.5 seconds
	// after _showFront() and forces an update.
	setTimeout("document.getElementById(\"front\").style.opacity = 1;", 1500);

	savePrefs();	
	
	gTS_ShowingBack=false;

	frontRowsPopulate();
	gTS_Slider.setValue(0);
}

function _doSlide(value)
{
	document.getElementById("mail").style.display=(value < .05)?"none":"block";
	if (gTS_List.length==0 || !gTS_RespondToSlide || gTS_Slider == null) return;
	
	if ( value < .05 ) 
	{
		ensureSecTimer();
		gTS_OffsetShowingMins=0;
		gTS_RespondToSlide=false;
		gTS_Slider.setValue(0);
		gTS_RespondToSlide=true;
		gTS_ShowingMinute=-1;
	}
	else
	{
		clearSecTimer();
		gTS_OffsetShowingMins=((value-.05)/.95)*gTS_SlideDays*24*60;
	}
	showTimes();
}

function _doKeyPress(event)
{
	if ( gTS_ShowingBack )
	{
		if ( gTS_EditingRoxIdx != -1 )
		{
			switch(event.keyCode)
			{
				case 13:	// Enter/return
				case 9:		// tab
					ensureCityEditEnded();
					break;
			}
		}
	}
	else
	{
		var rounding = (event.metaKey || event.altKey) ? gTS_kRoundQuarterHour : gTS_kRoundHour;
		var deltaDir=0;
		
		if (event.keyIdentifier=="Right")
			deltaDir = +1;
		else if (event.keyIdentifier=="Left")
			deltaDir = -1;
        else if ( event.metaKey && event.keyCode==67 )
            _doCopy();
	
		if ( deltaDir != 0 )
			offsetByDelta(deltaDir*rounding, rounding);
	}
}

function _doMouseWheel(event)
{
	if (!gTS_ShowingBack)
	{
		if ( event.metaKey || event.altKey )
			offsetByDelta( (event.wheelDelta / 120) * 15, gTS_kRoundQuarterHour );
		else
			offsetByDelta( (event.wheelDelta / 120) * 60, gTS_kRoundHour );
	}
}

function offsetByDelta(inDeltaMins,inRounding)
{
	var maxSlideMins=gTS_SlideDays*24*60;
	gTS_OffsetShowingMins += inDeltaMins;
	
	// We need to offset the offset so we align with the requested rounding.
	var nonAlignedMins = new Date().getUTCMinutes() + gTS_OffsetShowingMins;
	var offsetOffset = nonAlignedMins % inRounding;
	gTS_OffsetShowingMins -= offsetOffset;
	
	gTS_OffsetShowingMins=limitMinMax( gTS_OffsetShowingMins, 0, maxSlideMins );
	if ( gTS_OffsetShowingMins==0 ) 
		ensureSecTimer();
	else
		clearSecTimer();
	showTimes();
	
	// Reflect offset on slider.
	gTS_RespondToSlide=false;
	gTS_ShowingMinute=-1;
	if (gTS_Slider) gTS_Slider.setValue( gTS_OffsetShowingMins == 0 ? 0 : ((gTS_OffsetShowingMins/maxSlideMins)*.95)+.05 );
	gTS_RespondToSlide=true;
}

function frontRowsPopulate()
{
	if ( gTS_List.length == 0 ) return; // shouldnt happen.

	document.getElementById("front").style.width="300px";

	var inner=document.getElementById("data");
	while( inner.firstChild )
		inner.removeChild( inner.firstChild );

	for( var i in gTS_List ) 
	{
		frontRowAdd( i, gTS_List[i].name );
	}
	
	var maxWidth=0;
	for( var i in gTS_List ) 
	{
		var city = document.getElementById("city"+i);
		if ( city.scrollWidth > maxWidth ) maxWidth=city.scrollWidth;
	}
	
	var timeLeft = document.getElementById("time0").offsetLeft;
	var cityLeft = document.getElementById("city0").offsetLeft;
	
	gTS_Width = window.innerWidth + (maxWidth-(timeLeft-cityLeft)) + 5;
	
	for( var i in gTS_List ) 
	{
		var sizer = document.getElementById("city"+i);
		sizer.style.width=maxWidth + "px";
	}
	
	doResize();
}

function frontRowAdd( i, inName )
{
	var parent=document.createElement("li");
	parent.setAttribute("class", "frow" + (gTS_Small ? " frowSm":"") );
	parent.id="frow"+i;
	document.getElementById("data").appendChild(parent);

	var col=document.createElement("span");
	col.setAttribute("class", "city" + (gTS_Small ? " citySm":"") );
	col.id="city"+i;
	col.innerText=inName;
	parent.appendChild(col);
	
	col=document.createElement("span");
	if ( gTS_Small )
		col.setAttribute("class", "time " + (gTS_24Hr ? "sm24Hr" : "sm12Hr" ));
	else
		col.setAttribute("class", "time " + (gTS_24Hr ? "lrg24Hr" : "lrg12Hr" ));
	col.id="time"+i;
	parent.appendChild(col);
	
	col=document.createElement("canvas");
	col.setAttribute("class", "gim" + (gTS_Small ? " gimSm":""));
	col.id="gim"+i;
	parent.appendChild(col);
	col.width=col.clientWidth;
	col.height=col.clientHeight;

	if ( !gTS_Small )
	{
		col=document.createElement("span");
		col.setAttribute("class", "ampm");
		col.id="ampm"+i;
		parent.appendChild(col);
		
		col=document.createElement("span");
		if ( gTS_24Hr )
			col.setAttribute("class","day day24");
		else
			col.setAttribute("class","day");
		col.id="day"+i;
		parent.appendChild(col);	
	}
}

function doResize()
{
	// Lots of magic constants ;-)
	var rowHeight=document.getElementById("frow0").clientHeight;
	
	var height=(gTS_List.length * rowHeight + 60);
	var frontHeight = Math.max( height, 140 );	
	var winHeight = Math.max( height, 377 );
	var winWidth = Math.max( gTS_Width, 300 );
	var front=document.getElementById("front");
	front.style.height=frontHeight + "px";
	front.style.width=gTS_Width + "px";
	
	var world=document.getElementById("world");
	
	var kWorldW=331;
	var kWorldH=150;
	var kWorldMarg=50;
	var worldScale=0;
	var worldOffL=0;
	var worldOffT=kWorldMarg/2;
	if ( (kWorldW/kWorldH) > ((gTS_Width-kWorldMarg)/(frontHeight-kWorldMarg)) )
	{
		// Float TB
		worldScale = (gTS_Width-kWorldMarg)/kWorldW;
		worldOffL = (kWorldMarg/2);
	}
	else
	{
		// Float LR
		worldScale = (frontHeight-kWorldMarg)/kWorldH;
		worldOffL = (gTS_Width - ( kWorldW*worldScale )) / 2;
	}
			
	world.style.height = kWorldH*worldScale+"px";
	world.style.width = kWorldW*worldScale+"px";
	world.style.top = worldOffT+"px";
	world.style.left = worldOffL+"px";
	
	document.getElementById("flash").style.height=height - 60 + "px";
	document.getElementById("l").style.height=frontHeight - 120 + "px";
	document.getElementById("t").style.width=gTS_Width - 120 + "px";
	document.getElementById("r").style.height=frontHeight - 120 + "px";
	document.getElementById("c").style.width=gTS_Width - 120 + "px";
	document.getElementById("c").style.height=frontHeight - 120 + "px";
	document.getElementById("b").style.width=gTS_Width - 120 + "px";
	window.resizeTo( winWidth, winHeight );
	
	if ( gTS_Slider ) gTS_Slider.remove();
	gTS_Slider=null;
	gTS_Slider=new AppleHorizontalSlider( document.getElementById("slid"), _doSlide );
}

function defaultCities()
{
	if ( gTS_List.length == 0 )
	{
		var city=continents[gTS_ContinentIdx].cities[gTS_CityIdx];
		gTS_List[0]={name:city.name, tz:city.tz};
	}
	
	var defs=
	[
		{name:"New York", tz:"America/New_York"},
		{name:"London", tz:"Europe/London"},
		{name:"Sydney", tz:"Australia/Sydney"}
	];
	
	for( var i in defs )
	{
		var used=false;
		for( var e in gTS_List )
		{
			if ( gTS_List[e].name == defs[i].name ) used=true;
		}
	
		if ( ! used )
		{
			gTS_List[gTS_List.length]={name:defs[i].name, tz:defs[i].tz};
			if ( gTS_List.length == 3 ) break;
		}
	}
}

function loadPrefs()
{
	if ( gTS_Small )
		document.getElementById("data").setAttribute( "class", "data dataSm" );
	else
		document.getElementById("data").setAttribute( "class", "data" );

	gTS_24Hr=getPreference("Hr24");
	if ( gTS_24Hr == null ) gTS_24Hr=false;		
	document.getElementById("Hr24").checked=gTS_24Hr;
	
	gTS_ShowDay=getPreference("ShowDay");
	if ( gTS_ShowDay == null ) gTS_ShowDay=true;
	document.getElementById("ShowDay").checked=gTS_ShowDay;
	
	gTS_Small=getPreference("SmallSize");
	if ( gTS_Small == null ) gTS_Small=false;
	document.getElementById("SmallSize").checked=gTS_Small;
	
	gTS_Loz=getPreference("LozStyle");
	if ( gTS_Loz == null ) gTS_Loz=false;
	document.getElementById("StylePop").selectedIndex = gTS_Loz?1:0;

	gTS_Rotate=getPreference("Rotation");
	if ( gTS_Rotate == null ) gTS_Rotate="Right";
	document.getElementById("RotatePop").value = gTS_Rotate;

	gTS_SlideDays=getPreference("Duration");
	if ( gTS_SlideDays == null ) gTS_SlideDays=3;
	document.getElementById("duration").value=gTS_SlideDays;

	gTS_List.length=0;
	var temp=getPreference("Cities");
	if ( temp != null && temp.length > 0 )
	{
		var carr=temp.split("|");
		var idx=0;
		for( var i in carr )
		{
			if ( carr[i] != null && carr[i].length > 0 )
			{
				var tarr=carr[i].split("~");
				gTS_List[idx++]={name:tarr[0],tz:tarr[1]};
			}
		}
	}
	
	if ( gTS_List.length < 2 ) defaultCities();
	
	temp=getPreference("Segs");
	if ( temp == null || temp.length == 0 )
	{
		gTS_Segs=
		[
			{hour:9, colour:"Green"},
			{hour:17, colour:"Amber"},
			{hour:21, colour:"Red"}
		];
	}
	else
	{
		var carr=temp.split("|");
		var idx=0;
		for( var i in carr )
		{
			if ( carr[i] != null && carr[i].length > 0 )
			{
				var tarr=carr[i].split("~");
				gTS_Segs[idx++]={hour:tarr[0],colour:tarr[1]};
			}
		}
	}
}

function savePrefs()
{
	gTS_SlideDays=Number(document.getElementById("duration").value);
	if (isNaN(gTS_SlideDays)) gTS_SlideDays=3;
	setPreference( gTS_SlideDays, "Duration");

	var cities="";
	for( var i in gTS_List ) 
		cities += (i>0?"|":"") + gTS_List[i].name + "~" + gTS_List[i].tz;
	setPreference( cities, "Cities" );
	
	var segs="";
	for( var i in gTS_Segs ) 
		segs += (i>0?"|":"") + gTS_Segs[i].hour + "~" + gTS_Segs[i].colour;
	setPreference( segs, "Segs" );
}

function bodyText()
{
	var body="";
	for( var i in gTS_List ) 
	{
		var cityTime=gTS_List[i].cityTime;
		body += gTS_List[i].name + " - ";
		body += gTS_List[i].cityTime.getFullTimeStr();
		body += "\r";
	}
	return body;
}

function _doCopy()
{
	if (!gTS_ShowingBack)
	{
        if ( TimeScrollerPlugin ) TimeScrollerPlugin.copyToPasteboard(bodyText());
        document.getElementById('flash').style.display="block";
        gTS_FlashTimer=setInterval("unFlash();",100);
	}
}

function unFlash()
{
    clearInterval(gTS_FlashTimer);
    document.getElementById('flash').style.display="none";
	gTS_FlashTimer=null;
}

function _doMail(event) 
{
	var body=bodyText();
	var subject=getLocalizedString("AGoodTime");
	widget.openURL("mailto:recipient?Subject=" + subject + "&Body=" + body );
}

function paintGimbal( canvas, inPerc )
{
	var size=canvas.clientWidth;
	var rad= 0.0174532;
	var r360=6.2831853;
	var r=1 - inPerc + 0.75;
	var c=canvas.getContext("2d"); 
	
	c.save(); 
		c.scale( size/11, size/11 );
		c.clearRect(0,0,11,11); 
		c.translate(5.5,5.5);

		c.save(); 
			if (gTS_Loz)
			{
				lozPath(c);
				c.clip();
				c.scale(3,3);
			}

			if ( gTS_Rotate=="None" )
			{	
				// inPerc == 0..1
				var i;
				for( i=0; i < gTS_Segs.length; i++ )
				{
					if (inPerc < (gTS_Segs[i].hour/24)) break;
				}
				if ( i==0 ) i=gTS_Segs.length;
				
				c.fillStyle=gTS_Colour[gTS_Segs[i-1].colour].rgb;
				c.beginPath();
				c.arc(0,0,5,0,r360,0);
				c.fill();
			}	
			else
			{
				c.save(); 
				if ( gTS_Rotate=="Left") c.rotate(180*rad);
					c.fillStyle=gTS_Colour[gTS_Segs[gTS_Segs.length-1].colour].rgb;
					c.beginPath();
					c.arc(0,0,5,0,r360,0);
					c.fill();
					
					for( var i=0; i < (gTS_Segs.length-1); i++ )
					{
						c.fillStyle=gTS_Colour[gTS_Segs[i].colour].rgb;
						var r1=((r+(gTS_Segs[i].hour/24))*360) % 360;
						var r2=((r+(gTS_Segs[i+1].hour/24))*360) % 360;
						paintSegment( c, r1, r2 );
					}
				c.restore(); 
			}	

			var grad;
			c.save();
				if (gTS_Loz)
				{
					c.translate(0,-2.8);
					c.scale(0.8,0.5);
					grad=c.createLinearGradient(0,0.3,0,6);
				}
				else
				{
					c.translate(0,-2.5);
					c.scale(0.7,0.5);
					grad=c.createLinearGradient(0,-5,0,+5);
				}
				grad.addColorStop(0,"rgba(255,255,255,1)");
				grad.addColorStop(1,"rgba(255,255,255,0)");
				c.fillStyle=grad;
				c.beginPath();
				c.arc(0,0,5,0,r360,0);
				c.fill();
			c.restore(); 
		c.restore(); 

		if (gTS_Loz)
		{
			lozPath(c);
			c.clip();
			c.translate(0,-.3);
			lozPath(c);
			c.strokeStyle="rgba(0,0,0,0.1)";
			c.lineWidth=1.7;
			c.stroke();
			lozPath(c);
			c.strokeStyle="rgba(0,0,0,0.2)";
			c.lineWidth=1;
			c.stroke();
		}
		else
		{
			grad=c.createRadialGradient(0,0,0,0,0,5);
			grad.addColorStop(0,"rgba(0,0,0,0)");
			grad.addColorStop(0.7,"rgba(0,0,0,0.1)");
			grad.addColorStop(0.9,"rgba(0,0,0,0.3)");
			grad.addColorStop(1,"rgba(0,0,0,0.6)");
			c.fillStyle=grad;
			c.beginPath();
			c.arc(0,0,5,0,r360,0);
			c.fill();
		}
	c.restore(); 
}

function paintSegment( c, r2, r1 )
{
	var rad=0.0174532;
	var r90= 1.5707963;
	var r270=4.7123889;
	var r360=6.2831853;
	r2=359 - r2;
	r1=359 - r1;
	
	// Everything to the right of R1
	var L,R;
	if ( r1 > 180 && r2 > 180 && r1 > r2 )
	{
		c.beginPath();
		c.arc(0,0,5,0,r360,0);
		c.fill();
	}
	
	if ( r1 <= 180 )
	{
		L=r1;
		R=(r2 > r1 && r2 <= 180)?r2:180;
		if ( L != R )
		{
			c.save(); 
			c.beginPath();
			var sx=Math.cos(R*rad);
			if (Math.abs(sx)<0.001)sx=0.001;
			c.scale(sx,1);
			c.arc(0,0,5,r90,r270,0);
			c.scale(1/sx,1);
			sx=Math.cos(L*rad);
			c.scale(sx,1);
			c.arc(0,0,5,r270,r90,1);
			c.fill();
			c.restore();
		}
	}
	
	// Everything to the left of R2.
	if ( r2 <= 180 )
	{
		R=r2;
		L=( r1 > 0 && r1 < r2 )?r1:0;
		if ( L != R )
		{
			c.save(); 
			c.beginPath();
			var sx=Math.cos(R*rad);
			if (Math.abs(sx)<0.001)sx=0.001;
			c.scale(sx,1);
			c.arc(0,0,5,r90,r270,0);
			c.scale(1/sx,1);
			sx=Math.cos(L*rad);
			c.scale(sx,1);
			c.arc(0,0,5,r270,r90,1);
			c.fill();
			c.restore();
		}
	}
}

function lozPath(c)
{
	c.beginPath();
	c.moveTo(-5,0);
	c.arcTo(-5,-5,5,-5,3);
	c.arcTo(5,-5,5,5,3);
	c.arcTo(5,5,-5,5,3);
	c.arcTo(-5,5,-5,-5,3);
	c.closePath();
}

function _goWWW(event) 
{
	widget.openURL('http://www.timescroller.com/landing_widget.html?v='+gTS_Version);
}

function _doDurationChange(event) 
{
	// Insert Code Here
}

function testZones()
{
	for( var c in continents )
	{
		var cities=continents[c].cities;
		for( var i in cities )
		{
			if ( TimeScrollerPlugin.getTimeWithOffset(cities[i].tz,0) == 0 )
				debug( "TS: " + cities[i].tz );
		}
	}
}

var gTS_FlipShown=false;
var gTS_Animation={duration:0, starttime:0, to:1.0, now:0.0, from:0.0, element:null, timer:null};

function enterflip(event)
{
	document.getElementById('fliprollie').style.display='block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display='none';
}

function limitMinMax(val, min, max)
{
    return val < min ? min : (val > max ? max : val);
}

function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}

function animate()
{
	var T;
	var ease;
	var time=(new Date).getTime();
	
	T=limitMinMax(time-gTS_Animation.starttime, 0, gTS_Animation.duration);
	
	if (T >= gTS_Animation.duration)
	{
		clearInterval(gTS_Animation.timer);
		gTS_Animation.timer=null;
		gTS_Animation.now=gTS_Animation.to;
	}
	else
	{
		ease=0.5 - (0.5 * Math.cos(Math.PI * T / gTS_Animation.duration));
		gTS_Animation.now=computeNextFloat(gTS_Animation.from, gTS_Animation.to, ease);
	}
	
	gTS_Animation.element.style.opacity=gTS_Animation.now;
	document.getElementById('slid').style.opacity=gTS_Animation.now;
}

function mousemove(event)
{
	if (!gTS_FlipShown)
	{
		// fade in the flip widget
		if (gTS_Animation.timer != null)
		{
			clearInterval(gTS_Animation.timer);
			gTS_Animation.timer =null;
		}
		
		var starttime=(new Date).getTime() - 13; // set it back one frame
		
		gTS_Animation.duration=500;
		gTS_Animation.starttime=starttime;
		gTS_Animation.element=document.getElementById('flip');
		gTS_Animation.timer=setInterval("animate();", 13);
		gTS_Animation.from=gTS_Animation.now;
		gTS_Animation.to=1.0;
		animate();
		gTS_FlipShown=true;
	}
}

function mouseexit(event)
{
	if (gTS_FlipShown && (event.toElement==null || event.toElement.id == ""))
	{
	//	if ( event.relatedTarget.id == "front" )
	//		debug(event.relatedTarget.id);
	
		// fade in the flip widget
		if (gTS_Animation.timer != null)
		{
			clearInterval (gTS_Animation.timer);
			gTS_Animation.timer =null;
		}
		
		var starttime=(new Date).getTime() - 13; // set it back one frame
		
		gTS_Animation.duration=500;
		gTS_Animation.starttime=starttime;
		gTS_Animation.element=document.getElementById('flip');
		gTS_Animation.timer=setInterval("animate();", 13);
		gTS_Animation.from=gTS_Animation.now;
		gTS_Animation.to=0.0;
		animate();
		gTS_FlipShown=false;
	}
}
