// TimeScroller
// Copyright(C) Terry Brett, TimeScroller.com

function _showBack(event)
{
	// Expand if required before locking, otherwise bits of the back will be missing.
	// If we shrink less that current front size, well see bits chopped off that.
	var front=document.getElementById("front");
	var back=document.getElementById("back");
	window.resizeTo( Math.max(300,front.clientWidth), Math.max(377,front.clientHeight) );

	if (window.widget)
		widget.prepareForTransition("ToBack");
	
	// Now we're safe to resize to the correct size.
	window.resizeTo( 300, 377 );

	// Hide this if it's showing.
	document.getElementById('updateBox').style.display="none";

	gTS_ShowingBack=true;
	clearSecTimer();

	front.style.display="none";
	back.style.display="block";
	
	buildPopupWithArray( "popup-cont", continents );
	document.getElementById("popup-cont").selectedIndex=gTS_ContinentIdx;
	buildPopupWithArray( "popup-city", continents[ gTS_ContinentIdx ].cities );
	document.getElementById("popup-city").selectedIndex=gTS_CityIdx;
	
	backCitiesPopulate();
		
	buildSegPopups();
	document.getElementById('fliprollie').style.display='none';
	
	// Fix up the "mail me" link and the inline icon in the about text.
	var aboutText = getLocalizedString("abouttext1") + "<br /><br />"
		+ getLocalizedString("abouttext2") + "<br /><br />"
		+ getLocalizedString("abouttext3") + "<br /><br />"
		+ getLocalizedString("abouttext4") + "<br /><br />"
		+ getLocalizedString("abouttext5");
	
	var mailMe = "<a href='#' class='link' title='mailto:terry@timescroller.com' onclick=\"widget.openURL('mailto:terry@timescroller.com?Subject=TimeScroller " + gTS_Version + "');\">this link</a>";
    var tsOnItunes = "<a href='#' class='link' onclick=\"widget.openURL('http://itunes.apple.com/WebObjects/MZStore.woa/wa/viewArtist?id=288013815');\">this iTunes link</a>";
	aboutText = aboutText.replace( "_MAILME_", mailMe );
	aboutText = aboutText.replace( "_THIS_LINK_", tsOnItunes );
	aboutText = aboutText.replace( "_ICON_", "<img src=\"Images/mail.png\">" );
    aboutText = aboutText.replace( "_AVAILABLE_", "<B><span class='blueabouttext'>available for iPhone</span></B>" )    
    
	document.getElementById("abouttext").innerHTML = aboutText;

	if (window.widget)
		setTimeout("widget.performTransition();", 0);
}

function _cityEdit(event)
{
	if ( gTS_SelectedBackRow == null ) return;	// sanity checking
	
	if ( gTS_EditingRoxIdx == -1  )
	{
		// Not yet editing
		var idx=findNodeIndex( gTS_SelectedBackRow );
		if ( idx == -1 ) return; // WTF?
		gTS_EditingRoxIdx = idx;
		
		// Turn off row highlighting.
		gTS_SelectedBackRow.setAttribute( "class", "brow" );
		
		// Configure and show edit field.
		var cityedit=document.getElementById("cityedit");
		cityedit.value=gTS_List[idx].name;
		cityedit.style.posTop = gTS_SelectedBackRow.offsetTop - 5;
		cityedit.style.display="block";

		// Select all.
		cityedit.focus();
		cityedit.setSelectionRange(0,999);
	}
	else
	{
		// Already editing. Use clicked rename again, end edit.
		ensureCityEditEnded();
	}
}

function ensureCityEditEnded()
{
	if ( gTS_EditingRoxIdx != -1 )
	{
		var cityedit=document.getElementById("cityedit");
		var newName = cityedit.value;
		newName = newName.replace(/[\|\~]+/g, "");	// No ~ or | (we use them as seps when writing the prefs)
		newName = newName.replace(/^ +/g, "");		// No leading spaces
		newName = newName.replace(/ +$/g, "");		// No trailing spaces
		
		if ( newName.length > 0 )
		{
			gTS_SelectedBackRow.firstChild.innerText = newName;
			gTS_List[gTS_EditingRoxIdx].name = newName;
		}
		
		// Hide edit field.
		cityedit.style.display="none";
		
		// Restore row highlighting.
		gTS_SelectedBackRow.setAttribute( "class", "brow selected" );
		
		gTS_EditingRoxIdx = -1;
	}
}

function backCitiesPopulate()
{
	var inner=document.getElementById("blistin");
	while( inner.firstChild )
		inner.removeChild( inner.firstChild );

	for( var i in gTS_List ) 
		backCityAdd( gTS_List[i].name );
}

function backCityAdd( inCity )
{
	var innerList=document.getElementById("blistin");
	var row=document.createElement("div");
	row.setAttribute("class", "brow");
	row.setAttribute("onclick", "backRowClick(this,event);");
//	row.setAttribute("ondblclick", "_cityEdit(event);");	too easy to edit, people might think they can configure it this way!
	
	var span=document.createElement("span");
	span.innerText=inCity;
	span.setAttribute("class", "bcol");
	row.appendChild(span);
	
	innerList.appendChild(row);
}

function _backRowRemove( event )
{
	ensureCityEditEnded();
	var idx=findNodeIndex( gTS_SelectedBackRow );
	if ( idx != -1 )
	{
		// Remove that child!
		var list=gTS_SelectedBackRow.parentNode;
		list.removeChild( gTS_SelectedBackRow );
		
		// Update the list.
		gTS_List.splice( idx, 1 );
				
		if ( idx == gTS_List.length ) idx--;
		
		if ( idx >= 0 )
			backRowClick( list.childNodes[idx] );
		else
			backRowsDeselect();
			
		document.getElementById("add").object.setEnabled( true );
	}
}

function _backRowMoveUp( event )
{
	ensureCityEditEnded();
	_backRowMove( -1 );
}

function _backRowMoveDown( event )
{
	ensureCityEditEnded();
	_backRowMove( +1 );
}

function _backRowMove( vec )
{
	var idx=findNodeIndex( gTS_SelectedBackRow );
	if ( ( vec == +1 && idx >= 0 && idx < (gTS_List.length-1) )
		|| ( vec == -1 && idx > 0 ) )
	{
		var swap=gTS_List[idx+vec];
		gTS_List[idx+vec]=gTS_List[idx];
		gTS_List[idx]=swap;
		var list=gTS_SelectedBackRow.parentNode;
		
		list.childNodes[idx+vec].firstChild.innerText=gTS_List[idx+vec].name;
		list.childNodes[idx].firstChild.innerText=gTS_List[idx].name;
		backRowClick( list.childNodes[idx+vec] );
	}
}

function backRowsDeselect()
{
	if ( gTS_SelectedBackRow != null )
		gTS_SelectedBackRow.setAttribute( "class", "brow" );
	gTS_SelectedBackRow=null;
	document.getElementById("remove").object.setEnabled( false );
	document.getElementById("rename").object.setEnabled( false );
	document.getElementById("up").object.setEnabled( false );
	document.getElementById("down").object.setEnabled( false );
}

function backRowClick( row, event )
{
	ensureCityEditEnded();
	
	if ( gTS_SelectedBackRow != row )
	{
		backRowsDeselect();
		
		document.getElementById("remove").object.setEnabled( true );
		document.getElementById("rename").object.setEnabled( true );
		gTS_SelectedBackRow=row;
		gTS_SelectedBackRow.setAttribute("class", "brow selected" );
		
		var idx=findNodeIndex( gTS_SelectedBackRow );
		if ( idx > 0 ) document.getElementById("up").object.setEnabled( true );
		if ( idx < (gTS_List.length-1) ) document.getElementById("down").object.setEnabled( true );
	}	
	
	if ( event )
	{
		event.stopPropagation();
		event.preventDefault();
	}
}

function _continentSelected( event )
{
	gTS_ContinentIdx=event.srcElement.selectedIndex;
	buildPopupWithArray( "popup-city", continents[ gTS_ContinentIdx ].cities );
	gTS_CityIdx=0;
	backRowsDeselect();
}

function _citySelected( event )
{
	gTS_CityIdx=event.srcElement.selectedIndex;
	backRowsDeselect();
}

function _addButtonClick( event )
{
	var contCities=continents[ gTS_ContinentIdx ].cities;
	var cityTz=contCities[ gTS_CityIdx ].tz;
	var cityName=contCities[ gTS_CityIdx ].name;
	
	gTS_List[gTS_List.length]={name:cityName, tz:cityTz};
	backCityAdd( cityName );

	document.getElementById("add").object.setEnabled( gTS_List.length < 20 );
}

function sortSegs()
{
	gTS_Segs.sort(sortSegsComparitor);
	for( var i=gTS_Segs.length - 1; i >= 0; i-- )
	{
		if ( gTS_Segs[i].hour==0 || (i > 0 && ( gTS_Segs[i].hour==gTS_Segs[i-1].hour || gTS_Segs[i].colour==gTS_Segs[i-1].colour) ) )
			gTS_Segs.splice(i,1);
	}
}

function sortSegsComparitor(a, b) 
{
	return a.hour - b.hour;
}

var gChangingSeg=false;
function _segChange(event)
{
	if ( gChangingSeg ) return;
	
	gChangingSeg=true;
	for( var i=0; i < 4; i++ )
	{
		if ( gTS_Segs[i] == undefined ) gTS_Segs[i]=[];
		gTS_Segs[i].hour=document.getElementById("after"+i).selectedIndex;
		if ( gTS_Segs[i].hour == 0 )
			gTS_Segs[i].colour="";
		else
			gTS_Segs[i].colour=gTS_ColourNames[ document.getElementById("colour"+i).selectedIndex ];
	}
	
	buildSegPopups();
	
	gChangingSeg=false;
}

function buildSegPopups()
{
	gChangingSeg=true;
	
	var hoursArr=[];
	for( var h=0; h < 25; h++ )
	{
		var hh=((h-1) % 12)+1;
		
		if ( h == 0 )
			hoursArr[h]="-";
		else if ( gTS_24Hr )
			hoursArr[h]="After " + (h < 10 ? "0":"") + h + ":00";
		else
			hoursArr[h]="After " + hh +":00"+(h >11&&h<24?"PM":"AM");
	}
	
	var coloursArr=[];
	var noColoursArr=["-"];
	for( var c in gTS_ColourNames )
	{
		coloursArr[c]="Show " + gTS_ColourNames[c];
	}
	
	for( var i=0; i < 4; i++ )
	{
		buildPopupWithArray( "after"+i, hoursArr );
		
		if ( gTS_Segs[i] == undefined || gTS_Segs[i].hour == 0 )
		{
			document.getElementById("after"+i).selectedIndex=0;
			buildPopupWithArray( "colour"+i, noColoursArr );
		}
		else
		{
			document.getElementById("after"+i).selectedIndex=gTS_Segs[i].hour;
			buildPopupWithArray( "colour"+i, coloursArr );
			document.getElementById("colour"+i).selectedIndex=gTS_Colour[ gTS_Segs[i].colour ].i;
		}
	}
	
	delete coloursArr;
	delete hoursArr;

	gChangingSeg=false;
}

function buildPopupWithArray( inID, inArray )
{
	var popup=document.getElementById( inID );
	
	// Clear current entries
	while( popup.hasChildNodes() )
		popup.removeChild( popup.firstChild );
	
	// Build new ones.
	for( var i in inArray )
	{
		var option=document.createElement("option");
		var name;
		if ( inArray[i].name == undefined )
		{
			name=inArray[i];
		}
		else
		{
			name=inArray[i].name;
			if ( inArray[i].info != undefined )
				name += " (" + inArray[i].info + ")";
		}
			
		option.innerText = name;
		popup.appendChild( option );
	}
}

function findNodeIndex( inNode )
{
	var iNode=inNode.parentNode.firstChild;
	var i=0;
	while( iNode != null )
	{
		if ( iNode == inNode ) return i;
		iNode=iNode.nextSibling;
		i++;
	}
	
	return -1;
}

function _doStyleChange(event) 
{
	gTS_Loz = (event.srcElement.value == 1);
	setPreference( gTS_Loz, "LozStyle");
}

function _doRotateChange(event) 
{
	gTS_Rotate = event.srcElement.value;
	setPreference( gTS_Rotate, "Rotation");
}

function _doPreferenceClick(event) 
{
	gTS_24Hr=document.getElementById("Hr24").checked;
	setPreference( gTS_24Hr, "Hr24");
	
	gTS_ShowDay=document.getElementById("ShowDay").checked;
	setPreference( gTS_ShowDay, "ShowDay");
	
	gTS_Small=document.getElementById("SmallSize").checked;
	setPreference( gTS_Small, "SmallSize");

	buildSegPopups();
}

function _showCities(event) 
{
	showPanel(0,true);
	showPanel(1,false);
	showPanel(2,false);
}

function _showSettings(event) 
{
	showPanel(0,false);
	showPanel(1,true);
	showPanel(2,false);
}

function _showAbout(event) 
{
	showPanel(0,false);
	showPanel(1,false);
	showPanel(2,true);
}

function showPanel(p,show)
{
	ensureCityEditEnded();

	document.getElementById("panelBox"+p).style.display=show?"block":"none";
	document.getElementById("panelStroke"+p).style.display=show?"block":"none";
	document.getElementById("panelBut"+p).object.textElement.style.fontSize=show?"14px":"10px";
	document.getElementById("panelBut"+p).object.textElement.style.minWidth="60px";
}


