/*
 * Decompiled with CFR 0.152.
 */
package StyleColorHandler;

import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJButton;
import Arachnophilia.SyntaxStyleData;
import StyleColorHandler.StyleColorPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.Field;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class StyleColorDialog
extends JDialog {
    Arachnophilia main;
    private JTextArea commentArea;
    private JScrollPane colorPanelScrollPane;
    private JPanel colorsPanel;
    private JPanel southPanel;
    private JPanel northPanel;
    private JButton closeButton;

    public StyleColorDialog(Arachnophilia arachnophilia) {
        super((Frame)arachnophilia, true);
        this.main = arachnophilia;
        this.initComponents();
        String string = "NOTE: Be sure to load the document type you are interested in changing, and make it visible while you make adjustments -- this dialog will update the display in real time.";
        this.commentArea.setText(string);
        this.commentArea.setBackground(this.getContentPane().getBackground());
        this.loadColorPanel();
        this.pack();
        Rectangle rectangle = this.main.getBounds();
        int n = rectangle.width / 4;
        int n2 = rectangle.height / 4;
        this.setBounds(rectangle.x + n, rectangle.y + n2, rectangle.width - n * 2, rectangle.height - n2 * 2);
        this.setTitle("Choose Syntax Colors");
        this.setVisible(true);
    }

    private void loadColorPanel() {
        Class<?> clazz = this.main.configValues.getClass();
        Field[] fieldArray = clazz.getFields();
        try {
            int n = 0;
            for (int i = 0; i < fieldArray.length; ++i) {
                Field field = fieldArray[i];
                Object object = field.get(this.main.configValues);
                if (!(object instanceof SyntaxStyleData)) continue;
                String string = field.getName();
                StyleColorPanel styleColorPanel = new StyleColorPanel(this.main, (SyntaxStyleData)object, string);
                this.colorsPanel.add(styleColorPanel);
                ++n;
            }
            this.colorsPanel.setLayout(new GridLayout(n, 1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this.colorPanelScrollPane = new JScrollPane();
        this.colorsPanel = new JPanel();
        this.southPanel = new JPanel();
        this.closeButton = new MyJButton();
        this.northPanel = new JPanel();
        this.commentArea = new JTextArea();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StyleColorDialog.this.closeDialog(windowEvent);
            }
        });
        this.colorPanelScrollPane.setViewportView(this.colorsPanel);
        this.getContentPane().add((Component)this.colorPanelScrollPane, "Center");
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StyleColorDialog.this.closeButtonActionPerformed(actionEvent);
            }
        });
        this.southPanel.add(this.closeButton);
        this.getContentPane().add((Component)this.southPanel, "South");
        this.northPanel.setLayout(new BorderLayout());
        this.commentArea.setBackground(new Color(204, 204, 204));
        this.commentArea.setEditable(false);
        this.commentArea.setLineWrap(true);
        this.commentArea.setWrapStyleWord(true);
        this.commentArea.setMargin(new Insets(8, 8, 8, 8));
        this.northPanel.add((Component)this.commentArea, "Center");
        this.getContentPane().add((Component)this.northPanel, "North");
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.quit();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.quit();
    }

    private void quit() {
        this.setVisible(false);
        this.dispose();
    }
}

