/*
 * Decompiled with CFR 0.152.
 */
package MacroManager;

import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJPopupMenu;
import MacroManager.MacroTreeNodeData;
import MacroManager.MyJTree;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;

public final class MacroTreePanel
extends JPanel {
    Arachnophilia main = null;
    public MyJTree mjt;
    int tabValue;
    DefaultMutableTreeNode buttonNode = null;
    Frame frame = null;
    private JPanel bottomPanel;
    private JPopupMenu buttonPopupMenu;
    private JMenuItem copyMenuItem;
    private JMenuItem cutMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenuItem editMenuButton;
    private JCheckBox editModeCheckBox;
    private JPanel internalPanel;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JMenuItem moveDownMenu;
    private JMenuItem moveDownMenuItem;
    private JMenuItem moveUpMenu;
    private JMenuItem moveUpMenuItem;
    private JMenuItem newMenuItem;
    private JCheckBox oneClickBox;
    private JMenuItem pasteMenuItem;
    private JPopupMenu popupMenu;
    private JMenuItem readFile;
    private JMenuItem readLegacyFile;
    private JCheckBoxMenuItem showHideMenuItem;
    private JMenuItem sortNormalMenuItem;
    private JMenuItem sortReversemenuItem;
    private JMenuItem writeFileMenuItem;

    public MacroTreePanel(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.tabValue = arachnophilia.configValues.tabSize;
        this.init(arachnophilia, this.tabValue);
    }

    private void init(Arachnophilia arachnophilia, int n) {
        this.frame = arachnophilia;
        this.initComponents();
        if (this.main != null) {
            this.mjt = new MyJTree(this.main, n);
            this.setEditMode(false, false);
        } else {
            this.mjt = new MyJTree(arachnophilia, this.tabValue);
        }
        this.internalPanel.add((Component)this.mjt, "West");
        this.internalPanel.setBackground(this.mjt.getBackground());
        this.jScrollPane1.setViewportView(this.internalPanel);
        if (this.main != null) {
            this.oneClickBox.setSelected(this.main.configValues.oneClickMacroMode);
        }
        this.mjt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                MacroTreePanel.this.mouseHandler(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MacroTreePanel.this.mouseHandler(mouseEvent);
            }
        });
    }

    public boolean macroExists(String string) {
        if (this.mjt != null && this.mjt.macroMap != null) {
            return this.mjt.macroMap.containsKey(string);
        }
        return false;
    }

    public String getMacroContent(String string) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.mjt.macroMap.get(string);
        MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
        return macroTreeNodeData.content;
    }

    public JPopupMenu getButtonMenu(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.buttonNode = defaultMutableTreeNode;
        return (MyJPopupMenu)this.buttonPopupMenu;
    }

    public void saveOnExit() {
        this.mjt.saveOnExit();
    }

    private void mouseHandler(MouseEvent mouseEvent) {
        if (this.popupMenu.isPopupTrigger(mouseEvent)) {
            int n = mouseEvent.getX();
            int n2 = mouseEvent.getY();
            this.mjt.selectOnRightClick(mouseEvent);
            this.showHideMenuItem.setSelected(this.mjt.itemVisible());
            ((MyJPopupMenu)this.popupMenu).show(this, n -= this.jScrollPane1.getHorizontalScrollBar().getValue(), n2 -= this.jScrollPane1.getVerticalScrollBar().getValue());
        }
    }

    private void changeEditMode(boolean bl) {
        this.setEditMode(!this.mjt.editMode, bl);
    }

    public void setEditMode(boolean bl, boolean bl2) {
        if (bl) {
            this.setOneClickMode(false);
        }
        this.mjt.setEditMode(bl, bl2);
        this.setEditCheckBox(bl);
    }

    public void setEditCheckBox(boolean bl) {
        this.editModeCheckBox.setSelected(bl);
        this.mjt.editMode = bl;
    }

    private void initComponents() {
        this.popupMenu = new MyJPopupMenu();
        this.showHideMenuItem = new JCheckBoxMenuItem();
        this.cutMenuItem = new JMenuItem();
        this.copyMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.moveUpMenuItem = new JMenuItem();
        this.moveDownMenuItem = new JMenuItem();
        this.jSeparator1 = new JSeparator();
        this.newMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.jSeparator2 = new JSeparator();
        this.sortNormalMenuItem = new JMenuItem();
        this.sortReversemenuItem = new JMenuItem();
        this.jSeparator3 = new JSeparator();
        this.readFile = new JMenuItem();
        this.readLegacyFile = new JMenuItem();
        this.writeFileMenuItem = new JMenuItem();
        this.buttonPopupMenu = new MyJPopupMenu();
        this.editMenuButton = new JMenuItem();
        this.moveUpMenu = new JMenuItem();
        this.moveDownMenu = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.internalPanel = new JPanel();
        this.bottomPanel = new JPanel();
        this.oneClickBox = new JCheckBox();
        this.editModeCheckBox = new JCheckBox();
        this.showHideMenuItem.setText("Show/(Hide) selected item  (key x)");
        this.showHideMenuItem.setToolTipText("Hiding applies to toolbars, buttons and menus");
        this.showHideMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.showHideMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.showHideMenuItem);
        this.cutMenuItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        this.cutMenuItem.setText("Cut");
        this.cutMenuItem.setToolTipText("Cut this item");
        this.cutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.cutMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.cutMenuItem);
        this.copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.copyMenuItem.setText("Copy");
        this.copyMenuItem.setToolTipText("Copy this item");
        this.copyMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.copyMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.copyMenuItem);
        this.pasteMenuItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.pasteMenuItem.setText("Paste");
        this.pasteMenuItem.setToolTipText("Paste previously cut/copied item");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.pasteMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.pasteMenuItem);
        this.moveUpMenuItem.setText("Move item up (key -)");
        this.moveUpMenuItem.setToolTipText("Move this item up the list");
        this.moveUpMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.moveUpMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.moveUpMenuItem);
        this.moveDownMenuItem.setText("Move item down (key +)");
        this.moveDownMenuItem.setToolTipText("Move this item down the list");
        this.moveDownMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.moveDownMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.moveDownMenuItem);
        this.popupMenu.add(this.jSeparator1);
        this.newMenuItem.setText("New");
        this.newMenuItem.setToolTipText("Create new item");
        this.newMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.newMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.newMenuItem);
        this.deleteMenuItem.setAccelerator(KeyStroke.getKeyStroke(127, 0));
        this.deleteMenuItem.setText("Delete");
        this.deleteMenuItem.setToolTipText("Delete this item and all its children");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.deleteMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.deleteMenuItem);
        this.popupMenu.add(this.jSeparator2);
        this.sortNormalMenuItem.setText("Sort normal");
        this.sortNormalMenuItem.setToolTipText("Sort children in normal order");
        this.sortNormalMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.sortNormalMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.sortNormalMenuItem);
        this.sortReversemenuItem.setText("Sort reverse");
        this.sortReversemenuItem.setToolTipText("Sort children in reverse order");
        this.sortReversemenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.sortReversemenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.sortReversemenuItem);
        this.popupMenu.add(this.jSeparator3);
        this.readFile.setText("Read macro file");
        this.readFile.setToolTipText("Read commands from macro file");
        this.readFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.readFileActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.readFile);
        this.readLegacyFile.setText("Read legacy file");
        this.readLegacyFile.setToolTipText("Read pre-version 5.0 \"toolbar file\"");
        this.readLegacyFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.readLegacyFileActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.readLegacyFile);
        this.writeFileMenuItem.setText("Write macro file");
        this.writeFileMenuItem.setToolTipText("Write contents of selected node and its children");
        this.writeFileMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.writeFileMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.writeFileMenuItem);
        this.editMenuButton.setText("Edit");
        this.editMenuButton.setToolTipText("Edit this button");
        this.editMenuButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.editMenuButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPopupMenu.add(this.editMenuButton);
        this.moveUpMenu.setText("Move Up/Left");
        this.moveUpMenu.setToolTipText("Move this item");
        this.moveUpMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.moveUpMenuActionPerformed(actionEvent);
            }
        });
        this.buttonPopupMenu.add(this.moveUpMenu);
        this.moveDownMenu.setText("Move Down/Right");
        this.moveDownMenu.setToolTipText("Move this item");
        this.moveDownMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.moveDownMenuActionPerformed(actionEvent);
            }
        });
        this.buttonPopupMenu.add(this.moveDownMenu);
        this.setLayout(new BorderLayout());
        this.internalPanel.setLayout(new BorderLayout());
        this.internalPanel.setBackground(Color.white);
        this.internalPanel.setBorder(new EmptyBorder(new Insets(4, 4, 4, 4)));
        this.jScrollPane1.setViewportView(this.internalPanel);
        this.add((Component)this.jScrollPane1, "Center");
        this.bottomPanel.setLayout(new GridLayout(1, 0));
        this.bottomPanel.setMinimumSize(new Dimension(0, 35));
        this.oneClickBox.setText("One-click");
        this.oneClickBox.setToolTipText("Select one-click mode to use macros, deselect to edit them");
        this.oneClickBox.setHorizontalAlignment(0);
        this.oneClickBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.oneClickBoxActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.oneClickBox);
        this.editModeCheckBox.setText("Edit");
        this.editModeCheckBox.setToolTipText("Select to allow macro editing");
        this.editModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroTreePanel.this.editModeCheckBoxActionPerformed(actionEvent);
            }
        });
        this.bottomPanel.add(this.editModeCheckBox);
        this.add((Component)this.bottomPanel, "South");
    }

    private void moveDownMenuActionPerformed(ActionEvent actionEvent) {
        this.moveDownButton();
    }

    private void moveUpMenuActionPerformed(ActionEvent actionEvent) {
        this.moveUpButton();
    }

    private void editMenuButtonActionPerformed(ActionEvent actionEvent) {
        this.editButton();
    }

    private void editModeCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.changeEditMode(true);
    }

    private void showHideMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.showHide();
    }

    private void writeFileMenuItemActionPerformed(ActionEvent actionEvent) {
        if (this.main != null) {
            this.mjt.promptWriteMacroFile(this.main);
        }
    }

    private void oneClickBoxActionPerformed(ActionEvent actionEvent) {
        this.toggleOneClickMode();
    }

    private void readLegacyFileActionPerformed(ActionEvent actionEvent) {
        if (this.main != null) {
            this.mjt.promptReadMacroFile(this.main, true);
        }
    }

    private void readFileActionPerformed(ActionEvent actionEvent) {
        if (this.main != null) {
            this.mjt.promptReadMacroFile(this.main, false);
        }
    }

    private void sortReversemenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.sortReverse();
    }

    private void sortNormalMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.sortNormal();
    }

    private void newMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.newNode();
    }

    private void editMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.editNode(this.frame, this.tabValue);
    }

    private void moveDownMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.moveDown();
    }

    private void moveUpMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.moveUp();
    }

    private void deleteMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.deleteNode();
    }

    private void pasteMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.pasteNode();
    }

    private void copyMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.copyNode();
    }

    private void cutMenuItemActionPerformed(ActionEvent actionEvent) {
        this.mjt.cutNode();
    }

    private void editButton() {
        if (this.buttonNode != null) {
            this.mjt.refocusNode(this.buttonNode);
            this.mjt.editNode();
        }
    }

    private void moveUpButton() {
        if (this.buttonNode != null) {
            this.mjt.refocusNode(this.buttonNode);
            this.mjt.moveUp();
        }
    }

    private void moveDownButton() {
        if (this.buttonNode != null) {
            this.mjt.refocusNode(this.buttonNode);
            this.mjt.moveDown();
        }
    }

    private void toggleOneClickMode() {
        if (this.main != null) {
            this.setOneClickMode(!this.main.configValues.oneClickMacroMode);
        }
    }

    private void setOneClickMode(boolean bl) {
        if (this.main != null) {
            if (this.mjt.editMode && bl) {
                bl = false;
                Toolkit.getDefaultToolkit().beep();
            }
            this.main.configValues.oneClickMacroMode = bl;
            this.oneClickBox.setSelected(bl);
        }
    }
}

