/*
 * Decompiled with CFR 0.152.
 */
package MacroManager;

import Arachnophilia.ArachComp;
import Arachnophilia.Arachnophilia;
import Arachnophilia.SearchReplace;
import MacroManager.KeyDescription;
import MacroManager.LegacyToolbarConverter;
import MacroManager.MacroTreeNodeData;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;

public final class MacroFileReadWrite {
    Arachnophilia main;

    public MacroFileReadWrite(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
    }

    public boolean readLegacyMacroFile(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        boolean bl = false;
        LegacyToolbarConverter legacyToolbarConverter = new LegacyToolbarConverter();
        String string2 = legacyToolbarConverter.convertFile(string);
        if (string2 != null) {
            Vector vector = ArachComp.parseDelimLine(string2, "\n", false);
            this.processReadXMLData(1, vector, defaultMutableTreeNode);
            bl = true;
        }
        return bl;
    }

    public boolean readMacroFile(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        String string2 = ArachComp.readProgramFile(string, true);
        if (string2 != null) {
            return this.readMacroString(string, string2, defaultMutableTreeNode);
        }
        return false;
    }

    public boolean readMacroString(String string, String string2, DefaultMutableTreeNode defaultMutableTreeNode) {
        Vector vector;
        boolean bl = false;
        if (string2 != null && (vector = ArachComp.parseDelimLine(string2, "\n", true)).size() > 0) {
            String string3 = ((String)vector.get(0)).toLowerCase();
            if (string3.indexOf("<?xml") != -1) {
                bl = this.processReadXMLData(1, vector, defaultMutableTreeNode);
            } else {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(null, "File \"" + string + "\"\nis not a valid macro file.\n" + "If you are trying to read legacy Arachnophilia\n" + "(pre-4.0) toolbar files, use the \"Read legacy file\"\n" + "menu option.", "Not Valid Macro File", 1);
            }
        }
        return bl;
    }

    private boolean processReadXMLData(int n, Vector vector, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.execReadXMLData(n, vector, defaultMutableTreeNode);
        return true;
    }

    private int execReadXMLData(int n, Vector vector, DefaultMutableTreeNode defaultMutableTreeNode) {
        MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
        int n2 = vector.size();
        while (n < n2) {
            int n3 = this.readTag(macroTreeNodeData, (String)vector.get(n));
            ++n;
            if (n3 == 1) {
                MacroTreeNodeData macroTreeNodeData2 = new MacroTreeNodeData();
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(macroTreeNodeData2);
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                n = this.execReadXMLData(n, vector, defaultMutableTreeNode2);
                macroTreeNodeData2.name = ArachComp.getStringForNode(defaultMutableTreeNode2);
                continue;
            }
            if (n3 != -1) continue;
            break;
        }
        return n;
    }

    private int readTag(MacroTreeNodeData macroTreeNodeData, String string) {
        String string2 = "";
        if (string.indexOf("<?") != -1) {
            return 0;
        }
        int n = string.indexOf("<");
        int n2 = string.indexOf(">", n);
        int n3 = string.indexOf("</");
        if (n == -1) {
            return 0;
        }
        if (n3 != -1 && n3 < n2) {
            string2 = string.substring(n3 + 1, n2);
            return -1;
        }
        if (n2 != -1 && n < n2) {
            string2 = string.substring(n + 1, n2);
        }
        if (n3 != -1 && n2 < n3) {
            if (macroTreeNodeData != null) {
                String string3 = string.substring(n2 + 1, n3);
                string3 = ArachComp.unescapeXMLContent(string3);
                if (string2.equals("title")) {
                    macroTreeNodeData.title = string3.trim();
                } else if (string2.equals("tooltip")) {
                    macroTreeNodeData.toolTip = string3;
                } else if (string2.equals("keyboardhook")) {
                    macroTreeNodeData.keyboardHook = new KeyDescription(string3);
                    if (!macroTreeNodeData.keyboardHook.isValid()) {
                        KeyStroke keyStroke = this.translateToAccelerator(string3);
                        macroTreeNodeData.keyboardHook = new KeyDescription(keyStroke);
                    }
                } else if (string2.equals("content")) {
                    macroTreeNodeData.content = string3;
                } else if (string2.equals("icon")) {
                    macroTreeNodeData.icon = string3;
                    macroTreeNodeData.refreshIcon();
                } else if (string2.equals("toolbar")) {
                    macroTreeNodeData.isToolBar = true;
                    macroTreeNodeData.refreshIcon();
                } else if (string2.equals("menu")) {
                    macroTreeNodeData.isMenu = true;
                    macroTreeNodeData.refreshIcon();
                } else if (string2.equals("hidden")) {
                    macroTreeNodeData.isHidden = true;
                    macroTreeNodeData.refreshIcon();
                } else if (string2.equals("separator")) {
                    macroTreeNodeData.isSeparator = true;
                    macroTreeNodeData.refreshIcon();
                } else if (string2.equals("showtitleandicon")) {
                    macroTreeNodeData.showTitleAndIcon = true;
                    macroTreeNodeData.refreshIcon();
                }
            }
            return 0;
        }
        return 1;
    }

    private KeyStroke translateToAccelerator(String string) {
        SearchReplace searchReplace = new SearchReplace();
        string = searchReplace.srchRplc(string, "Ctrl", "control");
        string = searchReplace.srchRplc(string, "Alt", "alt");
        string = searchReplace.srchRplc(string, "Shift", "shift");
        string = searchReplace.srchRplc(string, "-", " ");
        string = searchReplace.srchRplc(string, "+", " ");
        string = searchReplace.srchRplc(string, "Enter", "ENTER");
        string = searchReplace.srchRplc(string, "Space", "SPACE");
        return KeyStroke.getKeyStroke(string);
    }

    public void writeRootMacroFile(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        if (defaultMutableTreeNode.getUserObject() != null) {
            this.writeMacroFileCore(string, defaultMutableTreeNode, 0);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void writeMacroFile(String string, DefaultMutableTreeNode defaultMutableTreeNode) {
        this.writeMacroFileCore(string, defaultMutableTreeNode, -1);
    }

    private void writeMacroFileCore(String string, DefaultMutableTreeNode defaultMutableTreeNode, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<?xml version=\"1.0\" standalone=\"yes\" encoding=\"iso-8859-1\"?>\n");
        this.scanJTree(n, stringBuffer, defaultMutableTreeNode);
        ArachComp.writeProgramFile(string, stringBuffer.toString(), true);
    }

    private String makeTabs(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append("\t");
        }
        return stringBuffer.toString();
    }

    private void scanJTree(int n, StringBuffer stringBuffer, DefaultMutableTreeNode defaultMutableTreeNode) {
        MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
        int n2 = defaultMutableTreeNode.getChildCount();
        if (n2 > 0) {
            String string;
            if (n >= 0) {
                string = this.makeTagGroup(macroTreeNodeData, "node", n, false);
                stringBuffer.append(string);
            }
            for (int i = 0; i < n2; ++i) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
                this.scanJTree(n + 1, stringBuffer, defaultMutableTreeNode2);
            }
            if (n >= 0) {
                string = this.makeTag(n, "node", false) + "\n";
                stringBuffer.append(string);
            }
        } else if (n >= 0) {
            String string = this.makeTagGroup(macroTreeNodeData, "leaf", n, true);
            stringBuffer.append(string);
        }
    }

    private String makeTagGroup(MacroTreeNodeData macroTreeNodeData, String string, int n, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.makeTag(n, string, true) + "\n");
        stringBuffer.append(this.makeDataTag(n + 1, "title", macroTreeNodeData.title));
        stringBuffer.append(this.makeDataTag(n + 1, "tooltip", macroTreeNodeData.toolTip));
        String string2 = "";
        if (macroTreeNodeData.keyboardHook != null && macroTreeNodeData.keyboardHook.isValid()) {
            string2 = macroTreeNodeData.keyboardHook.toString();
        }
        stringBuffer.append(this.makeDataTag(n + 1, "keyboardhook", string2));
        stringBuffer.append(this.makeDataTag(n + 1, "icon", macroTreeNodeData.icon));
        stringBuffer.append(this.makeDataTag(n + 1, "content", macroTreeNodeData.content));
        stringBuffer.append(this.makeDataTag(n + 1, "toolbar", macroTreeNodeData.isToolBar));
        stringBuffer.append(this.makeDataTag(n + 1, "menu", macroTreeNodeData.isMenu));
        stringBuffer.append(this.makeDataTag(n + 1, "hidden", macroTreeNodeData.isHidden));
        stringBuffer.append(this.makeDataTag(n + 1, "separator", macroTreeNodeData.isSeparator));
        stringBuffer.append(this.makeDataTag(n + 1, "showtitleandicon", macroTreeNodeData.showTitleAndIcon));
        if (bl) {
            stringBuffer.append(this.makeTag(n, string, false) + "\n");
        }
        return stringBuffer.toString();
    }

    private String makeTag(int n, String string, boolean bl) {
        return this.makeTabs(n) + "<" + (bl ? "" : "/") + string + ">";
    }

    private String makeDataTag(int n, String string, String string2) {
        String string3 = "";
        if (string2.length() > 0) {
            string3 = this.makeTabs(n) + "<" + string + ">" + ArachComp.escapeXMLContent(string2) + "</" + string + ">\n";
        }
        return string3;
    }

    private String makeDataTag(int n, String string, boolean bl) {
        String string2 = "";
        if (bl) {
            string2 = this.makeDataTag(n, string, "true");
        }
        return string2;
    }
}

