/*
 * Decompiled with CFR 0.152.
 */
package MacroManager;

import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;

public class KeyDescription {
    private int keyCode = 0;
    private int keyMods = 0;
    private boolean valid = false;
    private String description = null;

    public KeyDescription() {
    }

    public KeyDescription(int n, int n2) {
        this(KeyStroke.getKeyStroke(n, n2));
    }

    public KeyDescription(KeyEvent keyEvent) {
        this(KeyStroke.getKeyStrokeForEvent(keyEvent));
    }

    public KeyDescription(KeyStroke keyStroke) {
        if (keyStroke != null) {
            this.keyCode = keyStroke.getKeyCode();
            this.keyMods = keyStroke.getModifiers();
            if (this.keyCode > 0 || this.keyMods > 0) {
                this.valid = true;
            }
        }
    }

    public KeyDescription(String string) {
        String[] stringArray = string.split(",");
        if (stringArray.length == 2) {
            try {
                this.keyCode = Integer.parseInt(stringArray[0]);
                this.keyMods = Integer.parseInt(stringArray[1]);
                if (this.keyCode > 0 || this.keyMods > 0) {
                    this.valid = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    public Object clone() {
        return new KeyDescription(this.keyCode, this.keyMods);
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public int getModifiers() {
        return this.keyMods;
    }

    public String toString() {
        return this.keyCode + "," + this.keyMods;
    }

    public String getDescription() {
        if (!this.valid) {
            return "";
        }
        if (this.description != null) {
            return this.description;
        }
        this.description = this.getTextForm();
        return this.description == null ? "" : this.description;
    }

    private boolean isCtrlAltModified(int n) {
        return (n & 8) != 0 || (n & 2) != 0;
    }

    public String getTextForm() {
        String string = KeyEvent.getKeyModifiersText(this.keyMods);
        String string2 = KeyEvent.getKeyText(this.keyCode);
        if (this.keyCode != 9 && this.keyCode < 32 && !this.isCtrlAltModified(this.keyMods)) {
            return null;
        }
        String string3 = "";
        if (string.length() > 0) {
            string3 = string + "-";
        }
        this.description = string3 = string3 + string2;
        return string3;
    }
}

