/*
 * Decompiled with CFR 0.152.
 */
package LookAndFeel;

import Arachnophilia.ArachComp;
import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJButton;
import LookAndFeel.LookAndFeelDialog;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class LookAndFeelPanel
extends JPanel {
    Arachnophilia main;
    LookAndFeelDialog dialog;
    String[][] lookAndFeelNames;
    private JPanel topPane;
    private JScrollPane jScrollPane1;
    private JTextArea messageArea;
    private JPanel centerPane;
    private JList lfList;
    private JPanel bottomPane;
    private JButton applyButton;
    private JButton quitButton;

    public LookAndFeelPanel(Arachnophilia arachnophilia, LookAndFeelDialog lookAndFeelDialog, String string) {
        this.main = arachnophilia;
        this.dialog = lookAndFeelDialog;
        this.initComponents();
        String string2 = "This dialog allows you to choose a look & feel for Arachnophilia 5.4. A look & feel is a set of appearances and behaviors that you can use to change how Arachnophilia behaves.\n\nChoose a look & feel from the list below. Then click \"Apply\" to apply it to Arachnophilia.\n\nSome of the changes may not fully \"take\" until you have exited and re-entered Arachnophilia.";
        this.messageArea.setText(string2);
        this.messageArea.setBackground(this.getBackground());
        this.lookAndFeelNames = ArachComp.getLookAndFeelNames();
        this.lfList.setListData(this.lookAndFeelNames[1]);
    }

    public void apply() {
        int n = this.lfList.getSelectedIndex();
        if (n >= 0) {
            ArachComp.setupLookAndFeel(this.lookAndFeelNames[0][n]);
            this.main.configValues.lookAndFeelName = this.lookAndFeelNames[0][n];
        }
    }

    private void initComponents() {
        this.topPane = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.messageArea = new JTextArea();
        this.centerPane = new JPanel();
        this.lfList = new JList();
        this.bottomPane = new JPanel();
        this.applyButton = new MyJButton();
        this.quitButton = new MyJButton();
        this.setLayout(new BorderLayout());
        this.topPane.setLayout(new BorderLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(350, 200));
        this.messageArea.setBackground(new Color(204, 204, 204));
        this.messageArea.setEditable(false);
        this.messageArea.setLineWrap(true);
        this.messageArea.setWrapStyleWord(true);
        this.messageArea.setMargin(new Insets(8, 8, 8, 8));
        this.jScrollPane1.setViewportView(this.messageArea);
        this.topPane.add((Component)this.jScrollPane1, "Center");
        this.add((Component)this.topPane, "North");
        this.centerPane.setLayout(new BorderLayout());
        this.lfList.setToolTipText("Choose a look & feel, then press \"Apply\"");
        this.lfList.setSelectionMode(0);
        this.centerPane.add((Component)this.lfList, "Center");
        this.add((Component)this.centerPane, "Center");
        this.applyButton.setText("Apply");
        this.applyButton.setToolTipText("Apply the chosen Look & Feel to the main application");
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookAndFeelPanel.this.applyButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPane.add(this.applyButton);
        this.quitButton.setText("Quit");
        this.quitButton.setToolTipText("Quit this dialog");
        this.quitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LookAndFeelPanel.this.quitButtonActionPerformed(actionEvent);
            }
        });
        this.bottomPane.add(this.quitButton);
        this.add((Component)this.bottomPane, "South");
    }

    private void applyButtonActionPerformed(ActionEvent actionEvent) {
        this.apply();
    }

    private void quitButtonActionPerformed(ActionEvent actionEvent) {
        this.dialog.quit();
    }
}

