/*
 * Decompiled with CFR 0.152.
 */
package JArachTextArea;

import JArachTextArea.SyntaxStyle;
import JArachTextArea.Token;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import javax.swing.text.Segment;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;

public final class SyntaxUtilities {
    public static boolean regionMatches(boolean bl, Segment segment, int n, String string) {
        int n2 = n + string.length();
        char[] cArray = segment.array;
        if (n2 > segment.offset + segment.count) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            char c = cArray[n3];
            char c2 = string.charAt(n4);
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public static boolean regionMatches(boolean bl, Segment segment, int n, char[] cArray) {
        int n2 = n + cArray.length;
        char[] cArray2 = segment.array;
        if (n2 > segment.offset + segment.count) {
            return false;
        }
        int n3 = n;
        int n4 = 0;
        while (n3 < n2) {
            char c = cArray2[n3];
            char c2 = cArray[n4];
            if (bl) {
                c = Character.toUpperCase(c);
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) {
                return false;
            }
            ++n3;
            ++n4;
        }
        return true;
    }

    public static SyntaxStyle[] getDefaultSyntaxStyles() {
        SyntaxStyle[] syntaxStyleArray = new SyntaxStyle[16];
        syntaxStyleArray[1] = new SyntaxStyle(Color.black, true, false);
        syntaxStyleArray[2] = new SyntaxStyle(new Color(0x990033), true, false);
        syntaxStyleArray[6] = new SyntaxStyle(Color.blue, false, true);
        syntaxStyleArray[7] = new SyntaxStyle(new Color(0, 128, 0), false, false);
        syntaxStyleArray[8] = new SyntaxStyle(new Color(38400), false, false);
        syntaxStyleArray[3] = new SyntaxStyle(new Color(6619289), false, false);
        syntaxStyleArray[4] = new SyntaxStyle(new Color(6619289), false, true);
        syntaxStyleArray[5] = new SyntaxStyle(new Color(0x990033), false, true);
        syntaxStyleArray[9] = new SyntaxStyle(Color.black, false, true);
        syntaxStyleArray[10] = new SyntaxStyle(Color.red, false, true);
        syntaxStyleArray[11] = new SyntaxStyle(Color.blue, false, false);
        syntaxStyleArray[12] = new SyntaxStyle(Color.black, false, false);
        syntaxStyleArray[13] = new SyntaxStyle(Color.green.darker(), false, false);
        syntaxStyleArray[14] = new SyntaxStyle(Color.magenta.darker(), false, false);
        syntaxStyleArray[15] = new SyntaxStyle(Color.blue, false, false);
        return syntaxStyleArray;
    }

    public static int paintSyntaxLine(Segment segment, Token token, SyntaxStyle[] syntaxStyleArray, TabExpander tabExpander, Graphics graphics, int n, int n2) {
        byte by;
        Font font = graphics.getFont();
        Color color = graphics.getColor();
        int n3 = 0;
        while ((by = token.id) != 127) {
            int n4 = token.length;
            if (by == 0) {
                if (!color.equals(graphics.getColor())) {
                    graphics.setColor(color);
                }
                if (!font.equals(graphics.getFont())) {
                    graphics.setFont(font);
                }
            } else {
                syntaxStyleArray[by].setGraphicsFlags(graphics, font);
            }
            segment.count = n4;
            if (segment.offset + segment.count >= segment.array.length) {
                segment.count = segment.array.length - segment.offset;
            }
            n = Utilities.drawTabbedText(segment, n, n2, graphics, tabExpander, 0);
            segment.offset += n4;
            n3 += n4;
            token = token.next;
        }
        return n;
    }

    private SyntaxUtilities() {
    }
}

