/*
 * Decompiled with CFR 0.152.
 */
package FileTypes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.HashSet;
import java.util.Vector;

public final class FileTypes
implements FileFilter {
    public Vector suffixVector;
    HashSet suffixHash;
    public String[] fileTypeNames;
    public String[] fileTemplateSuffs;
    public String[] markerClassNames;
    public String[] binTextType;
    public int fileTypeMax = 0;
    private int type = 0;
    private String path = ".";

    public FileTypes(String string, String string2) {
        this.path = string2;
        this.getFileTypeData();
        this.setFileType(string);
    }

    public FileTypes(String string) {
        this.path = string;
        this.getFileTypeData();
        this.setFileType("All");
    }

    public void getFileTypeData() {
        this.suffixVector = new Vector();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        Vector<String> vector3 = new Vector<String>();
        Vector<String> vector4 = new Vector<String>();
        int n = 0;
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.path));
            while ((string = bufferedReader.readLine()) != null) {
                Vector vector5 = this.parseDelimLine(string, ";");
                string = (String)vector5.elementAt(0);
                if ((string = string.trim()).length() <= 0 || (vector5 = this.parseDelimLine(string, "|", true)).size() <= 2) continue;
                vector.add((String)vector5.get(0));
                vector4.add((String)vector5.get(1));
                vector2.add((String)vector5.get(2));
                String string2 = (String)vector5.get(3);
                Vector vector6 = this.parseDelimLine(string2, ",", true);
                this.suffixVector.add(vector6);
                vector3.add((String)vector6.get(0));
                ++n;
            }
            bufferedReader.close();
            this.fileTypeMax = n;
            this.fileTypeNames = vector.toArray(new String[vector.size()]);
            this.fileTemplateSuffs = vector3.toArray(new String[vector3.size()]);
            this.markerClassNames = vector2.toArray(new String[vector2.size()]);
            this.binTextType = vector4.toArray(new String[vector4.size()]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getFileType(String string) {
        int n = this.getFileTypeForName("Text");
        return this.getFileType(string, n);
    }

    public int testFileType(String string) {
        int n = -1;
        return this.getFileType(string, n);
    }

    public int getValidFileType(String string) {
        return this.getFileType(string, -1);
    }

    private int getFileType(String string, int n) {
        int n2 = string.lastIndexOf(".");
        if (n2 != -1) {
            String string2 = string.substring(n2 + 1);
            string2 = string2.toLowerCase();
            string2 = string2.trim();
            boolean bl = false;
            block0: for (int i = 0; !bl && i < this.suffixVector.size(); ++i) {
                Vector vector = (Vector)this.suffixVector.elementAt(i);
                for (int j = 0; !bl && j < vector.size(); ++j) {
                    bl = string2.equals((String)vector.elementAt(j));
                    if (!bl) continue;
                    n = i;
                    continue block0;
                }
            }
        }
        return n;
    }

    public boolean isTextFile(String string) {
        boolean bl = false;
        int n = this.testFileType(string);
        if (n != -1) {
            bl = this.binTextType[n].toLowerCase().equals("t");
        }
        return bl;
    }

    public boolean isValidTextFile(int n) {
        boolean bl = false;
        if (n >= 0 && n < this.fileTypeMax) {
            return this.markerClassNames[n].length() > 0;
        }
        return bl;
    }

    public int getFileTypeForName(String string) {
        for (int i = 0; i < this.fileTypeNames.length; ++i) {
            if (!string.equals(this.fileTypeNames[i])) continue;
            return i;
        }
        return -1;
    }

    Vector parseDelimLine(String string, String string2, boolean bl) {
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = string2.length();
        while ((n = string.indexOf(string2, n2)) != -1) {
            String string3 = string.substring(n2, n);
            if (bl) {
                string3 = string3.trim();
            }
            vector.addElement(string3);
            n2 = n + n3;
        }
        if (n2 <= string.length()) {
            vector.addElement(string.substring(n2));
        }
        return vector;
    }

    Vector parseDelimLine(String string, String string2) {
        return this.parseDelimLine(string, string2, false);
    }

    public void setFileType(String string) {
        int n = this.getFileTypeForName(string);
        if (n >= 0) {
            this.setFileType(n);
        }
    }

    public void setFileType(int n) {
        this.type = n;
        this.suffixHash = new HashSet();
        Vector vector = (Vector)this.suffixVector.elementAt(this.type);
        for (int i = 0; i < vector.size(); ++i) {
            this.suffixHash.add((String)vector.elementAt(i));
        }
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        if (this.suffixHash.size() == 0) {
            return true;
        }
        if (this.suffixHash.contains("*.*")) {
            return true;
        }
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(n + 1);
            string = string.toLowerCase();
            if ((string = string.trim()).length() > 0) {
                return this.suffixHash.contains(string);
            }
        }
        return false;
    }

    public String getDescription() {
        return this.getDescription(this.type);
    }

    public int getFileType() {
        return this.type;
    }

    public String[] getFileTypeNames() {
        return this.fileTypeNames;
    }

    public String getDescription(int n) {
        Vector vector = (Vector)this.suffixVector.elementAt(n);
        String string = this.fileTypeNames[n] + " Files (";
        if (vector.size() == 0) {
            string = string + "*.*";
        } else {
            for (int i = 0; i < vector.size(); ++i) {
                if (i > 0) {
                    string = string + ",";
                }
                string = string + (String)vector.elementAt(i);
            }
        }
        string = string + ")";
        return string;
    }
}

