/*
 * Decompiled with CFR 0.152.
 */
package FilePicker;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public final class GraphicPreviewPanel
extends JPanel {
    ImageIcon image = null;
    ImageIcon scaledImage = null;
    boolean blackBackground = false;
    boolean newImage = false;

    public GraphicPreviewPanel() {
        this.initComponents();
        this.doBackground();
    }

    public void doBackground() {
        this.setBackground(this.blackBackground ? Color.black : Color.white);
    }

    public void flipBackground() {
        this.blackBackground = !this.blackBackground;
        this.doBackground();
        this.repaint();
    }

    public void loadGraphic(File file) {
        this.scaledImage = null;
        if (file != null) {
            this.image = null;
            System.gc();
            this.image = new ImageIcon(file.getPath());
            if (this.image.getIconHeight() < 1) {
                this.image = null;
            }
            this.scaleImage();
            this.invalidate();
            this.repaint();
        }
    }

    public void scaleImage() {
        this.scaledImage = null;
        if (this.image != null) {
            Dimension dimension = this.getSize();
            double d = dimension.width - 8;
            double d2 = dimension.height - 8;
            double d3 = this.image.getIconWidth();
            double d4 = this.image.getIconHeight();
            double d5 = d3 <= d && d4 <= d2 ? 1.0 : (d3 / d < d4 / d2 ? d2 / d4 : d / d3);
            int n = new Double(d3 * d5).intValue();
            int n2 = new Double(d4 * d5).intValue();
            System.gc();
            Image image = this.image.getImage();
            this.scaledImage = image.getWidth(this) > 0 && image.getHeight(this) > 0 && n > 0 && n2 > 0 ? new ImageIcon(image.getScaledInstance(n, n2, 1)) : this.image;
            this.newImage = false;
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.scaledImage != null) {
            int n = this.getWidth() / 2 - this.scaledImage.getIconWidth() / 2;
            int n2 = this.getHeight() / 2 - this.scaledImage.getIconHeight() / 2;
            if (n2 < 0) {
                n2 = 0;
            }
            if (n < 5) {
                n = 5;
            }
            this.scaledImage.paintIcon(this, graphics, n, n2);
        } else {
            String string = "No Preview Available";
            FontMetrics fontMetrics = graphics.getFontMetrics();
            int n = fontMetrics.stringWidth(string);
            graphics.drawString(string, (this.getWidth() - n) / 2, this.getHeight() / 2);
        }
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.setBackground(Color.white);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                GraphicPreviewPanel.this.formComponentResized(componentEvent);
            }
        });
    }

    private void formComponentResized(ComponentEvent componentEvent) {
        this.scaleImage();
        this.repaint();
    }
}

