/*
 * Decompiled with CFR 0.152.
 */
package FTPService;

import Arachnophilia.ArachConstants;
import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJButton;
import FTPService.FTPSiteData;
import FTPService.FTPUtils;
import FTPService.ThreadFTPFrame;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JPopupMenu;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class FTPPanel
extends JPanel {
    private Arachnophilia main;
    Vector siteList;
    boolean isChanged = false;
    boolean holdChange = false;
    public boolean cancelOp = false;
    int traceLevel = 1;
    final int max = 32;
    int lastIndex = -1;
    FTPUtils ftpUtils;
    ThreadFTPFrame parent;
    private JLabel jLabel4;
    private JLabel jLabel8;
    private JButton rehearseButton;
    private JPanel processSouth;
    private JSlider traceDetailSlider;
    private JTextField passwordBox;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JTextArea traceDisplay;
    private JTextField portNumberBox;
    private JButton useCurrentDirButton;
    private JLabel jLabel2;
    private JButton syncLogButton;
    private JSplitPane jSplitPane1;
    private JCheckBox savePasswordCheckBox;
    private JTextField siteNameBox;
    private JPanel jPanel2;
    private JButton jButton3;
    private JCheckBox searchSubsCheckBox;
    private JLabel jLabel9;
    private JTextField userNameBox;
    private JTextField remoteDirectoryBox;
    private JCheckBox uploadAllCheckBox;
    private JScrollPane processScrollPane;
    private JTextField localDirectoryBox;
    private JPanel processTracePanel;
    private JMenuItem lineWrapMenuItem;
    private JButton cancelButton;
    private JLabel jLabel7;
    private JComboBox siteListBox;
    private JPanel siteDataPane;
    private JLabel jLabel6;
    private JProgressBar progressBar;
    private JButton closeButton;
    private JTextField serverNameBox;
    private JButton execButton;
    private JPopupMenu popupMenu;
    private JPanel siteDataPanel;
    private JLabel jLabel5;

    public FTPPanel(Arachnophilia arachnophilia, ThreadFTPFrame threadFTPFrame) {
        this.main = arachnophilia;
        this.parent = threadFTPFrame;
        this.initComponents();
        this.initPanel();
    }

    private void initPanel() {
        int n;
        this.siteList = new Vector();
        for (n = 0; n < 32; ++n) {
            this.siteList.add(new FTPSiteData());
        }
        n = this.readDataFile();
        this.reloadList(n);
    }

    private void reloadList(int n) {
        this.siteListBox.removeAllItems();
        this.holdChange = true;
        for (int i = 0; i < this.siteList.size(); ++i) {
            this.siteListBox.addItem(i + 1 + ": " + ((FTPSiteData)this.siteList.get((int)i)).name);
        }
        this.siteListBox.setSelectedIndex(n);
        this.holdChange = false;
        this.handleListChange();
    }

    public void processTrace(String string, int n) {
        if (this.traceLevel == 0 && n > 0) {
            this.traceDisplay.append(".");
            this.traceDisplay.setCaretPosition(this.traceDisplay.getDocument().getLength() - 1);
        }
        if (n <= this.traceLevel) {
            this.traceDisplay.append(string + "\n");
            this.traceDisplay.setCaretPosition(this.traceDisplay.getDocument().getLength() - 1);
        }
    }

    private int readDataFile() {
        int n = 0;
        try {
            String string = this.main.ftpSitePath;
            File file = new File(string);
            if (file.exists()) {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string3 = bufferedReader.readLine();
                int n2 = string3.indexOf("\t");
                if (n2 != -1) {
                    n = Integer.parseInt(string3.substring(n2 + 1));
                }
                int n3 = 0;
                while (n3 < 32 && (string2 = bufferedReader.readLine()) != null) {
                    FTPSiteData fTPSiteData = new FTPSiteData(string2);
                    this.siteList.set(n3++, fTPSiteData);
                }
                bufferedReader.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public void writeDataFile() {
        this.handleListChange();
        try {
            String string = this.main.ftpSitePath;
            File file = new File(string);
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            int n = this.siteListBox.getSelectedIndex();
            bufferedWriter.write("Arachnophilia currently selected FTP site:\t" + n + ArachConstants.SYSTEM_EOL);
            for (int i = 0; i < 32; ++i) {
                FTPSiteData fTPSiteData = (FTPSiteData)this.siteList.get(i);
                if (fTPSiteData.name.equals("--") && fTPSiteData.user.length() == 0 && fTPSiteData.server.length() == 0) continue;
                String string2 = fTPSiteData.toString();
                bufferedWriter.write(fTPSiteData.toString());
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void syncLog() {
        this.scanFileSystem(false, true);
    }

    public void execute() {
        this.scanFileSystem(true, false);
    }

    public void rehearse() {
        this.scanFileSystem(false, false);
    }

    public void scanFileSystem(boolean bl, boolean bl2) {
        FTPSiteData fTPSiteData = this.handleListChange();
        if (fTPSiteData == null) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        String string = fTPSiteData.localDir;
        String string2 = fTPSiteData.remoteDir;
        String string3 = this.passwordBox.getText();
        boolean bl3 = fTPSiteData.scanSubs.length() > 0 && Character.toLowerCase(fTPSiteData.scanSubs.charAt(0)) == 'y';
        boolean bl4 = this.uploadAllCheckBox.getSelectedObjects() != null;
        this.traceDisplay.setText("");
        this.cancelOp = false;
        this.scanThread(fTPSiteData.portNumber, fTPSiteData.server, fTPSiteData.user, string3, string, string2, bl, bl3, bl4, bl2, this);
        bl2 = false;
    }

    public void scanThread(final String string, final String string2, final String string3, final String string4, final String string5, final String string6, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4, final FTPPanel fTPPanel) {
        Thread thread = new Thread(){

            @Override
            public void run() {
                try {
                    FTPUtils fTPUtils = new FTPUtils(string, string2, string3, string4, fTPPanel, FTPPanel.this.main, bl4);
                    fTPUtils.scanDirEntry(string5, string6, "", bl, bl2, bl3);
                    fTPUtils.logOut(bl);
                    int n = fTPUtils.errorFileList.size();
                    String string7 = bl ? "" : "would be ";
                    String string22 = "\nSummary of activity:\n\n" + fTPUtils.totalDirs + " subdirectories\n" + fTPUtils.totalFilesScanned + " files scanned\n" + fTPUtils.totalFilesTransferred + " files " + string7 + "transferred\n" + fTPUtils.totalBytesScanned + " bytes scanned\n" + fTPUtils.totalBytesTransferred + " bytes " + string7 + "transferred\n" + n + " file transfer errors.\n";
                    if (n > 0) {
                        string22 = string22 + "\nList of error file paths (may or may not have been transferred correctly): \n\n";
                        for (int i = 0; i < n; ++i) {
                            string22 = string22 + (String)fTPUtils.errorFileList.get(i) + "\n";
                        }
                        string22 = string22 + "\nPlease check these files for correct internal formatting.\n";
                    }
                    FTPPanel.this.processTrace(string22, 0);
                    Toolkit.getDefaultToolkit().beep();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        };
        thread.start();
    }

    public void updateProgressBar(int n, int n2, int n3, String string) {
        this.progressBar.setMinimum(n);
        this.progressBar.setMaximum(n2);
        this.progressBar.setValue(n3);
        if (n2 - n > 0) {
            int n4 = 100 * (n3 - n) / (n2 - n);
            String string2 = string + " " + n4 + "%";
            this.progressBar.setString(string2);
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.lineWrapMenuItem = new JMenuItem();
        this.jSplitPane1 = new JSplitPane();
        this.siteDataPanel = new JPanel();
        this.siteDataPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.siteListBox = new JComboBox();
        this.jLabel2 = new JLabel();
        this.siteNameBox = new JTextField();
        this.jLabel3 = new JLabel();
        this.serverNameBox = new JTextField();
        this.jLabel5 = new JLabel();
        this.userNameBox = new JTextField();
        this.jLabel6 = new JLabel();
        this.passwordBox = new JPasswordField();
        this.jLabel7 = new JLabel();
        this.remoteDirectoryBox = new JTextField();
        this.jLabel8 = new JLabel();
        this.localDirectoryBox = new JTextField();
        this.useCurrentDirButton = new MyJButton();
        this.jLabel9 = new JLabel();
        this.portNumberBox = new JTextField();
        this.jButton3 = new MyJButton();
        this.savePasswordCheckBox = new JCheckBox();
        this.searchSubsCheckBox = new JCheckBox();
        this.processTracePanel = new JPanel();
        this.processScrollPane = new JScrollPane();
        this.traceDisplay = new JTextArea();
        this.processSouth = new JPanel();
        this.progressBar = new JProgressBar();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.traceDetailSlider = new JSlider();
        this.rehearseButton = new MyJButton();
        this.execButton = new MyJButton();
        this.syncLogButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.uploadAllCheckBox = new JCheckBox();
        this.closeButton = new MyJButton();
        this.lineWrapMenuItem.setText("Line wrap");
        this.lineWrapMenuItem.setToolTipText("Wrap lines at right margin");
        this.lineWrapMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FTPPanel.this.lineWrapMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.lineWrapMenuItem);
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.siteDataPanel.setLayout(new BorderLayout());
        this.siteDataPane.setLayout(new GridBagLayout());
        this.siteDataPane.setBorder(new TitledBorder(new EtchedBorder(), "Site data"));
        this.jLabel1.setText("Select Site");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.jLabel1, gridBagConstraints);
        this.siteListBox.setToolTipText("Select an unused (--) site to make a new entry");
        this.siteListBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FTPPanel.this.siteListBoxActionPerformed(actionEvent);
            }
        });
        this.siteListBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FTPPanel.this.siteListBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.siteListBox, gridBagConstraints);
        this.jLabel2.setText("Site Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.siteNameBox, gridBagConstraints);
        this.jLabel3.setText("Server Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.jLabel3, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.serverNameBox, gridBagConstraints);
        this.jLabel5.setText("User Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.userNameBox, gridBagConstraints);
        this.jLabel6.setText("Password");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.jLabel6, gridBagConstraints);
        this.passwordBox.setText("abcdef");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.passwordBox, gridBagConstraints);
        this.jLabel7.setText("Remote Directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.jLabel7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.remoteDirectoryBox, gridBagConstraints);
        this.jLabel8.setText("Local Directory");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.jLabel8, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.localDirectoryBox, gridBagConstraints);
        this.useCurrentDirButton.setText("Use Current");
        this.useCurrentDirButton.setToolTipText("Use the directory of the current document");
        this.useCurrentDirButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FTPPanel.this.useCurrentDirButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.useCurrentDirButton, gridBagConstraints);
        this.jLabel9.setText("Port Number");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        this.siteDataPane.add((Component)this.jLabel9, gridBagConstraints);
        this.portNumberBox.setText("21");
        this.portNumberBox.setToolTipText("Standard is 21, don't change this unless you understand what it means");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.portNumberBox, gridBagConstraints);
        this.jButton3.setText("Set Default");
        this.jButton3.setToolTipText("Set the default value of 21");
        this.jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FTPPanel.this.jButton3ActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.jButton3, gridBagConstraints);
        this.savePasswordCheckBox.setText("Save password");
        this.savePasswordCheckBox.setToolTipText("Save your password in encrypted form");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.savePasswordCheckBox, gridBagConstraints);
        this.searchSubsCheckBox.setSelected(true);
        this.searchSubsCheckBox.setText("Scan subdirectories");
        this.searchSubsCheckBox.setToolTipText("Include subdirectories in the scan");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.siteDataPane.add((Component)this.searchSubsCheckBox, gridBagConstraints);
        this.siteDataPanel.add((Component)this.siteDataPane, "Center");
        this.jSplitPane1.setLeftComponent(this.siteDataPanel);
        this.processTracePanel.setLayout(new BorderLayout());
        this.processTracePanel.setBorder(new TitledBorder(new EtchedBorder(), "FTP Process"));
        this.traceDisplay.setLineWrap(true);
        this.traceDisplay.setWrapStyleWord(true);
        this.traceDisplay.setMargin(new Insets(4, 4, 4, 4));
        this.traceDisplay.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FTPPanel.this.traceDisplayMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FTPPanel.this.traceDisplayMouseReleased(mouseEvent);
            }
        });
        this.processScrollPane.setViewportView(this.traceDisplay);
        this.processTracePanel.add((Component)this.processScrollPane, "Center");
        this.processSouth.setLayout(new GridBagLayout());
        this.progressBar.setStringPainted(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.processSouth.add((Component)this.progressBar, gridBagConstraints);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel4.setHorizontalAlignment(0);
        this.jLabel4.setText("Level");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.traceDetailSlider.setMajorTickSpacing(1);
        this.traceDetailSlider.setMaximum(3);
        this.traceDetailSlider.setPaintTicks(true);
        this.traceDetailSlider.setSnapToTicks(true);
        this.traceDetailSlider.setToolTipText("Trace detail level (more or less tracing information)");
        this.traceDetailSlider.setValue(1);
        this.traceDetailSlider.setMinimumSize(new Dimension(50, 16));
        this.traceDetailSlider.setPreferredSize(new Dimension(100, 32));
        this.traceDetailSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                FTPPanel.this.traceDetailSliderStateChanged(changeEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.traceDetailSlider, gridBagConstraints);
        this.rehearseButton.setText("Rehearse");
        this.rehearseButton.setToolTipText("<html>Log onto the FTP server<br>and scan the local file system,<br>but don't transfer files</html>");
        this.rehearseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FTPPanel.this.rehearseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.rehearseButton, gridBagConstraints);
        this.execButton.setText("Execute");
        this.execButton.setToolTipText("Upload files to the FTP site");
        this.execButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FTPPanel.this.execButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.execButton, gridBagConstraints);
        this.syncLogButton.setText("SyncLog");
        this.syncLogButton.setToolTipText("Synchronize log file without uploading files");
        this.syncLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FTPPanel.this.syncLogButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.syncLogButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Cancel the current operation");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FTPPanel.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.cancelButton, gridBagConstraints);
        this.uploadAllCheckBox.setText("Upload All");
        this.uploadAllCheckBox.setToolTipText("Don't use a log file if one exists -- upload everything");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.uploadAllCheckBox, gridBagConstraints);
        this.closeButton.setText("Close");
        this.closeButton.setToolTipText("Close the FTP Service dialog");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FTPPanel.this.closeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.closeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.processSouth.add((Component)this.jPanel2, gridBagConstraints);
        this.processTracePanel.add((Component)this.processSouth, "South");
        this.jSplitPane1.setRightComponent(this.processTracePanel);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void lineWrapMenuItemActionPerformed(ActionEvent actionEvent) {
        this.toggleLineWrap();
    }

    private void traceDisplayMouseReleased(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void traceDisplayMousePressed(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void jButton3ActionPerformed(ActionEvent actionEvent) {
        this.portNumberBox.setText("21");
        this.handleListChange();
    }

    private void syncLogButtonActionPerformed(ActionEvent actionEvent) {
        this.syncLog();
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.parent.quit();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.cancelOp = true;
    }

    private void traceDetailSliderStateChanged(ChangeEvent changeEvent) {
        this.handleDetailSlider();
    }

    private void execButtonActionPerformed(ActionEvent actionEvent) {
        this.execute();
    }

    private void rehearseButtonActionPerformed(ActionEvent actionEvent) {
        this.rehearse();
    }

    private void siteListBoxActionPerformed(ActionEvent actionEvent) {
        if (!this.holdChange) {
            this.handleListChange();
        }
    }

    private void siteListBoxItemStateChanged(ItemEvent itemEvent) {
    }

    private void useCurrentDirButtonActionPerformed(ActionEvent actionEvent) {
        this.useCurrentDirectory();
    }

    private void handleMouse(MouseEvent mouseEvent) {
        if (this.popupMenu.isPopupTrigger(mouseEvent)) {
            this.popupMenu.show(this.traceDisplay, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void toggleLineWrap() {
        this.traceDisplay.setLineWrap(!this.traceDisplay.getLineWrap());
        this.traceDisplay.setWrapStyleWord(true);
    }

    private void handleDetailSlider() {
        this.traceLevel = this.traceDetailSlider.getValue();
    }

    private FTPSiteData handleListChange() {
        FTPSiteData fTPSiteData = null;
        FTPSiteData fTPSiteData2 = null;
        int n = this.siteListBox.getSelectedIndex();
        if (this.lastIndex != -1) {
            fTPSiteData = this.getDisplayedData();
            this.siteList.set(this.lastIndex, fTPSiteData);
            this.editSiteListBox(fTPSiteData.name, this.lastIndex);
        }
        if (n != -1) {
            fTPSiteData2 = (FTPSiteData)this.siteList.get(n);
            this.setDisplayedData(fTPSiteData2, n);
            this.lastIndex = n;
        }
        return fTPSiteData2;
    }

    private void setDisplayedData(FTPSiteData fTPSiteData, int n) {
        this.siteNameBox.setText(fTPSiteData.name);
        this.serverNameBox.setText(fTPSiteData.server);
        this.userNameBox.setText(fTPSiteData.user);
        this.portNumberBox.setText(fTPSiteData.portNumber);
        this.remoteDirectoryBox.setText(fTPSiteData.remoteDir);
        this.localDirectoryBox.setText(fTPSiteData.localDir);
        this.searchSubsCheckBox.setSelected(fTPSiteData.scanSubs.equals("y"));
        this.savePasswordCheckBox.setSelected(fTPSiteData.savePassword.equals("y"));
        if (this.valueForCheckBox(this.savePasswordCheckBox).equals("y")) {
            this.passwordBox.setText(this.formatString(this.intToChar(fTPSiteData.password)));
        }
        this.holdChange = true;
        this.editSiteListBox(fTPSiteData.name, n);
        this.holdChange = false;
    }

    private void editSiteListBox(String string, int n) {
        this.siteListBox.insertItemAt(n + 1 + ": " + string, n);
        this.siteListBox.removeItemAt(n + 1);
    }

    private FTPSiteData getDisplayedData() {
        FTPSiteData fTPSiteData = new FTPSiteData();
        fTPSiteData.name = this.siteNameBox.getText();
        fTPSiteData.server = this.serverNameBox.getText();
        fTPSiteData.portNumber = this.portNumberBox.getText();
        fTPSiteData.user = this.userNameBox.getText();
        fTPSiteData.remoteDir = this.remoteDirectoryBox.getText();
        fTPSiteData.localDir = this.localDirectoryBox.getText();
        fTPSiteData.scanSubs = this.valueForCheckBox(this.searchSubsCheckBox);
        fTPSiteData.savePassword = this.valueForCheckBox(this.savePasswordCheckBox);
        fTPSiteData.password = this.charToInt(this.formatString(this.passwordBox.getText()));
        return fTPSiteData;
    }

    public String valueForCheckBox(JCheckBox jCheckBox) {
        return jCheckBox.getSelectedObjects() != null ? "y" : "n";
    }

    private void useCurrentDirectory() {
        if (this.main.currentSelectedDocument != null) {
            this.localDirectoryBox.setText(this.main.currentSelectedDocument.path);
            this.handleListChange();
            this.isChanged = true;
        }
    }

    String charToInt(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            stringBuffer.append((i > 0 ? "," : "") + "" + Integer.toHexString(string.charAt(i)));
        }
        return stringBuffer.toString();
    }

    String intToChar(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        Vector vector = FTPPanel.parseDelimLine(string, ",", true);
        for (int i = 0; i < vector.size(); ++i) {
            try {
                int n = Integer.parseInt((String)vector.get(i), 16);
                stringBuffer.append((char)n);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return stringBuffer.toString();
    }

    String formatString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            int n = string.charAt(i);
            stringBuffer.append((char)(n ^= i + 63));
        }
        return stringBuffer.toString();
    }

    public static Vector parseDelimLine(String string, String string2, boolean bl) {
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = string2.length();
        while ((n = string.indexOf(string2, n2)) != -1) {
            String string3 = string.substring(n2, n);
            if (bl) {
                string3 = string3.trim();
            }
            vector.addElement(string3);
            n2 = n + n3;
        }
        if (n2 <= string.length()) {
            vector.addElement(string.substring(n2));
        }
        return vector;
    }
}

