/*
 * Decompiled with CFR 0.152.
 */
package CompilerReplyPanel;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.InputStream;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public final class ReplyPanel
extends JPanel {
    Arachnophilia main;
    Process process;
    Thread thread = null;
    boolean killThread = false;
    private JPopupMenu popupMenu;
    private JMenuItem closeMenuItem;
    private JScrollPane jScrollPane1;
    private JList replyList;

    public ReplyPanel(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.initComponents();
    }

    public void destroyThread() {
        this.killThread = true;
    }

    public void clearDataList() {
        this.replyList.setListData(new String[]{"Processing ..."});
    }

    public void processData(final Process process) {
        this.thread = new Thread(){

            @Override
            public void run() {
                ReplyPanel.this.processDataThread(process);
            }
        };
        this.thread.start();
    }

    private void processDataThread(Process process) {
        InputStream inputStream = process.getInputStream();
        InputStream inputStream2 = process.getErrorStream();
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        boolean bl = this.readData(inputStream2, vector, process);
        this.readData(inputStream, vector2, process);
        vector2.addAll(vector);
        vector2.add("Done.");
        this.replyList.setListData(vector2);
        this.updateMainLater(this);
        if (bl) {
            this.searchForFirstError(vector2);
        }
    }

    private void updateMainLater(final JPanel jPanel) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ReplyPanel.this.main.showCompilerPanel(true, jPanel);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private boolean readData(InputStream inputStream, Vector vector, Process process) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        try {
            int n;
            while (!this.killThread && (n = inputStream.read()) != -1) {
                stringBuffer.append((char)n);
            }
            String string = stringBuffer.toString();
            if (string.length() > 0) {
                bl = true;
                Vector vector2 = ArachComp.parseDelimLine(string = ArachComp.toJavaLineEndings(string), "\n");
                if (vector2 != null) {
                    vector.addAll(vector2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.closeMenuItem = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.replyList = new JList();
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.setToolTipText("Close this window");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReplyPanel.this.closeMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.closeMenuItem);
        this.setLayout(new BorderLayout());
        this.replyList.setToolTipText("Click an error line to jump to that line");
        this.replyList.setSelectionMode(0);
        this.replyList.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ReplyPanel.this.replyListMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ReplyPanel.this.replyListMouseReleased(mouseEvent);
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ReplyPanel.this.replyListMouseClicked(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.replyList);
        this.add((Component)this.jScrollPane1, "Center");
    }

    private void replyListMouseClicked(MouseEvent mouseEvent) {
        this.handleMouseClick(mouseEvent);
    }

    private void replyListMouseReleased(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void replyListMousePressed(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void closeMenuItemActionPerformed(ActionEvent actionEvent) {
        this.quit();
    }

    private void handleMouseClick(MouseEvent mouseEvent) {
        String string = (String)this.replyList.getSelectedValue();
        this.findLineNumber(string);
    }

    private void searchForFirstError(Vector vector) {
        int n = 0;
        int n2 = vector.size();
        boolean bl = false;
        while (n < n2 && !bl) {
            bl = this.findLineNumber((String)vector.get(n));
            if (bl) continue;
            ++n;
        }
        if (bl) {
            this.replyList.setSelectedIndex(n);
        }
    }

    private boolean findLineNumber(String string) {
        boolean bl = false;
        int n = string.length();
        while (n > 0) {
            int n2 = string.lastIndexOf(58, n);
            if (n2 != -1 && n2 > 0) {
                n = string.lastIndexOf(58, n2 - 1);
                if (n == -1) continue;
                try {
                    int n3 = Integer.parseInt(string.substring(n + 1, n2));
                    bl = true;
                    ArachDocument arachDocument = this.main.currentSelectedDocument;
                    if (arachDocument != null) {
                        int n4 = arachDocument.textComp.getLineCount();
                        if (--n3 >= 0 && n3 < n4) {
                            arachDocument.textComp.setCaretPosition(arachDocument.textComp.getLineStartOffset(n3));
                            arachDocument.centerCaretOnPage();
                            arachDocument.textComp.rfiw();
                        }
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                n = n2 - 1;
                continue;
            }
            n = -1;
        }
        return bl;
    }

    private void handleMouse(MouseEvent mouseEvent) {
        if (this.popupMenu.isPopupTrigger(mouseEvent)) {
            this.popupMenu.show(this.replyList, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void quit() {
        this.main.showCompilerPanel(false, this);
    }
}

