/*
 * Decompiled with CFR 0.152.
 */
package BrowserStuff;

import Arachnophilia.Arachnophilia;
import Arachnophilia.InfoDialog;
import BrowserStuff.BrowserPanel;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;

public final class BrowserDialog
extends JDialog {
    Arachnophilia main;
    BrowserPanel bp;

    public BrowserDialog(Arachnophilia arachnophilia) {
        super((Frame)arachnophilia, true);
        this.main = arachnophilia;
        this.main.haveFocus = false;
        this.setTitle("Arachnophilia 5.4 Browser Configuration");
        this.initComponents();
        this.bp = new BrowserPanel(this, arachnophilia);
        this.getContentPane().add(this.bp);
        this.pack();
        if (!this.bp.haveDefinedBrowser) {
            this.launchInfoDialog();
        }
        Rectangle rectangle = arachnophilia.getBounds();
        int n = rectangle.width / 8;
        int n2 = rectangle.height / 8;
        this.setLocation(rectangle.x + n, rectangle.y + n2);
        this.setVisible(true);
        this.repaint();
    }

    public void launchInfoDialog() {
        if (this.main.configValues.showBrowserInfo) {
            String string = "Arachnophilia needs to find your system browser.\n\nIn the dialog following this one, you will help Arachnophilia locate one or more browsers. If you are using Windows, the most likely location to search is in the \"/Program Files\" directory, so this choice will be made for you.\n\nFor other operating systems, you will need to know which directory contains the browser executable. Of course, you can always just search the entire file system, but this may take quite some time.\n\n1. Choose a directory if the default is not suitable.\n2. Press \"Search\".\n3. Press \"Transfer\" to complete the process.\n\nPress \"OK\" to move to the next dialog.";
            InfoDialog infoDialog = new InfoDialog((Frame)this.main, true, "HTML Browser configuration", string);
            this.main.configValues.showBrowserInfo = !infoDialog.dontShowAgain;
        }
    }

    private void initComponents() {
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                BrowserDialog.this.closeDialog(windowEvent);
            }
        });
        this.pack();
    }

    public void close() {
        this.main.haveFocus = true;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.close();
    }
}

