/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.TextInterface;
import java.awt.Toolkit;
import javax.swing.text.Caret;

public final class UndoRedoHandler {
    int stackSize = 0;
    int undoLevel = 0;
    int undoPtr = 0;
    int redoLevel = 0;
    int redoPtr = 0;
    StringStack undoStack;
    StringStack redoStack;

    public UndoRedoHandler(int n) {
        this.stackSize = n;
        this.undoStack = new StringStack(n);
        this.redoStack = new StringStack(n);
    }

    public void undoPush(TextInterface textInterface) {
        this.undoStack.push(textInterface);
    }

    public void undoPop(TextInterface textInterface) {
        if (this.undoStack.level > 0) {
            this.redoStack.push(textInterface);
            this.undoStack.pop(textInterface);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void redoPop(TextInterface textInterface) {
        if (this.redoStack.level > 0) {
            this.undoStack.push(textInterface);
            this.redoStack.pop(textInterface);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    class UndoData {
        String str;
        int selStart;
        int selEnd;
        int firstLine;

        UndoData(String string, int n, int n2, int n3) {
            this.str = string;
            this.selStart = n;
            this.selEnd = n2;
            this.firstLine = n3;
        }

        UndoData(TextInterface textInterface) {
            this.str = textInterface.getText();
            this.selStart = textInterface.getSelectionStart();
            this.selEnd = textInterface.getSelectionEnd();
            this.firstLine = textInterface.getFirstLine();
        }
    }

    class StringStack {
        int size;
        int pointer = 0;
        int level = 0;
        UndoData[] data;

        StringStack(int n) {
            this.size = n;
            this.data = new UndoData[n];
        }

        public void push(TextInterface textInterface) {
            if (this.size > 0) {
                UndoData undoData = new UndoData(textInterface);
                this.push(undoData);
            }
        }

        public void push(UndoData undoData) {
            if (this.size > 0) {
                this.data[this.pointer % this.size] = undoData;
                ++this.pointer;
                if (this.level < this.size) {
                    ++this.level;
                }
            }
        }

        public void pop(TextInterface textInterface) {
            UndoData undoData = this.pop();
            if (undoData != null) {
                textInterface.setText(undoData.str);
                textInterface.setSelectionStart(undoData.selStart);
                textInterface.setSelectionEnd(undoData.selEnd);
                textInterface.setFirstLine(undoData.firstLine);
                Caret caret = textInterface.getCaret();
                if (caret != null) {
                    caret.setSelectionVisible(true);
                }
            }
        }

        public UndoData pop() {
            UndoData undoData = null;
            if (this.size > 0) {
                if (this.level > 0) {
                    --this.pointer;
                    undoData = this.data[this.pointer % this.size];
                    this.data[this.pointer % this.size] = null;
                    --this.level;
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            return undoData;
        }
    }
}

