/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;

public final class PageColorSetupDialog
extends JDialog {
    Arachnophilia main;
    int[] colors;
    String[] names = new String[]{"Background", "Text", "Link", "Active Link", "Visited Link"};
    private JButton LinkButton;
    private JButton acceptButton;
    private JButton activeLinkButton;
    private JTextField activeLinkField;
    private JButton backgroundButton;
    private JTextField backgroundField;
    private JButton cancelButton;
    private JButton defaultsButton;
    private JPanel jPanel1;
    private JTextField linkField;
    private JButton textColorButton;
    private JTextField textField;
    private JButton visitedLinkButton;
    private JTextField visitedLinkField;

    public PageColorSetupDialog(Arachnophilia arachnophilia) {
        super((Frame)arachnophilia, true);
        this.setTitle("Arachnophilia 5.4 Web Page Color Selector");
        this.main = arachnophilia;
        this.initComponents();
        this.colors = new int[5];
        this.colors[0] = this.main.configValues.pageBackgroundColor;
        this.colors[1] = this.main.configValues.pageTextColor;
        this.colors[2] = this.main.configValues.pageLinkColor;
        this.colors[3] = this.main.configValues.pageActiveLinkColor;
        this.colors[4] = this.main.configValues.pageVisitedLinkColor;
        this.setupDisplay();
        this.pack();
        Rectangle rectangle = arachnophilia.getBounds();
        int n = rectangle.width / 4;
        int n2 = rectangle.height / 4;
        this.setLocation(rectangle.x + n, rectangle.y + n2);
        this.setVisible(true);
    }

    private void setupDisplay() {
        this.setColors(this.backgroundField, this.colors[0]);
        this.setColors(this.textField, this.colors[1]);
        this.setColors(this.linkField, this.colors[2]);
        this.setColors(this.activeLinkField, this.colors[3]);
        this.setColors(this.visitedLinkField, this.colors[4]);
    }

    private void setColors(JTextField jTextField, int n) {
        jTextField.setBackground(new Color(this.colors[0]));
        jTextField.setForeground(new Color(n));
    }

    private void chooseColor(int n) {
        Color color = JColorChooser.showDialog(this.main, "Choose a color for HTML Page " + this.names[n], new Color(this.colors[n]));
        if (color != null) {
            this.colors[n] = color.getRGB();
            this.setupDisplay();
        }
    }

    private void acceptChanges() {
        this.main.configValues.pageBackgroundColor = this.colors[0];
        this.main.configValues.pageTextColor = this.colors[1];
        this.main.configValues.pageLinkColor = this.colors[2];
        this.main.configValues.pageActiveLinkColor = this.colors[3];
        this.main.configValues.pageVisitedLinkColor = this.colors[4];
    }

    private void setDefaults() {
        this.colors[0] = 0xFFFFFF;
        this.colors[1] = 0;
        this.colors[2] = 255;
        this.colors[3] = 0xFF0000;
        this.colors[4] = 0x800080;
        this.setupDisplay();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.backgroundButton = new MyJButton();
        this.backgroundField = new JTextField();
        this.textColorButton = new MyJButton();
        this.textField = new JTextField();
        this.LinkButton = new MyJButton();
        this.linkField = new JTextField();
        this.activeLinkButton = new MyJButton();
        this.activeLinkField = new JTextField();
        this.visitedLinkButton = new MyJButton();
        this.visitedLinkField = new JTextField();
        this.acceptButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.defaultsButton = new MyJButton();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                PageColorSetupDialog.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.backgroundButton.setText("Page Background");
        this.backgroundButton.setToolTipText("Choose the page background color");
        this.backgroundButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageColorSetupDialog.this.backgroundButtonActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.backgroundButton, gridBagConstraints);
        this.backgroundField.setEditable(false);
        this.backgroundField.setHorizontalAlignment(0);
        this.backgroundField.setText("Background Color");
        this.backgroundField.setMargin(new Insets(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.backgroundField, gridBagConstraints);
        this.textColorButton.setText("Text Color");
        this.textColorButton.setToolTipText("Choose the text color");
        this.textColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageColorSetupDialog.this.textColorButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.textColorButton, gridBagConstraints);
        this.textField.setEditable(false);
        this.textField.setHorizontalAlignment(0);
        this.textField.setText("Text Color");
        this.textField.setMargin(new Insets(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.textField, gridBagConstraints);
        this.LinkButton.setText("Link Color");
        this.LinkButton.setToolTipText("Choose a link color");
        this.LinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageColorSetupDialog.this.LinkButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.LinkButton, gridBagConstraints);
        this.linkField.setEditable(false);
        this.linkField.setHorizontalAlignment(0);
        this.linkField.setText("Link Color");
        this.linkField.setMargin(new Insets(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.linkField, gridBagConstraints);
        this.activeLinkButton.setText("Active Link");
        this.activeLinkButton.setToolTipText("Choose an active link color");
        this.activeLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageColorSetupDialog.this.activeLinkButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.activeLinkButton, gridBagConstraints);
        this.activeLinkField.setEditable(false);
        this.activeLinkField.setHorizontalAlignment(0);
        this.activeLinkField.setText("Active Link Color");
        this.activeLinkField.setMargin(new Insets(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.activeLinkField, gridBagConstraints);
        this.visitedLinkButton.setText("Visited Link");
        this.visitedLinkButton.setToolTipText("Choose a visited link color");
        this.visitedLinkButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageColorSetupDialog.this.visitedLinkButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.visitedLinkButton, gridBagConstraints);
        this.visitedLinkField.setEditable(false);
        this.visitedLinkField.setHorizontalAlignment(0);
        this.visitedLinkField.setText("Visited Link Color");
        this.visitedLinkField.setMargin(new Insets(4, 4, 4, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.visitedLinkField, gridBagConstraints);
        this.acceptButton.setText("Accept");
        this.acceptButton.setToolTipText("Accept the choices and exit");
        this.acceptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageColorSetupDialog.this.acceptButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.acceptButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Discard the choices and exit");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageColorSetupDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.cancelButton, gridBagConstraints);
        this.defaultsButton.setText("Reset to Defaults");
        this.defaultsButton.setToolTipText("Choose standard colors");
        this.defaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PageColorSetupDialog.this.defaultsButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel1.add((Component)this.defaultsButton, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void defaultsButtonActionPerformed(ActionEvent actionEvent) {
        this.setDefaults();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    private void acceptButtonActionPerformed(ActionEvent actionEvent) {
        this.acceptChanges();
        this.close();
    }

    private void visitedLinkButtonActionPerformed(ActionEvent actionEvent) {
        this.chooseColor(4);
    }

    private void activeLinkButtonActionPerformed(ActionEvent actionEvent) {
        this.chooseColor(3);
    }

    private void LinkButtonActionPerformed(ActionEvent actionEvent) {
        this.chooseColor(2);
    }

    private void textColorButtonActionPerformed(ActionEvent actionEvent) {
        this.chooseColor(1);
    }

    private void backgroundButtonActionPerformed(ActionEvent actionEvent) {
        this.chooseColor(0);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.close();
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }
}

