/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public final class FontChooser
extends JDialog {
    public Font currentFont;
    String[] fontNames;
    int fontPoints;
    int fontStyle;
    String fontName;
    String sampleText = "Hello \u0437\u0434\u0440\u0430\u0432\u0441\u0442\u0432\u0443\u043b\u0442\u0435 \u3053\u3093\u306b\u3061\u306f";
    String[] styleNames = new String[]{"Plain", "Bold", "Italic", "Bold/Italic"};
    int[] styleConstants = new int[]{0, 1, 2, 3};
    String[] pointSizes;
    int smallest = 5;
    int largest = 128;
    boolean needInit = true;
    boolean okResult = false;
    private JPanel bottomPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton defaultButton;
    private JList fontList;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JButton okButton;
    private JComboBox pointBox;
    private JPanel samplePanel;
    private JScrollPane scrollPane;
    private JComboBox styleBox;
    private JTextField textSample;
    private JPanel topPanel;

    public FontChooser(Frame frame, boolean bl, Font font, String string) {
        super(frame, bl);
        this.setTitle(string);
        this.currentFont = font;
        if (this.currentFont == null || this.currentFont.getName() == "null") {
            System.out.println("font is null");
            this.currentFont = new Font("Monospaced", 0, 12);
        }
        this.fontPoints = this.currentFont.getSize();
        this.fontStyle = this.currentFont.getStyle();
        this.fontName = this.currentFont.getName();
        this.setupLists();
        this.initComponents();
        this.fontList.setListData(this.fontNames);
        this.setIndices();
        this.setSize(500, 400);
    }

    public boolean showDialog() {
        this.setVisible(true);
        this.showCurrent();
        return this.okResult;
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.needInit) {
            this.needInit = false;
            this.fontList.ensureIndexIsVisible(this.fontList.getSelectedIndex());
        }
    }

    private void setupLists() {
        this.fontNames = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.pointSizes = new String[this.largest - this.smallest];
        for (int i = this.smallest; i < 128; ++i) {
            this.pointSizes[i - this.smallest] = "" + i;
        }
    }

    private void setIndices() {
        int n = this.fontPoints - this.smallest;
        n = n < 0 ? 0 : n;
        n = n > this.largest - this.smallest ? this.largest - this.smallest : n;
        this.pointBox.setSelectedIndex(n);
        int n2 = 0;
        for (int i = 0; i < this.styleConstants.length; ++i) {
            if (this.fontStyle != this.styleConstants[i]) continue;
            n2 = i;
            break;
        }
        this.styleBox.setSelectedIndex(n2);
        this.fontList.setSelectedValue(this.fontName, true);
    }

    private void initComponents() {
        this.topPanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.styleBox = new JComboBox<String>(this.styleNames);
        this.jLabel2 = new JLabel();
        this.pointBox = new JComboBox<String>(this.pointSizes);
        this.scrollPane = new JScrollPane();
        this.fontList = new JList();
        this.bottomPanel = new JPanel();
        this.samplePanel = new JPanel();
        this.jLabel3 = new JLabel();
        this.textSample = new JTextField();
        this.buttonPanel = new JPanel();
        this.okButton = new JButton();
        this.defaultButton = new JButton();
        this.cancelButton = new JButton();
        this.setMinimumSize(new Dimension(350, 200));
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                FontChooser.this.closeDialog(windowEvent);
            }
        });
        this.topPanel.setPreferredSize(new Dimension(32, 32));
        this.jLabel1.setText("Style");
        this.topPanel.add(this.jLabel1);
        this.styleBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.styleBoxActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(this.styleBox);
        this.jLabel2.setText("Size");
        this.topPanel.add(this.jLabel2);
        this.pointBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.pointBoxActionPerformed(actionEvent);
            }
        });
        this.topPanel.add(this.pointBox);
        this.getContentPane().add((Component)this.topPanel, "North");
        this.fontList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                FontChooser.this.fontListValueChanged(listSelectionEvent);
            }
        });
        this.scrollPane.setViewportView(this.fontList);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.bottomPanel.setLayout(new BorderLayout());
        this.jLabel3.setText("Sample:");
        this.samplePanel.add(this.jLabel3);
        this.textSample.setHorizontalAlignment(0);
        this.textSample.setText("Hello \u0417\u0434\u0440\u0430\u0432\u0441\u0442\u0432\u0443\u0439\u0442\u0435 \u3053\u3093\u306b\u3061\u306f");
        this.textSample.setMargin(new Insets(4, 4, 4, 4));
        this.textSample.setMinimumSize(new Dimension(200, 35));
        this.textSample.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.textSampleActionPerformed(actionEvent);
            }
        });
        this.samplePanel.add(this.textSample);
        this.bottomPanel.add((Component)this.samplePanel, "North");
        this.okButton.setText("OK");
        this.okButton.setToolTipText("Use this font");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.okButton);
        this.defaultButton.setText("Default");
        this.defaultButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.defaultButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.defaultButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Do not change fonts");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.buttonPanel.add(this.cancelButton);
        this.bottomPanel.add((Component)this.buttonPanel, "South");
        this.getContentPane().add((Component)this.bottomPanel, "South");
        this.pack();
    }

    private void defaultButtonActionPerformed(ActionEvent actionEvent) {
        this.commitToFont(new Font("Monospaced", 0, 12));
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.commitToFont();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.currentFont = null;
        this.setVisible(false);
    }

    private void fontListValueChanged(ListSelectionEvent listSelectionEvent) {
        this.setNewFont();
    }

    private void pointBoxActionPerformed(ActionEvent actionEvent) {
        this.setNewFont();
    }

    private void styleBoxActionPerformed(ActionEvent actionEvent) {
        this.setNewFont();
    }

    private void setNewFont() {
        if (!this.needInit) {
            String string = (String)this.fontList.getSelectedValue();
            if (string != null) {
                this.fontName = string;
            }
            this.fontPoints = Integer.parseInt((String)this.pointBox.getSelectedItem());
            this.fontStyle = this.styleConstants[this.styleBox.getSelectedIndex()];
            this.showCurrent();
        }
    }

    private void showCurrent() {
        Font font = new Font(this.fontName, this.fontStyle, this.fontPoints);
        this.textSample.setFont(font);
        this.textSample.setText(this.sampleText);
        FontMetrics fontMetrics = this.textSample.getFontMetrics(font);
        Insets insets = this.textSample.getInsets();
        int n = fontMetrics.stringWidth(this.sampleText);
        int n2 = fontMetrics.getHeight();
        Dimension dimension = this.textSample.getSize();
        if ((n += insets.left + insets.right) > dimension.width || (n2 += insets.top + insets.bottom) > dimension.height || n < dimension.width - 128 || n2 < dimension.height - 128) {
            this.textSample.setSize(n + 16, n2 + 16);
            this.textSample.setPreferredSize(this.textSample.getSize());
            this.setSize(this.getSize().width + 1, this.getSize().height);
            this.setSize(this.getSize().width - 1, this.getSize().height);
        }
    }

    private void commitToFont() {
        this.currentFont = new Font(this.fontName, this.fontStyle, this.fontPoints);
        this.okResult = true;
        this.setVisible(false);
    }

    private void commitToFont(Font font) {
        this.currentFont = font;
        this.okResult = true;
        this.setVisible(false);
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void textSampleActionPerformed(ActionEvent actionEvent) {
    }

    public static void main(String[] stringArray) {
        FontChooser fontChooser = new FontChooser((Frame)new JFrame(), true, new Font("Monospaced", 0, 12), "Choose Font");
        boolean bl = fontChooser.showDialog();
        fontChooser.dispose();
    }
}

