/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.Arachnophilia;
import Arachnophilia.EscapeUnescapeStringHandler;
import Arachnophilia.InfoDialog;
import Arachnophilia.MacroFloatingWindow;
import Arachnophilia.MyJButton;
import Arachnophilia.RegExpWrapperClass;
import Arachnophilia.SearchReplaceStuff;
import MacroManager.MacroTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public final class FindReplacePanel
extends JPanel {
    Arachnophilia main;
    private SearchReplaceStuff searcher;
    private RegExpWrapperClass regExpWrapper;
    boolean expandedPanel = false;
    boolean lockAccess = false;
    String search;
    String replace;
    String unescSearch;
    String unescReplace;
    private JButton cancelButton;
    private JCheckBox caseSensCheckBox;
    private JButton clearButton;
    private JButton countButton;
    private JCheckBox dotMatchCheckBox;
    private JButton findFirstButton;
    public JComboBox findList;
    private JButton findNextButton;
    private JPanel frBottomPanel;
    private JPanel frTopPanel;
    private JCheckBox instantModeCheckBox;
    private JPanel jPanel2;
    private JButton moreButton;
    private JCheckBox multiLineCheckBox;
    private JCheckBox regExpCheckBox;
    private JButton replaceAllButton;
    private JButton replaceButton;
    private JButton replaceGlobalButton;
    public JComboBox replaceList;
    private JLabel resultLabel;

    public FindReplacePanel(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.initComponents();
        this.findList.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                FindReplacePanel.this.processFindListKey(keyEvent);
            }
        });
        this.replaceList.getEditor().getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FindReplacePanel.this.handleReplaceRightClick(mouseEvent, FindReplacePanel.this.replaceList);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FindReplacePanel.this.handleReplaceRightClick(mouseEvent, FindReplacePanel.this.replaceList);
            }
        });
        this.findList.getEditor().getEditorComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                FindReplacePanel.this.handleReplaceRightClick(mouseEvent, FindReplacePanel.this.findList);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                FindReplacePanel.this.handleReplaceRightClick(mouseEvent, FindReplacePanel.this.findList);
            }
        });
        this.searcher = new SearchReplaceStuff(this.main);
        this.regExpWrapper = new RegExpWrapperClass(this.main);
        this.setupCheckBoxes();
        this.setupStrings(this.main.configValues.findStrings, this.findList, this.main.configValues.findRepStringsLength);
        this.setupStrings(this.main.configValues.replaceStrings, this.replaceList, this.main.configValues.findRepStringsLength);
        this.showBottomPanel(this.main.configValues.expandedSearch);
    }

    private void setupCheckBoxes() {
        this.caseSensCheckBox.setSelected(this.main.configValues.caseSensitiveTextSearch);
        this.regExpCheckBox.setSelected(this.main.configValues.regExpTextSearch);
        this.instantModeCheckBox.setSelected(this.main.configValues.instantSearch);
        this.multiLineCheckBox.setSelected(this.main.configValues.multiLineSearch);
        this.dotMatchCheckBox.setSelected(this.main.configValues.dotMatchesNewline);
    }

    private void setupStrings(String[] stringArray, JComboBox jComboBox, int n) {
        jComboBox.setRenderer(new MyCellRenderer());
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string.length() <= 0) continue;
            jComboBox.addItem(string);
        }
    }

    public void setFindFocus() {
        this.findList.requestFocusInWindow();
    }

    public JComboBox getFindList() {
        return this.findList;
    }

    public JComboBox getReplaceList() {
        return this.replaceList;
    }

    public void saveStrings() {
        String string = this.getFindString();
        this.addStringToList(string, this.findList);
        String string2 = this.getReplaceString();
        this.addStringToList(string2, this.replaceList);
        this.saveFindRepStrings(this.main.configValues.findStrings, this.findList, this.main.configValues.findRepStringsLength);
        this.saveFindRepStrings(this.main.configValues.replaceStrings, this.replaceList, this.main.configValues.findRepStringsLength);
    }

    private void saveFindRepStrings(String[] stringArray, JComboBox jComboBox, int n) {
        int n2;
        for (n2 = 0; n2 < n && n2 < jComboBox.getItemCount(); ++n2) {
            String string;
            stringArray[n2] = string = (String)jComboBox.getItemAt(n2);
        }
        while (n2 < n) {
            stringArray[n2] = "";
            ++n2;
        }
    }

    public void addStringToList(String string, JComboBox jComboBox) {
        if (!this.lockAccess) {
            this.lockAccess = true;
            if (string.length() > 0) {
                int n = -1;
                int n2 = jComboBox.getItemCount();
                for (int i = 0; i < n2; ++i) {
                    if (!string.equals(jComboBox.getItemAt(i).toString())) continue;
                    n = i;
                    break;
                }
                if (n >= 0) {
                    jComboBox.removeItemAt(n);
                }
                if ((n2 = jComboBox.getItemCount()) > 0) {
                    jComboBox.insertItemAt(string, 0);
                } else {
                    jComboBox.addItem(string);
                }
                while (this.main.configValues.findRepStringsLength > 0 && jComboBox.getItemCount() >= this.main.configValues.findRepStringsLength) {
                    jComboBox.removeItemAt(jComboBox.getItemCount() - 1);
                }
                jComboBox.setSelectedItem(string);
            }
            this.lockAccess = false;
        }
    }

    private void initComponents() {
        this.frTopPanel = new JPanel();
        this.findList = new JComboBox();
        this.findFirstButton = new MyJButton();
        this.findNextButton = new MyJButton();
        this.replaceList = new JComboBox();
        this.replaceButton = new MyJButton();
        this.moreButton = new MyJButton();
        this.frBottomPanel = new JPanel();
        this.countButton = new MyJButton();
        this.replaceAllButton = new MyJButton();
        this.replaceGlobalButton = new MyJButton();
        this.instantModeCheckBox = new JCheckBox();
        this.caseSensCheckBox = new JCheckBox();
        this.resultLabel = new JLabel();
        this.jPanel2 = new JPanel();
        this.regExpCheckBox = new JCheckBox();
        this.multiLineCheckBox = new JCheckBox();
        this.dotMatchCheckBox = new JCheckBox();
        this.cancelButton = new MyJButton();
        this.clearButton = new MyJButton();
        this.setLayout(new BorderLayout());
        this.frTopPanel.setLayout(new GridBagLayout());
        this.findList.setEditable(true);
        this.findList.setToolTipText("Search text");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.frTopPanel.add((Component)this.findList, gridBagConstraints);
        this.findFirstButton.setText("First");
        this.findFirstButton.setToolTipText("Find first match");
        this.findFirstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.findFirstButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.frTopPanel.add((Component)this.findFirstButton, gridBagConstraints);
        this.findFirstButton.getAccessibleContext().setAccessibleDescription("Find first match");
        this.findNextButton.setText("Next");
        this.findNextButton.setToolTipText("Find next match (F3)");
        this.findNextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.findNextButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.frTopPanel.add((Component)this.findNextButton, gridBagConstraints);
        this.replaceList.setEditable(true);
        this.replaceList.setToolTipText("Replacement text");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.frTopPanel.add((Component)this.replaceList, gridBagConstraints);
        this.replaceButton.setText("Replace");
        this.replaceButton.setToolTipText("Replace one case");
        this.replaceButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.replaceButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.frTopPanel.add((Component)this.replaceButton, gridBagConstraints);
        this.moreButton.setText("Exp");
        this.moreButton.setToolTipText("Expand this panel");
        this.moreButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.moreButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.frTopPanel.add((Component)this.moreButton, gridBagConstraints);
        this.add((Component)this.frTopPanel, "Center");
        this.frBottomPanel.setLayout(new GridBagLayout());
        this.countButton.setText("Count");
        this.countButton.setToolTipText("Count cases of search string");
        this.countButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.countButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.frBottomPanel.add((Component)this.countButton, gridBagConstraints);
        this.replaceAllButton.setText("All");
        this.replaceAllButton.setToolTipText("<html>Replace all cases in selection<br>(or document if no selection)</html>");
        this.replaceAllButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.replaceAllButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.frBottomPanel.add((Component)this.replaceAllButton, gridBagConstraints);
        this.replaceGlobalButton.setText("Global");
        this.replaceGlobalButton.setToolTipText("Replace all cases in all open documents");
        this.replaceGlobalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.replaceGlobalButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.frBottomPanel.add((Component)this.replaceGlobalButton, gridBagConstraints);
        this.instantModeCheckBox.setText("Instant");
        this.instantModeCheckBox.setToolTipText("<html>Searches on each keystroke<br>(this can be risky when using regular expressions)</html>");
        this.instantModeCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.instantModeCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 7;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.frBottomPanel.add((Component)this.instantModeCheckBox, gridBagConstraints);
        this.caseSensCheckBox.setText("Case");
        this.caseSensCheckBox.setToolTipText("Make searches case-sensitive");
        this.caseSensCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.caseSensCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.frBottomPanel.add((Component)this.caseSensCheckBox, gridBagConstraints);
        this.resultLabel.setText(" ");
        this.resultLabel.setToolTipText("Result of most recent operation");
        this.resultLabel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Results"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.frBottomPanel.add((Component)this.resultLabel, gridBagConstraints);
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "RegExp functions"));
        this.jPanel2.setLayout(new GridBagLayout());
        this.regExpCheckBox.setText("RegExp");
        this.regExpCheckBox.setToolTipText("Allow regular expressions");
        this.regExpCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.regExpCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.regExpCheckBox, gridBagConstraints);
        this.multiLineCheckBox.setText("Multiline");
        this.multiLineCheckBox.setToolTipText("Treat files as one long line");
        this.multiLineCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.multiLineCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.multiLineCheckBox, gridBagConstraints);
        this.dotMatchCheckBox.setText(".=\\n");
        this.dotMatchCheckBox.setToolTipText("Dot matches newline");
        this.dotMatchCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.dotMatchCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanel2.add((Component)this.dotMatchCheckBox, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.frBottomPanel.add((Component)this.jPanel2, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("<html>Cancel current operation<br>(only works for global searches)</html>");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.frBottomPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.clearButton.setText("Clear");
        this.clearButton.setToolTipText("Clear dropdown lists");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindReplacePanel.this.clearButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.frBottomPanel.add((Component)this.clearButton, gridBagConstraints);
        this.add((Component)this.frBottomPanel, "South");
    }

    private void clearButtonActionPerformed(ActionEvent actionEvent) {
        this.clearSearchReplaceLists();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doCancel();
    }

    private void countButtonActionPerformed(ActionEvent actionEvent) {
        this.doCount(true);
    }

    private void dotMatchCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setDotNewline(((JCheckBox)actionEvent.getSource()).getSelectedObjects() != null);
    }

    private void multiLineCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setMultiLineMode(((JCheckBox)actionEvent.getSource()).getSelectedObjects() != null);
    }

    private void instantModeCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setInstantMode(((JCheckBox)actionEvent.getSource()).getSelectedObjects() != null);
    }

    private void moreButtonActionPerformed(ActionEvent actionEvent) {
        this.toggleMoreButton();
    }

    private void regExpCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setRegExp(((JCheckBox)actionEvent.getSource()).getSelectedObjects() != null);
    }

    private void caseSensCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setCaseSens(((JCheckBox)actionEvent.getSource()).getSelectedObjects() != null);
    }

    private void regExpButtonActionPerformed(ActionEvent actionEvent) {
        this.setRegExp(((JCheckBox)actionEvent.getSource()).getSelectedObjects() != null);
    }

    private void caseSensButtonActionPerformed(ActionEvent actionEvent) {
        this.setCaseSens(((JCheckBox)actionEvent.getSource()).getSelectedObjects() != null);
    }

    private void replaceGlobalButtonActionPerformed(ActionEvent actionEvent) {
        this.doGlobalReplace();
    }

    private void replaceAllButtonActionPerformed(ActionEvent actionEvent) {
        this.doAllReplace();
    }

    private void replaceButtonActionPerformed(ActionEvent actionEvent) {
        this.doReplace(true);
    }

    private void findNextButtonActionPerformed(ActionEvent actionEvent) {
        this.doNextFind(true);
    }

    private void findFirstButtonActionPerformed(ActionEvent actionEvent) {
        this.doFirstFind(true);
    }

    private void handleReplaceRightClick(MouseEvent mouseEvent, JComboBox jComboBox) {
        if (mouseEvent.isPopupTrigger()) {
            Vector vector = new Vector();
            MacroTreePanel macroTreePanel = this.main.getMacroPanel();
            if (macroTreePanel != null) {
                vector = macroTreePanel.mjt.getMacroList();
            }
            vector.addAll(this.main.comSwitchboard.getVectorList());
            Point point = ((Component)mouseEvent.getSource()).getLocationOnScreen();
            int n = point.x + mouseEvent.getX();
            int n2 = point.y + mouseEvent.getY();
            new MacroFloatingWindow(vector, new Point(n, n2), this, jComboBox);
        }
    }

    public void clearSearchReplaceLists() {
        this.findList.removeAllItems();
        this.replaceList.removeAllItems();
    }

    private void doCancel() {
        this.regExpWrapper.cancelCurrentOperation = true;
        this.searcher.cancelCurrentOperation = true;
    }

    public void processFindListKey(KeyEvent keyEvent) {
        char c;
        String string = this.main.macroKeyHandler.createCode(keyEvent);
        if (this.main.macroKeyHandler.checkDefinition(string) != null && this.main.currentSelectedDocument != null) {
            this.main.currentSelectedDocument.requestFocusInWindow();
        }
        if ((c = keyEvent.getKeyChar()) == '\n') {
            this.doNextFind(true);
        } else if (this.main.configValues.instantSearch) {
            this.doFirstFind(false);
        }
    }

    private void toggleMoreButton() {
        this.showBottomPanel(!this.expandedPanel);
    }

    private void showBottomPanel(boolean bl) {
        this.main.configValues.expandedSearch = bl;
        this.expandedPanel = bl;
        if (bl) {
            this.add((Component)this.frBottomPanel, "South");
            this.moreButton.setText("Comp");
            this.moreButton.setToolTipText("Compress this panel");
        } else {
            this.remove(this.frBottomPanel);
            this.moreButton.setText("Exp");
            this.moreButton.setToolTipText("Expand this panel");
        }
    }

    private void findListItemStateChanged(ItemEvent itemEvent) {
        this.doFirstFind(false);
    }

    public void setDotNewline(boolean bl) {
        this.main.configValues.dotMatchesNewline = bl;
        this.setupCheckBoxes();
    }

    public void setMultiLineMode(boolean bl) {
        this.main.configValues.multiLineSearch = bl;
        this.setupCheckBoxes();
    }

    public void setCaseSens(boolean bl) {
        this.main.configValues.caseSensitiveTextSearch = bl;
        this.setupCheckBoxes();
    }

    public void setInstantMode(boolean bl) {
        this.main.configValues.instantSearch = bl;
        this.setupCheckBoxes();
    }

    public void setRegExp(boolean bl) {
        this.main.configValues.regExpTextSearch = bl;
        if (bl) {
            this.setInstantMode(false);
            if (this.main.configValues.showRegexpWarning) {
                String string = "Regular Expressions are very powerful, but some seemingly innocent entries can use up all a processor's capacity and thus cause a program to lock up. It is best to practice regular expressions after saving all unsaved work, when there is little prospect of losing work if the RegExp routine should decide to take over your computer's entire, relatively small, brain.";
                InfoDialog infoDialog = new InfoDialog((Frame)this.main, true, "RegExp Launch Warning", string);
                this.main.configValues.showRegexpWarning = !infoDialog.dontShowAgain;
            }
        }
        this.setupCheckBoxes();
    }

    private void doGlobalReplace() {
        this.showBottomPanel(true);
        this.search = this.getFindString();
        String string = this.main.comSwitchboard.exec(this.search, 0);
        this.unescSearch = EscapeUnescapeStringHandler.unescapeString(string);
        this.addStringToList(this.search, this.findList);
        this.replace = this.getReplaceString();
        String string2 = this.main.comSwitchboard.exec(this.replace, 0);
        this.unescReplace = EscapeUnescapeStringHandler.unescapeString(string2);
        this.addStringToList(this.replace, this.replaceList);
        if (this.main.configValues.regExpTextSearch) {
            this.regExpWrapper.replaceGlobalThread(string, this.unescSearch, string2, this.unescReplace, this.getFlags(), this.resultLabel);
        } else {
            this.searcher.replaceGlobalThread(string, this.unescSearch, string2, this.unescReplace, this.resultLabel);
        }
    }

    public void doAllReplace() {
        this.showBottomPanel(true);
        this.search = this.getFindString();
        String string = this.main.comSwitchboard.exec(this.search, 0);
        this.unescSearch = EscapeUnescapeStringHandler.unescapeString(string);
        this.addStringToList(this.search, this.findList);
        this.replace = this.getReplaceString();
        String string2 = this.main.comSwitchboard.exec(this.replace, 0);
        this.unescReplace = EscapeUnescapeStringHandler.unescapeString(string2);
        this.addStringToList(this.replace, this.replaceList);
        if (this.main.configValues.regExpTextSearch) {
            this.regExpWrapper.replaceAllThread(this.main.currentSelectedDocument, string, this.unescReplace, this.getFlags(), this.resultLabel);
        } else {
            this.searcher.replaceAllThread(this.main.currentSelectedDocument, this.unescSearch, this.unescReplace, this.resultLabel);
        }
    }

    public int getFlags() {
        int n = 0;
        if (!this.main.configValues.caseSensitiveTextSearch) {
            n |= 2;
        }
        if (this.main.configValues.multiLineSearch) {
            n |= 8;
        }
        if (this.main.configValues.dotMatchesNewline) {
            n |= 0x20;
        }
        return n;
    }

    public void doCount(boolean bl) {
        if (this.main.currentSelectedDocument != null) {
            this.search = this.getFindString();
            String string = this.main.comSwitchboard.exec(this.search, 0);
            this.unescSearch = EscapeUnescapeStringHandler.unescapeString(string);
            if (bl) {
                this.addStringToList(this.search, this.findList);
            }
            if (this.main.configValues.regExpTextSearch) {
                this.regExpWrapper.countOccurrences(this.main.currentSelectedDocument, string, this.getFlags(), this.resultLabel);
            } else {
                this.searcher.countOccurrences(this.main.currentSelectedDocument, this.unescSearch, this.resultLabel);
            }
        }
    }

    public void doFirstFind(boolean bl) {
        this.search = this.getFindString();
        String string = this.main.comSwitchboard.exec(this.search, 0);
        this.unescSearch = EscapeUnescapeStringHandler.unescapeString(string);
        if (bl) {
            this.addStringToList(this.search, this.findList);
        }
        if (this.main.configValues.regExpTextSearch) {
            this.doFirstFindRegExp(string);
        } else {
            this.doFirstFindPlain(this.unescSearch);
        }
    }

    public void doNextFind(boolean bl) {
        this.search = this.getFindString();
        String string = this.main.comSwitchboard.exec(this.search, 0);
        this.unescSearch = EscapeUnescapeStringHandler.unescapeString(string);
        if (bl) {
            this.addStringToList(this.search, this.findList);
        }
        if (this.main.configValues.regExpTextSearch) {
            this.doNextFindRegExp(string);
        } else {
            this.doNextFindPlain(this.unescSearch);
        }
    }

    public void doReplace(boolean bl) {
        if (this.main.currentSelectedDocument != null) {
            this.search = this.getFindString();
            String string = this.main.comSwitchboard.exec(this.search, 0);
            this.unescSearch = EscapeUnescapeStringHandler.unescapeString(string);
            if (bl) {
                this.addStringToList(this.search, this.findList);
            }
            this.replace = this.getReplaceString();
            String string2 = this.main.comSwitchboard.exec(this.replace, 0);
            this.unescReplace = EscapeUnescapeStringHandler.unescapeString(string2);
            if (bl) {
                this.addStringToList(this.replace, this.replaceList);
            }
            if (this.main.configValues.regExpTextSearch) {
                this.doRegExpReplace(string, this.unescReplace);
            } else {
                this.doPlainReplace(this.unescSearch, this.unescReplace);
            }
        }
    }

    public void doFirstFindPlain(String string) {
        if (this.searcher != null && this.main.currentSelectedDocument != null && !this.searcher.lockAccess) {
            this.searcher.findFirst(this.main.currentSelectedDocument, string, this.resultLabel);
        }
    }

    public void doNextFindPlain(String string) {
        if (this.searcher != null && this.main.currentSelectedDocument != null && !this.searcher.lockAccess) {
            this.searcher.findNext(this.main.currentSelectedDocument, string, this.resultLabel);
        }
    }

    public void doFirstFindRegExp(String string) {
        if (this.regExpWrapper != null && this.main.currentSelectedDocument != null && !this.regExpWrapper.lockAccess) {
            this.regExpWrapper.findFirst(this.main.currentSelectedDocument, string, this.getFlags(), this.resultLabel);
        }
    }

    public void doNextFindRegExp(String string) {
        if (this.regExpWrapper != null && this.main.currentSelectedDocument != null && !this.regExpWrapper.lockAccess) {
            this.regExpWrapper.findNext(this.main.currentSelectedDocument, string, this.getFlags(), this.resultLabel);
        }
    }

    public void doPlainReplace(String string, String string2) {
        if (this.searcher != null && this.main.currentSelectedDocument != null && !this.searcher.lockAccess) {
            this.searcher.replaceText(string, string2, this.resultLabel);
        }
    }

    public void doRegExpReplace(String string, String string2) {
        if (this.regExpWrapper != null && this.main.currentSelectedDocument != null && !this.regExpWrapper.lockAccess) {
            this.regExpWrapper.replaceText(string, string2, this.getFlags(), this.resultLabel);
        }
    }

    public String getFindString() {
        return this.findList.getEditor().getItem().toString();
    }

    public String getReplaceString() {
        return this.replaceList.getEditor().getItem().toString();
    }

    class MyCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public MyCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(' ' + object.toString());
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }
    }
}

