/*
 * Decompiled with CFR 0.152.
 */
package StyleColorHandler;

import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJButton;
import Arachnophilia.SyntaxStyleData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class StyleColorPanel
extends JPanel {
    SyntaxStyleData data;
    String name;
    Arachnophilia main;
    private JCheckBox boldCheckBox;
    private JButton colorPatch;
    private JCheckBox italicCheckBox;
    private JLabel nameLabel;
    private JButton setColor;

    public StyleColorPanel(Arachnophilia arachnophilia, SyntaxStyleData syntaxStyleData, String string) {
        this.main = arachnophilia;
        this.data = syntaxStyleData;
        this.name = string;
        this.initComponents();
        String string2 = this.name + ":";
        while (string2.length() < 12) {
            string2 = string2 + " ";
        }
        this.nameLabel.setText(string2);
        this.resetButtonColor();
        this.italicCheckBox.setSelected(this.data.italic);
        this.boldCheckBox.setSelected(this.data.bold);
    }

    private void changeColor() {
        Color color = JColorChooser.showDialog(this.main, "Choose a color for " + this.name, new Color(this.data.color));
        if (color != null) {
            this.data.color = color.getRGB();
            this.resetButtonColor();
            this.refreshDocs();
        }
    }

    private void resetButtonColor() {
        int n = this.data.color;
        String string = Integer.toHexString(n);
        if (string.length() == 8) {
            string = string.substring(2, 8);
        }
        this.colorPatch.setText("<html><span style=\"background:#" + string + ";\">&nbsp;&nbsp;&nbsp;</span></html>");
        this.colorPatch.setBackground(new Color(this.data.color));
    }

    private void setItalic(Object object) {
        this.data.italic = ((JCheckBox)object).getSelectedObjects() != null;
        this.refreshDocs();
    }

    private void setBold(Object object) {
        this.data.bold = ((JCheckBox)object).getSelectedObjects() != null;
        this.refreshDocs();
    }

    private void refreshDocs() {
        ArachDocument[] arachDocumentArray = this.main.fileHandler.docArray();
        for (int i = 0; i < arachDocumentArray.length; ++i) {
            ArachDocument arachDocument = arachDocumentArray[i];
            if (arachDocument == null) continue;
            arachDocument.textComp.readNewColorValues();
        }
    }

    private void initComponents() {
        this.nameLabel = new JLabel();
        this.colorPatch = new JButton();
        this.setColor = new MyJButton();
        this.italicCheckBox = new JCheckBox();
        this.boldCheckBox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.nameLabel.setFont(new Font("Monospaced", 0, 14));
        this.nameLabel.setText("jLabel1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.add((Component)this.nameLabel, gridBagConstraints);
        this.colorPatch.setText("<html>&nbsp;&nbsp;&nbsp;</html>");
        this.colorPatch.setPreferredSize(new Dimension(24, 24));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.colorPatch, gridBagConstraints);
        this.setColor.setText("Choose Color");
        this.setColor.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleColorPanel.this.setColorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.setColor, gridBagConstraints);
        this.italicCheckBox.setText("Italic");
        this.italicCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleColorPanel.this.italicCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.italicCheckBox, gridBagConstraints);
        this.boldCheckBox.setText("Bold");
        this.boldCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StyleColorPanel.this.boldCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        this.add((Component)this.boldCheckBox, gridBagConstraints);
    }

    private void boldCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setBold(actionEvent.getSource());
    }

    private void italicCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.setItalic(actionEvent.getSource());
    }

    private void setColorActionPerformed(ActionEvent actionEvent) {
        this.changeColor();
    }
}

