/*
 * Decompiled with CFR 0.152.
 */
package ListTableWizards;

import Arachnophilia.ArachComp;
import Arachnophilia.Arachnophilia;
import Arachnophilia.DocContentHandler;
import Arachnophilia.MyJButton;
import ListTableWizards.TableWizData;
import ListTableWizards.TableWizardFrame;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public final class TableWizardPanel
extends JPanel {
    Arachnophilia main;
    TableWizardFrame parent;
    DocContentHandler docHandler = null;
    boolean bareTableMode = false;
    int tableRows = -1;
    int tableColumns = -1;
    Vector rowVector = null;
    String delimiter = null;
    String docContent = null;
    TableWizData wizData = null;
    final String[] delimiters = new String[]{",", "\t", ";", ":", "/", "|", ".", "+", " ", "\u0000"};
    final String[] delimText = new String[]{",", "[Tab]", ";", ":", "/", "|", ".", "+", "[Space]", "[None]"};
    private JLabel jLabel8;
    private JButton rescanButton;
    private JButton titleColorChip;
    private JCheckBox titleColorRowCheckBox;
    private JButton titleColorButton;
    private JScrollPane jScrollPane1;
    private JPanel eastpanel;
    private JButton backgroundColorButton;
    private JCheckBox centerDataCheckbox;
    private JTextField cellPaddingField;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JCheckBox colorBackgroundCheckBox;
    private JPanel scanResultPanel;
    private JLabel jLabel2;
    private JCheckBox commentMarkersCheckbox;
    private JTextArea scanResultsArea;
    private JPanel middlePanel;
    private JCheckBox titleColorColumnCheckbox;
    private JPanel colorSelectPanel;
    private JCheckBox boldFirstColumnCheckBox;
    private JLabel jLabel9;
    private JComboBox dataDelimiterComboBox;
    private JCheckBox boldFirstRowCheckBox;
    private JTextField cellSpacingField;
    private JButton createButton;
    private JTextField borderWidthField;
    private JButton undoButton;
    private JCheckBox colorBorderCheckBox;
    private JLabel jLabel7;
    private JTextField columnsField;
    private JButton borderColorButton;
    private JButton backgroundColorChip;
    private JTextField rowsField;
    private JTextField tableWidthField;
    private JButton doneButton;
    private JButton borderColorChip;
    private JLabel jLabel6;
    private JCheckBox placeHolderCheckBox;
    private JPanel bottomPanel;

    public TableWizardPanel(Arachnophilia arachnophilia, TableWizardFrame tableWizardFrame) {
        this.main = arachnophilia;
        this.parent = tableWizardFrame;
        this.initComponents();
        this.loadControls();
    }

    public void launch() {
        this.setVisible(true);
        this.analyzeDocSelection(true);
    }

    public void analyzeDocSelection(boolean bl) {
        this.docHandler = new DocContentHandler(this.main);
        boolean bl2 = false;
        boolean bl3 = false;
        this.rowVector = null;
        this.delimiter = null;
        this.docContent = this.docHandler.getContent();
        this.bareTableMode = !this.docHandler.textSelected();
        this.wizData = new TableWizData();
        this.retrieveControls(this.wizData);
        if (this.bareTableMode) {
            this.tableRows = this.readTextField(this.rowsField, 0);
            this.tableColumns = this.readTextField(this.columnsField, 0);
            this.scanResultsArea.setText("No document selection, using defaults of " + this.tableRows + " rows and " + this.tableColumns + " columns.");
        } else {
            this.rowVector = ArachComp.parseDelimLine(this.docContent, "\n", true);
            this.delimiter = this.getSelectedDelim();
            if (bl || this.delimiter == null) {
                String string = ArachComp.mergeDelimLine(this.rowVector, "\n");
                this.delimiter = this.findMostLikelyDelim(string);
                if (this.delimiter == null) {
                    Toolkit.getDefaultToolkit().beep();
                    JOptionPane.showMessageDialog(this.main, "Cannot find any delimiters. Please format\nyour text as a table, with field delimiters\nbetween fields, and try again.", "Searching for delimiters", 0);
                } else {
                    this.setDataDelimiterComboBox(this.dataDelimiterComboBox, this.delimiter);
                }
            }
            if (this.delimiter != null) {
                this.tableRows = this.rowVector.size();
                this.setTextField(this.rowsField, this.tableRows);
                this.tableColumns = this.findMaxColumns(this.rowVector, this.delimiter);
                this.setTextField(this.columnsField, this.tableColumns);
            }
            this.scanResultsArea.setText("Scanned document text, " + (bl ? "detected" : "using") + " delimiter of \"" + this.hashDelims(this.delimiter, false) + "\" and parsed table of " + this.tableRows + " rows and " + this.tableColumns + " columns.");
        }
    }

    private void executeBuild() {
        this.docHandler = new DocContentHandler(this.main);
        this.docContent = this.docHandler.getContent();
        boolean bl = this.bareTableMode = !this.docHandler.textSelected();
        if (this.bareTableMode) {
            this.docContent = "";
        }
        this.wizData = new TableWizData();
        this.retrieveControls(this.wizData);
        this.rowVector = null;
        if (!this.bareTableMode) {
            this.rowVector = ArachComp.parseDelimLine(this.docContent, "\n", true);
        }
        this.delimiter = this.getSelectedDelim();
        if (this.delimiter != null) {
            String string = this.buildTable(this.tableRows, this.tableColumns, this.rowVector, this.delimiter, this.wizData);
            if (string != null && string.length() > 0) {
                string = this.main.beautifyUtils.beautifyHTML(string, false);
                this.docHandler.setContent(string, true);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private String buildTable(int n, int n2, Vector vector, String string, TableWizData tableWizData) {
        Object object;
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = vector != null ? vector.size() : 0;
        for (int i = 0; i < n; ++i) {
            CharSequence charSequence;
            object = null;
            if (vector != null && i < n3) {
                charSequence = (String)vector.get(i);
                object = ArachComp.parseDelimLine((String)charSequence, string, true);
            }
            charSequence = new StringBuffer();
            for (int j = 0; j < n2; ++j) {
                String string2;
                String string3 = "";
                if (object != null) {
                    string3 = j < ((Vector)object).size() ? (String)((Vector)object).get(j) : "&nbsp;";
                } else if (tableWizData.placeholderData) {
                    string3 = "R" + (i + 1) + "C" + (j + 1);
                }
                string3 = string3 + "\n";
                if (tableWizData.commentMarkers) {
                    ((StringBuffer)charSequence).append("<!-- Row " + (i + 1) + " Column " + (j + 1) + " -->\n");
                }
                String string4 = string2 = tableWizData.centerData ? "align=\"center\"" : "";
                if (j == 0 && tableWizData.titlecolorFirstColumn || i == 0 && tableWizData.titlecolorFirstRow) {
                    string2 = string2 + " bgcolor=\"#" + ArachComp.colorIntToString(tableWizData.titleRowColor) + "\"";
                }
                if (j == 0 && tableWizData.boldFirstColumn || i == 0 && tableWizData.boldFirstRow) {
                    string3 = this.wrapTag("b", string3);
                }
                ((StringBuffer)charSequence).append(this.wrapTag("td", string3, string2));
            }
            stringBuffer.append(this.wrapTag("tr", ((StringBuffer)charSequence).toString()));
        }
        String string5 = "cellspacing=\"" + tableWizData.cellSpacing + "\"";
        string5 = string5 + " cellpadding=\"" + tableWizData.cellPadding + "\"";
        string5 = string5 + " border=\"" + tableWizData.borderWidth + "\"";
        if (tableWizData.tableWidth > 0) {
            string5 = string5 + " width=\"" + tableWizData.tableWidth + "%\"";
        }
        if (tableWizData.colorBackground) {
            string5 = string5 + " bgColor=\"#" + ArachComp.colorIntToString(tableWizData.backgroundColor) + "\"";
        }
        if (tableWizData.borderWidth > 0 && tableWizData.colorBorder) {
            string5 = string5 + " borderColor=\"#" + ArachComp.colorIntToString(tableWizData.borderColor) + "\"";
        }
        object = this.wrapTag("table", stringBuffer.toString(), string5);
        return object;
    }

    private String wrapTag(String string, String string2) {
        return this.wrapTag(string, string2, "");
    }

    private String wrapTag(String string, String string2, String string3) {
        if (string3.length() > 0) {
            string3 = " " + string3;
        }
        String string4 = "<" + string + string3 + ">\n" + string2 + "</" + string + ">\n";
        return string4;
    }

    private int findMaxColumns(Vector vector, String string) {
        int n = 0;
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            Vector vector2 = ArachComp.parseDelimLine((String)vector.get(i), string);
            int n3 = vector2.size();
            n = n < n3 ? n3 : n;
        }
        return n;
    }

    private String findMostLikelyDelim(String string) {
        String string2 = null;
        int n = 0;
        for (String string3 : this.delimiters) {
            int n2;
            if (string3.equals("\u0000") || n >= (n2 = this.countOccurrences(string, string3))) continue;
            string2 = string3;
            n = n2;
        }
        return string2;
    }

    private int countOccurrences(String string, String string2) {
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(string2, n2)) != -1) {
            ++n;
            n2 += string2.length();
        }
        return n;
    }

    private String getSelectedDelim() {
        String string = (String)this.dataDelimiterComboBox.getSelectedItem();
        if (string != null) {
            string = this.hashDelims(string, true);
        }
        return string;
    }

    private void setTitleColor() {
        this.setChipColor(this.titleColorChip, "table title row/column");
        this.parent.requestFocusInWindow();
    }

    private void setBackgroundColor() {
        this.setChipColor(this.backgroundColorChip, "table background");
        this.parent.requestFocusInWindow();
    }

    private void setBorderColor() {
        this.setChipColor(this.borderColorChip, "table border");
        this.parent.requestFocusInWindow();
    }

    private void setChipColor(JButton jButton, String string) {
        Color color = jButton.getBackground();
        color = JColorChooser.showDialog(this.main, "Choose a color for the " + string, color);
        if (color != null) {
            jButton.setBackground(color);
        }
    }

    public void quit() {
        TableWizData tableWizData = new TableWizData();
        this.retrieveControls(tableWizData);
        if (this.bareTableMode) {
            tableWizData.defaultColumns = this.main.configValues.tableWizData.defaultColumns;
            tableWizData.defaultRows = this.main.configValues.tableWizData.defaultRows;
        }
        this.main.configValues.tableWizData = tableWizData;
    }

    private void loadControls() {
        TableWizData tableWizData = this.main.configValues.tableWizData;
        this.setTextField(this.rowsField, tableWizData.defaultRows);
        this.setTextField(this.columnsField, tableWizData.defaultColumns);
        this.setTextField(this.tableWidthField, tableWizData.tableWidth);
        this.setTextField(this.borderWidthField, tableWizData.borderWidth);
        this.setTextField(this.cellPaddingField, tableWizData.cellPadding);
        this.setTextField(this.cellSpacingField, tableWizData.cellSpacing);
        this.setDataDelimiterComboBox(this.dataDelimiterComboBox, tableWizData.dataDelimiter);
        this.setCheckBox(this.commentMarkersCheckbox, tableWizData.commentMarkers);
        this.setCheckBox(this.centerDataCheckbox, tableWizData.centerData);
        this.setCheckBox(this.placeHolderCheckBox, tableWizData.placeholderData);
        this.setCheckBox(this.boldFirstRowCheckBox, tableWizData.boldFirstRow);
        this.setCheckBox(this.titleColorRowCheckBox, tableWizData.titlecolorFirstRow);
        this.setCheckBox(this.boldFirstColumnCheckBox, tableWizData.boldFirstColumn);
        this.setCheckBox(this.titleColorColumnCheckbox, tableWizData.titlecolorFirstColumn);
        this.setCheckBox(this.colorBackgroundCheckBox, tableWizData.colorBackground);
        this.setCheckBox(this.colorBorderCheckBox, tableWizData.colorBorder);
        this.borderColorChip.setBackground(new Color(tableWizData.borderColor));
        this.backgroundColorChip.setBackground(new Color(tableWizData.backgroundColor));
        this.titleColorChip.setBackground(new Color(tableWizData.titleRowColor));
    }

    private void retrieveControls(TableWizData tableWizData) {
        tableWizData.defaultRows = this.readTextField(this.rowsField, tableWizData.defaultRows);
        tableWizData.defaultColumns = this.readTextField(this.columnsField, tableWizData.defaultColumns);
        tableWizData.tableWidth = this.readTextField(this.tableWidthField, tableWizData.tableWidth);
        tableWizData.borderWidth = this.readTextField(this.borderWidthField, tableWizData.borderWidth);
        tableWizData.cellPadding = this.readTextField(this.cellPaddingField, tableWizData.cellPadding);
        tableWizData.cellSpacing = this.readTextField(this.cellSpacingField, tableWizData.cellSpacing);
        tableWizData.dataDelimiter = this.getDataDelimiterComboBox(this.dataDelimiterComboBox, tableWizData.dataDelimiter);
        tableWizData.commentMarkers = this.readCheckBox(this.commentMarkersCheckbox);
        tableWizData.centerData = this.readCheckBox(this.centerDataCheckbox);
        tableWizData.placeholderData = this.readCheckBox(this.placeHolderCheckBox);
        tableWizData.boldFirstRow = this.readCheckBox(this.boldFirstRowCheckBox);
        tableWizData.titlecolorFirstRow = this.readCheckBox(this.titleColorRowCheckBox);
        tableWizData.boldFirstColumn = this.readCheckBox(this.boldFirstColumnCheckBox);
        tableWizData.titlecolorFirstColumn = this.readCheckBox(this.titleColorColumnCheckbox);
        tableWizData.colorBackground = this.readCheckBox(this.colorBackgroundCheckBox);
        tableWizData.colorBorder = this.readCheckBox(this.colorBorderCheckBox);
        tableWizData.borderColor = this.borderColorChip.getBackground().getRGB();
        tableWizData.backgroundColor = this.backgroundColorChip.getBackground().getRGB();
        tableWizData.titleRowColor = this.titleColorChip.getBackground().getRGB();
    }

    private boolean readCheckBox(JCheckBox jCheckBox) {
        return jCheckBox.getSelectedObjects() != null;
    }

    private int readTextField(JTextField jTextField, int n) {
        try {
            n = Integer.parseInt(jTextField.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n;
    }

    private int readTextField(JTextField jTextField, char c) {
        String string = jTextField.getText();
        if (string.length() > 0) {
            c = string.charAt(0);
        }
        return c;
    }

    private int getDataDelimiterComboBox(JComboBox jComboBox, int n) {
        String string = (String)jComboBox.getSelectedItem();
        if (string != null && (string = this.hashDelims(string, true)) != null) {
            n = string.charAt(0);
        }
        return n;
    }

    private void setDataDelimiterComboBox(JComboBox jComboBox, int n) {
        String string = this.hashDelims("" + (char)n, false);
        if (string != null) {
            jComboBox.setSelectedItem(string);
        }
    }

    private void setDataDelimiterComboBox(JComboBox jComboBox, String string) {
        String string2 = this.hashDelims(string, false);
        if (string2 != null) {
            jComboBox.setSelectedItem(string2);
        }
    }

    private String hashDelims(String string, boolean bl) {
        string = bl ? this.hashDelimArrays(string, this.delimText, this.delimiters) : this.hashDelimArrays(string, this.delimiters, this.delimText);
        return string;
    }

    private String hashDelimArrays(String string, String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = stringArray.length;
        for (n = 0; n < n2 && !string.equals(stringArray[n]); ++n) {
        }
        string = n < n2 ? stringArray2[n] : null;
        return string;
    }

    private void setTextField(JTextField jTextField, int n) {
        jTextField.setText("" + n);
    }

    private void setTextField(JTextField jTextField, char c) {
        jTextField.setText("" + c);
    }

    private void setCheckBox(JCheckBox jCheckBox, boolean bl) {
        jCheckBox.setSelected(bl);
    }

    private void performUndo() {
        if (this.main.currentSelectedDocument != null) {
            this.main.currentSelectedDocument.undo();
        }
    }

    private void initComponents() {
        this.middlePanel = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.rowsField = new JTextField();
        this.columnsField = new JTextField();
        this.tableWidthField = new JTextField();
        this.borderWidthField = new JTextField();
        this.cellPaddingField = new JTextField();
        this.cellSpacingField = new JTextField();
        this.scanResultPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.scanResultsArea = new JTextArea();
        this.dataDelimiterComboBox = new JComboBox<String>(this.delimText);
        this.bottomPanel = new JPanel();
        this.colorSelectPanel = new JPanel();
        this.backgroundColorButton = new MyJButton();
        this.borderColorButton = new MyJButton();
        this.titleColorButton = new MyJButton();
        this.backgroundColorChip = new JButton();
        this.borderColorChip = new JButton();
        this.titleColorChip = new JButton();
        this.createButton = new MyJButton();
        this.rescanButton = new MyJButton();
        this.doneButton = new MyJButton();
        this.undoButton = new JButton();
        this.eastpanel = new JPanel();
        this.commentMarkersCheckbox = new JCheckBox();
        this.centerDataCheckbox = new JCheckBox();
        this.placeHolderCheckBox = new JCheckBox();
        this.boldFirstRowCheckBox = new JCheckBox();
        this.titleColorRowCheckBox = new JCheckBox();
        this.boldFirstColumnCheckBox = new JCheckBox();
        this.titleColorColumnCheckbox = new JCheckBox();
        this.colorBackgroundCheckBox = new JCheckBox();
        this.colorBorderCheckBox = new JCheckBox();
        this.setLayout(new BorderLayout());
        this.middlePanel.setLayout(new GridBagLayout());
        this.middlePanel.setBorder(new TitledBorder(new EtchedBorder(), "Table Characteristics"));
        this.jLabel1.setText("Rows");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 8);
        this.middlePanel.add((Component)this.jLabel1, gridBagConstraints);
        this.jLabel2.setText("Columns");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 8);
        this.middlePanel.add((Component)this.jLabel2, gridBagConstraints);
        this.jLabel3.setText("Table Width %");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 8);
        this.middlePanel.add((Component)this.jLabel3, gridBagConstraints);
        this.jLabel6.setText("Border Width Pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 8);
        this.middlePanel.add((Component)this.jLabel6, gridBagConstraints);
        this.jLabel7.setText("Cell Padding Pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 8);
        this.middlePanel.add((Component)this.jLabel7, gridBagConstraints);
        this.jLabel8.setText("Cell Spacing Pixels");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 8);
        this.middlePanel.add((Component)this.jLabel8, gridBagConstraints);
        this.jLabel9.setText("Data Delimiter");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 8);
        this.middlePanel.add((Component)this.jLabel9, gridBagConstraints);
        this.rowsField.setPreferredSize(new Dimension(40, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.middlePanel.add((Component)this.rowsField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.middlePanel.add((Component)this.columnsField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.middlePanel.add((Component)this.tableWidthField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.middlePanel.add((Component)this.borderWidthField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.middlePanel.add((Component)this.cellPaddingField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.middlePanel.add((Component)this.cellSpacingField, gridBagConstraints);
        this.scanResultPanel.setLayout(new BorderLayout());
        this.scanResultPanel.setBorder(new TitledBorder(new EtchedBorder(), "Scan Results"));
        this.jScrollPane1.setMinimumSize(new Dimension(70, 70));
        this.jScrollPane1.setPreferredSize(new Dimension(70, 70));
        this.scanResultsArea.setEditable(false);
        this.scanResultsArea.setLineWrap(true);
        this.scanResultsArea.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.scanResultsArea);
        this.scanResultPanel.add((Component)this.jScrollPane1, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.middlePanel.add((Component)this.scanResultPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.middlePanel.add((Component)this.dataDelimiterComboBox, gridBagConstraints);
        this.add((Component)this.middlePanel, "Center");
        this.bottomPanel.setLayout(new GridBagLayout());
        this.colorSelectPanel.setLayout(new GridBagLayout());
        this.colorSelectPanel.setBorder(new TitledBorder(new EtchedBorder(), "Choose Colors"));
        this.backgroundColorButton.setText("Background");
        this.backgroundColorButton.setToolTipText("Choose a color for the table's background");
        this.backgroundColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableWizardPanel.this.backgroundColorButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.colorSelectPanel.add((Component)this.backgroundColorButton, gridBagConstraints);
        this.borderColorButton.setText("Border");
        this.borderColorButton.setToolTipText("Choose a color for the table's border");
        this.borderColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableWizardPanel.this.borderColorButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.colorSelectPanel.add((Component)this.borderColorButton, gridBagConstraints);
        this.titleColorButton.setText("Title");
        this.titleColorButton.setToolTipText("Choose a color for the title regions");
        this.titleColorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableWizardPanel.this.titleColorButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 5;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.colorSelectPanel.add((Component)this.titleColorButton, gridBagConstraints);
        this.backgroundColorChip.setBackground(new Color(255, 51, 102));
        this.backgroundColorChip.setText(" ");
        this.backgroundColorChip.setToolTipText("Sample of background color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.colorSelectPanel.add((Component)this.backgroundColorChip, gridBagConstraints);
        this.borderColorChip.setBackground(new Color(255, 51, 102));
        this.borderColorChip.setText(" ");
        this.borderColorChip.setToolTipText("Sample of border color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.colorSelectPanel.add((Component)this.borderColorChip, gridBagConstraints);
        this.titleColorChip.setBackground(new Color(255, 51, 102));
        this.titleColorChip.setText(" ");
        this.titleColorChip.setToolTipText("Sample of title color");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.colorSelectPanel.add((Component)this.titleColorChip, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.bottomPanel.add((Component)this.colorSelectPanel, gridBagConstraints);
        this.createButton.setIcon(new ImageIcon(this.getClass().getResource("/Icons/NewSheet.gif")));
        this.createButton.setText("Create");
        this.createButton.setToolTipText("Create the described table, replace the document selection");
        this.createButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableWizardPanel.this.createButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)this.createButton, gridBagConstraints);
        this.rescanButton.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Options.gif")));
        this.rescanButton.setText("Rescan");
        this.rescanButton.setToolTipText("Re-evaluate the document selection using your specifications");
        this.rescanButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableWizardPanel.this.rescanButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)this.rescanButton, gridBagConstraints);
        this.doneButton.setText("Done");
        this.doneButton.setToolTipText("Close this dialog");
        this.doneButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableWizardPanel.this.doneButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)this.doneButton, gridBagConstraints);
        this.undoButton.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Undo.gif")));
        this.undoButton.setText("Undo");
        this.undoButton.setToolTipText("Undo table creation");
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TableWizardPanel.this.undoButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.bottomPanel.add((Component)this.undoButton, gridBagConstraints);
        this.add((Component)this.bottomPanel, "South");
        this.eastpanel.setLayout(new GridBagLayout());
        this.eastpanel.setBorder(new TitledBorder(new EtchedBorder(), "Options"));
        this.commentMarkersCheckbox.setText("Comment markers");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.eastpanel.add((Component)this.commentMarkersCheckbox, gridBagConstraints);
        this.centerDataCheckbox.setText("Center Data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.eastpanel.add((Component)this.centerDataCheckbox, gridBagConstraints);
        this.placeHolderCheckBox.setText("Placeholder Data");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.eastpanel.add((Component)this.placeHolderCheckBox, gridBagConstraints);
        this.boldFirstRowCheckBox.setText("Bold First Row");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.eastpanel.add((Component)this.boldFirstRowCheckBox, gridBagConstraints);
        this.titleColorRowCheckBox.setText("Titlecolor First Row");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.eastpanel.add((Component)this.titleColorRowCheckBox, gridBagConstraints);
        this.boldFirstColumnCheckBox.setText("Bold First Column");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.eastpanel.add((Component)this.boldFirstColumnCheckBox, gridBagConstraints);
        this.titleColorColumnCheckbox.setText("Titlecolor First Column");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.eastpanel.add((Component)this.titleColorColumnCheckbox, gridBagConstraints);
        this.colorBackgroundCheckBox.setText("Color Background");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.eastpanel.add((Component)this.colorBackgroundCheckBox, gridBagConstraints);
        this.colorBorderCheckBox.setText("Color Border");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.eastpanel.add((Component)this.colorBorderCheckBox, gridBagConstraints);
        this.add((Component)this.eastpanel, "East");
    }

    private void undoButtonActionPerformed(ActionEvent actionEvent) {
        this.performUndo();
    }

    private void createButtonActionPerformed(ActionEvent actionEvent) {
        this.executeBuild();
    }

    private void rescanButtonActionPerformed(ActionEvent actionEvent) {
        this.analyzeDocSelection(false);
    }

    private void titleColorButtonActionPerformed(ActionEvent actionEvent) {
        this.setTitleColor();
    }

    private void backgroundColorButtonActionPerformed(ActionEvent actionEvent) {
        this.setBackgroundColor();
    }

    private void borderColorButtonActionPerformed(ActionEvent actionEvent) {
        this.setBorderColor();
    }

    private void doneButtonActionPerformed(ActionEvent actionEvent) {
        this.parent.quit();
    }
}

