/*
 * Decompiled with CFR 0.152.
 */
package JArachTextArea;

import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJTextArea;
import Arachnophilia.TextInterface;
import JArachTextArea.TokenMarker;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DropTarget;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Element;

public final class MyPlainTextArea
extends MyJTextArea
implements TextInterface {
    Arachnophilia main;
    FontMetrics fm;
    int visibleLines;
    int viewportHeight;
    int lineHeight;
    ArachDocument theDoc;
    boolean keyCaptured = false;
    int needInit = 0;
    JScrollPane scrollPane;

    public MyPlainTextArea(Arachnophilia arachnophilia, String string, JScrollPane jScrollPane, ArachDocument arachDocument) {
        super(arachnophilia, string);
        this.main = arachnophilia;
        this.theDoc = arachDocument;
        this.scrollPane = jScrollPane;
        this.fm = this.getFontMetrics(this.getFont());
        BasicBorders.MarginBorder marginBorder = new BasicBorders.MarginBorder(){

            public Insets getBorderInsets(Component component, Insets insets) {
                return new Insets(0, 4, 0, 4);
            }
        };
        this.setBorder(marginBorder);
        this.scrollPane.setBorder(null);
        Caret caret = this.getCaret();
        if (caret != null) {
            caret.setSelectionVisible(true);
        }
        this.recalculateVisibleLines();
        this.scrollPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                MyPlainTextArea.this.recalculateVisibleLines();
                try {
                    MyPlainTextArea.this.scrollRectToVisible(MyPlainTextArea.this.modelToView(MyPlainTextArea.this.getCaretPosition()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                MyPlainTextArea.this.handlePressedKey(keyEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                MyPlainTextArea.this.handleTypedKey(keyEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                MyPlainTextArea.this.handleReleasedKey(keyEvent);
            }
        });
        this.getDocument().addDocumentListener(new DocumentHandler());
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                MyPlainTextArea.this.theDoc.testLastModifiedTime();
            }
        });
        new DropTarget(this, 3, arachDocument.main);
    }

    public void rfiw() {
        this.requestFocusInWindow();
    }

    public void readNewColorValues() {
    }

    private void handlePressedKey(KeyEvent keyEvent) {
        this.keyCaptured = false;
        if (!this.theDoc.handleLineFeed(keyEvent) && this.theDoc.main.macroKeyHandler.execute(keyEvent)) {
            keyEvent.consume();
            this.keyCaptured = true;
        }
    }

    private void handleTypedKey(KeyEvent keyEvent) {
        if (this.keyCaptured) {
            keyEvent.consume();
        }
    }

    private void handleReleasedKey(KeyEvent keyEvent) {
        if (this.keyCaptured) {
            keyEvent.consume();
        }
        this.keyCaptured = false;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.fm = this.getFontMetrics(font);
        this.recalculateVisibleLines();
    }

    public final void recalculateVisibleLines() {
        if (this.scrollPane != null) {
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            this.viewportHeight = this.scrollPane.getViewport().getSize().height;
            this.lineHeight = this.getRowHeight();
            jScrollBar.setMaximum(this.getLineCount() * this.lineHeight);
            if (this.lineHeight != 0) {
                this.visibleLines = this.viewportHeight / this.lineHeight;
                if (this.visibleLines != 0) {
                    jScrollBar.setVisibleAmount(this.visibleLines * this.lineHeight);
                }
            }
        }
    }

    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.addRenderingHints(this.main.renderHints);
        super.paint(graphics2D);
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.needInit < 2) {
            this.centerCaretInView();
            ++this.needInit;
            this.repaint();
        }
        this.theDoc.computeStatusString();
    }

    public String getText(int n, int n2) {
        String string = "";
        try {
            string = this.getDocument().getText(n, n2);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
        return string;
    }

    public void select(int n, int n2) {
        if (this.theDoc != null && this.theDoc.centerCaret) {
            this.centerCaretInView(n);
            this.theDoc.centerCaret = false;
        }
        super.select(n, n2);
    }

    public int getLength() {
        return this.getDocument().getLength();
    }

    public final int getVisibleLines() {
        return this.visibleLines;
    }

    public final int getLineCount() {
        return this.getDocument().getDefaultRootElement().getElementCount();
    }

    public int getFirstLine() {
        if (this.lineHeight != 0) {
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            return this.scrollPane.getVerticalScrollBar().getValue() / this.lineHeight;
        }
        return 0;
    }

    public void centerCaretInView() {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        if (this.lineHeight == 0) {
            this.recalculateVisibleLines();
        }
        JScrollBar jScrollBar2 = this.scrollPane.getHorizontalScrollBar();
        try {
            int n = this.getCaretPosition();
            Rectangle rectangle = this.modelToView(n);
            Dimension dimension = this.scrollPane.getViewport().getSize();
            if (rectangle != null && dimension != null) {
                jScrollBar.setValue(rectangle.y - dimension.height / 2);
                if (this.getLineWrap()) {
                    jScrollBar2.setValue(0);
                } else {
                    jScrollBar2.setValue(rectangle.x - dimension.width / 2);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void centerCaretInView(int n) {
        if (this.scrollPane != null) {
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            if (this.lineHeight == 0) {
                this.recalculateVisibleLines();
            }
            JScrollBar jScrollBar2 = this.scrollPane.getHorizontalScrollBar();
            try {
                Rectangle rectangle = this.modelToView(n);
                Dimension dimension = this.scrollPane.getViewport().getSize();
                if (rectangle != null && dimension != null) {
                    jScrollBar.setValue(rectangle.y - dimension.height / 2);
                    if (this.getLineWrap()) {
                        jScrollBar2.setValue(0);
                    } else {
                        jScrollBar2.setValue(rectangle.x - dimension.width / 2);
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setFirstLine(int n) {
        JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
        jScrollBar.setMaximum(this.getLineCount() * this.lineHeight);
        jScrollBar.setValue(n * this.lineHeight);
    }

    public final int getDocumentLength() {
        return this.getDocument().getLength();
    }

    public void centerEditPos() {
        try {
            Rectangle rectangle = this.modelToView(this.getCaretPosition());
            if (rectangle != null) {
                int n = rectangle.y - this.viewportHeight / 2;
                n = n < 0 ? 0 : n;
                this.scrollPane.getVerticalScrollBar().setValue(n);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public final int getLineOfOffset(int n) {
        return this.getDocument().getDefaultRootElement().getElementIndex(n);
    }

    public final int getCaretLine() {
        return this.getLineOfOffset(this.getCaretPosition());
    }

    public final int getLineStartOffset(int n) {
        int n2 = -1;
        try {
            n2 = super.getLineStartOffset(n);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n2;
    }

    public void addMouseListener(MouseAdapter mouseAdapter) {
        super.addMouseListener(mouseAdapter);
    }

    public void setRightClickPopup(JPopupMenu jPopupMenu) {
    }

    public void setTokenMarker(TokenMarker tokenMarker) {
    }

    public int getLineLength(int n) {
        Element element = this.getDocument().getDefaultRootElement().getElement(n);
        if (element == null) {
            return -1;
        }
        return element.getEndOffset() - element.getStartOffset() - 1;
    }

    protected void documentChanged(DocumentEvent documentEvent) {
        if (!this.theDoc.suppressFirst) {
            boolean bl = this.theDoc.docChanged;
            this.theDoc.docChanged = true;
            if (!bl) {
                this.theDoc.updateTitle();
            }
        }
    }

    public int viewToModel(Point point) {
        return super.viewToModel(point);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String string) {
        try {
            this.getDocument().remove(0, this.getDocument().getLength());
            this.getDocument().insertString(0, string, null);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }

    public void replaceSelection(String string) {
        super.replaceSelection(string);
    }

    public String getLineText(int n) {
        String string = "";
        try {
            int n2 = this.getLineStartOffset(n);
            int n3 = this.getLineEndOffset(n);
            string = this.getText(n2, n3 - n2 - 1);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    class DocumentHandler
    implements DocumentListener {
        DocumentHandler() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            MyPlainTextArea.this.documentChanged(documentEvent);
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            MyPlainTextArea.this.documentChanged(documentEvent);
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            MyPlainTextArea.this.documentChanged(documentEvent);
        }
    }
}

