/*
 * Decompiled with CFR 0.152.
 */
package FTPService;

import Arachnophilia.ArachConstants;
import Arachnophilia.Arachnophilia;
import Arachnophilia.SearchReplace;
import FTPService.FTPPanel;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class FTPUtils {
    Arachnophilia main;
    public static int portNumber = 21;
    private Socket comSocket;
    private Socket dataSocket = null;
    private BufferedReader bReader;
    private PrintWriter pWriter;
    boolean waitForReply = false;
    boolean uploadAll = false;
    boolean syncLog = false;
    private Hashtable fileTable;
    String server;
    String currentDirectory = "";
    private String user;
    private String password;
    FTPPanel panel;
    int totalFilesScanned;
    int totalFilesTransferred;
    int totalBytesScanned;
    int totalBytesTransferred;
    int totalDirs;
    Vector errorFileList;
    String currentFile = "";

    public FTPUtils(String string, String string2, String string3, String string4, FTPPanel fTPPanel, Arachnophilia arachnophilia, boolean bl) {
        this.syncLog = bl;
        this.errorFileList = new Vector();
        this.panel = fTPPanel;
        this.main = arachnophilia;
        this.user = string3;
        this.password = string4;
        this.server = string2;
        try {
            portNumber = Integer.parseInt(string);
        }
        catch (Exception exception) {
            portNumber = 21;
        }
        if (!bl) {
            this.initializeConnection();
        }
    }

    private void initializeConnection() {
        try {
            this.panel.processTrace("* Establishing connection with " + this.server, 1);
            this.connect(this.server);
            this.login(this.user, this.password);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private void connect(String string) throws IOException {
        this.comSocket = new Socket(string, portNumber);
        InputStream inputStream = this.comSocket.getInputStream();
        this.bReader = new BufferedReader(new InputStreamReader(inputStream));
        OutputStream outputStream = this.comSocket.getOutputStream();
        this.pWriter = new PrintWriter(outputStream, true);
        String string2 = this.sendCommand("", "220");
        if (string2 != null && string2.length() > 0) {
            this.panel.processTrace("Connected to FTP server " + string, 2);
        } else {
            this.panel.processTrace("Error connecting to FTP server " + string, 2);
        }
    }

    private void login(String string, String string2) throws IOException {
        this.sendCommand("USER " + string, "");
        this.sendCommand("PASS " + string2, "230");
        this.currentDirectory = "???";
    }

    private boolean changeDir(String string) throws IOException {
        boolean bl = true;
        if (!string.equals(this.currentDirectory)) {
            bl = this.sendCommand("CWD " + string, "").length() > 0;
            this.panel.processTrace("CWD " + string + " " + (bl ? "successful" : "failed"), 3);
            if (bl) {
                this.currentDirectory = string;
            }
        }
        return bl;
    }

    private String getList(String string) throws IOException {
        if (this.sendCommand("LIST " + string, "").length() > 0) {
            return this.getDataAsString();
        }
        return null;
    }

    private boolean fileExists(String string) throws IOException {
        return this.getList(string) != null;
    }

    private String getDataAsString() throws IOException {
        this.dataSocket = this.getDataSocket();
        InputStream inputStream = this.dataSocket.getInputStream();
        String string = this.getAsString(inputStream);
        inputStream.close();
        this.dataSocket.close();
        return string;
    }

    private byte[] getDataAsByteArray() throws IOException {
        this.dataSocket = this.getDataSocket();
        InputStream inputStream = this.dataSocket.getInputStream();
        byte[] byArray = this.getAsByteArray(inputStream);
        inputStream.close();
        this.dataSocket.close();
        return byArray;
    }

    private boolean makeDir(String string, boolean bl) throws IOException {
        boolean bl2 = this.sendCommand("MKD " + string, "").length() > 0;
        this.panel.processTrace("MKD " + string + " " + (bl2 | bl ? "successful" : "failed"), 3);
        return bl2;
    }

    private void changeMakeDir(String string) throws IOException {
        if (!this.changeDir(string)) {
            int n = 0;
            while ((n = string.indexOf("/", n)) != -1) {
                String string2 = string.substring(0, n);
                if (string2.length() > 1) {
                    this.makeDir(string2, true);
                }
                ++n;
            }
            this.makeDir(string, true);
        }
        this.changeDir(string);
    }

    private void setTransferType(boolean bl) throws IOException {
        String string = bl ? "A" : "I";
        this.sendCommand("TYPE " + string, "200");
    }

    public boolean createDirUploadFile(String string, String string2, String string3, String string4, boolean bl) throws IOException {
        String string5 = this.smartDelim(string2, string3);
        this.panel.processTrace("Processing " + string5 + "/" + string4, 2);
        this.changeMakeDir(string5);
        byte[] byArray = this.readLocalFile(string, string3, string4, bl);
        boolean bl2 = false;
        boolean bl3 = false;
        while (!bl2) {
            if (bl3) {
                this.panel.processTrace("Error: must reinitialize.", 3);
                this.initializeConnection();
                this.changeMakeDir(string5);
                bl3 = false;
            }
            try {
                this.uploadByteArray(string4, byArray, bl);
                bl2 = true;
            }
            catch (Exception exception) {
                this.panel.processTrace("*** error in createDirUploadFile: " + exception.getMessage(), 3);
                bl3 = true;
            }
        }
        return bl2;
    }

    public void uploadByteArray(String string, byte[] byArray, boolean bl) throws IOException {
        this.setTransferType(bl);
        this.dataSocket = this.getDataSocket();
        OutputStream outputStream = this.dataSocket.getOutputStream();
        this.sendCommand("STOR " + string, "");
        int n = byArray.length;
        int n2 = 0;
        int n3 = 2048;
        while (n2 < n) {
            int n4 = n3;
            if (n4 > n - n2) {
                n4 = n - n2;
            }
            outputStream.write(byArray, n2, n4);
            outputStream.flush();
            this.panel.updateProgressBar(0, n, n2 += n4, string);
        }
        outputStream.close();
        this.dataSocket.close();
        this.sendCommand("", "226");
        this.panel.updateProgressBar(0, n, 0, "");
    }

    public byte[] readLocalFile(String string, String string2, String string3, boolean bl) {
        byte[] byArray = null;
        ByteArrayOutputStream byteArrayOutputStream = null;
        int n = 8192;
        File file = new File(string + "/" + string2 + "/" + string3);
        try {
            int n2;
            FileInputStream fileInputStream = new FileInputStream(file);
            byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[n];
            while ((n2 = fileInputStream.read(byArray2, 0, n)) != -1) {
                byteArrayOutputStream.write(byArray2, 0, n2);
            }
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    private void loadHashTable(String string) {
        String string2 = this.smartDelim(string, ".ArachnophiliaFTPUploadFileList.log");
        File file = new File(string2);
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while ((string3 = bufferedReader.readLine()) != null) {
                int n = string3.indexOf(";");
                if (n != -1 || (n = string3.indexOf("\t")) == -1) continue;
                String string4 = string3.substring(0, n).trim();
                String string5 = string3.substring(n + 1).trim();
                long l = Long.parseLong(string5, 16);
                this.fileTable.put(string4, new Long(l));
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void saveHashTable(String string) {
        String string2 = this.smartDelim(string, ".ArachnophiliaFTPUploadFileList.log");
        File file = new File(string2);
        try {
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            String string3 = ";\n; Arachnophilia FTP Service Log File -- " + new Date() + "\n" + ";\n" + "; This file contains the most recent modification times\n" + "; for the files in this direcory and its subdirectories.\n" + ";\n" + "; This information is used by the Arachnophilia FTP Service\n" + "; to synchronize these file with your Web site without uploading\n" + "; files unnecessarily.\n" + ";\n" + "; If you delete this file, the next FTP update will upload\n" + "; all files and recreate this file.\n" + ";\n";
            string3 = new SearchReplace().srchRplc(string3, "\n", ArachConstants.SYSTEM_EOL);
            bufferedWriter.write(string3);
            Enumeration enumeration = this.fileTable.keys();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = string4 + "\t" + Long.toString((Long)this.fileTable.get(string4), 16);
                bufferedWriter.write(string5 + ArachConstants.SYSTEM_EOL);
            }
            bufferedWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void fileTablePut(File file) {
        this.fileTable.put(file.getPath(), new Long(file.lastModified()));
    }

    private boolean isFileNewer(File file) {
        if (this.uploadAll) {
            return true;
        }
        Long l = (Long)this.fileTable.get(file.getPath());
        if (l != null) {
            return l < file.lastModified();
        }
        return true;
    }

    public void scanDirEntry(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.totalDirs = 0;
        this.totalFilesScanned = 0;
        this.totalFilesTransferred = 0;
        this.totalBytesScanned = 0;
        this.totalBytesTransferred = 0;
        this.errorFileList = new Vector();
        this.uploadAll = bl3;
        this.fileTable = new Hashtable();
        if (!bl3) {
            this.loadHashTable(string);
        }
        this.scanDir(string, string2, string3, bl, bl2, this.syncLog);
        if (this.panel.cancelOp) {
            this.panel.processTrace("*** Operation cancelled.", 0);
        } else if (bl || this.syncLog) {
            this.saveHashTable(string);
        }
    }

    public void scanDir(String string, String string2, String string3, boolean bl, boolean bl2, boolean bl3) throws IOException {
        String string4 = this.smartDelim(string, string3);
        this.panel.processTrace("Scanning directory: " + string4, 1);
        File file = new File(string4);
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length && !this.panel.cancelOp; ++i) {
                File file2 = fileArray[i];
                String string5 = file2.getName();
                if (string5.equals(".ArachnophiliaFTPUploadFileList.log")) continue;
                if (string5.indexOf("~ArachBrowserTemp") != -1) continue;
                if (file2.isDirectory()) {
                    ++this.totalDirs;
                    if (!bl2) continue;
                    this.scanDir(string, string2, this.smartDelim(string3, string5), bl, bl2, bl3);
                    continue;
                }
                ++this.totalFilesScanned;
                this.totalBytesScanned = (int)((long)this.totalBytesScanned + file2.length());
                String string6 = this.smartDelim(string2, string3);
                string6 = this.smartDelim(string6, string5);
                String string7 = file2.getPath();
                if (this.isFileNewer(file2)) {
                    if (bl) {
                        this.panel.processTrace("* Uploading " + string7, 1);
                        boolean bl4 = this.main.fileTypes.isTextFile(string5);
                        this.currentFile = string7;
                        if (!this.createDirUploadFile(string, string2, string3, string5, bl4)) continue;
                        ++this.totalFilesTransferred;
                        this.totalBytesTransferred = (int)((long)this.totalBytesTransferred + file2.length());
                        this.fileTablePut(file2);
                        continue;
                    }
                    if (bl3) {
                        this.fileTablePut(file2);
                    }
                    ++this.totalFilesTransferred;
                    this.totalBytesTransferred = (int)((long)this.totalBytesTransferred + file2.length());
                    this.panel.processTrace("Would upload " + string7, 1);
                    continue;
                }
                this.panel.processTrace("Scanning " + string7, 1);
            }
        } else {
            this.panel.processTrace("Error: null directory list for " + file.getPath(), 3);
        }
    }

    private String smartDelim(String string, String string2) {
        int n = 0;
        if (string.length() > 0 && string.charAt(string.length() - 1) == '/') {
            ++n;
        }
        if (string2.length() > 0 && string2.charAt(0) == '/') {
            ++n;
        }
        if (n == 1) {
            return string + string2;
        }
        if (n == 0) {
            return string + "/" + string2;
        }
        return string + string2.substring(1);
    }

    public void logOut(boolean bl) {
        if (bl && !this.syncLog) {
            try {
                this.panel.processTrace("* Closing connection with " + this.server, 1);
                this.pWriter.print("BYE\r\n");
                this.pWriter.flush();
                this.pWriter.close();
                this.bReader.close();
                this.comSocket.close();
                if (this.dataSocket != null) {
                    this.dataSocket.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private String sendCommand(String string, String string2) throws IOException {
        char c;
        String string3;
        if (string.length() > 0) {
            string3 = string;
            if (string3.indexOf("PASS ") != -1) {
                string3 = "PASS *******************";
            }
            this.panel.processTrace("> Local command: " + string3, 3);
        }
        if (string.length() > 0) {
            this.pWriter.print(string.trim() + "\r\n");
            this.pWriter.flush();
        }
        string3 = "";
        String string4 = "";
        boolean bl = false;
        boolean bl2 = false;
        do {
            string4 = this.bReader.readLine().trim();
            this.panel.processTrace("< Server reply: " + string4, 3);
            if (string4 == null || string4.length() <= 4) continue;
            string3 = string4.substring(0, 3);
            bl = string4.charAt(3) == '-';
            c = (char)(Character.isDigit(string4.charAt(0)) ? 1 : 0);
            if (!bl && c != '\u0000') continue;
            bl2 = true;
        } while (string2.length() > 0 && (!string3.equals(string2) || bl));
        if (string4 != null && string4.length() > 0 && ((c = string4.charAt(0)) == '4' || c == '5')) {
            string4 = "";
        }
        if (bl2) {
            this.errorFileList.add(this.currentFile);
            this.panel.processTrace("*** Probable format error in file " + this.currentFile, 2);
        }
        return string4;
    }

    private String getAsString(InputStream inputStream) {
        boolean bl = false;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 8192;
        byte[] byArray = new byte[n];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
                stringBuffer.append(new String(byArray, 0, n2));
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return stringBuffer.toString();
    }

    private byte[] getAsByteArray(InputStream inputStream) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 8192;
        byte[] byArray = new byte[n];
        try {
            int n2;
            while ((n2 = inputStream.read(byArray, 0, n)) != -1) {
                byteArrayOutputStream.write(byArray, 0, n2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public Socket getDataSocket() throws IOException {
        String string = this.sendCommand("PASV", "227");
        int n = string.indexOf(",");
        if (n != -1) {
            int n2;
            while (this.isValidAddressChar(string, n)) {
                --n;
            }
            Integer[] integerArray = this.scanAddressPort(string, n + 1);
            if (integerArray.length != 6) {
                this.panel.processTrace("Malformed server reply to PASV: \"" + string + "\"", 3);
            }
            String string2 = "";
            for (n2 = 0; n2 < 4; ++n2) {
                string2 = string2 + (n2 > 0 ? "." : "") + integerArray[n2];
            }
            n2 = (integerArray[4] << 8) + integerArray[5];
            this.dataSocket = new Socket(string2, n2);
        }
        this.panel.processTrace("socket params: " + this.dataSocket, 3);
        return this.dataSocket;
    }

    private boolean isValidAddressChar(String string, int n) {
        if (n >= 0 && n < string.length()) {
            char c = string.charAt(n);
            return Character.isDigit(c) || c == ',';
        }
        return false;
    }

    private Integer[] scanAddressPort(String string, int n) {
        Vector<Integer> vector = new Vector<Integer>();
        boolean bl = false;
        int n2 = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (Character.isDigit(c)) {
                if (!bl) {
                    n2 = 0;
                    bl = true;
                }
                n2 = n2 * 10 + (c - 48);
            } else {
                if (bl) {
                    vector.add(new Integer(n2));
                }
                bl = false;
            }
            if (!Character.isDigit(c) && c != ',') break;
            ++n;
        }
        if (bl) {
            vector.add(new Integer(n2));
        }
        return vector.toArray(new Integer[0]);
    }
}

