/*
 * Decompiled with CFR 0.152.
 */
package BrowserStuff;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachConstants;
import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJButton;
import BrowserStuff.BrowserData;
import BrowserStuff.BrowserDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.HashSet;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ListModel;

public final class BrowserPanel
extends JPanel {
    Arachnophilia main;
    BrowserDialog browserDialog;
    String namesPath;
    boolean threadExists = false;
    boolean stopSearching = false;
    boolean suppressDisplayChanges = false;
    public boolean haveDefinedBrowser = false;
    int statusCounter = 0;
    int statusInterval = 0;
    int foundCount = 0;
    int lastSelectedIndex = -1;
    Vector listVector;
    BrowserData[] browserArray;
    private JButton acceptButton;
    private JButton acceptSearchButton;
    private JCheckBox ajdpCheckBox;
    private JPanel appListPanel;
    private JTextField appPath;
    private JPanel bottomPane;
    private JButton browseButton;
    private JComboBox browserList;
    private JTextField browserName;
    private JButton cancelButton;
    private JCheckBox cboCheckBox;
    private JButton deleteButton;
    private JTextArea executableNames;
    private JPanel gimmickPanel;
    private JTextField htmlLaunchArgTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSplitPane jSplitPane1;
    private JButton makeActiveButton;
    private JTextField phpLaunchArgTextField;
    private JList resultList;
    private JPanel resultListPanel;
    private JButton startButton;
    private JTextField startPath;
    private JLabel startPathLabel;
    private JLabel statusLabel;
    private JButton stopButton;
    private JPanel topPanel;

    public BrowserPanel(BrowserDialog browserDialog, Arachnophilia arachnophilia) {
        this.browserDialog = browserDialog;
        this.main = arachnophilia;
        this.initComponents();
        this.listVector = new Vector();
        this.browserArray = new BrowserData[this.main.configValues.browserListSize];
        int n = this.loadBrowserList();
        this.haveDefinedBrowser = n > 0;
        this.listToDisplay();
        int n2 = this.main.configValues.selectedBrowser;
        if (n2 >= 0 && n2 < this.browserList.getItemCount()) {
            this.browserList.setSelectedIndex(n2);
        }
        this.handleListChange();
        this.listVector.add("Browsers Located:");
        this.resultList.setListData(this.listVector);
        this.namesPath = this.main.basePath + ArachConstants.SYSTEM_FILESEP + "ArachConf" + ArachConstants.SYSTEM_FILESEP + "BrowserExecutableNames.txt";
        String string = ArachComp.readProgramFile(this.namesPath, true);
        if (string != null) {
            this.executableNames.setText(string);
            this.executableNames.setCaretPosition(0);
            if (!this.haveDefinedBrowser) {
                File file = new File("/Program Files");
                this.main.configValues.browserSearchStartPath = file.exists() ? file.getPath() : ((file = new File("/Applications")).exists() ? file.getPath() : ((file = new File("/usr/bin")).exists() ? file.getPath() : "/"));
            }
            this.startPath.setText(this.main.configValues.browserSearchStartPath);
        }
    }

    private int loadBrowserList() {
        int n;
        int n2 = 0;
        for (n = 0; n < this.browserArray.length; ++n) {
            BrowserData browserData = new BrowserData(this.main.configValues.browserList[n]);
            if (browserData.appPath.equals("") && browserData.name.equals("--")) continue;
            this.browserArray[n2++] = browserData;
        }
        n = n2;
        while (n2 < this.browserArray.length) {
            this.browserArray[n2++] = new BrowserData();
        }
        return n;
    }

    private void saveBrowserList() {
        for (int i = 0; i < this.browserArray.length; ++i) {
            this.main.configValues.browserList[i] = this.browserArray[i].toString();
        }
    }

    private void debugList() {
        for (int i = 0; i < this.browserArray.length; ++i) {
        }
    }

    private void deleteListItem() {
        this.handleListChange();
        this.debugList();
        int n = this.lastSelectedIndex;
        if (n != -1 && n < this.browserArray.length) {
            this.suppressDisplayChanges = true;
            for (int i = n; i < this.browserArray.length - 1; ++i) {
                this.browserArray[i] = BrowserData.clone(this.browserArray[i + 1]);
            }
            this.browserArray[this.browserArray.length - 1] = new BrowserData();
        }
        this.debugList();
        this.arrayToDisplay(n);
        this.listToDisplay();
        this.suppressDisplayChanges = false;
        this.browserList.setSelectedIndex(n);
    }

    private void acceptClose() {
        ArachComp.writeProgramFile(this.namesPath, this.executableNames.getText(), false);
        this.handleListChange();
        if (this.browserArray[0].name.equals("--")) {
            this.acceptSearchResults(true);
            this.handleListChange();
        } else {
            this.saveBrowserList();
            this.browserDialog.close();
        }
    }

    private void doCancel() {
        this.browserDialog.close();
    }

    private void selectBrowser() {
        this.handleListChange();
        if (this.lastSelectedIndex != -1) {
            int n;
            this.main.configValues.selectedBrowser = n = this.lastSelectedIndex;
            this.listToDisplay();
            this.browserList.setSelectedIndex(n);
        }
    }

    private void handleListChange() {
        if (!this.suppressDisplayChanges) {
            int n = this.browserList.getSelectedIndex();
            if (this.lastSelectedIndex != -1) {
                this.displayToArray(this.lastSelectedIndex);
            }
            if (n != -1) {
                this.arrayToDisplay(n);
                this.lastSelectedIndex = n;
            }
        }
    }

    private void displayToArray(int n) {
        this.browserArray[n] = new BrowserData(this.browserName.getText(), this.appPath.getText(), this.htmlLaunchArgTextField.getText(), this.phpLaunchArgTextField.getText(), this.cboCheckBox.getSelectedObjects() != null, this.ajdpCheckBox.getSelectedObjects() != null);
        this.browserList.insertItemAt(this.makePrefix(n) + this.browserName.getText(), n);
        this.browserList.removeItemAt(n + 1);
    }

    private void arrayToDisplay(int n) {
        this.browserName.setText(this.browserArray[n].name);
        this.appPath.setText(this.browserArray[n].appPath);
        this.htmlLaunchArgTextField.setText(this.browserArray[n].htmlLaunchArgument);
        this.phpLaunchArgTextField.setText(this.browserArray[n].phpLaunchArgument);
        this.cboCheckBox.setSelected(this.browserArray[n].closeBeforeOpening);
        this.ajdpCheckBox.setSelected(this.browserArray[n].alwaysJumpToDocPos);
        this.browserList.insertItemAt(this.makePrefix(n) + this.browserName.getText(), n);
        this.browserList.removeItemAt(n + 1);
    }

    private String makePrefix(int n) {
        String string = this.main.configValues.selectedBrowser == n ? "*" : " ";
        return n + ":" + string;
    }

    private void listToDisplay() {
        this.suppressDisplayChanges = true;
        this.browserList.removeAllItems();
        for (int i = 0; i < this.browserArray.length; ++i) {
            this.browserList.addItem(this.makePrefix(i) + this.browserArray[i].name);
        }
        this.suppressDisplayChanges = false;
    }

    private void addPathToList(String string) {
        if (string.length() > 0 && !this.listVector.contains(string)) {
            ++this.foundCount;
            this.listVector.add(string);
        }
        this.resultList.setListData(this.listVector);
    }

    private void startSearch(boolean bl) {
        if (this.threadExists) {
            Toolkit.getDefaultToolkit().beep();
        } else {
            String string;
            this.stopSearching = false;
            this.foundCount = 0;
            ArachComp.writeProgramFile(this.namesPath, this.executableNames.getText(), false);
            this.main.configValues.browserSearchStartPath = string = this.startPath.getText();
            String string2 = this.executableNames.getText();
            Vector vector = ArachComp.parseDelimLine(string2, "\n");
            HashSet<String> hashSet = new HashSet<String>();
            for (int i = 0; i < vector.size(); ++i) {
                hashSet.add(((String)vector.get(i)).toLowerCase());
            }
            this.addPathToList("");
            this.startSearchThread(string, hashSet, bl);
        }
    }

    private void startSearchThread(final String string, final HashSet hashSet, final boolean bl) {
        this.threadExists = true;
        Thread thread = new Thread(){

            public void run() {
                try {
                    File file = new File(new File(string).getCanonicalPath());
                    BrowserPanel.this.searchForFile(file, hashSet);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                BrowserPanel.this.threadExists = false;
                Toolkit.getDefaultToolkit().beep();
                BrowserPanel.this.statusLabel.setText("Done.");
                BrowserPanel.this.wrapUpSearch();
                if (bl) {
                    BrowserPanel.this.acceptSearchResults(false);
                }
            }
        };
        thread.start();
    }

    private void searchForFile(File file, HashSet hashSet) {
        try {
            File file2;
            if (file != null && (file2 = new File(file.getCanonicalPath())).equals(file) && !this.stopSearching) {
                if (this.statusInterval++ % 20 == 0) {
                    this.updateStatusLabel();
                }
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    File file3 = fileArray[i];
                    if (file3.isDirectory()) {
                        this.searchForFile(file3, hashSet);
                        continue;
                    }
                    if (!hashSet.contains(file3.getName().toLowerCase())) continue;
                    this.addPathToList(file3.getPath());
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void updateStatusLabel() {
        String[] stringArray = new String[]{"\\", "|", "/", "-"};
        this.statusLabel.setText("Search " + stringArray[this.statusCounter % stringArray.length]);
        ++this.statusCounter;
    }

    private void stopSearch() {
        if (this.threadExists) {
            this.stopSearching = true;
            this.wrapUpSearch();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void wrapUpSearch() {
        if (this.foundCount > 0) {
            this.resultList.setToolTipText("<html>Select one or more of the results,<br>then press \"Transfer\" below.</html>");
        }
    }

    private void browseForStartPath() {
        String string = this.startPath.getText();
        if (string.length() == 0) {
            string = "/";
        }
        JFileChooser jFileChooser = new JFileChooser(string);
        jFileChooser.setFileSelectionMode(1);
        jFileChooser.setDialogTitle("Choose Browser Search Path");
        jFileChooser.setApproveButtonText("Accept");
        int n = jFileChooser.showOpenDialog(this.main);
        if (n == 0) {
            this.startPath.setText(jFileChooser.getSelectedFile().toString());
        }
        this.requestFocusInWindow();
        this.browserDialog.requestFocusInWindow();
    }

    private void acceptSearchResults(boolean bl) {
        int n;
        ArachComp.writeProgramFile(this.namesPath, this.executableNames.getText(), false);
        Object[] objectArray = this.resultList.getSelectedValues();
        if (objectArray.length == 0) {
            ListModel listModel = this.resultList.getModel();
            Vector vector = new Vector();
            for (n = 1; n < listModel.getSize(); ++n) {
                vector.add(listModel.getElementAt(n));
            }
            objectArray = vector.toArray();
        }
        int n2 = 0;
        if (objectArray.length > 0) {
            int n3 = this.browserList.getSelectedIndex();
            for (n = 0; n < objectArray.length; ++n) {
                String string = (String)objectArray[n];
                File file = new File(string);
                if (file.exists()) {
                    String string2 = file.getName();
                    int n4 = string2.lastIndexOf(46);
                    if (n4 != -1) {
                        string2 = string2.substring(0, n4);
                    }
                    String string3 = string2;
                    int n5 = 2;
                    while (this.alreadyInList(string3)) {
                        string3 = string2 + n5;
                        ++n5;
                    }
                    if (string3.length() > 0) {
                        string3 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
                    }
                    if (!this.alreadyInList(string3)) {
                        if ((n2 = this.getNextFreeListSlot(n2)) == -1) {
                            Toolkit.getDefaultToolkit().beep();
                            JOptionPane.showMessageDialog(this.main, "There are no free list locations.\n\nPlease delete some existing browser definitions\nand try again.", "No room at the inn", 1);
                            break;
                        }
                        this.browserArray[n2] = new BrowserData(string3, string, "file:$1", "http://server-name/server-path/$1", true, true);
                    }
                }
                this.arrayToDisplay(n3);
                this.listToDisplay();
            }
        } else {
            this.startSearch(bl);
        }
    }

    private boolean alreadyInList(String string) {
        for (int i = 0; i < this.browserArray.length; ++i) {
            if (!this.browserArray[i].appPath.equals(string)) continue;
            return true;
        }
        return false;
    }

    private int getNextFreeListSlot(int n) {
        while (n < this.browserArray.length && !this.browserArray[n].name.equals("--")) {
            ++n;
        }
        if (n >= this.browserArray.length) {
            n = -1;
        }
        return n;
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.topPanel = new JPanel();
        this.appListPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.executableNames = new JTextArea();
        this.resultListPanel = new JPanel();
        this.jScrollPane2 = new JScrollPane();
        this.resultList = new JList();
        this.startPath = new JTextField();
        this.startPathLabel = new JLabel();
        this.browseButton = new MyJButton();
        this.startButton = new MyJButton();
        this.stopButton = new MyJButton();
        this.gimmickPanel = new JPanel();
        this.statusLabel = new JLabel();
        this.acceptSearchButton = new JButton();
        this.bottomPane = new JPanel();
        this.browserList = new JComboBox();
        this.jLabel1 = new JLabel();
        this.browserName = new JTextField();
        this.jLabel2 = new JLabel();
        this.appPath = new JTextField();
        this.jLabel3 = new JLabel();
        this.cboCheckBox = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.htmlLaunchArgTextField = new JTextField();
        this.acceptButton = new MyJButton();
        this.cancelButton = new MyJButton();
        this.makeActiveButton = new MyJButton();
        this.deleteButton = new MyJButton();
        this.ajdpCheckBox = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.phpLaunchArgTextField = new JTextField();
        this.setLayout(new BorderLayout());
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setOneTouchExpandable(true);
        this.topPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Browser Search"));
        this.topPanel.setLayout(new GridBagLayout());
        this.appListPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Search Names"));
        this.appListPanel.setLayout(new BorderLayout());
        this.executableNames.setColumns(20);
        this.executableNames.setRows(5);
        this.jScrollPane1.setViewportView(this.executableNames);
        this.appListPanel.add((Component)this.jScrollPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.appListPanel, gridBagConstraints);
        this.resultListPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Search results"));
        this.resultListPanel.setLayout(new BorderLayout());
        this.jScrollPane2.setAutoscrolls(true);
        this.jScrollPane2.setPreferredSize(new Dimension(200, 100));
        this.resultList.setToolTipText("This list will contain any located browser executables");
        this.resultList.setMaximumSize(new Dimension(Short.MAX_VALUE, Short.MAX_VALUE));
        this.resultList.setMinimumSize(new Dimension(100, 50));
        this.resultList.setPreferredSize(new Dimension(500, 200));
        this.jScrollPane2.setViewportView(this.resultList);
        this.resultListPanel.add((Component)this.jScrollPane2, "North");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.topPanel.add((Component)this.resultListPanel, gridBagConstraints);
        this.startPath.setToolTipText("This is the path at which to begin the search");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.startPath, gridBagConstraints);
        this.startPathLabel.setText("Search path:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.startPathLabel, gridBagConstraints);
        this.browseButton.setText("Browse");
        this.browseButton.setToolTipText("Select a directory at which to start the search");
        this.browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.browseButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.browseButton, gridBagConstraints);
        this.startButton.setText("Search");
        this.startButton.setToolTipText("Start searching for browsers");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.startButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.startButton, gridBagConstraints);
        this.stopButton.setText("Stop");
        this.stopButton.setToolTipText("Stop ongoing search");
        this.stopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.stopButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.stopButton, gridBagConstraints);
        this.gimmickPanel.setLayout(new BorderLayout());
        this.statusLabel.setHorizontalAlignment(0);
        this.gimmickPanel.add((Component)this.statusLabel, "Center");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.gimmickPanel, gridBagConstraints);
        this.acceptSearchButton.setText("Transfer");
        this.acceptSearchButton.setToolTipText("<html>Transfer selected/all located paths<br>to unused browser locations below</html>");
        this.acceptSearchButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.acceptSearchButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.topPanel.add((Component)this.acceptSearchButton, gridBagConstraints);
        this.jSplitPane1.setLeftComponent(this.topPanel);
        this.bottomPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Browser Definitions"));
        this.bottomPane.setLayout(new GridBagLayout());
        this.browserList.setToolTipText("Choose an unused position (--) for a new entry");
        this.browserList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.browserListActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.browserList, gridBagConstraints);
        this.jLabel1.setText("Select Browser");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.jLabel1, gridBagConstraints);
        this.browserName.setToolTipText("You may enter a custom name here.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.browserName, gridBagConstraints);
        this.jLabel2.setText("Browser Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.jLabel2, gridBagConstraints);
        this.appPath.setToolTipText("<html>This is the full path to the executable.<br>You may want to use the search engine above</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.appPath, gridBagConstraints);
        this.jLabel3.setText("Application Path");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.jLabel3, gridBagConstraints);
        this.cboCheckBox.setText("Close browser before reopening");
        this.cboCheckBox.setToolTipText("Close the existing browser and relaunch");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.cboCheckBox, gridBagConstraints);
        this.jLabel4.setText("HTML Launch arg.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.jLabel4, gridBagConstraints);
        this.htmlLaunchArgTextField.setToolTipText("<html>This should be \"file:$1\" in most cases,<br>\nbut you may need to change it for some browsers.\n</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.htmlLaunchArgTextField, gridBagConstraints);
        this.acceptButton.setText("OK");
        this.acceptButton.setToolTipText("Accept and save changes, close dialog");
        this.acceptButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.acceptButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.acceptButton, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Discard changes, close dialog");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.cancelButton, gridBagConstraints);
        this.makeActiveButton.setText("Make Default");
        this.makeActiveButton.setToolTipText("Make this browser the default");
        this.makeActiveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.makeActiveButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.makeActiveButton, gridBagConstraints);
        this.deleteButton.setText("Delete");
        this.deleteButton.setToolTipText("Delete selected definition");
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                BrowserPanel.this.deleteButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.deleteButton, gridBagConstraints);
        this.ajdpCheckBox.setText("Jump to doc pos (may fail embedded scripts)");
        this.ajdpCheckBox.setToolTipText("<html>Jump to current editing position on preview<br>(this option may create errors in embedded scripts)</html>");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.ajdpCheckBox, gridBagConstraints);
        this.jLabel5.setText("PHP,ASP Launch Arg.");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.bottomPane.add((Component)this.phpLaunchArgTextField, gridBagConstraints);
        this.jSplitPane1.setRightComponent(this.bottomPane);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doCancel();
    }

    private void makeActiveButtonActionPerformed(ActionEvent actionEvent) {
        this.selectBrowser();
    }

    private void deleteButtonActionPerformed(ActionEvent actionEvent) {
        this.deleteListItem();
    }

    private void browserListActionPerformed(ActionEvent actionEvent) {
        this.handleListChange();
    }

    private void acceptButtonActionPerformed(ActionEvent actionEvent) {
        this.acceptClose();
    }

    private void acceptSearchButtonActionPerformed(ActionEvent actionEvent) {
        this.acceptSearchResults(true);
    }

    private void stopButtonActionPerformed(ActionEvent actionEvent) {
        this.stopSearch();
    }

    private void browseButtonActionPerformed(ActionEvent actionEvent) {
        this.browseForStartPath();
    }

    private void startButtonActionPerformed(ActionEvent actionEvent) {
        this.startSearch(false);
    }
}

