/*
 * Decompiled with CFR 0.152.
 */
package BrowserStuff;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import BrowserStuff.BrowserData;
import BrowserStuff.BrowserDialog;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.JOptionPane;

public final class BrowserLauncher {
    ArachDocument doc = null;
    Arachnophilia main = null;
    Process browserProcess = null;
    public File browserTempFile = null;
    boolean needServer;

    public BrowserLauncher(ArachDocument arachDocument, Arachnophilia arachnophilia) {
        this.doc = arachDocument;
        this.main = arachnophilia;
        int n = this.main.fileTypes.getFileTypeForName("ASP");
        int n2 = this.main.fileTypes.getFileTypeForName("PHP");
        this.needServer = this.doc.fileType == n || this.doc.fileType == n2;
    }

    public BrowserLauncher(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
    }

    public void closeThings() {
        if (this.browserTempFile != null) {
            this.browserTempFile.delete();
            this.browserTempFile = null;
        }
        if (this.browserProcess != null) {
            this.browserProcess.destroy();
            this.browserProcess = null;
        }
    }

    public void retireTempFile() {
        this.closeThings();
    }

    private BrowserData chooseBrowser(String string) {
        BrowserData browserData = null;
        if (string.length() > 0) {
            for (int i = 0; i < this.main.configValues.browserList.length; ++i) {
                BrowserData browserData2 = new BrowserData(this.main.configValues.browserList[i]);
                if (!string.equalsIgnoreCase(browserData2.name)) continue;
                browserData = browserData2;
                break;
            }
            if (browserData == null) {
                Toolkit.getDefaultToolkit().beep();
                JOptionPane.showMessageDialog(this.main, "You have requested a browser with an unrecognized name\nor a site with an unrecognized URL:\"" + string + "\".\n" + "For browser names, case doesn't matter, but spelling does.\n\n" + "The browser configuration dialog will launch next,\n" + "where you can check the spelling of the browser name.\n" + "Then you may want to edit the browser launch\n" + "button/macro you are using.", "Named browser not found", 1);
            }
        } else {
            int n = this.main.configValues.selectedBrowser;
            if (n >= 0 && n < this.main.configValues.browserList.length && !(browserData = new BrowserData(this.main.configValues.browserList[n])).exists()) {
                browserData = null;
            }
        }
        return browserData;
    }

    public void launchBrowser(String string) {
        this.launchBrowser(string, null);
    }

    public void launchDefaultBrowserWithURL(String string) {
        this.launchBrowser(null, string);
    }

    public void launchBrowser(String string, String string2) {
        String string3;
        BrowserData browserData = null;
        browserData = string != null ? this.chooseBrowser(string) : this.chooseBrowser("");
        if (browserData == null) {
            new BrowserDialog(this.main);
            return;
        }
        String string4 = null;
        if (string2 == null && this.doc != null) {
            string4 = this.doc.path;
            if (!this.doc.isFile) {
                string4 = this.main.userHome;
            }
        }
        if (this.browserProcess != null && browserData.closeBeforeOpening) {
            this.browserProcess.destroy();
            this.browserProcess = null;
        }
        boolean bl = false;
        if (this.needServer) {
            bl = browserData.phpLaunchArgument.indexOf("$1") != -1;
        } else {
            boolean bl2 = bl = browserData.htmlLaunchArgument.indexOf("$1") != -1;
        }
        if (bl && this.browserTempFile == null && string2 == null) {
            this.closeThings();
            try {
                string3 = ".html";
                int n = this.doc.name.lastIndexOf(".");
                if (n > 0) {
                    string3 = this.doc.name.substring(n);
                }
                this.browserTempFile = File.createTempFile("~ArachBrowserTemp", string3, new File(string4));
                this.browserTempFile.deleteOnExit();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (string2 != null) {
            try {
                this.browserProcess = Runtime.getRuntime().exec(new String[]{browserData.appPath, string2});
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else if (this.browserTempFile != null || !bl) {
            string3 = "";
            if (this.browserTempFile != null) {
                string3 = this.browserTempFile.getPath().replaceAll("\\\\", "/");
            }
            String string5 = this.doc.textComp.getText();
            String string6 = "";
            String string7 = "";
            if (bl && browserData.alwaysJumpToDocPos) {
                int n = this.doc.textComp.getCaretLine();
                int n2 = this.doc.textComp.getLineCount();
                int n3 = this.doc.textComp.getVisibleLines();
                n = (n -= 3) < 0 ? 0 : n;
                int n4 = this.doc.textComp.getLineStartOffset(n = n >= n2 ? n2 - 1 : n);
                if (n4 != -1) {
                    string7 = "#ArachTempDocPos";
                    string6 = "<a name=\"ArachTempDocPos\"></a>";
                    String string8 = string5.substring(n4);
                    string5 = string5.substring(0, n4) + string6 + string8;
                }
            }
            ArachComp.writeDataFile(this.browserTempFile.getPath(), string5, true);
            String string9 = this.needServer ? browserData.phpLaunchArgument : browserData.htmlLaunchArgument;
            string9 = this.main.comSwitchboard.exec(string9, 0);
            if (bl) {
                if (this.needServer) {
                    String string10 = this.browserTempFile.getName();
                    string9 = browserData.formatActivationString(string9, "$1", string10 + string7);
                } else {
                    string9 = browserData.formatActivationString(string9, "$1", string3 + string7);
                }
            }
            try {
                this.browserProcess = Runtime.getRuntime().exec(new String[]{browserData.appPath, string9});
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

