/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import Arachnophilia.SearchReplace;
import Arachnophilia.TextInterface;
import java.awt.Toolkit;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.text.Caret;

public final class SearchReplaceStuff {
    int findCount;
    int fileCount;
    Arachnophilia main;
    ArachDocument doc;
    int pos = -1;
    int selStart;
    int selEnd;
    boolean found = false;
    public boolean cancelCurrentOperation = false;
    boolean lockAccess = false;

    public SearchReplaceStuff(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
    }

    public void countOccurrences(ArachDocument arachDocument, String string, JLabel jLabel) {
        if (arachDocument != null) {
            int n;
            SearchReplace searchReplace = new SearchReplace();
            int n2 = arachDocument.textComp.getCaretPosition();
            int n3 = arachDocument.textComp.getSelectionStart();
            boolean bl = n3 != (n = arachDocument.textComp.getSelectionEnd());
            String string2 = bl ? arachDocument.textComp.getSelectedText() : arachDocument.textComp.getText();
            int n4 = searchReplace.countOccurrences(0, string2, string, this.main.configValues.caseSensitiveTextSearch);
            if (jLabel != null) {
                jLabel.setText("Found " + n4 + " case" + this.smartModifier(n4) + ".");
            }
        }
    }

    private String smartModifier(int n) {
        return n == 1 ? "" : "s";
    }

    public void findFirst(ArachDocument arachDocument, String string, JLabel jLabel) {
        if (arachDocument != null) {
            arachDocument.textComp.setCaretPosition(0);
            this.findNext(arachDocument, string, jLabel);
        }
    }

    public void findNext(ArachDocument arachDocument, String string, JLabel jLabel) {
        if (arachDocument != null) {
            if (string.length() > 0) {
                this.doc = arachDocument;
                this.pos = arachDocument.textComp.getCaretPosition();
                this.findText2(string, jLabel);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public void findText2(String string, JLabel jLabel) {
        this.found = false;
        if (this.main.currentSelectedDocument == this.doc && this.doc != null) {
            this.pos = this.searchText(string, this.pos, this.main.configValues.caseSensitiveTextSearch, this.doc.textComp);
            if (this.pos != -1) {
                this.found = true;
                this.selStart = this.pos;
                this.selEnd = this.pos + string.length();
                this.doc.centerCaret = true;
                this.doc.textComp.select(this.selStart, this.selEnd);
                Caret caret = this.doc.textComp.getCaret();
                if (caret != null) {
                    caret.setSelectionVisible(true);
                }
                this.pos = this.selEnd;
                if (jLabel != null) {
                    jLabel.setText("Found 1 case.");
                }
            } else {
                this.pos = 0;
                this.doc.textComp.setCaretPosition(0);
                Toolkit.getDefaultToolkit().beep();
                if (jLabel != null) {
                    jLabel.setText("Not found.");
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private int searchText(String string, int n, boolean bl, TextInterface textInterface) {
        int n2 = textInterface.getLength();
        int n3 = string.length();
        n2 -= n3;
        int n4 = -1;
        if (bl) {
            for (int i = n; i < n2; ++i) {
                if (!string.equals(textInterface.getText(i, n3))) continue;
                n4 = i;
                break;
            }
        } else {
            for (int i = n; i < n2; ++i) {
                if (!string.equalsIgnoreCase(textInterface.getText(i, n3))) continue;
                n4 = i;
                break;
            }
        }
        return n4;
    }

    public void replaceText(String string, String string2, JLabel jLabel) {
        if (!this.found || this.main.currentSelectedDocument != this.doc || this.doc == null) {
            if (jLabel != null) {
                jLabel.setText("Searching.");
            }
            this.findNext(this.main.currentSelectedDocument, string, jLabel);
        } else {
            this.doc.undoPush();
            this.doc.textComp.replaceSelection(string2);
            int n = string2.length() - string.length();
            this.pos += n;
            this.doc.textComp.setCaretPosition(this.selStart);
            this.doc.textComp.moveCaretPosition(this.pos);
            this.found = false;
            if (jLabel != null) {
                jLabel.setText("Replaced 1 case.");
            }
        }
    }

    public void replaceGlobalThread(String string, final String string2, String string3, final String string4, final JLabel jLabel) {
        if (!this.lockAccess) {
            int n = JOptionPane.showConfirmDialog(this.main, "This operation will replace ALL cases of \n\"" + string + "\" with\n" + "\"" + string3 + "\"\n" + "in ALL open documents.\n" + "Okay to proceed?", "Global Replace All", 0);
            if (n == 0) {
                this.lockAccess = true;
                Thread thread = new Thread(){

                    public void run() {
                        SearchReplaceStuff.this.replaceGlobal(string2, string4, jLabel);
                    }
                };
                thread.start();
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void replaceGlobal(String string, String string2, JLabel jLabel) {
        this.cancelCurrentOperation = false;
        this.fileCount = 0;
        this.findCount = 0;
        ArachDocument[] arachDocumentArray = this.main.fileHandler.docArray();
        for (int i = 0; i < arachDocumentArray.length && !this.cancelCurrentOperation; ++i) {
            ArachDocument arachDocument = arachDocumentArray[i];
            arachDocument.textComp.setSelectionEnd(arachDocument.textComp.getSelectionStart());
            this.replaceAll2(arachDocument, string, string2);
            ++this.fileCount;
        }
        if (jLabel != null) {
            jLabel.setText("Replaced " + this.findCount + " case" + this.smartModifier(this.findCount) + " in " + this.fileCount + " file" + this.smartModifier(this.fileCount) + ".");
        }
        this.cancelCurrentOperation = false;
        this.lockAccess = false;
    }

    public void replaceAllThread(final ArachDocument arachDocument, final String string, final String string2, final JLabel jLabel) {
        if (arachDocument != null && !this.lockAccess) {
            this.findCount = 0;
            this.lockAccess = true;
            Thread thread = new Thread(){

                public void run() {
                    SearchReplaceStuff.this.replaceAll(arachDocument, string, string2, jLabel);
                }
            };
            thread.start();
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void replaceAll(ArachDocument arachDocument, String string, String string2, JLabel jLabel) {
        this.replaceAll2(arachDocument, string, string2);
        this.lockAccess = false;
        if (jLabel != null) {
            jLabel.setText("Replaced " + this.findCount + " case" + this.smartModifier(this.findCount) + ".");
        }
    }

    private void replaceAll2(ArachDocument arachDocument, String string, String string2) {
        if (arachDocument != null) {
            String string3;
            boolean bl;
            arachDocument.undoPush();
            SearchReplace searchReplace = new SearchReplace();
            arachDocument.lockDocument = true;
            int n = 0;
            int n2 = 0;
            int n3 = arachDocument.textComp.getCaretPosition();
            int n4 = arachDocument.textComp.getSelectionStart();
            int n5 = arachDocument.textComp.getSelectionEnd();
            boolean bl2 = bl = n4 != n5;
            if (bl) {
                string3 = arachDocument.textComp.getSelectedText();
                n = string3.length();
            } else {
                string3 = arachDocument.textComp.getText();
            }
            string3 = searchReplace.srchRplc(0, string3, string, string2, this.main.configValues.caseSensitiveTextSearch);
            this.findCount += searchReplace.findCount;
            if (bl) {
                arachDocument.textComp.replaceSelection(string3);
                n2 = string3.length();
                arachDocument.textComp.setSelectionStart(n4);
                arachDocument.textComp.setSelectionEnd(n5 + n2 - n);
            } else {
                arachDocument.textComp.setText(string3);
                if (n3 < arachDocument.textComp.getDocument().getLength()) {
                    arachDocument.textComp.setCaretPosition(n3);
                }
            }
            Caret caret = arachDocument.textComp.getCaret();
            if (caret != null) {
                caret.setSelectionVisible(true);
            }
            arachDocument.textComp.rfiw();
            arachDocument.lockDocument = false;
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

