/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachConstants;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import Arachnophilia.ContentFloatingWindow;
import Arachnophilia.DocumentProcessingFunctions;
import Arachnophilia.SearchReplace;
import FilePicker.PickerDialog;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;

public final class RightClickProcessor {
    Arachnophilia main;
    int line;
    int lineStartOffset;
    int lineEndOffset;
    String documentLine;
    SearchReplace srch;
    Vector windowVals = null;

    public RightClickProcessor(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
        this.srch = new SearchReplace();
        String string = this.main.basePath + ArachConstants.SYSTEM_FILESEP + "ArachConf" + ArachConstants.SYSTEM_FILESEP + "CtrlRightClickList.txt";
        this.windowVals = ArachComp.loadDataVector(string);
    }

    public boolean processRightClickEvent(MouseEvent mouseEvent, ArachDocument arachDocument) {
        int n;
        int n2;
        if ((mouseEvent.getModifiers() & 2) != 0) {
            Point point = ((Component)mouseEvent.getSource()).getLocationOnScreen();
            int n3 = point.x + mouseEvent.getX();
            int n4 = point.y + mouseEvent.getY();
            new ContentFloatingWindow(this.windowVals, new Point(n3, n4), this.main);
            return true;
        }
        int n5 = arachDocument.textComp.getCaretPosition();
        Bundle bundle = this.getDocumentLine(arachDocument);
        this.documentLine = bundle.s;
        Bundle bundle2 = this.getDocumentField(bundle);
        if (bundle2 == null) {
            return false;
        }
        Bundle bundle3 = this.getColorField(bundle2);
        if (bundle3 != null && bundle3.s.length() == 6) {
            bundle3.s = new DocumentProcessingFunctions(this.main).launchColorSelectorDialog(bundle3.s);
            this.replaceSelection(arachDocument, n5, bundle3, true);
            return true;
        }
        if (this.testForLinkArgument(bundle2)) {
            return false;
        }
        int n6 = this.main.fileTypes.getValidFileType(bundle2.s);
        if (n6 == -1 && (n2 = bundle2.s.length()) > 3 && (n = bundle2.s.lastIndexOf(46)) < n2 - 1 && n > 0 && Character.isLetter(bundle2.s.charAt(n + 1)) && Character.isLetter(bundle2.s.charAt(n - 1))) {
            n6 = this.main.fileTypes.getFileTypeForName("All");
        }
        if (n6 != -1) {
            n2 = n6 == this.main.fileTypes.getFileTypeForName("Graphic") ? 1 : 0;
            File file = this.promptDoc(arachDocument, n6, n2 != 0);
            if (file != null && this.main.currentSelectedDocument != null) {
                File file2 = new File(this.main.currentSelectedDocument.fullPath);
                String string = file.getPath();
                String string2 = file2.getPath();
                bundle2.s = ArachComp.createRelativePath(string, string2);
                this.replaceSelection(arachDocument, n5, bundle2, true);
                if (n2 != 0) {
                    this.sizeGraphicTagsInLine(arachDocument, n5);
                }
            }
            return true;
        }
        return false;
    }

    public void sizeGraphicTagsInLine(ArachDocument arachDocument, int n) {
        Bundle bundle = this.getDocumentLine(arachDocument);
        String string = bundle.s;
        int n2 = string.length();
        string = this.sizeAllGraphicTagsInString(arachDocument, string);
        this.replaceSelection(arachDocument, n, new Bundle(string, 0, n2 - 1, n), true);
    }

    public String sizeAllGraphicTagsInString(ArachDocument arachDocument, String string) {
        int n = 0;
        Bundle bundle = new Bundle(string, 0, 0, 0);
        while ((n = this.sizeGraphic(arachDocument, bundle, n)) != -1) {
        }
        return bundle.s;
    }

    private int sizeGraphic(ArachDocument arachDocument, Bundle bundle, int n) {
        String string = "<img";
        int n2 = this.findLC(bundle.s, string, n);
        if (n2 != -1) {
            int n3 = bundle.s.indexOf("/>", n2);
            if (n3 == -1) {
                n3 = bundle.s.indexOf(">", n2);
            }
            if (n3 != -1) {
                n = n3 + 1;
                String string2 = bundle.s.substring(n2, n3);
                String string3 = this.getValueForArg(string2, "src");
                string3 = arachDocument.path + "/" + string3;
                File file = new File(string3);
                ImageIcon imageIcon = new ImageIcon(file.getPath());
                int n4 = imageIcon.getImage().getWidth(null);
                int n5 = imageIcon.getImage().getHeight(null);
                if (n4 != -1 && n5 != -1) {
                    string2 = this.replaceTag(string2, "width", "width=\"" + n4 + "\"");
                    string2 = this.replaceTag(string2, "height", "height=\"" + n5 + "\"");
                }
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(bundle.s.substring(0, n2));
                stringBuffer.append(string2);
                stringBuffer.append(bundle.s.substring(n3));
                bundle.s = stringBuffer.toString();
            } else {
                n = -1;
            }
        } else {
            n = -1;
        }
        return n;
    }

    private int findLC(String string, String string2, int n) {
        boolean bl = false;
        int n2 = string2.length();
        int n3 = string.length() - n2;
        for (int i = n; i < n3; ++i) {
            if (!string.substring(i, i + n2).equalsIgnoreCase(string2)) continue;
            return i;
        }
        return -1;
    }

    private String getValueForArg(String string, String string2) {
        boolean bl = false;
        boolean bl2 = false;
        String string3 = "";
        string2 = string2 + "=";
        String string4 = string.toLowerCase();
        int n = 0;
        int n2 = string.length();
        int n3 = string4.indexOf(string2);
        if (n3 != -1) {
            for (n = n3 += string2.length(); n < n2; ++n) {
                char c = string.charAt(n);
                if (c == '\"') {
                    bl = !bl;
                    continue;
                }
                if (bl || !Character.isWhitespace(c) && c != '>') continue;
                bl2 = true;
                break;
            }
        }
        if (n3 != -1 && (bl2 || n == n2)) {
            string3 = string.substring(n3, n);
            string3 = this.srch.srchRplc(string3, "\"", "");
        }
        return string3;
    }

    private String replaceTag(String string, String string2, String string3) {
        boolean bl = false;
        boolean bl2 = false;
        string2 = string2 + "=";
        String string4 = string.toLowerCase();
        int n = 0;
        int n2 = string.length();
        int n3 = string4.lastIndexOf(string2);
        if (n3 != -1) {
            for (n = n3 + string2.length(); n < n2; ++n) {
                char c = string.charAt(n);
                if (c == '\"') {
                    bl = !bl;
                    continue;
                }
                if (bl || !Character.isWhitespace(c)) continue;
                bl2 = true;
                break;
            }
        }
        string = n3 != -1 && (bl2 || n == n2) ? string.substring(0, n3) + string3 + string.substring(n) : string + ' ' + string3;
        return string;
    }

    private boolean testForLinkArgument(Bundle bundle) {
        return bundle.s.indexOf("://") != -1;
    }

    private Bundle getDocumentField(Bundle bundle) {
        char c;
        int n;
        int n2 = bundle.s.length();
        int n3 = bundle.pos - bundle.a;
        if (n3 > 0 && n3 < n2 && ((n = (int)bundle.s.charAt(n3)) == 58 || n == 61 || n == 32 || n == 34 || n == 10)) {
            --n3;
        }
        int n4 = n3;
        for (n = n3; n >= 0 && n < n2; --n) {
            c = bundle.s.charAt(n);
            if (c == '<' || c == '>') {
                return null;
            }
            if (c != '=' && c != ':') continue;
            if (n >= n3) break;
            ++n;
            break;
        }
        if (n < 0) {
            return null;
        }
        while (n < n2 && ((c = bundle.s.charAt(n)) == ' ' || c == '\"')) {
            ++n;
        }
        if (n >= n2) {
            return null;
        }
        while (n4 >= 0 && n4 < n2) {
            c = bundle.s.charAt(n4);
            if (c == ' ' || c == '}' || c == '\"' || c == '>' || c == '\n') {
                if (n4 <= n3) break;
                --n4;
                break;
            }
            ++n4;
        }
        if (n4 >= n2) {
            return null;
        }
        if (n >= 0 && n < n2 && n4 >= 0 && n4 < n2 && n4 > n) {
            String string = bundle.s.substring(n, n4 + 1);
            return new Bundle(string, bundle.a + n, bundle.a + n4, bundle.pos);
        }
        return null;
    }

    private Bundle getColorField(Bundle bundle) {
        char c;
        int n;
        int n2 = bundle.s.length();
        int n3 = bundle.pos - bundle.a;
        if (n3 >= 0 && n3 <= n2) {
            if (n3 > 0 && n3 >= n2) {
                --n3;
            } else {
                n = bundle.s.charAt(n3);
                if (n == 35) {
                    if (n3 < n2 - 1) {
                        ++n3;
                    }
                } else if (!ArachComp.isHexDigit((char)n) && n3 > 0) {
                    --n3;
                }
            }
        }
        int n4 = n3;
        for (n = n3; n >= 0 && n < n2; --n) {
            c = bundle.s.charAt(n);
            if (ArachComp.isHexDigit(c)) continue;
            if (n >= n3) break;
            ++n;
            break;
        }
        if (n < 0) {
            ++n;
        }
        while (n4 >= 0 && n4 < n2) {
            c = bundle.s.charAt(n4);
            if (!ArachComp.isHexDigit(c)) {
                if (n4 <= n3) break;
                --n4;
                break;
            }
            ++n4;
        }
        if (n4 >= n2) {
            --n4;
        }
        if (n >= 0 && n < n2 && n4 >= 0 && n4 < n2 && n4 > n) {
            String string = bundle.s.substring(n, n4 + 1);
            return new Bundle(string, bundle.a + n, bundle.a + n4, bundle.pos);
        }
        return null;
    }

    private Bundle getDocumentLine(ArachDocument arachDocument) {
        Bundle bundle = new Bundle();
        int n = arachDocument.textComp.getCaretPosition();
        this.line = arachDocument.textComp.getCaretLine();
        this.lineEndOffset = this.lineStartOffset = arachDocument.textComp.getLineStartOffset(this.line);
        try {
            this.lineEndOffset = arachDocument.textComp.getLineEndOffset(this.line);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
        bundle.s = arachDocument.textComp.getText(this.lineStartOffset, this.lineEndOffset - this.lineStartOffset);
        bundle.a = 0;
        bundle.b = this.lineEndOffset - this.lineStartOffset;
        bundle.pos = n - this.lineStartOffset;
        return bundle;
    }

    private void replaceSelection(ArachDocument arachDocument, int n, Bundle bundle, boolean bl) {
        arachDocument.undoPush();
        arachDocument.textComp.setCaretPosition(this.lineStartOffset + bundle.a);
        arachDocument.textComp.moveCaretPosition(this.lineStartOffset + bundle.b + 1);
        if (bl) {
            arachDocument.textComp.replaceSelection(bundle.s);
            arachDocument.textComp.setCaretPosition(n);
        }
    }

    public String createGraphicLink(ArachDocument arachDocument) {
        return this.createFileLink(arachDocument, "Graphic");
    }

    public String createFileLink(ArachDocument arachDocument, String string) {
        String string2 = "";
        int n = this.main.fileTypes.getFileTypeForName(string);
        if (n != -1) {
            File file = this.promptDoc(arachDocument, n, true);
            if (file != null) {
                File file2 = new File(arachDocument.fullPath);
                String string3 = file.getPath();
                String string4 = file2.getPath();
                string2 = ArachComp.createRelativePath(string3, string4);
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
            JOptionPane.showMessageDialog(this.main, "The file type \"" + string + "\" was not found.\n" + "Please be sure the submitted file type matches one\n" + "in the list of file types located at\n" + "\"" + this.main.basePath + "/ArachConf/FileData.txt.\"\n" + "These file types are case sensitive.", "Open file by type", 0);
        }
        return string2;
    }

    public File promptDoc(ArachDocument arachDocument, int n, boolean bl) {
        File[] fileArray;
        int n2;
        PickerDialog pickerDialog;
        if (!arachDocument.isFile) {
            JOptionPane.showMessageDialog(this.main, "HTML files cannot link to other documents\nor resources or be linked from others\nbefore they are saved.\nTo enable this operation,\nplease first save your document.", "Right-cick wizard -- File not saved", 0);
            return null;
        }
        File file = null;
        String string = this.main.configValues.fileTypePaths[n];
        this.main.fileTypes.setFileType(n);
        if (string.length() > 0) {
            File file2 = new File(string);
            pickerDialog = new PickerDialog(this.main, file2, this.main.fileTypes, 0);
        } else {
            pickerDialog = new PickerDialog(this.main, this.main.fileTypes, 0);
        }
        pickerDialog.setDialogTitle("Create link to " + this.main.fileTypes.fileTypeNames[n] + " file");
        if (bl) {
            pickerDialog.getPickerPanel();
            pickerDialog.setPreviewMode(2);
        }
        if ((n2 = pickerDialog.showOpenDialog()) == 1 && (fileArray = pickerDialog.getSelectedFiles()).length > 0) {
            file = fileArray[0];
            this.main.configValues.fileTypePaths[n] = ArachComp.pathFromFullPath(file.getPath());
        }
        return file;
    }

    class Bundle {
        public String s = "";
        public int a = 0;
        public int b = 0;
        public int pos = 0;

        public Bundle() {
        }

        public Bundle(String string, int n, int n2, int n3) {
            this.s = string;
            this.a = n;
            this.b = n2;
            this.pos = n3;
        }
    }
}

