/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachConstants;
import Arachnophilia.Arachnophilia;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public final class RecentFileList {
    public Vector list = new Vector();
    private int max;
    private int insertPoint;
    private Arachnophilia main;
    JComponent targetMenu;

    public RecentFileList(Arachnophilia arachnophilia, int n, JComponent jComponent) {
        this.main = arachnophilia;
        this.max = n;
        this.setTarget(jComponent);
    }

    public void setTarget(JComponent jComponent) {
        this.targetMenu = jComponent;
        if (jComponent != null) {
            this.insertPoint = this.getCount(jComponent);
        }
        this.clearMenu();
        this.rebuildMenu();
    }

    private int getCount(JComponent jComponent) {
        if (jComponent instanceof JPopupMenu) {
            return ((JPopupMenu)jComponent).getComponentCount();
        }
        return ((JMenu)jComponent).getItemCount();
    }

    public void clearList() {
        this.clearMenu();
        this.list.clear();
    }

    public void clearMenu() {
        if (this.targetMenu != null) {
            while (this.getCount(this.targetMenu) - this.insertPoint > 0) {
                this.targetMenu.remove(this.insertPoint);
            }
        }
    }

    public void put(String string) {
        this.clearMenu();
        this.deleteExisting(string);
        if (this.list.size() > 0) {
            this.list.insertElementAt(string, 0);
        } else {
            this.list.add(string);
        }
        while (this.list.size() > this.max) {
            this.list.remove(this.list.size() - 1);
        }
        this.rebuildMenu();
    }

    private void verifyList() {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.fileExists((String)this.list.get(i))) continue;
            this.list.remove(i);
        }
    }

    private boolean fileExists(String string) {
        return new File(string).exists();
    }

    private void rebuildMenu() {
        if (this.targetMenu != null) {
            this.verifyList();
            for (int i = 0; i < this.list.size(); ++i) {
                JMenuItem jMenuItem;
                String string;
                String string2 = string = (String)this.list.get(i);
                int n = string.lastIndexOf(ArachConstants.SYSTEM_FILESEP);
                if (n != -1 && n < string.length() - 1) {
                    string2 = string.substring(n + 1);
                }
                if (string.length() <= 0) continue;
                int n2 = this.getCount(this.targetMenu);
                if (i < n2 - this.insertPoint) {
                    jMenuItem = (JMenuItem)this.targetMenu.getComponent(i + this.insertPoint);
                    jMenuItem.setText(string2);
                    if (string.equals(string2)) continue;
                    jMenuItem.setToolTipText(string);
                    continue;
                }
                jMenuItem = new JMenuItem(string2);
                if (!string.equals(string2)) {
                    jMenuItem.setToolTipText(string);
                }
                this.targetMenu.add(jMenuItem);
                this.addListener(jMenuItem);
            }
        }
    }

    private void deleteExisting(String string) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!string.equals((String)this.list.get(i))) continue;
            this.list.remove(i);
            break;
        }
    }

    public void putAll(String[] stringArray) {
        this.clearList();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].length() <= 0 || !this.fileExists(stringArray[i])) continue;
            this.list.add(stringArray[i]);
            if (this.targetMenu == null) continue;
            JMenuItem jMenuItem = new JMenuItem(stringArray[i]);
            this.targetMenu.add(jMenuItem);
            this.addListener(jMenuItem);
        }
    }

    public String[] getAll() {
        return this.list.toArray(new String[this.list.size()]);
    }

    private void addListener(JMenuItem jMenuItem) {
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecentFileList.this.menuActionPerformed(actionEvent);
            }
        });
    }

    private void menuActionPerformed(ActionEvent actionEvent) {
        JMenuItem jMenuItem = (JMenuItem)actionEvent.getSource();
        String string = jMenuItem.getToolTipText();
        File file = new File(string);
        if (!file.exists()) {
            Toolkit.getDefaultToolkit().beep();
            this.deleteExisting(string);
            this.clearMenu();
            this.rebuildMenu();
        } else {
            this.main.openDoc(file, true, true);
        }
    }
}

