/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.Timer;

public abstract class FloatingWindow
extends JFrame {
    static final int destroyDelayMillis = 4000;
    static FloatingWindow window = null;
    Timer destroyTimer = null;
    private JScrollPane scrollPane;
    private JList dataList;

    public FloatingWindow(Vector vector, Point point) {
        this.setUndecorated(true);
        if (window != null) {
            window.resetDestroyTimer();
            window.setVisible(false);
            window.dispose();
        }
        window = this;
        this.initComponents();
        this.scrollPane.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMouseExited(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMouseEntered(mouseEvent);
            }
        });
        this.scrollPane.getHorizontalScrollBar().addMouseListener(new MouseAdapter(){

            public void mouseExited(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMouseExited(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMouseEntered(mouseEvent);
            }
        });
        this.dataList.setModel(new DefaultComboBoxModel(vector));
        this.pack();
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dimension2 = this.getSize();
        int n = point.x + dimension2.width;
        if (n > dimension.width) {
            point.x -= n - dimension.width;
        }
        if ((n = point.y + dimension2.height) > dimension.height) {
            point.y -= n - dimension.height;
        }
        this.setLocation(point);
        this.showWindow();
    }

    public void showWindow() {
        this.setDestroyTimer();
        this.setVisible(true);
        this.requestFocusInWindow();
    }

    private void setDestroyTimer() {
        if (this.destroyTimer == null) {
            this.destroyTimer = new Timer(4000, new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (window != null) {
                        window.setVisible(false);
                    }
                    FloatingWindow.this.resetDestroyTimer();
                }
            });
            this.destroyTimer.start();
        }
    }

    private void resetDestroyTimer() {
        if (this.destroyTimer != null) {
            this.destroyTimer.stop();
            this.destroyTimer = null;
        }
    }

    private void doValueChanged() {
        String string = (String)this.dataList.getSelectedValue();
        if (window != null) {
            window.resetDestroyTimer();
            window.setVisible(false);
            window.dispose();
        }
        this.processChange(string);
    }

    abstract void processChange(String var1);

    abstract void cleanup();

    private void initComponents() {
        this.scrollPane = new JScrollPane();
        this.dataList = new JList();
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                FloatingWindow.this.formKeyPressed(keyEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                FloatingWindow.this.exitForm(windowEvent);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            public void windowGainedFocus(WindowEvent windowEvent) {
            }

            public void windowLostFocus(WindowEvent windowEvent) {
                FloatingWindow.this.formWindowLostFocus(windowEvent);
            }
        });
        this.dataList.setBackground(new Color(255, 255, 216));
        this.dataList.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMouseReleased(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMouseClicked(mouseEvent);
            }

            public void mouseExited(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMouseExited(mouseEvent);
            }

            public void mouseEntered(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMouseEntered(mouseEvent);
            }
        });
        this.dataList.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                FloatingWindow.this.dataListMouseDragged(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.dataList);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.pack();
    }

    private void dataListMouseReleased(MouseEvent mouseEvent) {
    }

    private void dataListMousePressed(MouseEvent mouseEvent) {
    }

    private void dataListMouseDragged(MouseEvent mouseEvent) {
    }

    private void dataListMouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
        this.doValueChanged();
    }

    private void dataListItemStateChanged(ItemEvent itemEvent) {
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 27) {
            this.quit();
        }
    }

    private void formWindowLostFocus(WindowEvent windowEvent) {
        this.quit();
    }

    private void dataListMouseExited(MouseEvent mouseEvent) {
        this.setDestroyTimer();
    }

    private void dataListMouseEntered(MouseEvent mouseEvent) {
        this.resetDestroyTimer();
    }

    private void exitForm(WindowEvent windowEvent) {
        this.quit();
    }

    private void quit() {
        if (window != null) {
            window.resetDestroyTimer();
            window.setVisible(false);
            window.dispose();
        }
        this.cleanup();
    }
}

