/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachComp;
import Arachnophilia.Arachnophilia;
import Arachnophilia.FileChangedDialog;
import Arachnophilia.TextInterface;
import Arachnophilia.UndoRedoHandler;
import BrowserStuff.BrowserLauncher;
import FilePicker.PickerDialog;
import JArachTextArea.JArachTextArea;
import JArachTextArea.MyPlainTextArea;
import JArachTextArea.TokenMarker;
import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public final class ArachDocument
extends JPanel {
    public Arachnophilia main;
    UndoRedoHandler undoRedoHandler;
    public TextInterface textComp = null;
    public String fullPath = "";
    File file = null;
    public String path = "";
    public String name = "";
    public int fileType;
    public boolean validCreation = false;
    public long lastModifiedTime = -1L;
    boolean needInit = true;
    public int firstPaint = 0;
    public boolean suppressFirst = true;
    public boolean docChanged = false;
    public boolean isFile = false;
    public boolean isHTMLDocument = false;
    public boolean plainText = true;
    public boolean lockDocument = false;
    public boolean centerCaret = true;
    public BrowserLauncher browserLauncher;

    public ArachDocument(String string, Arachnophilia arachnophilia, int n, boolean bl, boolean bl2) {
        this.main = arachnophilia;
        this.fileType = n;
        this.fullPath = string;
        this.isFile = bl;
        this.plainText = bl2;
        this.browserLauncher = new BrowserLauncher(this, this.main);
        this.isHTMLDocument = this.main.fileTypes.getFileTypeForName("HTML") == n || this.main.fileTypes.getFileTypeForName("PHP") == n;
        boolean bl3 = this.main.configValues.maximized;
        this.initComponents();
        this.undoRedoHandler = new UndoRedoHandler(arachnophilia.configValues.undoRedoStackSize);
        this.setLayout(new BorderLayout());
        this.setNewFont();
        if (this.readSourceFile()) {
            this.main.fileHandler.updateDocTitle(this);
            this.main.fileHandler.setFileNameStrings(string, this, bl);
            this.main.configValues.maximized = bl3;
            this.setVisible(true);
            this.docChanged = false;
            this.main.latestOpenedDocument = this;
            this.validCreation = true;
        }
    }

    private boolean readSourceFile() {
        boolean bl = false;
        String string = ArachComp.readDataFile(this.fullPath, true);
        if (string != null) {
            if (!this.isFile) {
                string = this.main.comSwitchboard.exec(string, 0);
            }
            this.lastModifiedTime = ArachComp.getLastModifiedTime(this.fullPath);
            int n = 0;
            if (!this.isFile) {
                n = this.getStringCaretPos(string);
                if (n < 0) {
                    n = 0;
                }
                string = this.clearStringCaretPos(string, n);
            }
            if (this.plainText) {
                this.setupPlainText(string, n, n, 0, this.fileType);
            } else {
                this.setupFancyText(string, n, n, 0, this.fileType);
            }
            this.textComp.setCaretPosition(n);
            this.docChanged = false;
            bl = true;
        }
        return bl;
    }

    public void testLastModifiedTime() {
        long l;
        if (this.lastModifiedTime != -1L && (l = ArachComp.getLastModifiedTime(this.fullPath)) > this.lastModifiedTime) {
            FileChangedDialog fileChangedDialog = new FileChangedDialog((Frame)this.main, this.fullPath, this.docChanged, true);
            int n = fileChangedDialog.state;
            switch (n) {
                case 3: {
                    this.saveFile(false, false, true);
                    break;
                }
                case 2: {
                    this.readSourceFile();
                    break;
                }
                default: {
                    this.lastModifiedTime = l;
                }
            }
        }
    }

    public boolean handleLineFeed(KeyEvent keyEvent) {
        boolean bl = false;
        if (keyEvent.getKeyChar() == '\n') {
            try {
                if (this.main.configValues.autoIndent) {
                    int n;
                    int n2 = this.textComp.getCaretLine();
                    int n3 = this.textComp.getLineStartOffset(n2);
                    int n4 = this.textComp.getCaretPosition();
                    String string = this.textComp.getText(n3, n4 - n3);
                    int n5 = string.length();
                    for (n = 0; n < n5 && Character.isWhitespace(string.charAt(n)); ++n) {
                    }
                    String string2 = string.substring(0, n);
                    this.textComp.select(n4, n4);
                    this.textComp.replaceSelection("\n" + string2);
                    bl = true;
                    keyEvent.consume();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public int getFileType() {
        return this.fileType;
    }

    public void gotoLine(int n) {
        int n2 = this.textComp.getLineCount();
        n = n > n2 - 1 ? n2 - 1 : n;
        n = n < 0 ? 0 : n;
        int n3 = this.textComp.getLineStartOffset(n);
        this.textComp.setCaretPosition(n3);
        this.centerCaretOnPage();
    }

    public void centerCaretOnPage() {
        this.textComp.centerCaretInView();
    }

    public void centerCaretOnPage(int n) {
        this.textComp.centerCaretInView(n);
    }

    public String getBrowserTempFileName() {
        if (this.browserLauncher.browserTempFile != null) {
            return this.browserLauncher.browserTempFile.getPath();
        }
        return "";
    }

    public void undoPush() {
        this.undoRedoHandler.undoPush(this.textComp);
    }

    public void undo() {
        this.undoRedoHandler.undoPop(this.textComp);
        if (this.main.haveFocus) {
            this.textComp.grabFocus();
        }
    }

    public void redo() {
        this.undoRedoHandler.redoPop(this.textComp);
        if (this.main.haveFocus) {
            this.textComp.grabFocus();
        }
    }

    public void computeStatusString() {
        if (this.textComp != null) {
            int n = this.textComp.getLineCount();
            int n2 = this.textComp.getCaretPosition();
            int n3 = this.textComp.getCaretLine();
            int n4 = this.textComp.getLineStartOffset(n3);
            int n5 = this.textComp.getLineLength(n3);
            int n6 = this.textComp.getLength();
            long l = 0L;
            if (n6 > 0) {
                l = 100 * n2 / n6;
            }
            String string = " R(" + (n3 + 1) + ":" + n + ")";
            string = string + " C(" + (n2 - n4 + 1) + ":" + (n5 + 1) + ")";
            string = string + " D(" + n2 + ":" + n6 + ") " + l + "%";
            this.main.updateStatusBar(string);
        }
    }

    public void setTabSize(int n) {
        this.main.configValues.tabSize = n;
        if (this.textComp != null) {
            this.textComp.getDocument().putProperty("tabSize", new Integer(n));
        }
    }

    public void setTabSize() {
        this.setTabSize(this.main.configValues.tabSize);
    }

    public void changeDisplayModes(boolean bl) {
        this.plainText = !bl;
        this.firstPaint = 0;
        if (this.textComp == null) {
            return;
        }
        String string = this.textComp.getText();
        int n = this.textComp.getSelectionStart();
        int n2 = this.textComp.getSelectionEnd();
        int n3 = this.textComp.getCaretPosition();
        int n4 = this.textComp.getFirstLine();
        if (this.plainText) {
            this.setupPlainText(string, n, n2, n3, this.fileType);
        } else {
            this.setupFancyText(string, n, n2, n3, this.fileType);
        }
        this.textComp.setFirstLine(n4);
        this.centerCaretOnPage();
        this.main.updateStatusBar("");
    }

    private void setupPlainText(String string, int n, int n2, int n3, int n4) {
        this.suppressFirst = true;
        JScrollPane jScrollPane = new JScrollPane();
        this.textComp = new MyPlainTextArea(this.main, string, jScrollPane, this);
        jScrollPane.setViewportView((JTextArea)((Object)this.textComp));
        this.textComp.setFont(this.getFont());
        if (string.length() > 0) {
            if (n3 == n) {
                this.textComp.setCaretPosition(n2);
                this.textComp.moveCaretPosition(n3);
            } else {
                this.textComp.setCaretPosition(n);
                this.textComp.moveCaretPosition(n3);
            }
        }
        this.suppressFirst = false;
        if (this.getComponentCount() > 0) {
            this.remove(0);
        }
        this.add(jScrollPane);
        this.textComp.setLineWrap(true);
        this.textComp.setWrapStyleWord(true);
        this.textComp.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ArachDocument.this.handleMouse(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ArachDocument.this.handleMouse(mouseEvent);
            }
        });
        this.setTabSize();
        if (this.main.haveFocus) {
            this.textComp.rfiw();
        }
    }

    private void setupFancyText(String string, int n, int n2, int n3, int n4) {
        this.suppressFirst = true;
        this.textComp = new JArachTextArea(this.main, this);
        this.textComp.setFont(this.getFont());
        this.textComp.setText(string);
        if (string.length() > 0) {
            if (n3 == n) {
                this.textComp.setCaretPosition(n2);
                this.textComp.moveCaretPosition(n3);
            } else {
                this.textComp.setCaretPosition(n);
                this.textComp.moveCaretPosition(n3);
            }
        }
        this.suppressFirst = false;
        this.chooseMarker(n4);
        if (this.getComponentCount() > 0) {
            this.remove(0);
        }
        this.add((JComponent)((Object)this.textComp));
        this.textComp.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ArachDocument.this.handleMouse(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ArachDocument.this.handleMouse(mouseEvent);
            }
        });
        this.setTabSize();
        if (this.main.haveFocus) {
            this.textComp.rfiw();
        }
    }

    public void setNewFont() {
        Font font = new Font(this.main.configValues.editFontName, this.main.configValues.editFontStyle, this.main.configValues.editFontSize);
        this.setFont(font);
        if (this.textComp != null) {
            this.textComp.setFont(font);
            this.updateUI();
        }
        this.updateUI();
    }

    public boolean equals(ArachDocument arachDocument) {
        return arachDocument.fullPath.equals(this.fullPath);
    }

    private int getStringCaretPos(String string) {
        return string.indexOf("|");
    }

    private String clearStringCaretPos(String string, int n) {
        if (n >= 0 && n < string.length() - 1) {
            string = string.substring(0, n) + string.substring(n + 1);
        }
        return string;
    }

    public void changeFileType(int n) {
        this.chooseMarker(n);
        this.fileType = n;
        this.repaint();
    }

    private void chooseMarker(int n) {
        if (n >= 0 && n < this.main.fileTypes.markerClassNames.length) {
            String string = this.main.fileTypes.markerClassNames[n];
            if (string.length() == 0) {
                this.textComp.setTokenMarker(null);
            } else if (Character.isLetter(string.charAt(0))) {
                try {
                    this.textComp.setTokenMarker((TokenMarker)Class.forName(this.main.fileTypes.markerClassNames[n]).newInstance());
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            } else {
                this.textComp.setTokenMarker(null);
            }
        }
    }

    public boolean saveClose(boolean bl) {
        boolean bl2 = this.saveFile(bl, true, false);
        if (bl2) {
            this.browserLauncher.closeThings();
            this.main.fileHandler.removeDoc(this);
            if (this.main.currentSelectedDocument == this) {
                this.main.currentSelectedDocument = null;
            }
        }
        return bl2;
    }

    public boolean saveFile(boolean bl, boolean bl2, boolean bl3) {
        if (!this.docChanged && !bl3) {
            return true;
        }
        return this.saveFile(this.fullPath, this.isFile, bl, bl2);
    }

    public String toString() {
        return this.fullPath;
    }

    public boolean saveFile(String string, boolean bl, boolean bl2, boolean bl3) {
        String string2 = "";
        if (string.equals("")) {
            string = this.fullPath;
        }
        boolean bl4 = false;
        if (this.textComp != null) {
            string2 = this.textComp.getText();
            if (bl) {
                int n = 0;
                if (bl2) {
                    n = this.saveFilePrompt(string);
                }
                if (n == 2) {
                    bl4 = false;
                } else if (n == 1) {
                    bl4 = true;
                } else if (n == 0) {
                    File file = new File(string);
                    File file2 = new File(this.fullPath);
                    this.main.fileHandler.swapDocuments(file2, file, this);
                    bl4 = ArachComp.writeDataFile(string, string2, true);
                    if (bl4) {
                        if (!file2.getPath().equals(file.getPath())) {
                            this.browserLauncher.retireTempFile();
                        }
                        this.main.fileHandler.setFileNameStrings(string, this, true);
                        this.docChanged = false;
                        this.updateTitle();
                        this.main.configValues.fileTypePaths[this.fileType] = ArachComp.pathFromFullPath(string);
                        this.main.recentFileList.put(string);
                    }
                }
            } else {
                int n = 0;
                if (bl2) {
                    n = this.saveFilePrompt(string);
                }
                if (n == 0) {
                    bl4 = this.saveFileAs(bl3);
                } else if (n == 1) {
                    bl4 = true;
                }
            }
        }
        this.lastModifiedTime = ArachComp.getLastModifiedTime(this.fullPath);
        return bl4;
    }

    private int saveFilePrompt(String string) {
        int n = JOptionPane.showConfirmDialog(this.main, "The file \"" + string + "\"\nis changed but has not been saved.\nDo you want to save it?\n" + "(\"Yes\" = save, \"No\" = discard, \"Cancel\" = take no action)?", "Save File", 1);
        return n;
    }

    public void launchBrowser(String string) {
        this.browserLauncher.launchBrowser(string);
    }

    public void updateTitle() {
        this.main.fileHandler.updateDocTitle(this);
    }

    public boolean saveFileAs(boolean bl) {
        String string = this.main.fileHandler.genNewFileName(this);
        return this.saveFileAs(string, bl);
    }

    public boolean saveFileAs(String string, boolean bl) {
        File file;
        PickerDialog pickerDialog;
        File file2;
        boolean bl2 = false;
        String string2 = this.main.configValues.fileTypePaths[this.fileType];
        this.main.fileTypes.setFileType(this.fileType);
        File file3 = new File(string2, string);
        if (string2.length() > 0) {
            file2 = new File(string2);
            pickerDialog = new PickerDialog(this.main, file2, this.main.fileTypes, 0);
        } else {
            pickerDialog = new PickerDialog(this.main, this.main.fileTypes, 0);
        }
        pickerDialog.setDialogTitle("Save " + this.main.fileTypes.fileTypeNames[this.fileType] + " file");
        file2 = new File(string);
        pickerDialog.setFileName(file2.getName());
        int n = -1;
        n = pickerDialog.showSaveDialog();
        while (bl && !bl2 && n == 0) {
            int n2 = this.saveFilePrompt(string2);
            if (n2 == 1) {
                bl2 = true;
            }
            if (bl2) continue;
            n = pickerDialog.showSaveDialog();
        }
        if (!bl2 && n == 1 && (file = pickerDialog.getSelectedFile()) != null) {
            int n3 = 0;
            if (file.exists() && !file.equals(file3)) {
                n3 = JOptionPane.showConfirmDialog(this.main, "File \"" + file.getPath() + "\" exists.\nOkay to overwrite?", "File Exists", 1);
            }
            if (n3 == 0) {
                File file4 = this.file;
                bl2 = this.saveFile(file.getPath(), true, false, bl);
                if (bl2) {
                    this.main.fileHandler.swapDocuments(file4, file, this);
                }
            }
        }
        this.lastModifiedTime = ArachComp.getLastModifiedTime(this.fullPath);
        return bl2;
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent componentEvent) {
                ArachDocument.this.formComponentShown(componentEvent);
            }

            public void componentHidden(ComponentEvent componentEvent) {
                ArachDocument.this.formComponentHidden(componentEvent);
            }
        });
        this.addContainerListener(new ContainerAdapter(){

            public void componentRemoved(ContainerEvent containerEvent) {
                ArachDocument.this.formComponentRemoved(containerEvent);
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                ArachDocument.this.formFocusGained(focusEvent);
            }
        });
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.onActivation();
    }

    private void closePlainMenuActionPerformed(ActionEvent actionEvent) {
        this.main.closeDoc(this);
    }

    private void closeFancyMenuActionPerformed(ActionEvent actionEvent) {
        this.main.closeDoc(this);
    }

    private void formComponentHidden(ComponentEvent componentEvent) {
        this.onDeactivation();
    }

    private void formComponentShown(ComponentEvent componentEvent) {
        this.onActivation();
    }

    private void formComponentRemoved(ContainerEvent containerEvent) {
        this.onDeactivation();
    }

    private void testMenuItemActionPerformed(ActionEvent actionEvent) {
        this.doTest();
    }

    private void toggleLineWrapActionPerformed(ActionEvent actionEvent) {
        this.toggleLineWrap();
    }

    private void showFancyMenuItemActionPerformed(ActionEvent actionEvent) {
        this.changeDisplayModes(true);
    }

    private void toPlainTextMenuItemActionPerformed(ActionEvent actionEvent) {
        this.changeDisplayModes(false);
    }

    private void changeFontMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void eolMarkMenuItemActionPerformed(ActionEvent actionEvent) {
        this.toggleEOLMarks();
    }

    private void lineNumsButtonActionPerformed(ActionEvent actionEvent) {
        this.main.configValues.lineNumberColumn = !this.main.configValues.lineNumberColumn;
        this.repaint();
    }

    private void testMaxMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void MaxDocMenuItemActionPerformed(ActionEvent actionEvent) {
    }

    private void linePanelMenuItemActionPerformed(ActionEvent actionEvent) {
        this.main.configValues.lineNumberColumn = !this.main.configValues.lineNumberColumn;
        this.repaint();
    }

    private void formMousePressed(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void formMouseReleased(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void doTest() {
        if (this.textComp != null) {
            // empty if block
        }
    }

    public void toggleLineNumbers() {
        this.main.configValues.lineNumberColumn = !this.main.configValues.lineNumberColumn;
        this.repaint();
    }

    public void toggleLineWrap() {
        if (this.textComp == null) {
            return;
        }
        boolean bl = this.textComp.getLineWrap();
        this.textComp.setLineWrap(!bl);
    }

    public void handleMouse(MouseEvent mouseEvent) {
        int n;
        int n2;
        if (this.main.haveFocus) {
            this.textComp.rfiw();
        }
        if ((mouseEvent.getModifiers() & 0x10) == 0 && (n2 = this.textComp.getSelectionStart()) == (n = this.textComp.getSelectionEnd())) {
            Point point = new Point(mouseEvent.getX(), mouseEvent.getY());
            int n3 = this.textComp.viewToModel(point);
            this.textComp.setCaretPosition(n3);
        }
        if (mouseEvent.isPopupTrigger() && !this.main.processRightClick(mouseEvent, this)) {
            this.main.getDocPopup(this.plainText).show((JComponent)((Object)this.textComp), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public void onActivation() {
        this.main.currentSelectedDocument = this;
        if (this.main.haveFocus) {
            this.textComp.rfiw();
        }
        if (this.needInit) {
            this.needInit = false;
        }
    }

    private void onDeactivation() {
        this.main.updateStatusBar("");
    }

    public void toggleEOLMarks() {
        this.main.configValues.paintEOLMarks = !this.main.configValues.paintEOLMarks;
        this.repaint();
    }
}

