/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachConstants;
import Arachnophilia.Arachnophilia;
import Arachnophilia.EscapeUnescapeStringHandler;
import Arachnophilia.FieldData;
import Arachnophilia.SearchReplace;
import Arachnophilia.SyntaxStyleData;
import Arachnophilia.TextInputDialog;
import JArachTextArea.SyntaxStyle;
import JArachTextArea.TextAreaDefaults;
import MacroManager.MacroTreeNodeData;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.RandomAccessFile;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class ArachComp {
    static Arachnophilia main;
    static SearchReplace search;

    private ArachComp() {
    }

    public static void setMain(Arachnophilia arachnophilia) {
        main = arachnophilia;
    }

    public static String wrapTag(String string, String string2) {
        return "<" + string2 + ">" + string + "</" + string2 + ">";
    }

    public static String wrapTag(String string, String string2, String string3) {
        return "<" + string2 + " " + string3 + ">" + string + "</" + string2 + ">";
    }

    public static String getTabString() {
        return ArachComp.main.configValues.useSpacesForTabs ? ArachComp.makeSpaceTab() : "\t";
    }

    public static String makeSpaceTab() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < ArachComp.main.configValues.tabSize; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    static boolean isHexDigit(char c) {
        return Character.isDigit(c) || "abcdef".indexOf(Character.toLowerCase(c)) != -1;
    }

    static int scanLeftForHexDigits(String string, int n) {
        while (n >= 0 && ArachComp.isHexDigit(string.charAt(n))) {
            --n;
        }
        return n + 1;
    }

    static int scanRightForHexDigits(String string, int n) {
        int n2 = string.length();
        while (n < n2 && ArachComp.isHexDigit(string.charAt(n))) {
            ++n;
        }
        return n;
    }

    public static String colorIntToString(int n) {
        String string = Integer.toHexString(n & 0xFFFFFF);
        while (string.length() < 6) {
            string = "0" + string;
        }
        return string;
    }

    static int colorStringToInt(String string) {
        while (string.length() > 0 && ArachComp.isHexDigit(string.charAt(0))) {
            string = string.substring(1);
        }
        int n = 0;
        try {
            n = Integer.parseInt(string, 16);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n & 0xFFFFFF;
    }

    public static ImageIcon loadIcon(String string) {
        URL uRL = main.getClass().getResource(string);
        if (uRL != null) {
            return new ImageIcon(uRL);
        }
        return null;
    }

    public static String dashedLine(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append("-");
        }
        return stringBuffer.toString();
    }

    public static int getMax(String string, int n) {
        int n2 = string.length();
        return n > n2 ? n : n2;
    }

    public static String doPostTab(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        n -= string.length();
        while (n-- > -2) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static String doPreTab(int n, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static MacroTreeNodeData getDataForPath(TreePath treePath) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        if (treePath != null && (defaultMutableTreeNode = ArachComp.getNodeForPath(treePath)) != null) {
            return (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
        }
        return null;
    }

    public static String getStringForNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        String string = ArachComp.getPathForNode(defaultMutableTreeNode).toString();
        string = search.srchRplc(string, ", ", ",");
        return string;
    }

    public static DefaultMutableTreeNode getNodeForPath(TreePath treePath) {
        return (DefaultMutableTreeNode)treePath.getLastPathComponent();
    }

    public static TreePath getPathForNode(DefaultMutableTreeNode defaultMutableTreeNode) {
        return new TreePath(defaultMutableTreeNode.getPath());
    }

    public static String getStringForPath(TreePath treePath) {
        String string = treePath.toString();
        string = search.srchRplc(string, ", ", ",");
        return string;
    }

    public static String editValueDialog(Component component, String string, String string2, String string3) {
        TextInputDialog textInputDialog = new TextInputDialog(main);
        String string4 = textInputDialog.showDialog(string, string2, string3);
        if (string4 != null) {
            string3 = string4;
        }
        return string3;
    }

    public static String[][] getLookAndFeelNames() {
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
        String[][] stringArray = new String[2][lookAndFeelInfoArray.length];
        for (int i = 0; i < lookAndFeelInfoArray.length; ++i) {
            stringArray[0][i] = lookAndFeelInfoArray[i].getClassName();
            stringArray[1][i] = lookAndFeelInfoArray[i].getName();
        }
        return stringArray;
    }

    public static void setupLookAndFeel(String string) {
        if (string.length() > 0) {
            try {
                UIManager.setLookAndFeel(string);
                SwingUtilities.updateComponentTreeUI(main);
                ArachComp.main.configValues.lookAndFeelName = string;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            try {
                String string2 = UIManager.getSystemLookAndFeelClassName();
                UIManager.setLookAndFeel(string2);
                SwingUtilities.updateComponentTreeUI(main);
                ArachComp.main.configValues.lookAndFeelName = string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void setProgramFont(Font font) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = uIDefaults.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            Font font2 = uIDefaults.getFont(k);
            if (font2 == null) continue;
            Font font3 = font;
            vector.add(k);
            vector.add(font);
        }
        uIDefaults.putDefaults(vector.toArray());
    }

    public static void resetFont(Component component, Font font) {
        component.setFont(font);
        if (component instanceof Container && component.getClass().getName().indexOf("JArachTextArea") == -1) {
            Component[] componentArray = ((Container)component).getComponents();
            if (component instanceof JMenu) {
                componentArray = ((JMenu)component).getMenuComponents();
            }
            for (int i = 0; i < componentArray.length; ++i) {
                ArachComp.resetFont(componentArray[i], font);
            }
        }
    }

    public static void buildNewOpenMenus(JComponent jComponent) {
        JMenu jMenu = new JMenu("New");
        jMenu.setToolTipText("Create a new document");
        jMenu.setIcon(ArachComp.loadIcon("/Icons/New.gif"));
        ArachComp.makeNewMenu(jMenu);
        jComponent.add(jMenu);
        JMenu jMenu2 = new JMenu("Open ...");
        jMenu2.setIcon(ArachComp.loadIcon("/Icons/Open.gif"));
        jMenu2.setToolTipText("Open an existing document");
        ArachComp.makeOpenMenu(jMenu2);
        jComponent.add(jMenu2);
    }

    public static void makeOpenMenu(JComponent jComponent) {
        for (int i = 0; i < ArachComp.main.fileTypes.fileTypeNames.length; ++i) {
            boolean bl = ArachComp.main.fileTypes.fileTypeNames[i].equals("All");
            if (!bl && ArachComp.main.fileTypes.markerClassNames[i].length() <= 0) continue;
            final int n = i;
            String string = bl ? "(List all files)" : ArachComp.main.fileTypes.fileTypeNames[i] + " file";
            JMenuItem jMenuItem = new JMenuItem(string);
            jComponent.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    main.promptDoc(n);
                }
            });
        }
    }

    public static void makeNewMenu(JComponent jComponent) {
        for (int i = 0; i < ArachComp.main.fileTypes.fileTypeNames.length; ++i) {
            if (ArachComp.main.fileTypes.markerClassNames[i].length() <= 0) continue;
            final int n = i;
            JMenuItem jMenuItem = new JMenuItem(ArachComp.main.fileTypes.fileTypeNames[i] + " file");
            jComponent.add(jMenuItem);
            jMenuItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    main.newDoc(n, true);
                }
            });
        }
    }

    public static void readCustomValues(TextAreaDefaults textAreaDefaults) {
        SyntaxStyle[] syntaxStyleArray = textAreaDefaults.styles;
        for (int i = 0; i < ArachConstants.styleConstants.length; ++i) {
            Object object = ArachComp.main.initFileHandler.readSymbolicObject(ArachComp.main.configValues, ArachConstants.styleNames[i]);
            SyntaxStyleData syntaxStyleData = (SyntaxStyleData)object;
            syntaxStyleArray[ArachConstants.styleConstants[i]] = new SyntaxStyle(new Color(syntaxStyleData.color), syntaxStyleData.italic, syntaxStyleData.bold);
        }
    }

    public static void startProgressBar(JProgressBar jProgressBar, long l, long l2, long l3) {
        if (jProgressBar != null) {
            jProgressBar.setMinimum((int)l);
            jProgressBar.setMaximum((int)l2);
            jProgressBar.setValue((int)l2);
        }
    }

    public static void updateProgressBar(JProgressBar jProgressBar, long l) {
        if (jProgressBar != null) {
            jProgressBar.setValue((int)l);
        }
    }

    public static void stopProgressBar(JProgressBar jProgressBar) {
        if (jProgressBar != null) {
            jProgressBar.setValue(jProgressBar.getMinimum());
        }
    }

    public static String pathFromFullPath(String string) {
        int n = string.lastIndexOf(ArachConstants.SYSTEM_FILESEP);
        if (n != -1) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String nameFromFullPath(String string) {
        int n = string.lastIndexOf(ArachConstants.SYSTEM_FILESEP);
        if (n != -1) {
            return string.substring(n + 1);
        }
        return string;
    }

    private static String changeLineEndingsToPlatform(String string, String string2) {
        if (!string2.equals("\n")) {
            string = string.replaceAll("\n", string2);
        }
        return string;
    }

    public static String toJavaLineEndings(String string) {
        if (string != null) {
            if (string.indexOf("\r\n") != -1) {
                string = string.replaceAll("\r\n", "\n");
            } else if (string.indexOf("\r") != -1) {
                string = string.replaceAll("\r", "\n");
            }
        }
        return string;
    }

    public static String createRelativePath(String string, String string2) {
        string = string.replace('\\', '/');
        string2 = string2.replace('\\', '/');
        int n = string.length();
        int n2 = string2.length();
        int n3 = 0;
        for (int i = 0; i < n && i < n2 && string.charAt(i) == string2.charAt(i); ++i) {
            if (string.charAt(i) != '/') continue;
            n3 = i;
        }
        string = string.substring(n3 + 1);
        string2 = string2.substring(n3 + 1);
        String string3 = "";
        int n4 = 0;
        while ((n4 = string2.indexOf(47, n4)) != -1) {
            ++n4;
            string3 = string3 + "../";
        }
        return string3 + string;
    }

    public static Vector loadDataVector(String string) {
        Vector<String> vector = null;
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            vector = new Vector<String>();
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim()).length() <= 0) continue;
                int n = string2.indexOf(59);
                if (n != -1) {
                    string2 = string2.substring(0, n).trim();
                }
                if (string2.length() <= 0) continue;
                string2 = EscapeUnescapeStringHandler.unescapeString(string2);
                vector.add(string2);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(main, "I/O problem with required file: \n" + string, "Data File Reading", 0);
            exception.printStackTrace();
        }
        return vector;
    }

    public static Hashtable loadParserData(String string) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            while ((string2 = bufferedReader.readLine()) != null) {
                if ((string2 = string2.trim().toLowerCase()).length() <= 0) continue;
                int n = string2.indexOf(59);
                if (n != -1) {
                    string2 = string2.substring(0, n).trim();
                }
                if (string2.length() <= 0) continue;
                int n2 = (string2 = EscapeUnescapeStringHandler.unescapeString(string2)).indexOf(9);
                if (n2 != -1) {
                    hashtable.put(string2.substring(0, n2), string2.substring(n2 + 1));
                    continue;
                }
                hashtable.put(string2, "");
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(main, "I/O problem with required file: \n" + string, "Data File Reading", 0);
            exception.printStackTrace();
        }
        return hashtable;
    }

    public static long getLastModifiedTime(String string) {
        return new File(string).lastModified();
    }

    public static String readProgramFile(String string, boolean bl) {
        return ArachComp.readFileCore(string, bl, "ISO-8859-1");
    }

    public static String readDataFile(String string, boolean bl) {
        return ArachComp.readFileCore(string, bl, ArachComp.main.configValues.fileEncoding);
    }

    static String detectCharacterError(Exception exception) {
        String string = "";
        String string2 = exception.toString();
        if (string2.matches("(?i).*java\\.nio\\.charset.*")) {
            string = "\nNOTE: Be sure to check for correspondence between\n";
            string = string + "the character encoding of the file being processed\n";
            string = string + "and your selection at menu item \"File ... Character Encoding\".\n\n";
            string = string + "(If in doubt, go to menu item \"File ... Character Encoding\"\n";
            string = string + "and select UTF-8.)\n";
        }
        return string;
    }

    public static String readFileCore(String string, boolean bl, String string2) {
        String string3;
        block6: {
            string3 = null;
            if (string.length() > 0) {
                try {
                    Charset charset = Charset.forName(string2);
                    CharsetDecoder charsetDecoder = charset.newDecoder();
                    FileInputStream fileInputStream = new FileInputStream(new File(string));
                    FileChannel fileChannel = fileInputStream.getChannel();
                    int n = (int)fileChannel.size();
                    if (n > 0) {
                        MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n);
                        CharBuffer charBuffer = charsetDecoder.decode(mappedByteBuffer);
                        charsetDecoder.flush(charBuffer);
                        string3 = charBuffer.toString();
                        mappedByteBuffer.clear();
                        charBuffer.clear();
                        mappedByteBuffer = null;
                        charBuffer = null;
                    } else {
                        string3 = "";
                    }
                    fileChannel.close();
                    fileInputStream.close();
                    System.gc();
                    string3 = ArachComp.toJavaLineEndings(string3);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    if (!bl) break block6;
                    String string4 = "Unable to read file \n\"" + string + "\"\n" + exception.toString() + "\n";
                    if (string.indexOf("template.") != -1) {
                        string4 = string4 + "\nIf this is a template file,\nyou may need to create one for the file type\nyou are opening, and place it in directory\n" + ArachComp.main.basePath + "/Templates\n" + "(not all supported file types have creation\n" + "templates by default).";
                    }
                    string4 = string4 + ArachComp.detectCharacterError(exception);
                    JOptionPane.showMessageDialog(main, string4, "File Read Error", 0);
                }
            }
        }
        return string3;
    }

    public static boolean writeProgramFile(String string, String string2, boolean bl) {
        return ArachComp.writeFileCore(string, string2, bl, true, "ISO-8859-1");
    }

    public static boolean writeDataFile(String string, String string2, boolean bl) {
        return ArachComp.writeFileCore(string, string2, bl, false, ArachComp.main.configValues.fileEncoding);
    }

    private static boolean writeFileCore(String string, String string2, boolean bl, boolean bl2, String string3) {
        boolean bl3;
        block2: {
            bl3 = false;
            try {
                string2 = bl2 ? ArachComp.toSystemLineEndings(string2) : ArachComp.toCustomLineEndings(string2);
                Charset charset = Charset.forName(string3);
                CharsetEncoder charsetEncoder = charset.newEncoder();
                CharBuffer charBuffer = CharBuffer.wrap(string2.toCharArray());
                ByteBuffer byteBuffer = charsetEncoder.encode(charBuffer);
                charsetEncoder.flush(byteBuffer);
                FileOutputStream fileOutputStream = new FileOutputStream(new File(string));
                FileChannel fileChannel = fileOutputStream.getChannel();
                fileChannel.write(byteBuffer);
                fileChannel.close();
                fileOutputStream.close();
                byteBuffer.clear();
                charBuffer.clear();
                byteBuffer = null;
                charBuffer = null;
                System.gc();
                bl3 = true;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                if (!bl) break block2;
                String string4 = "Unable to write file \n\"" + string + "\"\n" + exception.toString() + "\n";
                string4 = string4 + ArachComp.detectCharacterError(exception);
                JOptionPane.showMessageDialog(main, string4, "File Write Error", 0);
            }
        }
        return bl3;
    }

    public static String toSystemLineEndings(String string) {
        if (string != null) {
            string = ArachComp.changeLineEndingsToPlatform(string, ArachConstants.SYSTEM_EOL);
        }
        return string;
    }

    public static String toCustomLineEndings(String string) {
        if (string != null) {
            String string2 = ArachConstants.SYSTEM_EOL;
            if (ArachComp.main.configValues != null) {
                string2 = EscapeUnescapeStringHandler.unescapeString(ArachComp.main.configValues.fileSaveEOL);
            }
            string = ArachComp.changeLineEndingsToPlatform(string, string2);
        }
        return string;
    }

    public static String padChar(String string, int n, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        n -= string.length();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(string2);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static String padChar(int n, int n2, String string) {
        return ArachComp.padChar("" + n, n2, string);
    }

    public static String padString(String string, int n, int n2) {
        int n3;
        int n4 = string.length();
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < n; ++n3) {
            stringBuffer.append(' ');
        }
        n3 = n2 == 0 ? 0 : (n2 == 1 ? (n - n4) / 2 : n - n4);
        n3 = n3 < 0 ? 0 : n3;
        stringBuffer.replace(n3, n3 + n4, string);
        return stringBuffer.toString();
    }

    public static String escapeXMLContent(String string) {
        string = EscapeUnescapeStringHandler.escapeString(string);
        string = search.srchRplc(string, "&", "&amp;", true);
        string = search.srchRplc(string, "<", "&lt;", true);
        string = search.srchRplc(string, ">", "&gt;", true);
        return string;
    }

    public static String unescapeXMLContent(String string) {
        string = EscapeUnescapeStringHandler.unescapeString(string);
        string = search.srchRplc(string, "&lt;", "<", true);
        string = search.srchRplc(string, "&gt;", ">", true);
        string = search.srchRplc(string, "&amp;", "&", true);
        return string;
    }

    public static void tweakFont(Component component) {
        component.setFont(new Font("Monospaced", component.getFont().getStyle(), component.getFont().getSize()));
    }

    public static Container getFrameParent(Container container) {
        while (container != null && !(container instanceof Frame)) {
            container = container.getParent();
        }
        return container;
    }

    public static String mergeDelimLine(Vector vector, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append((String)vector.elementAt(i) + (i < n - 1 ? string : ""));
        }
        return stringBuffer.toString();
    }

    static int skipWS(String string, int n) {
        while (Character.isWhitespace(string.charAt(n)) && n < string.length()) {
            ++n;
        }
        return n;
    }

    static FieldData getWSField(String string, int n) {
        int n2 = n = ArachComp.skipWS(string, n);
        while (n < string.length() && !Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        String string2 = string.substring(n2, n);
        return new FieldData(string2, n);
    }

    static Vector parseLine(String string) {
        string = string.trim();
        Vector<String> vector = new Vector<String>();
        int n = 0;
        while (n < string.length()) {
            FieldData fieldData = ArachComp.getWSField(string, n);
            n = fieldData.pos;
            vector.add(fieldData.field);
        }
        return vector;
    }

    public static Vector parseDelimLine(String string, String string2, boolean bl) {
        String string3;
        int n;
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        int n3 = string2.length();
        while ((n = string.indexOf(string2, n2)) != -1) {
            string3 = string.substring(n2, n);
            if (bl) {
                string3 = string3.trim();
            }
            vector.addElement(string3);
            n2 = n + n3;
        }
        if (n2 <= string.length()) {
            string3 = string.substring(n2);
            if (bl) {
                string3 = string3.trim();
            }
            vector.addElement(string3);
        }
        return vector;
    }

    public static Vector parseDelimLine(String string, String string2) {
        return ArachComp.parseDelimLine(string, string2, false);
    }

    static long fileDate(String string) {
        long l = 0L;
        File file = new File(string);
        if (file != null) {
            l = file.lastModified();
        }
        return l;
    }

    static long fileSize(String string) {
        long l = 0L;
        File file = new File(string);
        if (file != null) {
            l = file.length();
        }
        return l;
    }

    private static String readNonWSChars(RandomAccessFile randomAccessFile) {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            char c;
            while (Character.isWhitespace(c = (char)randomAccessFile.readByte())) {
            }
            while (!Character.isWhitespace(c)) {
                stringBuffer.append(c);
                c = (char)randomAccessFile.readByte();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return stringBuffer.toString();
    }

    public static String[] extractAllRegexMatches(String string, Pattern pattern) {
        Vector<String> vector = new Vector<String>();
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            vector.add(matcher.group());
        }
        return vector.toArray(new String[0]);
    }

    static {
        search = new SearchReplace();
    }
}

