/*
 * Decompiled with CFR 0.152.
 */
package ConsoleWindow;

import Arachnophilia.Arachnophilia;
import Arachnophilia.MyJButton;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Timer;

public class ConsoleWindow
extends JFrame {
    Arachnophilia main;
    InputStream is;
    InputStream es;
    OutputStream os;
    Timer timer;
    int displayPos = 0;
    private JPanel jPanel1;
    private JButton jButton1;
    private JScrollPane jScrollPane1;
    private JPopupMenu popupMenu;
    private JMenuItem jMenuItem1;
    private JTextArea display;

    public ConsoleWindow(Arachnophilia arachnophilia, Process process) {
        this.main = arachnophilia;
        this.initComponents();
        this.setTitle("Arachnophilia 5.4 System Console Window");
        this.setIconImage(arachnophilia.getIconImage());
        Rectangle rectangle = this.main.getBounds();
        int n = rectangle.width / 8;
        int n2 = rectangle.height / 8;
        this.setBounds(rectangle.x + n, rectangle.y + n2, rectangle.width - n * 2, rectangle.height - n2 * 2);
        this.setVisible(true);
        this.is = process.getInputStream();
        this.es = process.getErrorStream();
        this.os = process.getOutputStream();
        this.timer = new Timer(20, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleWindow.this.readStream(ConsoleWindow.this.is);
                ConsoleWindow.this.readStream(ConsoleWindow.this.es);
            }
        });
        this.timer.start();
        this.display.requestFocus();
    }

    private void readStream(InputStream inputStream) {
        try {
            int n = inputStream.available();
            if (n > 0) {
                byte[] byArray = new byte[n];
                inputStream.read(byArray);
                String string = new String(byArray);
                this.display.append(string);
                this.displayPos = this.display.getDocument().getLength();
                this.display.setCaretPosition(this.displayPos);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.display = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jButton1 = new MyJButton();
        this.jMenuItem1.setText("Toggle line wrap");
        this.jMenuItem1.setToolTipText("Choose between wrapped and unwrapped text");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleWindow.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.jMenuItem1);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                ConsoleWindow.this.exitForm(windowEvent);
            }
        });
        this.display.setFont(new Font("Monospaced", 0, 12));
        this.display.addKeyListener(new KeyAdapter(){

            public void keyTyped(KeyEvent keyEvent) {
                ConsoleWindow.this.displayKeyTyped(keyEvent);
            }

            public void keyPressed(KeyEvent keyEvent) {
                ConsoleWindow.this.displayKeyPressed(keyEvent);
            }

            public void keyReleased(KeyEvent keyEvent) {
                ConsoleWindow.this.displayKeyReleased(keyEvent);
            }
        });
        this.display.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ConsoleWindow.this.displayMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ConsoleWindow.this.displayMouseReleased(mouseEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.display);
        this.getContentPane().add((Component)this.jScrollPane1, "Center");
        this.jButton1.setText("Close");
        this.jButton1.setToolTipText("Close this window");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConsoleWindow.this.jButton1ActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.jButton1);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        this.toggleLineWrap();
    }

    private void displayMouseReleased(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void displayMousePressed(MouseEvent mouseEvent) {
        this.handleMouse(mouseEvent);
    }

    private void jButton1ActionPerformed(ActionEvent actionEvent) {
        this.doClose();
    }

    private void displayKeyReleased(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
    }

    private void displayKeyPressed(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
    }

    private void displayKeyTyped(KeyEvent keyEvent) {
        this.handleKey(keyEvent);
    }

    private void exitForm(WindowEvent windowEvent) {
        this.doClose();
    }

    private void toggleLineWrap() {
        this.display.setLineWrap(!this.display.getLineWrap());
        this.display.setWrapStyleWord(true);
    }

    private void handleMouse(MouseEvent mouseEvent) {
        if (this.popupMenu.isPopupTrigger(mouseEvent)) {
            this.popupMenu.show(this.display, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void doClose() {
        this.timer.stop();
        this.setVisible(false);
        this.dispose();
    }

    private void handleKey(KeyEvent keyEvent) {
        char c;
        if (keyEvent.getID() == 401 && (c = keyEvent.getKeyChar()) != '\uffff') {
            try {
                if (c == '\n') {
                    int n = this.display.getCaretPosition();
                    String string = this.display.getDocument().getText(this.displayPos, n - this.displayPos);
                    string = string + c;
                    this.os.write(string.getBytes());
                    this.os.flush();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

