/*
 * Decompiled with CFR 0.152.
 */
package RTFConverter;

import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import RTFConverter.HTMLStateMachine;
import java.io.StringReader;
import javax.swing.JOptionPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.rtf.RTFEditorKit;

public class RTFConverter {
    public void convertRTFToHTML(Arachnophilia arachnophilia) {
        ArachDocument arachDocument = arachnophilia.currentSelectedDocument;
        if (arachDocument != null) {
            int n = arachnophilia.fileTypes.getFileTypeForName("RTF");
            if (arachDocument.getFileType() == n) {
                HTMLStateMachine hTMLStateMachine = new HTMLStateMachine();
                String string = arachDocument.textComp.getText();
                string = string.replaceAll("&", "&amp;");
                string = string.replaceAll("<", "&lt;");
                string = string.replaceAll(">", "&gt;");
                string = this.convertRTFStringToHTML(string, hTMLStateMachine);
                arachnophilia.createHTMLDocForRTFConversion(string);
            } else {
                JOptionPane.showMessageDialog(arachnophilia, "The source for this conversion must be an RTF-formatted document.", "Source not RTF Document", 2);
            }
        }
    }

    private String convertRTFStringToHTML(String string, HTMLStateMachine hTMLStateMachine) {
        RTFEditorKit rTFEditorKit = new RTFEditorKit();
        DefaultStyledDocument defaultStyledDocument = new DefaultStyledDocument();
        this.readString(string, defaultStyledDocument, rTFEditorKit);
        string = this.scanDocument(defaultStyledDocument, hTMLStateMachine);
        return string;
    }

    private void readString(String string, Document document, RTFEditorKit rTFEditorKit) {
        try {
            rTFEditorKit.read(new StringReader(string), document, 0);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String scanDocument(Document document, HTMLStateMachine hTMLStateMachine) {
        String string = "";
        try {
            StringBuffer stringBuffer = new StringBuffer();
            Element element = document.getDefaultRootElement();
            this.recurseElements(element, document, stringBuffer, hTMLStateMachine);
            hTMLStateMachine.closeTags(stringBuffer);
            string = stringBuffer.toString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string;
    }

    private void recurseElements(Element element, Document document, StringBuffer stringBuffer, HTMLStateMachine hTMLStateMachine) {
        for (int i = 0; i < element.getElementCount(); ++i) {
            Element element2 = element.getElement(i);
            this.scanAttributes(element2, document, stringBuffer, hTMLStateMachine);
            this.recurseElements(element2, document, stringBuffer, hTMLStateMachine);
        }
    }

    private void scanAttributes(Element element, Document document, StringBuffer stringBuffer, HTMLStateMachine hTMLStateMachine) {
        try {
            int n = element.getStartOffset();
            int n2 = element.getEndOffset();
            String string = document.getText(n, n2 - n);
            AttributeSet attributeSet = element.getAttributes();
            hTMLStateMachine.updateState(attributeSet, stringBuffer, element);
            String string2 = element.getName();
            if (string2.equalsIgnoreCase("content")) {
                StringBuffer stringBuffer2 = new StringBuffer();
                for (int i = 0; i < string.length(); ++i) {
                    char c = string.charAt(i);
                    if (c == '\u0403' && i < string.length() - 1) {
                        char c2 = string.charAt(++i);
                        System.out.println((int)c2);
                        switch (c2) {
                            case 'e': {
                                stringBuffer2.append("&lsquo;");
                                break;
                            }
                            case 'f': {
                                stringBuffer2.append("&rsquo;");
                                break;
                            }
                            case 'g': {
                                stringBuffer2.append("&ldquo;");
                                break;
                            }
                            case 'h': {
                                stringBuffer2.append("&rdquo;");
                                break;
                            }
                            default: {
                                stringBuffer2.append(c);
                                stringBuffer2.append(c2);
                                break;
                            }
                        }
                        continue;
                    }
                    stringBuffer2.append(c);
                }
                string = stringBuffer2.toString();
                string = string.replaceAll("\\t", hTMLStateMachine.getSpaceTab(8));
                string = string.replaceAll("\\n", "<br/>\n");
                string = hTMLStateMachine.performFirstLineIndent(string);
                stringBuffer.append(string);
            }
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
        }
    }
}

