/*
 * Decompiled with CFR 0.152.
 */
package MacroManager;

import Arachnophilia.ArachComp;
import Arachnophilia.Arachnophilia;
import MacroManager.MacroTreeNodeData;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;

public final class MenuManager {
    Arachnophilia main;
    Vector comList;
    int comIndex;
    TreeMap macroMap;

    public MenuManager(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
    }

    public TreeMap buildMenus(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.main.getMenu("").removeAll();
        this.main.getMenu("_SyntaxDocPopup").removeAll();
        this.main.getMenu("_PlainDocPopup").removeAll();
        this.main.getMenu("_RootPopup").removeAll();
        this.comList = new Vector();
        this.comIndex = 0;
        this.macroMap = new TreeMap();
        this.buildMenusRecursive(null, defaultMutableTreeNode, this.comIndex, this.macroMap);
        this.main.getMenu("").updateUI();
        this.main.getMenu("_SyntaxDocPopup").updateUI();
        this.main.getMenu("_PlainDocPopup").updateUI();
        this.main.getMenu("_RootPopup").updateUI();
        return this.macroMap;
    }

    private int buildMenusRecursive(JComponent jComponent, DefaultMutableTreeNode defaultMutableTreeNode, int n, TreeMap treeMap) {
        DefaultMutableTreeNode defaultMutableTreeNode2 = null;
        int n2 = defaultMutableTreeNode.getChildCount();
        for (int i = 0; i < n2; ++i) {
            JComponent jComponent2;
            Object object;
            defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i);
            MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode2.getUserObject();
            if (macroTreeNodeData.isHidden) continue;
            boolean bl = defaultMutableTreeNode2.getChildCount() > 0;
            String string = macroTreeNodeData.title;
            if (bl) {
                object = null;
                if (jComponent != null) {
                    object = new JMenu();
                    this.setupItem((JComponent)object, macroTreeNodeData);
                    jComponent.add((Component)object);
                    n = this.buildMenusRecursive((JComponent)object, defaultMutableTreeNode2, n, treeMap);
                    continue;
                }
                if (macroTreeNodeData.isMenu) {
                    object = new JMenu();
                    this.setupItem((JComponent)object, macroTreeNodeData);
                    jComponent2 = this.main.getMenu(string);
                    if (jComponent2 instanceof JPopupMenu) {
                        object = (JPopupMenu)jComponent2;
                    } else {
                        jComponent2.add((Component)object);
                    }
                }
                n = this.buildMenusRecursive((JComponent)object, defaultMutableTreeNode2, n, treeMap);
                continue;
            }
            if (!(macroTreeNodeData.isHidden || macroTreeNodeData.isMenu || macroTreeNodeData.isToolBar || macroTreeNodeData.isSeparator)) {
                object = ArachComp.getStringForNode(defaultMutableTreeNode2);
                treeMap.put(object, defaultMutableTreeNode2);
            }
            if (jComponent == null) continue;
            if (macroTreeNodeData.isSeparator) {
                if (jComponent instanceof JPopupMenu) {
                    ((JPopupMenu)jComponent).addSeparator();
                    continue;
                }
                ((JMenu)jComponent).addSeparator();
                continue;
            }
            object = macroTreeNodeData.content.toLowerCase();
            if (((String)object).indexOf("[buildnewopenmenus]") != -1 || ((String)object).indexOf("[locatefilelist]") != -1) {
                this.main.comSwitchboard.exec(macroTreeNodeData.content, 0, jComponent);
                continue;
            }
            jComponent2 = new JMenuItem();
            this.setupItem(jComponent2, macroTreeNodeData);
            n = this.addHook(n, (AbstractButton)jComponent2, macroTreeNodeData.content);
            jComponent.add(jComponent2);
        }
        return n;
    }

    private void setupItem(JComponent jComponent, MacroTreeNodeData macroTreeNodeData) {
        if (jComponent != null && !(jComponent instanceof JPopupMenu)) {
            AbstractButton abstractButton = (AbstractButton)jComponent;
            String string = macroTreeNodeData.title;
            try {
                if (macroTreeNodeData.keyboardHook != null && macroTreeNodeData.keyboardHook.isValid()) {
                    if (jComponent instanceof JMenuItem) {
                        ((JMenuItem)abstractButton).setAccelerator(KeyStroke.getKeyStroke(macroTreeNodeData.keyboardHook.getKeyCode(), macroTreeNodeData.keyboardHook.getModifiers()));
                    } else if (jComponent instanceof JMenu) {
                        abstractButton.setMnemonic(macroTreeNodeData.keyboardHook.getKeyCode());
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            abstractButton.setText(string);
            if (macroTreeNodeData.toolTip.length() > 0) {
                abstractButton.setToolTipText(macroTreeNodeData.toolTip);
            }
            if (macroTreeNodeData.imageIcon != null) {
                abstractButton.setIcon(macroTreeNodeData.imageIcon);
            }
        }
    }

    private int addHook(int n, AbstractButton abstractButton, String string) {
        final int n2 = n;
        abstractButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MenuManager.this.execCom(n2);
            }
        });
        this.comList.add(string);
        return n + 1;
    }

    private void execCom(int n) {
        if (n >= 0 && n < this.comList.size()) {
            this.main.macroHandler.executeCommand((String)this.comList.get(n));
        }
    }
}

