/*
 * Decompiled with CFR 0.152.
 */
package FilePicker;

import Arachnophilia.ArachConstants;
import Arachnophilia.MyJButton;
import Arachnophilia.MyJPopupMenu;
import Arachnophilia.TextInputDialog;
import FilePicker.GraphicPreviewPanel;
import FilePicker.TableNoEdit;
import FileTypes.FileTypes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.Document;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public final class PickerPanel
extends JPanel {
    public static final int PREVIEW_NONE = 0;
    public static final int PREVIEW_TEXT = 1;
    public static final int PREVIEW_GRAPHIC = 2;
    Container parent;
    JFrame pframe;
    FileSystemView fsv;
    boolean modal = true;
    boolean saveMode = false;
    String fileName;
    DefaultMutableTreeNode baseNode;
    DefaultTreeModel model;
    File currentDir;
    File treeSelectedFile = null;
    File listSelectedFile = null;
    File[] currentFileList;
    File[] selectedFileList = null;
    File textFile = null;
    Icon branchIcon;
    Icon openBranchIcon;
    Icon theLeafIcon;
    Icon driveIcon;
    int fileTableColumnZeroWidth;
    Font defaultFont;
    GraphicPreviewPanel graphicPreviewPanel;
    File[] fileSystemRoots;
    FileTypes ft;
    String configPath = ".";
    private boolean documentChanged = false;
    Hashtable fileListHash = null;
    boolean needinit = true;
    boolean textQuery = false;
    int textFilePosition = 0;
    public static final int ACCEPT = 1;
    public static final int CANCEL = 0;
    public static final int FILES_ONLY = 0;
    public static final int FILES_AND_DIRECTORIES = 1;
    public static final int DIRECTORIES_ONLY = 2;
    private int displayMode = 1;
    private int response = 0;
    private JMenuItem Delete;
    private JLabel NoPreviewLabel;
    private JMenuItem Rename;
    private JMenuItem Rename1;
    private JPanel bottomPanel;
    private JButton cancelButton;
    private JPanel centerPanel;
    private JCheckBox editCheckBox;
    private JPanel editTopPane;
    private JPanel fileListSurround;
    private JTextField fileNameField;
    private JPopupMenu filePopupMenu;
    private JTextField fileSelectedField;
    private JTextField fileStatsField;
    private JPanel fileStatsPane;
    private JTable fileTable;
    private JComboBox fileTypeBox;
    private JMenuItem flipColorMenuItem;
    private JPopupMenu graphicPopupMenu;
    private JButton homeButton;
    private JSplitPane horizSplitPane;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JMenuItem lineWrapMenuItem;
    private JMenuItem newFolder;
    private JMenuItem newTextFile;
    private JButton openButton;
    private JTextField pathField;
    private JTree pathTree;
    private JMenuItem refreshMenuItem;
    private JMenuItem saveMenuItem;
    private JMenuItem selectAllMenuItem;
    private JSplitPane splitPane;
    private JTabbedPane tabbedPane;
    private JScrollPane tableScrollPane;
    private JPanel tableSurround;
    private JPanel textEditPane;
    private JPopupMenu textPopupMenu;
    private JTextArea textPreviewArea;
    private JTextField textSearchField;
    private JPanel topPanel;
    private JPopupMenu treePopupMenu;
    private JButton upButton;
    private JMenuItem upOneLevelMenuItem;

    public PickerPanel(String string, Container container, JFrame jFrame, File file, int n) {
        FileTypes fileTypes = new FileTypes("All");
        this.PickerPanelInit(string, container, jFrame, file, fileTypes, 0, n);
    }

    public PickerPanel(String string, Container container, JFrame jFrame, File file, FileTypes fileTypes, int n) {
        this.PickerPanelInit(string, container, jFrame, file, fileTypes, 0, n);
    }

    public PickerPanel(String string, Container container, JFrame jFrame, File file, FileTypes fileTypes, int n, int n2) {
        this.PickerPanelInit(string, container, jFrame, file, fileTypes, n, n2);
    }

    public void PickerPanelInit(String string, Container container, JFrame jFrame, File file, FileTypes fileTypes, int n, int n2) {
        this.displayMode = n2;
        this.parent = container;
        this.pframe = jFrame;
        this.fsv = FileSystemView.getFileSystemView();
        this.configPath = string;
        if (fileTypes == null) {
            fileTypes = new FileTypes(string, "All");
        }
        this.ft = fileTypes;
        this.setLayout(new BorderLayout());
        this.initComponents();
        this.upButton.setIcon(new ImageIcon(this.getClass().getResource("/Icons/FolderOut.gif")));
        this.homeButton.setIcon(new ImageIcon(this.getClass().getResource("/Icons/Home.gif")));
        this.pathTree.getSelectionModel().setSelectionMode(1);
        if (!this.modal) {
            this.getContentPane().remove(this.bottomPanel);
        }
        this.currentDir = this.getFileForUnknown(file);
        this.graphicPreviewPanel = new GraphicPreviewPanel();
        this.graphicPreviewPanel.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                PickerPanel.this.showGraphicPopupMenu(mouseEvent);
            }

            public void mousePressed(MouseEvent mouseEvent) {
                PickerPanel.this.showGraphicPopupMenu(mouseEvent);
            }
        });
        this.tabbedPane.addTab("Graphics", this.graphicPreviewPanel);
        this.tabbedPane.setTitleAt(0, "Preview: None");
        this.tabbedPane.setTitleAt(1, "Text");
        DefaultTableModel defaultTableModel = new DefaultTableModel();
        this.fileTable.setModel(defaultTableModel);
        this.addMouseListenerToHeaderInTable(this.fileTable);
        this.defaultFont = new Font("Monospaced", 0, 12);
        this.pathTree.setFont(this.defaultFont);
        this.fileTable.setFont(this.defaultFont);
        this.centerPanel.setBackground(this.fileTable.getBackground());
        this.fileListSurround.setBackground(this.fileTable.getBackground());
        this.splitPane.setBackground(this.fileTable.getBackground());
        this.horizSplitPane.setBackground(this.fileTable.getBackground());
        this.jScrollPane1.setBackground(this.pathTree.getBackground());
        this.tableSurround.setBackground(this.fileTable.getBackground());
        this.tableScrollPane.setColumnHeaderView(this.fileTable.getTableHeader());
        this.tableScrollPane.getVerticalScrollBar().setUnitIncrement(16);
        this.tabbedPane.setFont(this.defaultFont);
        this.fileNameField.setFont(this.defaultFont);
        this.pathField.setFont(this.defaultFont);
        this.fileStatsField.setFont(this.defaultFont);
        this.fileSelectedField.setFont(this.defaultFont);
        this.textPreviewArea.setFont(this.defaultFont);
        this.textPreviewArea.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent documentEvent) {
                PickerPanel.this.handleTextChanged();
            }

            public void insertUpdate(DocumentEvent documentEvent) {
                PickerPanel.this.handleTextChanged();
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                PickerPanel.this.handleTextChanged();
            }
        });
        DefaultTreeCellRenderer defaultTreeCellRenderer = new DefaultTreeCellRenderer();
        this.branchIcon = new ImageIcon(this.getClass().getResource("/Icons/Folder.gif"));
        this.openBranchIcon = new ImageIcon(this.getClass().getResource("/Icons/Open.gif"));
        this.theLeafIcon = new ImageIcon(this.getClass().getResource("/Icons/List.gif"));
        this.driveIcon = new ImageIcon(this.getClass().getResource("/Icons/Data.gif"));
        int n3 = this.branchIcon.getIconHeight();
        int n4 = this.theLeafIcon.getIconHeight();
        int n5 = n3 > n4 ? n3 : n4;
        n5 = n5 < 4 ? 4 : n5;
        n3 = this.branchIcon.getIconWidth();
        n4 = this.theLeafIcon.getIconWidth();
        this.fileTableColumnZeroWidth = (n3 > n4 ? n3 : n4) + 8;
        this.fileTable.setRowHeight(n5);
        this.pathTree.setRowHeight(n5);
        this.setupTableListener(this.fileTable);
        this.setupFileTypeList();
        this.setNewPath(this.currentDir);
        this.setPreviewMode(n);
    }

    private void handleTextChanged() {
        this.documentChanged = true;
    }

    public void addMouseListenerToHeaderInTable(JTable jTable) {
        final JTable jTable2 = jTable;
        jTable2.setColumnSelectionAllowed(false);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = jTable2.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = jTable2.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    PickerPanel.this.showList(n2);
                }
            }
        };
        JTableHeader jTableHeader = jTable2.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
    }

    public int showAsDialog(Component component, boolean bl) {
        this.saveMode = bl;
        if (this.saveMode) {
            this.openButton.setText("Save");
            this.fileTable.setSelectionMode(0);
            this.pathTree.getSelectionModel().setSelectionMode(1);
        }
        component.setVisible(true);
        return this.response;
    }

    private void setupTableListener(JTable jTable) {
        ListSelectionModel listSelectionModel = jTable.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
                if (!listSelectionModel.isSelectionEmpty()) {
                    PickerPanel.this.doTableValueChanged();
                }
            }
        });
    }

    private void setupFileTypeList() {
        for (int i = 0; i < this.ft.fileTypeNames.length; ++i) {
            this.fileTypeBox.addItem(this.ft.getDescription(i));
        }
        this.fileTypeBox.setSelectedIndex(this.ft.getFileType());
    }

    public void setFileName(String string) {
        this.fileName = string;
        this.fileNameField.setText(this.fileName);
    }

    public File[] getSelectedFiles() {
        return this.selectedFileList;
    }

    public File getSelectedFile() {
        if (this.selectedFileList != null && this.selectedFileList.length > 0) {
            return this.selectedFileList[0];
        }
        return null;
    }

    public int getResponse() {
        return this.response;
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.needinit) {
            this.needinit = false;
            this.splitPane.setDividerLocation(0.3333333333333333);
        }
    }

    private JPanel getContentPane() {
        return this;
    }

    private void pack() {
    }

    public int accept() {
        return this.response;
    }

    private void setNewPath(File file) {
        this.fileListHash = new Hashtable();
        this.currentDir = file;
        this.baseNode = new DefaultMutableTreeNode(this.currentDir);
        this.model = new DefaultTreeModel(this.baseNode);
        this.pathTree.setModel(this.model);
        this.pathTree.setCellRenderer(new MyTreeCellRenderer());
        this.setupPath(this.baseNode, false);
        this.doPreview();
    }

    private void refreshPath() {
        boolean bl = false;
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.pathTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode == null) {
            this.pathTree.setSelectionRow(0);
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.pathTree.getLastSelectedPathComponent();
            bl = true;
        }
        TreePath treePath = this.pathTree.getSelectionPath();
        this.setupPath(defaultMutableTreeNode, true);
        DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)this.pathTree.getLastSelectedPathComponent();
        if (defaultMutableTreeNode2 != null && defaultMutableTreeNode2.getUserObject() instanceof File) {
            File file = (File)defaultMutableTreeNode2.getUserObject();
            if (!file.exists()) {
                treePath = this.pathTree.getPathForRow(0);
                bl = true;
            }
        } else {
            bl = true;
        }
        if (bl) {
            this.doTreeValueChanged();
        }
        this.pathTree.expandPath(treePath);
        this.pathTree.setSelectionPath(treePath);
        this.pathTree.treeDidChange();
        this.pathTree.invalidate();
        this.showList(-1);
    }

    private void setupPath(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        DefaultMutableTreeNode defaultMutableTreeNode2;
        File file = (File)defaultMutableTreeNode.getUserObject();
        if (!file.isDirectory() && (defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()) != null) {
            defaultMutableTreeNode = defaultMutableTreeNode2;
        }
        this.scanDir(defaultMutableTreeNode, bl);
        if (!bl) {
            this.pathTree.setSelectionRow(0);
            this.doTreeValueChanged();
        }
    }

    private void scanDir(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        this.scanDirCore(defaultMutableTreeNode, bl);
        if (!(defaultMutableTreeNode.getUserObject() instanceof File)) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)this.pathTree.getLastSelectedPathComponent();
        }
        this.treeSelectedFile = this.getFilePath(defaultMutableTreeNode);
    }

    private FileData getFileList(File file, boolean bl, boolean bl2, boolean bl3) {
        FileData fileData = null;
        if (file != null && file.exists() && file.isDirectory()) {
            if (!bl && this.fileListHash.containsKey(file)) {
                fileData = (FileData)this.fileListHash.get(file);
                if (!fileData.needFileScan) {
                    return fileData;
                }
            }
            if (bl || fileData == null) {
                fileData = new FileData();
            }
            if (bl || fileData.needFileScan) {
                fileData.list = this.fsv.getFiles(file, false);
                if (fileData.list != null) {
                    Vector<File> vector = new Vector<File>();
                    for (int i = 0; i < fileData.list.length; ++i) {
                        if (!this.ft.accept(fileData.list[i])) continue;
                        vector.add(fileData.list[i]);
                    }
                    fileData.list = vector.toArray(new File[0]);
                    this.sortFileData(fileData, fileData.sortType);
                    fileData.needFileScan = false;
                }
                if (bl2 && fileData != null) {
                    this.fileListHash.put(file, fileData);
                }
            }
        }
        return fileData;
    }

    private void sortFileData(FileData fileData, int n) {
        fileData.sortType = n;
        if (fileData.sortedType == fileData.sortType) {
            fileData.reverseSort = !fileData.reverseSort;
        }
        compareDirEntries compareDirEntries2 = new compareDirEntries(fileData.sortType, fileData.reverseSort);
        Arrays.sort(fileData.list, compareDirEntries2);
        fileData.sortedType = fileData.sortType;
    }

    private void scanDirCore(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        if (defaultMutableTreeNode != null) {
            DefaultMutableTreeNode defaultMutableTreeNode2 = null;
            boolean bl2 = false;
            FileData fileData = null;
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof File) {
                fileData = this.getFileList((File)object, bl, true, false);
            }
            if (fileData != null) {
                int n;
                int n2 = defaultMutableTreeNode.getChildCount();
                int n3 = fileData.list.length;
                int n4 = 0;
                for (n = 0; n < n3; ++n) {
                    File file = fileData.list[n];
                    if (!this.fsv.isTraversable(file).booleanValue()) continue;
                    defaultMutableTreeNode2 = new DefaultMutableTreeNode(file);
                    if (bl) {
                        if (!defaultMutableTreeNode.isNodeChild(defaultMutableTreeNode2)) {
                            defaultMutableTreeNode.add(defaultMutableTreeNode2);
                            ++n2;
                            bl2 = true;
                        }
                    } else {
                        defaultMutableTreeNode.add(defaultMutableTreeNode2);
                        ++n2;
                        bl2 = true;
                    }
                    ++n4;
                }
                for (n = n2 - 1; n >= n4; --n) {
                    defaultMutableTreeNode.remove(n);
                    bl2 = true;
                }
            }
            if (bl2) {
                this.model.reload(defaultMutableTreeNode);
            }
        }
    }

    private void initComponents() {
        this.textPopupMenu = new MyJPopupMenu();
        this.lineWrapMenuItem = new JMenuItem();
        this.saveMenuItem = new JMenuItem();
        this.treePopupMenu = new MyJPopupMenu();
        this.upOneLevelMenuItem = new JMenuItem();
        this.newFolder = new JMenuItem();
        this.Rename1 = new JMenuItem();
        this.refreshMenuItem = new JMenuItem();
        this.filePopupMenu = new MyJPopupMenu();
        this.newTextFile = new JMenuItem();
        this.selectAllMenuItem = new JMenuItem();
        this.Rename = new JMenuItem();
        this.Delete = new JMenuItem();
        this.graphicPopupMenu = new MyJPopupMenu();
        this.flipColorMenuItem = new JMenuItem();
        this.centerPanel = new JPanel();
        this.splitPane = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.pathTree = new JTree();
        this.horizSplitPane = new JSplitPane();
        this.fileListSurround = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.tableSurround = new JPanel();
        this.fileTable = new TableNoEdit();
        this.fileStatsPane = new JPanel();
        this.jLabel5 = new JLabel();
        this.fileStatsField = new JTextField();
        this.jLabel6 = new JLabel();
        this.fileSelectedField = new JTextField();
        this.tabbedPane = new JTabbedPane();
        this.NoPreviewLabel = new JLabel();
        this.textEditPane = new JPanel();
        this.jScrollPane3 = new JScrollPane();
        this.textPreviewArea = new JTextArea();
        this.editTopPane = new JPanel();
        this.jLabel1 = new JLabel();
        this.textSearchField = new JTextField();
        this.editCheckBox = new JCheckBox();
        this.topPanel = new JPanel();
        this.jLabel4 = new JLabel();
        this.pathField = new JTextField();
        this.upButton = new MyJButton();
        this.homeButton = new MyJButton();
        this.bottomPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.fileNameField = new JTextField();
        this.openButton = new MyJButton();
        this.jLabel3 = new JLabel();
        this.fileTypeBox = new JComboBox();
        this.cancelButton = new MyJButton();
        this.lineWrapMenuItem.setText("Line Wrap");
        this.lineWrapMenuItem.setToolTipText("Enable/disable line wrap");
        this.lineWrapMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.lineWrapMenuItemActionPerformed(actionEvent);
            }
        });
        this.textPopupMenu.add(this.lineWrapMenuItem);
        this.saveMenuItem.setText("Save file");
        this.saveMenuItem.setToolTipText("Save changes to this text document");
        this.saveMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.saveMenuItemActionPerformed(actionEvent);
            }
        });
        this.textPopupMenu.add(this.saveMenuItem);
        this.upOneLevelMenuItem.setText("Up one level");
        this.upOneLevelMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.upOneLevelMenuItemActionPerformed(actionEvent);
            }
        });
        this.treePopupMenu.add(this.upOneLevelMenuItem);
        this.newFolder.setText("New Folder");
        this.newFolder.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.newFolderActionPerformed(actionEvent);
            }
        });
        this.treePopupMenu.add(this.newFolder);
        this.Rename1.setText("Rename");
        this.Rename1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.Rename1ActionPerformed(actionEvent);
            }
        });
        this.treePopupMenu.add(this.Rename1);
        this.refreshMenuItem.setIcon(new ImageIcon(this.getClass().getResource("/Icons/ThumbUp.gif")));
        this.refreshMenuItem.setText("Refresh Display");
        this.refreshMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.refreshMenuItemActionPerformed(actionEvent);
            }
        });
        this.treePopupMenu.add(this.refreshMenuItem);
        this.newTextFile.setText("New Text File");
        this.newTextFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.newTextFileActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.newTextFile);
        this.selectAllMenuItem.setText("Select All");
        this.selectAllMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.selectAllMenuItemActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.selectAllMenuItem);
        this.Rename.setText("Rename");
        this.Rename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.RenameActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.Rename);
        this.Delete.setIcon(new ImageIcon(this.getClass().getResource("/Icons/DocumentDelete.gif")));
        this.Delete.setText("Delete Item(s)");
        this.Delete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.DeleteActionPerformed(actionEvent);
            }
        });
        this.filePopupMenu.add(this.Delete);
        this.flipColorMenuItem.setText("Switch Background Colors");
        this.flipColorMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.flipColorMenuItemActionPerformed(actionEvent);
            }
        });
        this.graphicPopupMenu.add(this.flipColorMenuItem);
        this.setLayout(new BorderLayout());
        this.centerPanel.setLayout(new BorderLayout());
        this.splitPane.setOneTouchExpandable(true);
        this.pathTree.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PickerPanel.this.pathTreeMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PickerPanel.this.pathTreeMouseReleased(mouseEvent);
            }
        });
        this.pathTree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            }

            public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
                PickerPanel.this.pathTreeTreeExpanded(treeExpansionEvent);
            }
        });
        this.pathTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                PickerPanel.this.pathTreeValueChanged(treeSelectionEvent);
            }
        });
        this.jScrollPane1.setViewportView(this.pathTree);
        this.splitPane.setLeftComponent(this.jScrollPane1);
        this.horizSplitPane.setOrientation(0);
        this.horizSplitPane.setOneTouchExpandable(true);
        this.horizSplitPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent componentEvent) {
                PickerPanel.this.horizSplitPaneComponentResized(componentEvent);
            }
        });
        this.fileListSurround.setLayout(new BorderLayout());
        this.tableScrollPane.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PickerPanel.this.tableScrollPaneMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PickerPanel.this.tableScrollPaneMouseReleased(mouseEvent);
            }
        });
        this.fileTable.setAutoResizeMode(0);
        this.fileTable.setIntercellSpacing(new Dimension(0, 0));
        this.fileTable.setShowHorizontalLines(false);
        this.fileTable.setShowVerticalLines(false);
        this.fileTable.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PickerPanel.this.fileTableMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PickerPanel.this.fileTableMouseReleased(mouseEvent);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                PickerPanel.this.fileTableMouseClicked(mouseEvent);
            }
        });
        this.tableSurround.add(this.fileTable);
        this.tableScrollPane.setViewportView(this.tableSurround);
        this.fileListSurround.add((Component)this.tableScrollPane, "Center");
        this.fileStatsPane.setLayout(new GridBagLayout());
        this.jLabel5.setHorizontalAlignment(2);
        this.jLabel5.setText("Listed:");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.fileStatsPane.add((Component)this.jLabel5, gridBagConstraints);
        this.fileStatsField.setToolTipText("Directory Information");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.fileStatsPane.add((Component)this.fileStatsField, gridBagConstraints);
        this.jLabel6.setHorizontalAlignment(2);
        this.jLabel6.setText("Selected:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.fileStatsPane.add((Component)this.jLabel6, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.fileStatsPane.add((Component)this.fileSelectedField, gridBagConstraints);
        this.fileListSurround.add((Component)this.fileStatsPane, "South");
        this.horizSplitPane.setLeftComponent(this.fileListSurround);
        this.tabbedPane.setTabPlacement(3);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                PickerPanel.this.tabbedPaneStateChanged(changeEvent);
            }
        });
        this.NoPreviewLabel.setHorizontalAlignment(0);
        this.NoPreviewLabel.setText("No Preview");
        this.tabbedPane.addTab("jLabel7", null, this.NoPreviewLabel, "");
        this.textEditPane.setLayout(new BorderLayout());
        this.textPreviewArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                PickerPanel.this.textPreviewAreaMousePressed(mouseEvent);
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                PickerPanel.this.textPreviewAreaMouseReleased(mouseEvent);
            }
        });
        this.jScrollPane3.setViewportView(this.textPreviewArea);
        this.textEditPane.add((Component)this.jScrollPane3, "Center");
        this.editTopPane.setLayout(new GridBagLayout());
        this.jLabel1.setText("Search:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.editTopPane.add((Component)this.jLabel1, gridBagConstraints);
        this.textSearchField.setToolTipText("Type for instant search, press \"Enter\" for next");
        this.textSearchField.setMinimumSize(new Dimension(32, 21));
        this.textSearchField.setPreferredSize(new Dimension(64, 21));
        this.textSearchField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PickerPanel.this.textSearchFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.editTopPane.add((Component)this.textSearchField, gridBagConstraints);
        this.editCheckBox.setText("Edit Document");
        this.editCheckBox.setToolTipText("Activate edit mode for this file");
        this.editCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.editCheckBoxActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.editTopPane.add((Component)this.editCheckBox, gridBagConstraints);
        this.textEditPane.add((Component)this.editTopPane, "North");
        this.tabbedPane.addTab("jPanel1", null, this.textEditPane, "");
        this.horizSplitPane.setRightComponent(this.tabbedPane);
        this.splitPane.setRightComponent(this.horizSplitPane);
        this.centerPanel.add((Component)this.splitPane, "Center");
        this.add((Component)this.centerPanel, "Center");
        this.topPanel.setLayout(new GridBagLayout());
        this.jLabel4.setText("Path:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.topPanel.add((Component)this.jLabel4, gridBagConstraints);
        this.pathField.setToolTipText("Current directory path");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.topPanel.add((Component)this.pathField, gridBagConstraints);
        this.upButton.setToolTipText("Up one level");
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.upButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.topPanel.add((Component)this.upButton, gridBagConstraints);
        this.homeButton.setToolTipText("Go to user's home directory");
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.homeButtonActionPerformed(actionEvent);
            }
        });
        this.topPanel.add((Component)this.homeButton, new GridBagConstraints());
        this.add((Component)this.topPanel, "North");
        this.bottomPanel.setLayout(new GridBagLayout());
        this.jLabel2.setText("File:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.jLabel2, gridBagConstraints);
        this.fileNameField.setToolTipText("Currently selected file(s)");
        this.fileNameField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                PickerPanel.this.fileNameFieldKeyReleased(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.fileNameField, gridBagConstraints);
        this.openButton.setText("Open");
        this.openButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.openButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.openButton, gridBagConstraints);
        this.jLabel3.setText("Files of type:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.jLabel3, gridBagConstraints);
        this.fileTypeBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                PickerPanel.this.fileTypeBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.fileTypeBox, gridBagConstraints);
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PickerPanel.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.bottomPanel.add((Component)this.cancelButton, gridBagConstraints);
        this.add((Component)this.bottomPanel, "South");
    }

    private void Rename1ActionPerformed(ActionEvent actionEvent) {
        this.renameDirectory();
    }

    private void homeButtonActionPerformed(ActionEvent actionEvent) {
        this.goToUserHomeDir();
    }

    private void editCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.textEditEnable();
    }

    private void fileTableMouseClicked(MouseEvent mouseEvent) {
        this.handleMouseClick(mouseEvent);
    }

    private void horizSplitPaneComponentResized(ComponentEvent componentEvent) {
        this.handleTabChangeEvent();
    }

    private void pathTreeMousePressed(MouseEvent mouseEvent) {
        this.showTreePopupMenu(mouseEvent);
    }

    private void fileTableMousePressed(MouseEvent mouseEvent) {
        this.showFilePopupMenu(mouseEvent, this.fileTable);
    }

    private void textPreviewAreaMousePressed(MouseEvent mouseEvent) {
        this.showTextPopupMenu(mouseEvent);
    }

    private void tableScrollPaneMousePressed(MouseEvent mouseEvent) {
        this.showFilePopupMenu(mouseEvent, this.tableScrollPane);
    }

    private void fileTypeBoxItemStateChanged(ItemEvent itemEvent) {
        this.changeFileType();
    }

    private void selectAllMenuItemActionPerformed(ActionEvent actionEvent) {
        this.selectAllFromFileTable();
    }

    private void upOneLevelMenuItemActionPerformed(ActionEvent actionEvent) {
        this.ascendPath();
    }

    private void refreshMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setNewPath(this.currentDir);
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(false);
    }

    private void openButtonActionPerformed(ActionEvent actionEvent) {
        this.doClose(true);
    }

    private void DeleteActionPerformed(ActionEvent actionEvent) {
        this.doDeleteItems();
    }

    private void tableScrollPaneMouseReleased(MouseEvent mouseEvent) {
        this.showFilePopupMenu(mouseEvent, this.tableScrollPane);
    }

    private void newFolderActionPerformed(ActionEvent actionEvent) {
        this.createNewFolder();
    }

    private void newTextFileActionPerformed(ActionEvent actionEvent) {
        this.createNewTextFile();
    }

    private void RenameActionPerformed(ActionEvent actionEvent) {
        this.doRename();
    }

    private void textPreviewAreaMouseReleased(MouseEvent mouseEvent) {
        this.showTextPopupMenu(mouseEvent);
    }

    private void textSearchFieldKeyReleased(KeyEvent keyEvent) {
        this.incrementalTextSearch(keyEvent);
    }

    private void upButtonActionPerformed(ActionEvent actionEvent) {
        this.ascendPath();
    }

    private void flipColorMenuItemActionPerformed(ActionEvent actionEvent) {
        this.graphicPreviewPanel.flipBackground();
    }

    private void pathTreeMouseReleased(MouseEvent mouseEvent) {
        this.showTreePopupMenu(mouseEvent);
    }

    private void fileTableMouseReleased(MouseEvent mouseEvent) {
        this.showFilePopupMenu(mouseEvent, this.fileTable);
    }

    private void saveMenuItemActionPerformed(ActionEvent actionEvent) {
        this.testSaveFile();
    }

    private void lineWrapMenuItemActionPerformed(ActionEvent actionEvent) {
        this.textPreviewArea.setLineWrap(!this.textPreviewArea.getLineWrap());
        this.textPreviewArea.setWrapStyleWord(true);
    }

    private void tabbedPaneStateChanged(ChangeEvent changeEvent) {
        this.setPreviewMode(this.tabbedPane.getSelectedIndex());
    }

    private void pathTreeTreeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.doTreeExpanded(treeExpansionEvent);
    }

    private void pathTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
        this.doTreeValueChanged();
    }

    private void fileNameFieldKeyReleased(KeyEvent keyEvent) {
        int n = keyEvent.getKeyCode();
        if (n == 10 && this.fileNameField.getText().length() > 0 && this.saveMode) {
            this.doClose(true);
        }
    }

    private void goToUserHomeDir() {
        this.setNewPath(new File(ArachConstants.USERHOME));
    }

    public void setPreviewMode(int n) {
        this.tabbedPane.setSelectedIndex(n);
        this.handleTabChangeEvent();
        this.doPreview();
    }

    public void changeFileType() {
        int n;
        if (!this.needinit && (n = this.fileTypeBox.getSelectedIndex()) != this.ft.getFileType()) {
            this.ft.setFileType(n);
            this.fileListHash = new Hashtable();
            this.showList(-1);
        }
    }

    private void selectAllFromFileTable() {
        this.fileTable.selectAll();
    }

    private void doClose(boolean bl) {
        if (bl) {
            this.response = 1;
            if (this.selectedFileList == null) {
                this.doTreeValueChangedCore();
            }
            if (this.saveMode && this.selectedFileList != null && this.selectedFileList.length > 0) {
                String string = this.fileNameField.getText();
                File file = this.selectedFileList[0];
                if (file.isDirectory() && string.length() > 0) {
                    this.selectedFileList[0] = new File(file.getPath(), string);
                } else if (this.selectedFileList.length == 1 && !file.getName().equals(string)) {
                    this.selectedFileList[0] = new File(this.fsv.getParentDirectory(this.selectedFileList[0]), string);
                }
            }
        } else {
            this.response = 0;
        }
        if (this.modal) {
            this.parent.setVisible(false);
        }
    }

    private void wrongSelectionDialog(boolean bl) {
        JOptionPane.showMessageDialog(this, bl ? "Too many items have been selected." : "No items have been selected.", "File/Dialog operations", 0);
    }

    private void notFolderDialog() {
        JOptionPane.showMessageDialog(this, "A folder must be selected.", "File/Dialog operations", 0);
    }

    private void doDeleteItems() {
        this.selectedFileList = null;
        this.testFileSelection();
        if (this.selectedFileList != null && this.selectedFileList.length > 0) {
            int n = 0;
            boolean bl = false;
            for (int i = 0; i < this.selectedFileList.length; ++i) {
                File file = this.selectedFileList[i];
                boolean bl2 = true;
                if (!bl) {
                    String string = file.isDirectory() ? "directory" : "file";
                    String string2 = "Warning - " + string + " deletion \n\n";
                    Object[] objectArray = new Object[]{"Yes to All", "Yes", "No", "Cancel"};
                    int n2 = JOptionPane.showOptionDialog(this, string2.toUpperCase() + "Okay to delete " + string + " \n" + "\"" + file.getPath() + "\"", "Delete " + string, -1, 2, null, objectArray, objectArray[2]);
                    if (n2 == 0) {
                        bl = true;
                    } else if (n2 > 1) {
                        bl2 = false;
                    }
                } else {
                    bl2 = true;
                }
                if (!bl2) continue;
                boolean bl3 = file.delete();
                if (bl3) {
                    ++n;
                    continue;
                }
                JOptionPane.showMessageDialog(this, "Deletion of \n\"" + file.getPath() + "\"\n" + "failed.\n" + "If this is a directory, it must be empty.\n" + "If this is a file, you must have write permission.", "Delete failed", 0);
            }
            if (n > 0) {
                this.selectedFileList = this.deleteMissingItems(this.selectedFileList);
                this.refreshPath();
            }
        } else {
            this.wrongSelectionDialog(false);
        }
    }

    private File[] deleteMissingItems(File[] fileArray) {
        Vector<File> vector = new Vector<File>();
        if (fileArray != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                if (fileArray[i] == null || !fileArray[i].exists()) continue;
                vector.add(fileArray[i]);
            }
            fileArray = vector.toArray(new File[0]);
        }
        return fileArray;
    }

    private void createNewTextFile() {
        if (this.treeSelectedFile != null) {
            String string;
            File file;
            int n = 0;
            while ((file = new File(this.treeSelectedFile, string = "NewText" + ++n + ".txt")).exists()) {
            }
            try {
                file.createNewFile();
                this.refreshPath();
                int n2 = this.ft.getFileType();
                if (n2 != this.ft.getFileTypeForName("Text") && n2 != this.ft.getFileTypeForName("All")) {
                    JOptionPane.showMessageDialog(this, "You have created a new text file, but it will not be visible\nbecause filename filtering is in effect. To see the file,\nChoose \"All Files (*.*)\" for the file type at the bottom\nof the file picker dialog.", "Text File Creation", 0);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.notFolderDialog();
        }
    }

    private void renameDirectory() {
        if (this.treeSelectedFile != null) {
            TextInputDialog textInputDialog = new TextInputDialog(this.pframe);
            String string = this.treeSelectedFile.getName();
            String string2 = textInputDialog.showDialog("File/Dialog operations", "Enter new directory name:", string);
            if (string2 != null && !string2.equals(string)) {
                File file = new File(this.treeSelectedFile.getParent(), string2);
                if (!file.exists()) {
                    this.treeSelectedFile.renameTo(file);
                    this.setNewPath(file);
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void createNewFolder() {
        if (this.treeSelectedFile != null) {
            String string;
            File file;
            int n = 0;
            while ((file = new File(this.treeSelectedFile, string = "NewFolder" + ++n)).exists()) {
            }
            try {
                file.mkdir();
                this.setNewPath(this.treeSelectedFile);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.notFolderDialog();
        }
    }

    private void doRename() {
        this.selectedFileList = null;
        this.testFileSelection();
        if (this.selectedFileList != null && this.selectedFileList.length == 1) {
            File file = this.selectedFileList[0];
            if (!file.isDirectory()) {
                TextInputDialog textInputDialog = new TextInputDialog(this.pframe);
                String string = file.getName();
                String string2 = textInputDialog.showDialog("File/Dialog operations", "Enter new file name:", string);
                if (string2 != null && !string2.equals(string)) {
                    File file2 = new File(file.getParent(), string2);
                    if (!file2.exists()) {
                        file.renameTo(file2);
                        this.refreshPath();
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        } else if (this.selectedFileList != null && this.selectedFileList.length > 1) {
            this.wrongSelectionDialog(true);
        } else {
            this.wrongSelectionDialog(false);
        }
    }

    private int findText(String string, int n, boolean bl, Document document) {
        int n2;
        block5: {
            n2 = -1;
            try {
                int n3 = document.getLength();
                int n4 = string.length();
                n3 -= n4;
                if (bl) {
                    for (int i = n; i < n3; ++i) {
                        if (!string.equals(document.getText(i, n4))) continue;
                        n2 = i;
                        break block5;
                    }
                    break block5;
                }
                for (int i = n; i < n3; ++i) {
                    if (!string.equalsIgnoreCase(document.getText(i, n4))) continue;
                    n2 = i;
                    break;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return n2;
    }

    private void incrementalTextSearch(KeyEvent keyEvent) {
        String string = this.textSearchField.getText();
        int n = 0;
        int n2 = keyEvent.getKeyCode();
        if (n2 == 10 || n2 == 114) {
            n = this.textFilePosition;
        } else {
            this.textFilePosition = 0;
        }
        int n3 = this.findText(string, this.textFilePosition, false, this.textPreviewArea.getDocument());
        int n4 = string.length();
        if (n3 == -1) {
            Toolkit.getDefaultToolkit().beep();
            n3 = 0;
            n4 = 0;
        }
        this.textPreviewArea.setCaretPosition(n3);
        this.textPreviewArea.moveCaretPosition(n3 + n4);
        this.textPreviewArea.getCaret().setSelectionVisible(true);
        this.textFilePosition = n3 + n4;
    }

    private void textEditEnable() {
        boolean bl;
        boolean bl2 = bl = this.editCheckBox.getSelectedObjects() != null;
        if (this.textFile != null) {
            this.testSaveFile();
        }
        if (bl && !this.textPreviewArea.isEditable() && this.listSelectedFile != null) {
            this.editCheckBox.setSelected(true);
            this.textPreviewArea.setEditable(true);
            this.textFile = this.listSelectedFile;
            this.requestFocus();
            this.textPreviewArea.requestFocus();
            this.documentChanged = false;
        }
    }

    private File getFileForUnknown(File file) {
        File file2 = new File(".");
        if (file != null) {
            file2 = new File(file.getPath());
        }
        try {
            file2 = file2.getCanonicalFile();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return file2;
    }

    File getRootDir(File file) {
        File file2;
        do {
            file2 = file;
        } while ((file = this.fsv.getParentDirectory(file)) != null);
        return file2;
    }

    private void ascendPath() {
        File file = this.fsv.getParentDirectory(this.currentDir);
        if (file != null) {
            this.setNewPath(file);
        }
    }

    private void showTextPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            ((MyJPopupMenu)this.textPopupMenu).show(this.textPreviewArea, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void showFilePopupMenu(MouseEvent mouseEvent, Component component) {
        if (mouseEvent.isPopupTrigger()) {
            ((MyJPopupMenu)this.filePopupMenu).show(component, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void handleMouseClick(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.doClose(true);
        }
    }

    private void showTreePopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            ((MyJPopupMenu)this.treePopupMenu).show(this.pathTree, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void showGraphicPopupMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            ((MyJPopupMenu)this.graphicPopupMenu).show(this.graphicPreviewPanel, mouseEvent.getX(), mouseEvent.getY());
        }
    }

    private void handleTabChangeEvent() {
        this.tabbedPane.invalidate();
        int n = this.tabbedPane.getSelectedIndex();
        if (n == 0) {
            Dimension dimension = this.horizSplitPane.getSize();
            Dimension dimension2 = this.tabbedPane.getSize();
            Dimension dimension3 = this.tabbedPane.getComponentAt(0).getSize();
            this.horizSplitPane.setDividerLocation(dimension.height - (dimension2.height - dimension3.height) - this.horizSplitPane.getDividerSize());
        } else {
            this.horizSplitPane.setDividerLocation(0.5);
        }
    }

    private void doPreview() {
        this.testSaveFile();
        int n = this.tabbedPane.getSelectedIndex();
        if (n == 1) {
            String string = this.readFile(this.listSelectedFile);
            if (string == null) {
                string = "\n\n\t*** No Preview Available ***";
            }
            this.textPreviewArea.setText(string);
            this.textPreviewArea.setCaretPosition(0);
            this.textPreviewArea.repaint();
        } else if (n == 2) {
            this.graphicPreviewPanel.loadGraphic(this.listSelectedFile);
        }
    }

    public void testSaveFile() {
        if (this.textPreviewArea.isEditable() && this.textFile != null && this.documentChanged) {
            String string = this.textPreviewArea.getText();
            this.queryWriteFile(this.textFile, string);
        }
        this.textPreviewArea.setEditable(false);
        this.textFile = null;
        this.documentChanged = false;
        this.editCheckBox.setSelected(false);
    }

    public void queryWriteFile(File file, String string) {
        int n;
        if (file != null && (n = JOptionPane.showConfirmDialog(this, "You have changed\n\"" + file.getPath() + "\"\nOkay to save?", "Save Edited File", 0)) == 0) {
            this.writeFile(file, string);
        }
    }

    public boolean writeFile(File file, String string) {
        boolean bl = false;
        try {
            if (file != null) {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                int n = string.length();
                bufferedWriter.write(string.toCharArray());
                bufferedWriter.close();
                bl = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    public String readFile(File file) {
        this.textFile = null;
        String string = null;
        try {
            if (file != null && !file.isDirectory()) {
                string = "Error: Unable to read \"" + file.getPath() + "\"";
                int n = (int)file.length();
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                char[] cArray = new char[n];
                bufferedReader.read(cArray);
                bufferedReader.close();
                string = new String(cArray);
                if (string.length() > 0) {
                    this.textFile = file;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    private void doTreeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        if (treePath != null) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            this.scanDir(defaultMutableTreeNode, false);
        }
    }

    private void doTableValueChanged() {
        int[] nArray = this.fileTable.getSelectedRows();
        if (nArray.length != 0) {
            this.selectedFileList = new File[nArray.length];
            String string = "";
            for (int i = 0; i < nArray.length; ++i) {
                this.selectedFileList[i] = (File)this.fileTable.getValueAt(nArray[i], 0);
            }
            this.updateFileStats();
            if (this.selectedFileList.length == 1) {
                this.listSelectedFile = this.selectedFileList[0];
            }
        }
        this.doPreview();
    }

    private void testFileSelection() {
        if (this.selectedFileList == null || this.selectedFileList.length == 0) {
            this.doTableValueChanged();
        }
    }

    private void doTreeValueChanged() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.pathTree.getLastSelectedPathComponent();
        this.treeSelectedFile = this.getFilePath(defaultMutableTreeNode);
        if (this.treeSelectedFile != null && this.treeSelectedFile.exists()) {
            this.pathField.setText(this.treeSelectedFile.getPath());
        } else {
            this.pathField.setText("");
        }
        this.showList(-1);
    }

    private void doTreeValueChangedCore() {
        int[] nArray = this.pathTree.getSelectionRows();
        if (nArray != null) {
            int n = nArray.length;
            this.selectedFileList = new File[n];
            for (int i = 0; i < n; ++i) {
                File file;
                TreePath treePath = this.pathTree.getPathForRow(nArray[i]);
                if (treePath == null) continue;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
                this.selectedFileList[i] = file = (File)defaultMutableTreeNode.getUserObject();
            }
        } else {
            this.selectedFileList = null;
        }
        this.updateFileStats();
    }

    private File getFilePath(DefaultMutableTreeNode defaultMutableTreeNode) {
        Object object;
        if (defaultMutableTreeNode != null && (object = defaultMutableTreeNode.getUserObject()) != null && object instanceof File) {
            return (File)object;
        }
        return null;
    }

    private void tweakWidth(String string, FontMetrics fontMetrics, int[] nArray, int n) {
        int n2 = fontMetrics.stringWidth(string) + 16;
        if (n2 > nArray[n]) {
            nArray[n] = n2;
        }
    }

    private Vector makeTableEntry(File file, FontMetrics fontMetrics, int[] nArray) {
        Vector<Object> vector = new Vector<Object>();
        String string = this.fsv.getSystemDisplayName(file).trim() + " ";
        String string2 = " ";
        String string3 = " ";
        if (!this.fsv.isDrive(file)) {
            string2 = String.valueOf(file.length()) + " ";
            Date date = new Date(file.lastModified());
            string3 = date.toString();
        }
        this.tweakWidth(string, fontMetrics, nArray, 1);
        this.tweakWidth(string2, fontMetrics, nArray, 2);
        this.tweakWidth(string3, fontMetrics, nArray, 3);
        vector.add(file);
        vector.add(string);
        vector.add(string2);
        vector.add(string3);
        return vector;
    }

    private void showSelectedList() {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.pathTree.getLastSelectedPathComponent();
        this.treeSelectedFile = this.getFilePath(defaultMutableTreeNode);
        this.doPreview();
    }

    private void showList(int n) {
        Serializable serializable;
        this.currentFileList = null;
        int n2 = 0;
        int n3 = 0;
        long l = 0L;
        if (this.treeSelectedFile != null && this.treeSelectedFile.exists()) {
            int n4;
            Object object;
            serializable = this.getFontMetrics(this.fileTable.getFont());
            int[] nArray = new int[]{0, 0, 0, 0};
            Vector<Vector> vector = new Vector<Vector>();
            if (this.fsv.isTraversable(this.treeSelectedFile).booleanValue()) {
                object = this.getFileList(this.treeSelectedFile, false, true, false);
                if (n != -1) {
                    this.sortFileData((FileData)object, n);
                }
                this.currentFileList = ((FileData)object).list;
                this.updateTree((FileData)object);
            } else {
                this.currentFileList = new File[1];
                this.currentFileList[0] = this.treeSelectedFile;
            }
            if (this.currentFileList != null && this.currentFileList.length > 0) {
                for (int i = 0; i < this.currentFileList.length; ++i) {
                    if (this.fsv.isTraversable(this.currentFileList[i]).booleanValue()) {
                        ++n3;
                        if (this.displayMode == 2 || this.displayMode == 1) {
                            vector.add(this.makeTableEntry(this.currentFileList[i], (FontMetrics)serializable, nArray));
                        }
                    } else {
                        ++n2;
                        if (this.displayMode == 0 || this.displayMode == 1) {
                            vector.add(this.makeTableEntry(this.currentFileList[i], (FontMetrics)serializable, nArray));
                        }
                    }
                    if (this.fsv.isDrive(this.currentFileList[i])) continue;
                    l += this.currentFileList[i].length();
                }
                object = new Vector();
                ((Vector)object).add("D/F");
                ((Vector)object).add("Name");
                ((Vector)object).add("Size");
                ((Vector)object).add("Modified");
                MyDefaultTableModel myDefaultTableModel = new MyDefaultTableModel(vector, (Vector)object);
                this.fileTable.setModel(myDefaultTableModel);
                int n5 = this.fileTable.getColumnModel().getColumnCount();
                for (int i = 0; i < this.fileTable.getColumnModel().getColumnCount(); ++i) {
                    TableColumn tableColumn = this.fileTable.getColumnModel().getColumn(i);
                    tableColumn.setCellRenderer(new MyTableCellRenderer());
                    tableColumn.setPreferredWidth(nArray[i]);
                }
            }
            if ((n4 = this.fileTable.getColumnModel().getColumnCount()) > 0) {
                this.fileTable.getColumnModel().getColumn(0).setMinWidth(this.fileTableColumnZeroWidth);
            }
            this.fileTable.revalidate();
            this.updateFileStats();
        }
        if (this.currentFileList == null || this.currentFileList.length == 0) {
            serializable = new DefaultTableModel();
            this.fileTable.setModel((TableModel)((Object)serializable));
            this.fileStatsField.setText("");
            this.fileSelectedField.setText("");
        }
    }

    private void updateTree(FileData fileData) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.pathTree.getLastSelectedPathComponent();
        for (int i = 0; i < fileData.list.length; ++i) {
            DefaultMutableTreeNode defaultMutableTreeNode2;
            if (!fileData.list[i].isDirectory() || defaultMutableTreeNode.isNodeChild(defaultMutableTreeNode2 = new DefaultMutableTreeNode(fileData.list[i]))) continue;
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
        }
    }

    private void updateFileStats() {
        this.selectedFileList = this.deleteMissingItems(this.selectedFileList);
        if (this.selectedFileList != null && this.selectedFileList.length > 0) {
            if (this.saveMode) {
                File file = this.selectedFileList[0];
                if (!this.fsv.isTraversable(file).booleanValue()) {
                    this.setFileName(this.fsv.getSystemDisplayName(file));
                }
            } else {
                this.fileName = "";
                for (int i = 0; i < this.selectedFileList.length; ++i) {
                    this.fileName = this.fileName + (i > 0 ? ";" : "") + this.fsv.getSystemDisplayName(this.selectedFileList[i]);
                }
                this.fileNameField.setText(this.fileName);
            }
        }
        this.fileStatsField.setText(this.formatStats(this.currentFileList));
        if (this.selectedFileList != null && this.selectedFileList.length > 0) {
            this.fileSelectedField.setText(this.formatStats(this.selectedFileList));
        }
    }

    private String formatStats(File[] fileArray) {
        String string = "";
        if (fileArray != null) {
            int n = 0;
            int n2 = 0;
            long l = 0L;
            for (int i = 0; i < fileArray.length; ++i) {
                if (this.fsv.isTraversable(fileArray[i]).booleanValue()) {
                    ++n2;
                } else {
                    ++n;
                }
                if (this.fsv.isDrive(fileArray[i])) continue;
                l += fileArray[i].length();
            }
            if (n > 0) {
                string = n + " files, ";
            }
            if (n2 > 0) {
                string = string + n2 + " folders, ";
            }
            string = string + l + " bytes";
        }
        return string;
    }

    class MyDefaultTableModel
    extends DefaultTableModel {
        MyDefaultTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        public boolean isCellEditable(int n, int n2) {
            return n2 == 1;
        }
    }

    final class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public MyTableCellRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object != null) {
                if (n2 == 0) {
                    boolean bl3;
                    File file = (File)object;
                    Icon icon = PickerPanel.this.branchIcon;
                    icon = PickerPanel.this.fsv.isDrive(file) ? PickerPanel.this.driveIcon : ((bl3 = file.isDirectory()) ? PickerPanel.this.branchIcon : PickerPanel.this.theLeafIcon);
                    this.setIcon(icon);
                } else {
                    String string = (String)object;
                    if (n2 == 2) {
                        this.setHorizontalAlignment(4);
                    }
                    this.setText(string);
                }
                this.setEnabled(jTable.isEnabled());
                this.setFont(jTable.getFont());
                if (bl) {
                    this.setBackground(jTable.getSelectionBackground());
                    this.setForeground(jTable.getSelectionForeground());
                } else {
                    this.setBackground(jTable.getBackground());
                    this.setForeground(jTable.getForeground());
                }
            }
            return this;
        }
    }

    class MyTreeCellRenderer
    extends DefaultTreeCellRenderer {
        MyTreeCellRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            if (object2 instanceof File) {
                File file = (File)object2;
                String string = PickerPanel.this.fsv.getSystemDisplayName(file).trim();
                if (string.length() == 0) {
                    string = file.getPath();
                }
                this.setText(string);
                Icon icon = PickerPanel.this.theLeafIcon;
                if (file.isDirectory()) {
                    Icon icon2 = icon = bl2 ? PickerPanel.this.openBranchIcon : PickerPanel.this.branchIcon;
                    if (PickerPanel.this.fsv.isDrive(file)) {
                        icon = PickerPanel.this.driveIcon;
                    }
                }
                this.setIcon(icon);
            }
            return this;
        }
    }

    class MyListCellRenderer
    extends DefaultListCellRenderer {
        MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
            this.setIcon(PickerPanel.this.driveIcon);
            return this;
        }
    }

    class compareDirEntries
    implements Comparator {
        int type;
        boolean reverse;

        compareDirEntries(int n, boolean bl) {
            this.type = n;
            this.reverse = bl;
        }

        public int compare(Object object, Object object2) {
            long l = this.compare2((File)object, (File)object2);
            int n = l > 0L ? 1 : (l < 0L ? -1 : 0);
            return this.reverse ? -n : n;
        }

        long compare2(File file, File file2) {
            if (this.type == 0) {
                return this.compareDirs(file, file2);
            }
            if (this.type == 1) {
                long l = this.compareDirs(file, file2);
                if (l != 0L) {
                    return l;
                }
                return file.getName().toLowerCase().compareTo(file2.getName().toLowerCase());
            }
            if (this.type == 2) {
                long l = this.compareDirs(file, file2);
                if (l != 0L) {
                    return l;
                }
                return file.length() - file2.length();
            }
            if (this.type == 3) {
                long l = this.compareDirs(file, file2);
                if (l != 0L) {
                    return l;
                }
                return file.lastModified() - file2.lastModified();
            }
            return 0L;
        }

        private long compareDirs(File file, File file2) {
            long l = file.isDirectory() ? 1L : 0L;
            long l2 = file2.isDirectory() ? 1L : 0L;
            return l2 - l;
        }
    }

    class FileData {
        public File[] list = null;
        public boolean needDirScan = true;
        public boolean needFileScan = true;
        public boolean hasChildDirs = false;
        public boolean reverseSort = false;
        public int sortType = 1;
        public int sortedType = -1;
    }
}

