/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class TextInputDialog
extends JDialog {
    boolean accept = false;
    boolean needInit = true;
    Frame parent;
    private JTextArea promptArea;
    private JTextField inputField;
    private JPanel jPanel1;
    private JButton OKButton;
    private JButton cancelButton;

    public TextInputDialog(Frame frame) {
        super(frame, true);
        this.parent = frame;
        this.initComponents();
        this.setFont(frame.getFont());
        this.promptArea.setFont(this.getFont());
        this.promptArea.setBackground(this.getContentPane().getBackground());
        this.inputField.setFont(this.getFont());
    }

    public String showDialog(String string, String string2, String string3) {
        this.setTitle(string);
        this.promptArea.setText(string2);
        this.pack();
        Rectangle rectangle = this.parent.getBounds();
        int n = rectangle.width / 4;
        int n2 = rectangle.height / 4;
        double d = Math.sqrt(string2.length());
        this.setBounds(rectangle.x + n, rectangle.y + n2, (int)(200.0 + 10.0 * d), (int)(100.0 + 10.0 * d));
        this.inputField.setText(string3);
        this.setVisible(true);
        if (this.accept) {
            return this.inputField.getText();
        }
        return null;
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (this.needInit) {
            this.needInit = false;
            this.inputField.grabFocus();
        }
    }

    private void initComponents() {
        this.promptArea = new JTextArea();
        this.inputField = new JTextField();
        this.jPanel1 = new JPanel();
        this.OKButton = new JButton();
        this.cancelButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setModal(true);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                TextInputDialog.this.formFocusGained(focusEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                TextInputDialog.this.closeDialog(windowEvent);
            }
        });
        this.promptArea.setBackground(new Color(204, 204, 204));
        this.promptArea.setLineWrap(true);
        this.promptArea.setWrapStyleWord(true);
        this.promptArea.setMargin(new Insets(4, 4, 4, 4));
        this.promptArea.setAutoscrolls(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.promptArea, gridBagConstraints);
        this.inputField.setColumns(30);
        this.inputField.setToolTipText("Enter/edit value here");
        this.inputField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextInputDialog.this.inputFieldActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.inputField, gridBagConstraints);
        this.OKButton.setText("OK");
        this.OKButton.setToolTipText("Accept this entry");
        this.OKButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextInputDialog.this.OKButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.OKButton);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Abandon the entry");
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TextInputDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.inputField.requestFocus();
    }

    private void inputFieldActionPerformed(ActionEvent actionEvent) {
        this.accept();
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void OKButtonActionPerformed(ActionEvent actionEvent) {
        this.accept = true;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void accept() {
        this.accept = true;
        this.setVisible(false);
        this.dispose();
    }
}

