/*
 * Decompiled with CFR 0.152.
 */
package Arachnophilia;

import Arachnophilia.ArachComp;
import Arachnophilia.ArachDocument;
import Arachnophilia.Arachnophilia;
import MacroManager.KeyDescription;
import MacroManager.MacroTreeNodeData;
import java.awt.event.KeyEvent;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public final class MacroKeyHandler {
    Arachnophilia main;
    HashMap keyMappings;
    Vector errorVector;
    public static final int POLICY_DO_NOTHING = 0;
    public static final int POLICY_ASK_USER = 1;
    public static final int POLICY_DELETE_FIRST = 2;
    public static final int POLICY_DELETE_SECOND = 3;
    int policy = 1;

    public MacroKeyHandler(Arachnophilia arachnophilia) {
        this.main = arachnophilia;
    }

    public boolean execute(KeyEvent keyEvent) {
        boolean bl = false;
        String string = this.createCode(keyEvent);
        int n = keyEvent.getID();
        if (n == 401) {
            String string2;
            Serializable serializable;
            if (this.keyMappings != null && this.keyMappings.containsKey(string)) {
                keyEvent.consume();
                serializable = this.getValue(string);
                this.executeMacro((TreePath)serializable);
                bl = true;
            }
            if (!bl && (serializable = this.main.currentSelectedDocument) != null && ((string2 = KeyEvent.getKeyText(keyEvent.getKeyCode())).equals("Backspace") || string2.equals("Delete"))) {
                int n2;
                String string3 = KeyEvent.getKeyModifiersText(keyEvent.getModifiers());
                int n3 = ((ArachDocument)serializable).textComp.getSelectionStart();
                if (n3 != (n2 = ((ArachDocument)serializable).textComp.getSelectionEnd()) || string3.equals("Ctrl")) {
                    ((ArachDocument)serializable).undoPush();
                }
            }
        }
        return bl;
    }

    public String checkDefinition(String string) {
        String string2 = null;
        if (this.keyMappings.containsKey(string)) {
            string2 = this.getValue(string).toString();
        }
        return string2;
    }

    public void removeKeyMacro(String string) {
        this.removeKeyMacro(this.getValue(string));
    }

    public void removeKeyMacro(TreePath treePath) {
        MacroTreeNodeData macroTreeNodeData = ArachComp.getDataForPath(treePath);
        if (macroTreeNodeData != null) {
            this.keyMappings.remove(macroTreeNodeData.keyboardHook);
            macroTreeNodeData.keyboardHook = null;
        }
    }

    private void executeMacro(TreePath treePath) {
        MacroTreeNodeData macroTreeNodeData = ArachComp.getDataForPath(treePath);
        if (macroTreeNodeData != null) {
            this.main.macroHandler.executeCommand(macroTreeNodeData.content);
        }
    }

    private TreePath getValue(String string) {
        if (this.keyMappings != null) {
            return (TreePath)this.keyMappings.get(string);
        }
        return null;
    }

    public DefaultMutableTreeNode getNodeForString(String string) {
        return ArachComp.getNodeForPath(this.getValue(string));
    }

    public boolean readKeymacrosFromTree(DefaultMutableTreeNode defaultMutableTreeNode) {
        this.keyMappings = new HashMap();
        this.errorVector = new Vector();
        this.policy = 1;
        boolean bl = this.findDefs(defaultMutableTreeNode, false);
        return bl;
    }

    private boolean findDefs(DefaultMutableTreeNode defaultMutableTreeNode, boolean bl) {
        MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)defaultMutableTreeNode.getUserObject();
        if (macroTreeNodeData != null && !macroTreeNodeData.isHidden) {
            if (macroTreeNodeData.keyboardHook != null && macroTreeNodeData.keyboardHook.isValid()) {
                TreePath treePath = new TreePath(defaultMutableTreeNode.getPath());
                if (this.keyMappings.containsKey(macroTreeNodeData.keyboardHook.toString())) {
                    TreePath treePath2 = this.getValue(macroTreeNodeData.keyboardHook.toString());
                    String string = ArachComp.doPostTab(macroTreeNodeData.keyboardHook.getDescription(), 8) + " mapped to " + ArachComp.doPostTab(treePath2.toString(), 16) + " and to " + treePath;
                    if (this.policy == 0) {
                        this.errorVector.add(string);
                        this.keyMappings.put(macroTreeNodeData.keyboardHook.toString(), treePath);
                    } else if (this.policy == 2) {
                        this.removeKeyMacro(treePath2);
                        this.keyMappings.put(macroTreeNodeData.keyboardHook.toString(), treePath);
                        bl = true;
                    } else if (this.policy == 3) {
                        this.removeKeyMacro(treePath);
                        bl = true;
                    } else if (this.policy == 1) {
                        string = "This key code:    [" + macroTreeNodeData.keyboardHook.getDescription() + "]\n" + "is mapped both to " + treePath2.toString() + "\n" + "and to            " + treePath;
                        string = "There is a duplicate key mapping.\n\n" + string + "\n\nDo you want to delete the lower key mapping?\n\n\"Yes\" deletes the lower key mapping.\n\"No\" deletes the higher key mapping.\n\"Cancel\" ends interactive error checking\nand changes neither.\n\n";
                        int n = JOptionPane.showConfirmDialog(this.main, string, "Key mapping scan -- duplicate definition", 1);
                        if (n == 0) {
                            this.removeKeyMacro(treePath);
                            bl = true;
                        } else if (n == 1) {
                            this.removeKeyMacro(treePath2);
                            this.keyMappings.put(macroTreeNodeData.keyboardHook.toString(), treePath);
                            bl = true;
                        } else if (n == 2) {
                            this.policy = 0;
                            this.keyMappings.put(macroTreeNodeData.keyboardHook.toString(), treePath);
                        }
                    }
                } else {
                    this.keyMappings.put(macroTreeNodeData.keyboardHook.toString(), treePath);
                }
            }
            int n = defaultMutableTreeNode.getChildCount();
            for (int i = 0; i < n; ++i) {
                bl = this.findDefs((DefaultMutableTreeNode)defaultMutableTreeNode.getChildAt(i), bl);
            }
        }
        return bl;
    }

    public String listDefs() {
        Vector vector = new Vector(this.keyMappings.values());
        Vector<MacroTreeNodeData> vector2 = new Vector<MacroTreeNodeData>();
        for (int i = 0; i < vector.size(); ++i) {
            TreePath treePath = (TreePath)vector.get(i);
            MacroTreeNodeData macroTreeNodeData = ArachComp.getDataForPath(treePath);
            vector2.add(macroTreeNodeData);
        }
        MacroTreeNodeData[] macroTreeNodeDataArray = vector2.toArray(new MacroTreeNodeData[0]);
        Arrays.sort(macroTreeNodeDataArray, new CompareMacroData());
        int n = 0;
        for (int i = 0; i < macroTreeNodeDataArray.length; ++i) {
            n = ArachComp.getMax(macroTreeNodeDataArray[i].keyboardHook.getDescription(), n);
        }
        StringBuffer stringBuffer = new StringBuffer();
        String string = "NOTE: Any key mappings that are located within hidden subtrees\nor nodes will not appear on this list, or be in force. To enable\na key mapping, make sure its node and all its parents are not hidden.\n\n";
        stringBuffer.append(string);
        String string2 = ArachComp.doPostTab("Key", n) + " = Macro\n";
        stringBuffer.append(string2);
        stringBuffer.append(ArachComp.dashedLine(70) + "\n");
        for (int i = 0; i < macroTreeNodeDataArray.length; ++i) {
            stringBuffer.append(ArachComp.doPostTab(macroTreeNodeDataArray[i].keyboardHook.getDescription(), n) + " = " + macroTreeNodeDataArray[i].name + "\n");
        }
        return stringBuffer.toString();
    }

    public String createCode(KeyDescription keyDescription) {
        return keyDescription.toString();
    }

    public String createCode(KeyEvent keyEvent) {
        return new KeyDescription(keyEvent).toString();
    }

    class CompareMacroData
    implements Comparator {
        CompareMacroData() {
        }

        public int compare(Object object, Object object2) {
            MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)object;
            MacroTreeNodeData macroTreeNodeData2 = (MacroTreeNodeData)object2;
            return macroTreeNodeData.keyboardHook.getDescription().compareTo(macroTreeNodeData2.keyboardHook.getDescription());
        }

        public boolean equals(Object object, Object object2) {
            MacroTreeNodeData macroTreeNodeData = (MacroTreeNodeData)object;
            MacroTreeNodeData macroTreeNodeData2 = (MacroTreeNodeData)object2;
            return macroTreeNodeData.keyboardHook.getDescription().equals(macroTreeNodeData2.keyboardHook.getDescription());
        }
    }
}

